/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_OPS_H
#define _HEIGHT_FIELD_OPS_H


#include "HeightField.h"
#include "HeightFieldDraw.h"
#include "flexarray.h"
#include "tf_flexarrCOORD2.h"
#include "tf_glistFlexArr.h"


/*
 *  HeightFieldOps: class for general height field utilities/transformations.
 * 	This is one big mess of methods. Just find what you need and call it. 
 */
class HeightFieldOps
	{
	public:
				HeightFieldOps (HeightField *HF);
				~HeightFieldOps();

		static HeightField *merge(char operation, HeightField *HF1,
					HeightField *HF2, float weight1, float weight2);

		int		upslopeSFD (int x, int y, PTYPE *cache);
		float		upslopeMFD (int x, int y, PTYPE *cache);
		HeightField	*flowmap (bool doSFD, bool ignoreSealevel=TRUE, 
				float maxElvErode=1.0);
		int		erode (int nTurns, int maxFlowAge, 
				       float maxElvErode, char *fName, 
				       bool trimLocalPeaks, bool doSFD, 
				       bool ignoreSealevel, HeightFieldDraw *HFD=NULL);
		int		hfDouble (double f, double f2);
		int		hfHalf ();
		HeightField	*hfResize (int newx=100, int newy=100);
		int		rotate90 (int degrees);
		int		roughSmooth (bool roughen, bool bigGrid, float factor);
		int		transform (PTYPE factor, int adjust_sea_level=TRUE);
		int		terrace (int nLevels, float factor, bool adjustSealevel=FALSE);
		int		gaussianHill (float cx, float cy, float radius, float radfac, float hscale, float smooth, float deltascale);
		int		invert (int adjust_sea_level=FALSE);
		int		fold (int falloff);
		int		linearScale (float centerx, float centery, float scaleFactor, float mindist=0.0, float maxdist=1.0, float smoothFactor=0.0, bool invertScale=FALSE, bool scaleFullDist=TRUE);
		int		mirror (int type);
		int		fill (PTYPE elv, float factor, bool keepMin);
		int		placePOVObject (char *outfile, char *object, 
					int hfsx, int hfsy, int hfsz, 
					PTYPE floor, PTYPE ceil, 
					float density, float pvar, 
					int osx, int osy, int osz,
					PTYPE osxvar, PTYPE osyvar, PTYPE oszvar, 
					int seed=0);

		TFGListFlexArr	*contourLines (int nElvLevels, float epsilon, 
					int squareSize);
		int		distributeCraters (unsigned int how_many, 
					bool wrap, D ch_scale, 
					D cr_scale, D craterCoverage, 
					int seed, float cx=-1, float cy=-1);
		static int	hf_sort (const void *v1, const void *v2);

	private:
		// cl methods: used by contour line code 
		PTYPE		*clCheckBestFit (PTYPE *bestFit, PTYPE *cell, int off);
		PTYPE		*clCheckSquareR (int x, int y, 
					int width=1);
		void		clFollow (TFFlexArrayCoord2 *faCList, 
					int x, int y);

		// d_cr methods: used by cater code
		double		crProfile (double nsq_rad);
		double		crDissolve (double nsq_rad);

		// d_cl variables: used by contour line code 
		bool			*p_clBuffer;		// contour line buffer
		int			d_clPoints,		// # of points in contour lines
					d_clLastRWidth, 
					d_clArrayElSize,
					d_clArrayLen, 
					d_clArrayInc,
					d_clArrayIncFactor,
					d_clSquareSize;
		PTYPE			d_clTargetElv, 
					d_clLevelLow, 
					d_clLevelHigh,
					d_clCurBestElv;

		// other vars
		long			d_cHit, d_cMiss; // cache hit/miss counts
		HeightField		*p_HF;
	};


#endif // _HEIGHT_FIELD_OPS_H 

