/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_MODEL
#define _HEIGHT_FIELD_MODEL


#include "HeightField.h"
#include "GuiColormap.h"
#include "MathTrig.h"

#define ELV_LOWEST	0
#define ELV_HIGHEST	0
#define ELV_AVG		0


/*
 *  HeightFieldModel: class for general height field utilities/transformations.
 * 	Depends on being declared a friend to HeightField
 */
class HeightFieldModel
	{
	public:
				HeightFieldModel (HeightField *HF);
				~HeightFieldModel();

		// command & utility 
		void		refresh (GuiColormap *cMap, int wireResolution=10, 
					float yscale=0.2, bool sea=TRUE, 
				 	int elvMode=0, float scale=1);
		int		get2DPoints (int i, PT2 *p1, PT2 *p2, PT2 *p3, 
					int *cIndex=NULL);
		int		buildModel ();
		int		transformD32 ();
		void 		transform (float a, float b, float c);

		// access methods 
		TriMod3D	*get3DModel ()	{return &d_tModel3D;}
		int		getNumTri ()	{return d_tModel3D.nTri;}
		int		getNumVer ()	{return d_size;}

	private:
		// private 
		void		rotateY (float yrot);
		void		rotateZ (float zrot);
		void		translate (float x, float b, float c);
		int		getColorIndex (float elv);

		HeightField		*p_HF;
		GuiColormap		*p_cMap;
		TriMod2D		d_tModel2D;
		TriMod3D		d_tModel3D;
		int			d_xsize, d_ysize, d_size,	// model size
					d_wRes,						// wireframe resolution 
					d_scale;					// view size scale
		float			d_xpos, d_ypos, d_zpos,		// land pos
					d_xrot, d_yrot, d_zrot,		// rotation angles
					d_min, d_max, d_range,		// max elevation
					d_yScale;					// y scale factor
		bool			b_sea;						// fill sea or not
	};


#endif // _HEIGHT_FIELD_MODEL 

