/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "GuiDialogReallyQuit.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
GuiDialogReallyQuit::GuiDialogReallyQuit (char *title, char *message)
	        : GuiDialogYN (title, NULL)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiDialogReallyQuit\n");

	b_Yes = FALSE;
	p_label = NULL;
	if (message)
		p_message = strdup (message);
	buildDialogWindow ();
	Gtk_Main::grab_add (*this);
}


/*
 *  destructor: clean up 
 */
GuiDialogReallyQuit::~GuiDialogReallyQuit ()
{
	Gtk_Main::grab_remove (*this);
	this->hide ();
	if (p_label) delete p_label;
	if (p_message) free (p_message);

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiDialogReallyQuit\n");
}


void GuiDialogReallyQuit::fillVBox ()
{
	p_label = new Gtk_Label (p_message);
	if (this->p_frmBase)
		this->p_frmBase->add (*p_label);
	else
		this->get_vbox()->pack_start (*p_label, TRUE, TRUE, 0);
	p_label->show ();
	if (this->p_frmBase)
		this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  setLabel: set the defaultLabel text
 */
void GuiDialogReallyQuit::setLabel (char *s)
{
	if (s)
		{
		if (p_message)
			free (p_message);
		p_message = strdup (s);
		p_label->set_text (s);
		//p_label->set_text (s);
		}
	
}



/*
 *  buttonCallbackYes: yes, really quit
 */
void GuiDialogReallyQuit::buttonCallbackYes ()
{	
	b_Yes = TRUE;
	Gtk_Main::grab_remove (*this);
	this->hide ();
}


/*
 *  buttonCallbackNo: no, don't quit
 */
void GuiDialogReallyQuit::buttonCallbackNo ()
{
	b_Yes = FALSE;
	Gtk_Main::grab_remove (*this);
	this->hide ();
}


gint GuiDialogReallyQuit::delete_event_impl (GdkEventAny *e)
{
	Gtk_Main::grab_remove (*this);
	this->hide ();
	return (0);
}


/*
int GlobalTrace::d_traceLevel=255;    // instantiate static data member
int main (int argc, char *argv[])
{
	Gtk_Main        gtkMain (&argc, &argv);
	GuiDialogReallyQuit *testDialog;

	testDialog = new GuiDialogReallyQuit (NULL, NULL, "TestTitle", "TestMessage");
	testDialog->show ();
	gtkMain.run ();
}
*/
