/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GLOBAL_DEFS_H
#define _GLOBAL_DEFS_H 1


#ifndef NULL
# define NULL		0L
#endif

#ifndef FALSE
# define FALSE		0
#endif

#ifndef TRUE 
# define TRUE		1
#endif

#ifndef ABS
# define ABS(n)		(n<0 ? -n : n) 
#endif

#ifndef MIN
# define MIN(i,j)	(i<j ? i : j)
#endif

#ifndef MAX
# define MAX(i,j)	(i>j ? i : j)
#endif


typedef	unsigned int	UI;
typedef	unsigned long	UL;
typedef	unsigned int	UI;
typedef	unsigned char	UC;
typedef float		F;
typedef double		D;
typedef unsigned char	BYTE;


// define the local terraform compile symbols
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


// support for gettext
#ifdef ENABLE_NLS
# include <locale.h>
# include <libintl.h>
# define _(x)	gettext(x)
# ifdef gettext_noop
#  define N_(x)	gettext_noop(x)
# else
#  define N_(x)	(x)
# endif
#else
# define _(x)	(x)
# define N_(x)	(x)
# define textdomain(String) 		(String)
# define gettext(String) 		(String)
# define dgettext(Domain,Message) 	(Message)
# define dcgettext(Domain,Message,Type) (Message)
# define bindtextdomain(Domain,Directory) (Domain)
#endif


#endif // _GLOBAL_DEFS_H
