/***************************************************************************
                          rsplitter.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rsplitter.h 1998/08/27 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RSPLITTER_H
#define RSPLITTER_H

#include <qwindowdefs.h>
#include <qsplitter.h>

#ifndef _WS_X11_
#define DEF_HANDLEWIDTH  6
#else
#define DEF_HANDLEWIDTH  10
#endif

/*! Splitter implementation
*/
class RSplitter : public QSplitter
{
private:
  /*! The Id of the handle
  */
  int handleId;

public:
  /*! Constructor
      \param _parent The parent widget
      \param _name Name
  */
  RSplitter(QWidget* _parent=0, const char* _name=0);
  /*! Destructor
  */
  ~RSplitter();
  
  /*! Memorize the ID of the handle
  */
  void memorizeHandleId(QWidget* _widget);
  /*! Move the handle to the right side
  */
  void moveToRight();
  /*! Move the handle to the left side
  */
  void moveToLeft();
  /*! Move the handle to the center
  */
  void moveToCenter();

};


#endif

// EOF


