/***************************************************************************
                          rconfigmach.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
                          rconfigmach.h  -  description
                             -------------------
    begin                : Wed Apr 28 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/

#ifndef RCONFIGMACH_H
#define RCONFIGMACH_H

#include <qframe.h>
#include <qlist.h>
#include <qpushbutton.h>
#include <qstrlist.h>
#include <qtabdialog.h>
#include <qtoolbutton.h>

#include "rcombobox.h"
#include "rgraphdef.h"
#include "rlabel.h"

#define DEF_CONFIGMACH_WIDTH  620
#define DEF_CONFIGMACH_HEIGHT 350

#define DEF_BUTINSERTORDER_WIDTH 20
#define DEF_ORDERITEMLINE_HEIGHT 36

class RCheckBox;
class QFrame;
class RLineEdit;
class QScrollView;
class RComboBox;

class RConfigMach : public QTabDialog
{
  Q_OBJECT
public:
  RConfigMach(const char* _machFile,
              QWidget* _parent=0, 
              const char* _name=0);
  ~RConfigMach();

  bool  updateOptionsFromGenerator();
  bool  fillOptionLists();
  
  bool  updateParametersFromGenerator();
  bool  updateParameterValues();
  int   getParameterLineIndex(char _code);
  void  presaveParameter(char _code);
  void  correctInputValues();

  bool     updateOrdersFromGenerator();
  bool     updateOrderFromString(const QString& _name);
  QString* getSelectedOrder();
  QString* getOrder(const QString& _name);
  void     insertItemAt(int _pos, const char* _what=0, bool _update=true);
  void     deleteItemAt(int _pos, bool _delIfEnd=true, bool _update=true);
  void     fillComboBoxWithParameterValues(RComboBox* _mb, char _code);
  void     presaveOrder(const QString& _name=0);

protected slots:
  void okDialog();
  void saveMachine();

private slots:
  void parameterChanged(int);
  void parameterCodeChanged(const QString& _text);
  void parameterDescriptionChanged(const QString& _text);
  void addParameter();
  void delParameter();

  void orderChanged(const QString& _name);
  void checkOrders(const QString& _name);
  void ifParameterChanged(const QString& _code);
  void modParameterChanged(const QString& _code);
  void saveOldItems();
  void updateOrderLayout();
  void insertItem(bool);
  void deleteItem(bool);
  void addOrder();
  void delOrder();
  
  void tabSelected(const QString& _tabLabel);
  
private:

  // We're configuring machine generator:
  //
  QString machFile;
  
  // Parameter presaving:
  //
  QString parameterString;
  QString parameter[DEF_MAXPARAMETERS*2];

  // Control updating of values:
  //
  bool updateParameterActive;           // Switch on/off updating of parameters
  bool parameterHasChanged;             // Is true if we changed something in 
                                        //   parameter list (code or description)
                                        
  // Order presaving:
  //
  QList<QString> order;                 // Presaving of orders
  char lastOrderName[128];              // Last order name "<Order>" for presaving

  // Layout-Elements:
  //
  QWidget* wOptions;
    RLabel*    lExtension;
    RComboBox* mbExtension;
    RLabel*    lOptimization;
    RComboBox* mbOptimization;
    RLabel*    lContourCenter;
    RComboBox* mbContourCenter;
    RLabel*    lSorting;
    RComboBox* mbSorting;
    RLabel*    lDirection;
    RComboBox* mbDirection;
    RLabel*    lStartNumber;
    RComboBox* mbStartNumber;
    RLabel*    lNumberStep;
    RComboBox* mbNumberStep;
    RLabel*    lMaxArcAngle;
    RComboBox* mbMaxArcAngle;
    RLabel*    lMaxArcLength;
    RComboBox* mbMaxArcLength;
    RLabel*    lTolerance;
    RComboBox* mbTolerance;
    RLabel*    lFactor;
    RComboBox* mbFactor;
    RLabel*    lPointing;
    RComboBox* mbPointing;
    RLabel*    lPointingAngle;
    RComboBox* mbPointingAngle;
    RLabel*    lPointingDepth;
    RComboBox* mbPointingDepth;
    RLabel*    lPointingLimit;
    RComboBox* mbPointingLimit;
    RLabel*    lPointingMaxLength;
    RComboBox* mbPointingMaxLength;
    
  QWidget* wParameter;
    RLabel*      lParameter;
    RComboBox*   mbParameter;
    QPushButton* bAddParameter;
    QPushButton* bDelParameter;
    QFrame*      fSep1;
    RLabel*      lCode;
    RLineEdit*   eCode;
    RCheckBox*   cbLayer;
    RCheckBox*   cbFix;
    RLabel*      lDescription;
    RLineEdit*   eDescription;
    RLabel*      lValueList;
    RLineEdit*   eValueList;
    RLabel*      lStandardValue;
    RLineEdit*   eStandardValue;

  QWidget* wOrder;
    bool         autoUpdateOrders;       // Update orders active?
    RLabel*      lOrder;
    RComboBox*   mbOrder;
    QPushButton* bAddOrder;
    QPushButton* bDelOrder;
    QFrame*      fSep2;
    QScrollView* scOrder;
    QWidget*     wdOrder;
    QList<QToolButton> bInsertItem;
    QList<QToolButton> bDeleteItem;
    QList<RComboBox>   mbItem;
    QList<QString>     sOldItem;
    QList<RLabel>      lItem;
    QList<QFrame>      fItemSep;
    
    QPixmap*     pixInsertItem;
    QPixmap*     pixDeleteItem;
    QFont*       boldFont;

};


#endif



