
/* VRMLFunc.c generated by VRMLC.pm. DO NOT MODIFY, MODIFY VRMLC.pm INSTEAD */

/* Code here comes almost verbatim from VRMLC.pm */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <math.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#include "OpenGL/OpenGL.m"

#define offset_of(p_type,field) ((unsigned int)(&(((p_type)NULL)->field)-NULL))

#define TC(a,b) glTexCoord2f(a,b)

#ifdef M_PI
#define PI M_PI
#else
#define PI 3.141592653589793
#endif

/* Faster trig macros (thanks for Robin Williams) */

#define DECL_TRIG1 float t_aa, t_ab, t_sa, t_ca, t_sa1, t_ca1;
#define INIT_TRIG1(div) t_aa = sin(PI/(div)); t_aa *= 2*t_aa; t_ab = sin(2*PI/(div));
#define START_TRIG1 t_sa = 0; t_ca = 1;
#define UP_TRIG1 t_sa1 = t_sa; t_sa -= t_sa*t_aa - t_ca * t_ab; t_ca -= t_ca * t_aa + t_sa1 * t_ab;
#define SIN1 t_sa
#define COS1 t_ca


#define DECL_TRIG2 float t2_aa, t2_ab, t2_sa, t2_ca, t2_sa1, t2_ca1;
#define INIT_TRIG2(div) t2_aa = sin(PI/(div)); t2_aa *= 2*t2_aa; t2_ab = sin(2*PI/(div));
#define START_TRIG2 t2_sa = 0; t2_ca = 1;
#define UP_TRIG2 t2_sa1 = t2_sa; t2_sa -= t2_sa*t2_aa - t2_ca * t2_ab; t2_ca -= t2_ca * t2_aa + t2_sa1 * t2_ab;
#define SIN2 t2_sa
#define COS2 t2_ca


D_OPENGL;


/* Rearrange to take advantage of headlight when off */
int curlight = 0;
int nlightcodes = 7;
int lightcode[7] = {
	GL_LIGHT1,
	GL_LIGHT2,
	GL_LIGHT3,
	GL_LIGHT4,
	GL_LIGHT5,
	GL_LIGHT6,
	GL_LIGHT7,
};
int nextlight() {
	if(curlight == nlightcodes) { return -1; }
	return lightcode[curlight++];
}

struct VRML_Virt {
	void (*prep)(void *);
	void (*rend)(void *); 
	void (*children)(void *);
	void (*fin)(void *);
	void (*rendray)(void *);
	void (*mkpolyrep)(void *);
	void (*light)(void *);
	/* And get float coordinates : Coordinate, Color */
	/* XXX Relies on MFColor repr.. */
	struct SFColor *(*get3)(void *, int *); /* Number in int */
	struct SFVec2f *(*get2)(void *, int *); /* Number in int */
	void (*changed)(void *);
	char *name;
};

/* Internal representation of IndexedFaceSet, Extrusion & ElevationGrid:
 * set of triangles.
 * done so that we get rid of concave polygons etc.
 */
struct VRML_PolyRep { /* Currently a bit wasteful, because copying */
	int _change;
	int ntri; /* number of triangles */
	int alloc_tri; /* number of allocated triangles */
	int *cindex;   /* triples (per triangle) */
	float *coord; /* triples (per point) */
	int *colindex;   /* triples (per triangle) */
	float *color; /* triples or null */
	int *norindex;
	float *normal; /* triples or null */
};


struct Multi_Float { int n; float  *p; };
struct SFRotation {
 	float r[4]; };
struct Multi_Rotation { int n; struct SFRotation  *p; };

struct Multi_Vec3f { int n; struct SFColor  *p; };


struct Multi_Int32 { int n; int  *p; };

struct Multi_Node { int n; void * *p; };
struct SFColor {
	float c[3]; };
struct Multi_Color { int n; struct SFColor  *p; };


struct Multi_String { int n; SV * *p; };
struct SFVec2f {
	float c[2]; };
struct Multi_Vec2f { int n; struct SFVec2f  *p; };

/* and now the structs for the nodetypes */ 
struct VRML_PointLight {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float radius;
	struct SFColor location;
	struct SFColor direction;
	struct SFColor attenuation;
	int on;
	struct SFColor color;
	float ambientIntensity;
	float intensity;
};
struct VRML_DirectionalLight {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct SFColor direction;
	int on;
	float ambientIntensity;
	struct SFColor color;
	float intensity;
};
struct VRML_Sphere {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float radius;
};
struct VRML_Coordinate {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Vec3f point;
};
struct VRML_FontStyle {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	SV *style;
	struct Multi_String family;
	SV *language;
	float spacing;
	int horizontal;
	int topToBottom;
	float size;
	int leftToRight;
	struct Multi_String justify;
};
struct VRML_Normal {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Vec3f vector;
};
struct VRML_Box {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct SFColor size;
};
struct VRML_Billboard {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Node children;
	struct SFColor axisOfRotation;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
int has_light; };
struct VRML_ElevationGrid {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	int zDimension;
	int colorPerVertex;
	struct Multi_Float height;
	void *normal;
	float creaseAngle;
	int solid;
	float xSpacing;
	int xDimension;
	int normalPerVertex;
	void *color;
	float zSpacing;
};
struct VRML_Extrusion {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	int convex;
	struct Multi_Vec2f scale;
	int beginCap;
	float creaseAngle;
	int solid;
	int endCap;
	struct Multi_Rotation orientation;
	int ccw;
	struct Multi_Vec2f crossSection;
	struct Multi_Vec3f spine;
};
struct VRML_Switch {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Node choice;
	int whichChoice;
};
struct VRML_ImageTexture {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	SV *__data;
	struct Multi_String url;
	int __depth;
	int repeatS;
	int repeatT;
	int __x;
	int __y;
};
struct VRML_TextureCoordinate {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Vec2f point;
};
struct VRML_IndexedFaceSet {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Int32 texCoordIndex;
	struct Multi_Int32 normalIndex;
	int convex;
	int colorPerVertex;
	void *coord;
	struct Multi_Int32 colorIndex;
	void *texCoord;
	void *normal;
	float creaseAngle;
	int solid;
	int ccw;
	struct Multi_Int32 coordIndex;
	void *color;
};
struct VRML_Background {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	int __y_left;
	SV *__data_left;
	int __depth_back;
	struct Multi_String backUrl;
	int __depth_top;
	struct Multi_String topUrl;
	int __y_back;
	int __depth_bottom;
	SV *__data_back;
	int __x_top;
	struct Multi_String bottomUrl;
	int __y_top;
	int __y_bottom;
	float bindTime;
	SV *__data_bottom;
	int __depth_right;
	int __x_right;
	int isBound;
	int __y_right;
	struct Multi_Float groundAngle;
	struct Multi_Color skyColor;
	SV *__data_front;
	int __x_left;
	int __x_back;
	int set_bind;
	SV *__data_top;
	int __x_bottom;
	struct Multi_Color groundColor;
	struct Multi_String rightUrl;
	SV *__data_right;
	int __depth_front;
	struct Multi_String frontUrl;
	int __depth_left;
	struct Multi_String leftUrl;
	struct Multi_Float skyAngle;
	int __x_front;
	int __y_front;
};
struct VRML_Text {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	void *fontStyle;
	int __rendersub;
	struct Multi_Float length;
	float maxExtent;
	struct Multi_String string;
};
struct VRML_Cone {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float height;
	float bottomRadius;
	int side;
	int bottom;
};
struct VRML_Viewpoint {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float fieldOfView;
	SV *description;
	int isBound;
	struct SFColor position;
	int set_bind;
	float bindTime;
	int jump;
	struct SFRotation orientation;
};
struct VRML_TextureTransform {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float rotation;
	struct SFVec2f scale;
	struct SFVec2f center;
	struct SFVec2f translation;
};
struct VRML_Group {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Node children;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
int has_light; };
struct VRML_ProximitySensor {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct SFColor center;
	int __hit;
	struct SFColor __t1;
	struct SFRotation __t2;
	struct SFRotation orientation_changed;
	int isActive;
	float exitTime;
	struct SFColor size;
	int enabled;
	float enterTime;
	struct SFColor position_changed;
};
struct VRML_Material {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float transparency;
	struct SFColor emissiveColor;
	float shininess;
	struct SFColor diffuseColor;
	struct SFColor specularColor;
	float ambientIntensity;
};
struct VRML_Appearance {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	void *texture;
	void *textureTransform;
	void *material;
};
struct VRML_Shape {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	void *appearance;
	void *geometry;
};
struct VRML_IndexedLineSet {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	int colorPerVertex;
	void *coord;
	void *color;
	struct Multi_Int32 colorIndex;
	struct Multi_Int32 coordIndex;
};
struct VRML_PointSet {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	void *color;
	void *coord;
};
struct VRML_Cylinder {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	float radius;
	float height;
	int top;
	int side;
	int bottom;
};
struct VRML_Anchor {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Node children;
	struct Multi_String parameter;
	struct Multi_String url;
	SV *description;
	struct SFColor bboxCenter;
	struct SFColor bboxSize;
int has_light; };
struct VRML_NavigationInfo {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	int set_bind;
	float speed;
	struct Multi_Float avatarSize;
	int headlight;
	struct Multi_String type;
	float bindTime;
	int isBound;
	float visibilityLimit;
};
struct VRML_Transform {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct SFRotation rotation;
	struct SFColor center;
	struct SFRotation scaleOrientation;
	struct SFColor bboxSize;
	struct SFColor scale;
	struct Multi_Node children;
	struct SFColor bboxCenter;
	struct SFColor translation;
int has_light; };
struct VRML_SpotLight {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct SFColor direction;
	float beamWidth;
	float ambientIntensity;
	float intensity;
	float radius;
	struct SFColor location;
	struct SFColor attenuation;
	int on;
	float cutOffAngle;
	struct SFColor color;
};
struct VRML_LOD {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Node level;
	struct SFColor center;
	struct Multi_Float range;
};
struct VRML_Color {
 /***/ struct VRML_Virt *v;
 /*s*/ int _sens; 
 /*t*/ int _hit; 
 /*a*/ int _change; 
 /*n*/ int _dlchange; 
 /*d*/ GLuint _dlist; 
 /*a*/ int _dl2change; 
 /*r*/ GLuint _dl2ist; 
       void **_parents; 
       int _nparents; 
       int _nparalloc; 
       int _ichange; 
 /*d*/ void *_intern; 
 /***/
	struct Multi_Color color;
};


int verbose;

int reverse_trans;
int render_vp; 
int render_geom;
int render_light;
int render_sensitive;

int horiz_div; int vert_div;
int vp_dist = 200000;

int cur_hits=0;

/* These two points define a ray in window coordinates */

struct pt {GLdouble x,y,z;};

struct pt r1 = {0,0,-1},r2 = {0,0,0},r3 = {0,1,0};
struct pt t_r1,t_r2,t_r3; /* transformed ray */
void *hypersensitive = 0; int hyperhit = 0;
struct pt hyper_r1,hyper_r2; /* Transformed ray for the hypersensitive node */

GLint viewport[4] = {-1,-1,2,2};

/* These three points define 1. hitpoint 2., 3. two different tangents
 * of the surface at hitpoint (to get transformation correctly */ 

/* All in window coordinates */

struct pt hp, ht1, ht2;
double hpdist; /* distance in ray: 0 = r1, 1 = r2, 2 = 2*r2-r1... */

struct currayhit {
void *node; /* What node hit at that distance? */
GLdouble modelMatrix[16]; /* What the matrices were at that node */
GLdouble projMatrix[16];
} rh,rph,rhhyper;
 /* used to test new hits */

/* defines for raycasting: */
#define APPROX(a,b) (fabs(a-b)<0.00000001)
#define NORMAL_VECTOR_LENGTH_TOLERANCE 0.00001
/* (test if the vector part of a rotation is normalized) */
#define IS_ROTATION_VEC_NOT_NORMAL(rot)        ( \
       fabs(1-sqrt(rot.r[0]*rot.r[0]+rot.r[1]*rot.r[1]+rot.r[2]*rot.r[2])) \
               >NORMAL_VECTOR_LENGTH_TOLERANCE \
)

/* defines for raycasting: */
#define XEQ (APPROX(t_r1.x,t_r2.x))
#define YEQ (APPROX(t_r1.y,t_r2.y))
#define ZEQ (APPROX(t_r1.z,t_r2.z))
/* xrat(a) = ratio to reach coordinate a on axis x */
#define XRAT(a) (((a)-t_r1.x)/(t_r2.x-t_r1.x))
#define YRAT(a) (((a)-t_r1.y)/(t_r2.y-t_r1.y))
#define ZRAT(a) (((a)-t_r1.z)/(t_r2.z-t_r1.z))
/* mratx(r) = x-coordinate gotten by multiplying by given ratio */
#define MRATX(a) (t_r1.x + (a)*(t_r2.x-t_r1.x))
#define MRATY(a) (t_r1.y + (a)*(t_r2.y-t_r1.y))
#define MRATZ(a) (t_r1.z + (a)*(t_r2.z-t_r1.z))
/* trat: test if a ratio is reasonable */
#undef TRAT
#define TRAT(a) 1
#undef TRAT
#define TRAT(a) ((a) > 0 && ((a) < hpdist || hpdist < 0))

#define VECSQ(a) VECPT(a,a)
#define VECPT(a,b) ((a).x*(b).x + (a).y*(b).y + (a).z*(b).z)
#define VECDIFF(a,b,c) {(c).x = (a).x-(b).x;(c).y = (a).y-(b).y;(c).z = (a).z-(b).z;}
#define VEC_FROM_CDIFF(a,b,r) {(r).x = (a).c[0]-(b).c[0];(r).y = (a).c[1]-(b).c[1];(r).z = (a).c[2]-(b).c[2];}
#define VECCP(a,b,c) {(c).x = (a).y*(b).z-(b).y*(a).z; (c).y = -((a).x*(b).z-(b).x*(a).z); (c).z = (a).x*(b).y-(b).x*(a).y;}
#define VECSCALE(a,c) {(a).x *= c; (a).y *= c; (a).z *= c;}

/*special case ; used in Extrusion.GenPolyRep and ElevationGrid.GenPolyRep: 
 *	Calc diff vec from 2 coordvecs which must be in the same field 	*/
#define VEC_FROM_COORDDIFF(f,a,g,b,v) {\
	(v).x= (f)[(a)*3]-(g)[(b)*3];	\
	(v).y= (f)[(a)*3+1]-(g)[(b)*3+1];	\
	(v).z= (f)[(a)*3+2]-(g)[(b)*3+2];	\
}

/* rotate a vector along one axis				*/
#define VECROTATE_X(c,angle) { \
	/*(c).x =  (c).x	*/ \
	  (c).y = 		  cos(angle) * (c).y 	- sin(angle) * (c).z; \
	  (c).z = 		  sin(angle) * (c).y 	+ cos(angle) * (c).z; \
	}
#define VECROTATE_Y(c,angle) { \
	  (c).x = cos(angle)*(c).x +			+ sin(angle) * (c).z; \
	/*(c).y = 				(c).y 	*/ \
	  (c).z = -sin(angle)*(c).x 			+ cos(angle) * (c).z; \
	}
#define VECROTATE_Z(c,angle) { \
	  (c).x = cos(angle)*(c).x - sin(angle) * (c).y;	\
	  (c).y = sin(angle)*(c).x + cos(angle) * (c).y; 	\
	/*(c).z = s						 (c).z; */ \
	}

#define MATRIX_ROTATION_X(angle,m) {\
	m[0][0]=1; m[0][1]=0; m[0][2]=0; \
	m[1][0]=0; m[1][1]=cos(angle); m[1][2]=- sin(angle); \
	m[2][0]=0; m[2][1]=sin(angle); m[2][2]=cos(angle); \
}
#define MATRIX_ROTATION_Y(angle,m) {\
	m[0][0]=cos(angle); m[0][1]=0; m[0][2]=sin(angle); \
	m[1][0]=0; m[1][1]=1; m[1][2]=0; \
	m[2][0]=-sin(angle); m[2][1]=0; m[2][2]=cos(angle); \
}
#define MATRIX_ROTATION_Z(angle,m) {\
	m[0][0]=cos(angle); m[0][1]=- sin(angle); m[0][2]=0; \
	m[1][0]=sin(angle); m[1][1]=cos(angle); m[1][2]=0; \
	m[2][0]=0; m[2][1]=0; m[2][2]=1; \
}

/* next matrix calculation comes from comp.graphics.algorithms FAQ	*/
/* the axis vector has to be normalized					*/
#define MATRIX_FROM_ROTATION(ro,m) { \
	struct { double x,y,z,w ; } __q; \
        double sinHalfTheta = sin(0.5*(ro.r[3]));\
        double xs, ys, zs, wx, wy, wz, xx, xy, xz, yy, yz, zz;\
        __q.x = (ro.r[0])*sinHalfTheta;\
        __q.y = (ro.r[1])*sinHalfTheta;\
        __q.z = (ro.r[2])*sinHalfTheta;\
        __q.w = cos(0.5*(ro.r[3]));\
        xs = 2*__q.x;  ys = 2*__q.y;  zs = 2*__q.z;\
        wx = __q.w*xs; wy = __q.w*ys; wz = __q.w*zs;\
        xx = __q.x*xs; xy = __q.x*ys; xz = __q.x*zs;\
        yy = __q.y*ys; yz = __q.y*zs; zz = __q.z*zs;\
        m[0][0] = 1 - (yy + zz); m[0][1] = xy - wz;      m[0][2] = xz + wy;\
        m[1][0] = xy + wz;       m[1][1] = 1 - (xx + zz);m[1][2] = yz - wx;\
        m[2][0] = xz - wy;       m[2][1] = yz + wx;      m[2][2] = 1-(xx + yy);\
}

/* matrix multiplication */
#define VECMM(m,c) { \
	double ___x=(c).x,___y=(c).y,___z=(c).z; \
	(c).x= m[0][0]*___x + m[0][1]*___y + m[0][2]*___z; \
	(c).y= m[1][0]*___x + m[1][1]*___y + m[1][2]*___z; \
	(c).z= m[2][0]*___x + m[2][1]*___y + m[2][2]*___z; \
}

	
/* next define rotates vector c with rotation vector r and angle */
/*  after section 5.8 of the VRML`97 spec			 */

#define VECROTATE(rx,ry,rz,angle,nc) { \
	double ___x=(nc).x,___y=(nc).y,___z=(nc).z; \
	double ___c=cos(angle),  ___s=sin(angle), ___t=1-___c; \
	(nc).x=   (___t*((rx)*(rx))+___c)     *___x    \
	        + (___t*(rx)*(ry)  -___s*(rz))*___y    \
	        + (___t*(rx)*(rz)  +___s*(ry))*___z ;  \
	(nc).y=   (___t*(rx)*(ry)  +___s*(rz))*___x    \
	        + (___t*((ry)*(ry))+___c)     *___y    \
	        + (___t*(ry)*(rz)  -___s*(rx))*___z ;  \
	(nc).z=   (___t*(rx)*(rz)  -___s*(ry))*___x    \
	        + (___t*(ry)*(rz)  +___s*(rx))*___y    \
	        + (___t*((rz)*(rz))+___c)     *___z ;  \
	}


/*
#define VECROTATE(rx,ry,rz,angle,c) { \
	double ___c=cos(angle),  ___s=sin(angle), ___t=1-___c; \
	(c).x=   (___t*((rx)*(rx))+___c)     *(c).x    \
	       + (___t*(rx)*(ry)  +___s*(rz))*(c).y    \
	       + (___t*(rx)*(rz)  -___s*(ry))*(c).z ;  \
	(c).y=   (___t*(rx)*(ry)  -___s*(rz))*(c).x    \
	       + (___t*((ry)*(ry))+___c)     *(c).y    \
	       + (___t*(ry)*(rz)  +___s*(rx))*(c).z ;  \
	(c).z=   (___t*(rx)*(rz)  +___s*(ry))*(c).x    \
	       + (___t*(ry)*(rz)  -___s*(rx))*(c).y    \
	       + (___t*((rz)*(rz))+ ___c)    *(c).z ;  \
	}

*/
/* next define abbreviates VECROTATE with use of the SFRotation struct	*/
#define VECRROTATE(ro,c) VECROTATE((ro).r[0],(ro).r[1],(ro).r[2],(ro).r[3],c)	



#define HIT rayhit

/* Sub, rather than big macro... */
void rayhit(float rat, float cx,float cy,float cz, float nx,float ny,float nz, 
float tx,float ty, char *descr)  {
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	GLdouble wx, wy, wz;
	/* Real rat-testing */
	if(verbose) printf("RAY HIT %s! %f (%f %f %f) (%f %f %f)\nR: (%f %f %f) (%f %f %f)\n",
		descr, rat,cx,cy,cz,nx,ny,nz,
		t_r1.x, t_r1.y, t_r1.z,
		t_r2.x, t_r2.y, t_r2.z
		);
	if(rat<0 || (rat>hpdist && hpdist >= 0)) {
		return;
	}
	glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluProject(cx,cy,cz, modelMatrix, projMatrix, viewport,
		&hp.x, &hp.y, &hp.z);
	hpdist = rat;
	rh=rph;
	rhhyper=rph;
}

/* Call this when modelview and projection modified */
void upd_ray() {
	GLdouble modelMatrix[16];
	GLdouble projMatrix[16];
	glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluUnProject(r1.x,r1.y,r1.z,modelMatrix,projMatrix,viewport,
		&t_r1.x,&t_r1.y,&t_r1.z);
	gluUnProject(r2.x,r2.y,r2.z,modelMatrix,projMatrix,viewport,
		&t_r2.x,&t_r2.y,&t_r2.z);
	gluUnProject(r3.x,r3.y,r3.z,modelMatrix,projMatrix,viewport,
		&t_r3.x,&t_r3.y,&t_r3.z);
/*	printf("Upd_ray: (%f %f %f)->(%f %f %f) == (%f %f %f)->(%f %f %f)\n",
		r1.x,r1.y,r1.z,r2.x,r2.y,r2.z,
		t_r1.x,t_r1.y,t_r1.z,t_r2.x,t_r2.y,t_r2.z);
*/
}


void *what_vp;
int render_anything; /* Turned off when we hit the viewpoint */
void render_node(void *node);
void render_polyrep(void *node, 
	int npoints, struct SFColor *points,
	int ncolors, struct SFColor *colors,
	int nnormals, struct SFColor *normals);
void regen_polyrep(void *node) ;
void calc_poly_normals_flat(struct VRML_PolyRep *rep);
void render_ray_polyrep(void *node,
	int npoints, struct SFColor *points);
	
	
/*********************************************************************
 * General tessellation functions
 *
 * to use the tessellation function, you have to
 * let global_tess_polyrep point towards a structure.
 * global_tess_polyrep->ntri is the first index number which will
 * be filled by the routines (which is the number of triangles
 * already represented in global_tess_polyrep)
 * global_tess_polyrep->cindex and global_tess_polyrep->coords have
 * to point towards enough memory.
 * (And you have to give gluTessVertex a third argument, in which
 * the new coords are written, it has to be a vector of
 * GLdouble s with enough space)
 * After calling gluTessEndPolygon() these vector will be filled.
 * global_tess_polyrep->ntri will contain the absolute
 * number of triangles in global_tess_polyrep after tessellation.
 */
  
/* GLUtesselator *global_tessobj;	/* this would be GLU 1.2 */
/* unfortunately we have to use GLU v1.1			 */

GLUtriangulatorObj *global_tessobj;	
struct VRML_PolyRep *global_tess_polyrep=NULL;

/* and now all the callback functions, which will be called
	by OpenGL automatically, if the Polygon is specified	*/

void ber_tess_begin(GLenum e) {
		/* we only should get GL_TRIANGLES as type, because
		we defined  the edge_flag callback		*/
		/* check, if the structure is there		*/
	if(e!=GL_TRIANGLES) 
		die("Something went wrong while tessellating!");
}

void ber_tess_end(void) {
	/* nothing to do	*/
}

void ber_tess_edgeflag(GLenum flag) {
	/* nothing to do, this function has to be registered
	so that only GL_TRIANGLES are used	*/
}

void ber_tess_vertex(void *p) {
	static int x=0;
	GLdouble *dp=p;

#define GTP global_tess_polyrep
	
	if(GTP->ntri >= GTP->alloc_tri) {
		die("Too many tesselated triangles!");
	}

#undef GTP
	
	global_tess_polyrep->coord[(global_tess_polyrep->ntri)*9+x*3]  =dp[0];
	global_tess_polyrep->coord[(global_tess_polyrep->ntri)*9+x*3+1]=dp[1];
	global_tess_polyrep->coord[(global_tess_polyrep->ntri)*9+x*3+2]=dp[2];
	global_tess_polyrep->cindex[(global_tess_polyrep->ntri)*3+x]=
					(global_tess_polyrep->ntri)*3+x;
	if(x==2) {
		x=0;
		(global_tess_polyrep->ntri)++;
	} else x++;
}

void ber_tess_error(GLenum e) {
	printf("ERROR %d: >%s<\n",e,gluErrorString(e));
}

/* next function has to be called once, after an OpenGL context is made
	and before tessellation is started			*/
	
void new_tessellation(void) {
	global_tessobj=gluNewTess();
	if(!global_tessobj)
		die("Got no memory for Tessellation Object!");
		
	/* register the CallBackfunctions				*/
	gluTessCallback(global_tessobj,GLU_BEGIN,ber_tess_begin);
	gluTessCallback(global_tessobj,GLU_EDGE_FLAG,ber_tess_edgeflag);
	gluTessCallback(global_tessobj,GLU_VERTEX,ber_tess_vertex);
	gluTessCallback(global_tessobj,GLU_ERROR,ber_tess_error);
	gluTessCallback(global_tessobj,GLU_END,ber_tess_end);
	
	/*if(verbose)*/{ printf("Tessellation Initialized!\n"); }
}

/* next function should be called once at the end, but where?	*/
void destruct_tessellation(void) {
	gluDeleteTess(global_tessobj);
	/*if(verbose)*/{ printf("Tessellation Object deleted!\n"); }
}






/*********************************************************************
 * Code here is generated from the hashes in VRMLC.pm and VRMLRend.pm
 */
	

void PointLight_Light(void *nod_){ /* GENERATED FROM HASH LightC, MEMBER PointLight */
			struct VRML_PointLight *this_ = (struct VRML_PointLight *)nod_;
			{
		if(((this_->on))) {
			int light = nextlight();
			if(light >= 0) {
				float vec[4];
				glEnable(light);
				vec[0] = ((this_->direction).c[0]);
				vec[1] = ((this_->direction).c[1]);
				vec[2] = ((this_->direction).c[2]);
				vec[3] = 1;
				glLightfv(light, GL_SPOT_DIRECTION, vec);
				vec[0] = ((this_->location).c[0]);
				vec[1] = ((this_->location).c[1]);
				vec[2] = ((this_->location).c[2]);
				vec[3] = 1;
				glLightfv(light, GL_POSITION, vec);

				glLightf(light, GL_CONSTANT_ATTENUATION, 
					((this_->attenuation).c[0]));
				glLightf(light, GL_LINEAR_ATTENUATION, 
					((this_->attenuation).c[1]));
				glLightf(light, GL_QUADRATIC_ATTENUATION, 
					((this_->attenuation).c[2]));


				vec[0] = ((this_->color).c[0]) * (this_->intensity);
				vec[1] = ((this_->color).c[1]) * (this_->intensity);
				vec[2] = ((this_->color).c[2]) * (this_->intensity);
				vec[3] = 1;
				glLightfv(light, GL_DIFFUSE, vec);
				glLightfv(light, GL_SPECULAR, vec);
				vec[0] *= (this_->ambientIntensity);
				vec[1] *= (this_->ambientIntensity);
				vec[2] *= (this_->ambientIntensity);
				glLightfv(light, GL_AMBIENT, vec);

				/* XXX */
				glLightf(light, GL_SPOT_CUTOFF, 180);
			}
		}
	}
			}

void DirectionalLight_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER DirectionalLight */
			struct VRML_DirectionalLight *this_ = (struct VRML_DirectionalLight *)nod_;
			{
	/* NOTE: This is called by the Group Children code
	 * at the correct point (in the beginning of the rendering
	 * of the children. We just turn the light on right now.
	 */
	if(((this_->on))) {
		int light = nextlight();
		if(light >= 0) {
			float vec[4];
			glEnable(light);
			vec[0] = -((this_->direction).c[0]);
			vec[1] = -((this_->direction).c[1]);
			vec[2] = -((this_->direction).c[2]);
			vec[3] = 0;
			glLightfv(light, GL_POSITION, vec);
			vec[0] = ((this_->color).c[0]) * (this_->intensity);
			vec[1] = ((this_->color).c[1]) * (this_->intensity);
			vec[2] = ((this_->color).c[2]) * (this_->intensity);
			vec[3] = 1;
			glLightfv(light, GL_DIFFUSE, vec);
			glLightfv(light, GL_SPECULAR, vec);
			vec[0] *= (this_->ambientIntensity);
			vec[1] *= (this_->ambientIntensity);
			vec[2] *= (this_->ambientIntensity);
			glLightfv(light, GL_AMBIENT, vec);
		}
	}
}
			}

void Sphere_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Sphere */
			struct VRML_Sphere *this_ = (struct VRML_Sphere *)nod_;
			{int vdiv = vert_div;
		int hdiv = horiz_div;
	   float vf = vert_div;
	   float hf = horiz_div;
		int v; int h;
		float va1,va2,van,ha1,ha2,han;
		DECL_TRIG1
		DECL_TRIG2
		INIT_TRIG1(vdiv) 
		INIT_TRIG2(hdiv)
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		glPushMatrix();
			/* if(!nomode) {
				glPushAttrib(&GL_LIGHTING);
				# glShadeModel(&GL_SMOOTH);
			} */
		glScalef((this_->radius), (this_->radius), (this_->radius));
		glBegin(GL_QUAD_STRIP);
		START_TRIG1
		for(v=0; v<vdiv; v++) {
			float vsin1 = SIN1;
			float vcos1 = COS1, vsin2,vcos2;
			UP_TRIG1
			vsin2 = SIN1;
			vcos2 = COS1;
			START_TRIG2
			for(h=0; h<=hdiv; h++) {
				float hsin1 = SIN2;
				float hcos1 = COS2;
				UP_TRIG2

				glNormal3f(vsin2 * hcos1, vcos2, vsin2 * hsin1);
				TC(h/hf,(v+1)/vf);
				glVertex3f(vsin2 * hcos1, vcos2, vsin2 * hsin1);

				glNormal3f(vsin1 * hcos1, vcos1, vsin1 * hsin1); 
				TC(h/hf,v/vf);
				glVertex3f(vsin1 * hcos1, vcos1, vsin1 * hsin1); 
			}
		}
		glEnd();
		glPopMatrix();
					/* if(!$nomode) {
						glPopAttrib();
					} */
		
			glEndList()
			;
}
			}

void Sphere_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER Sphere */
			struct VRML_Sphere *this_ = (struct VRML_Sphere *)nod_;
			{
	float r = (this_->radius);
	/* Center is at zero. t_r1 to t_r2 and t_r1 to zero are the vecs */
	float tr1sq = VECSQ(t_r1);
	float tr2sq = VECSQ(t_r2);
	float tr1tr2 = VECPT(t_r1,t_r2);
	struct pt dr2r1;
	float dlen;
	float a,b,c,disc;

	VECDIFF(t_r2,t_r1,dr2r1);
	dlen = VECSQ(dr2r1);

	a = dlen; /* tr1sq - 2*tr1tr2 + tr2sq; */
	b = 2*(VECPT(dr2r1, t_r1));
	c = tr1sq - r*r;

	disc = b*b - 4*a*c; /* The discriminant */
	
	if(disc > 0) { /* HITS */
		float q ;
		float sol1 ;
		float sol2 ;
		float cx,cy,cz;
		q = sqrt(disc);
		/* q = (-b+(b>0)?q:-q)/2; */
		sol1 = (-b+q)/(2*a);
		sol2 = (-b-q)/(2*a);
		/*
		printf("SPHSOL0: (%f %f %f) (%f %f %f)\n",
			t_r1.x, t_r1.y, t_r1.z, t_r2.x, t_r2.y, t_r2.z);
		printf("SPHSOL: (%f %f %f) (%f) (%f %f) (%f) (%f %f)\n",
			tr1sq, tr2sq, tr1tr2, a, b, c, und, sol1, sol2);
		*/
		cx = MRATX(sol1);
		cy = MRATY(sol1);
		cz = MRATZ(sol1);
		HIT(sol1, cx,cy,cz, cx/r,cy/r,cz/r, -1,-1, "sphere 0");
		cx = MRATX(sol2);
		cy = MRATY(sol2);
		cz = MRATZ(sol2);
		HIT(sol2, cx,cy,cz, cx/r,cy/r,cz/r, -1,-1, "sphere 1");
	}
}
			}

struct SFColor *Coordinate_Get3(void *nod_,int *n){ /* GENERATED FROM HASH Get3C, MEMBER Coordinate */
			struct VRML_Coordinate *this_ = (struct VRML_Coordinate *)nod_;
			{
	*n = ((this_->point).n); 
	return ((this_->point).p);
}
			}

void FontStyle_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER FontStyle */
			struct VRML_FontStyle *this_ = (struct VRML_FontStyle *)nod_;
			{}
			}

struct SFColor *Normal_Get3(void *nod_,int *n){ /* GENERATED FROM HASH Get3C, MEMBER Normal */
			struct VRML_Normal *this_ = (struct VRML_Normal *)nod_;
			{
	*n = ((this_->vector).n);
	return ((this_->vector).p);
}
			}

void Box_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Box */
			struct VRML_Box *this_ = (struct VRML_Box *)nod_;
			{
	 float x = ((this_->size).c[0])/2;
	 float y = ((this_->size).c[1])/2;
	 float z = ((this_->size).c[2])/2;
	 
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	glPushAttrib(GL_LIGHTING);
	glShadeModel(GL_FLAT);
		glBegin(GL_QUADS);
		glNormal3f(0,0,1);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(-x,y,z);
		TC(0,0);
		glVertex3f(-x,-y,z);
		TC(1,0);
		glVertex3f(x,-y,z);

		glNormal3f(0,0,-1);
		TC(1,0);
		glVertex3f(x,-y,-z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(0,1);
		glVertex3f(-x,y,-z);
		TC(1,1);
		glVertex3f(x,y,-z);

		glNormal3f(0,1,0);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(1,0);
		glVertex3f(x,y,-z);
		TC(0,0);
		glVertex3f(-x,y,-z);
		TC(0,1);
		glVertex3f(-x,y,z);

		glNormal3f(0,-1,0);
		TC(0,1);
		glVertex3f(-x,-y,z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(1,0);
		glVertex3f(x,-y,-z);
		TC(1,1);
		glVertex3f(x,-y,z);

		glNormal3f(1,0,0);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(x,-y,z);
		TC(0,0);
		glVertex3f(x,-y,-z);
		TC(1,0);
		glVertex3f(x,y,-z);

		glNormal3f(-1,0,0);
		TC(1,0);
		glVertex3f(-x,y,-z);
		TC(0,0);
		glVertex3f(-x,-y,-z);
		TC(0,1);
		glVertex3f(-x,-y,z);
		TC(1,1);
		glVertex3f(-x,y,z);
		glEnd();
	glPopAttrib();
	 
			glEndList()
			;
	}
			}

void Box_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER Box */
			struct VRML_Box *this_ = (struct VRML_Box *)nod_;
			{
	float x = ((this_->size).c[0])/2;
	float y = ((this_->size).c[1])/2;
	float z = ((this_->size).c[2])/2;
	/* 1. x=const-plane faces? */
	if(!XEQ) {
		float xrat0 = XRAT(x);
		float xrat1 = XRAT(-x);
		if(verbose) printf("!XEQ: %f %f\n",xrat0,xrat1);
		if(TRAT(xrat0)) {
			float cy = MRATY(xrat0);
			if(verbose) printf("TRok: %f\n",cy);
			if(cy >= -y && cy < y) {
				float cz = MRATZ(xrat0);
				if(verbose) printf("cyok: %f\n",cz);
				if(cz >= -z && cz < z) {
					if(verbose) printf("czok:\n");
					HIT(xrat0, x,cy,cz, 1,0,0, -1,-1, "cube x0");
				}
			}
		}
		if(TRAT(xrat1)) {
			float cy = MRATY(xrat1);
			if(cy >= -y && cy < y) {
				float cz = MRATZ(xrat1);
				if(cz >= -z && cz < z) {
					HIT(xrat1, -x,cy,cz, -1,0,0, -1,-1, "cube x1");
				}
			}
		}
	}
	if(!YEQ) {
		float yrat0 = YRAT(y);
		float yrat1 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			if(cx >= -x && cx < x) {
				float cz = MRATZ(yrat0);
				if(cz >= -z && cz < z) {
					HIT(yrat0, cx,y,cz, 0,1,0, -1,-1, "cube y0");
				}
			}
		}
		if(TRAT(yrat1)) {
			float cx = MRATX(yrat1);
			if(cx >= -x && cx < x) {
				float cz = MRATZ(yrat1);
				if(cz >= -z && cz < z) {
					HIT(yrat1, cx,-y,cz, 0,-1,0, -1,-1, "cube y1");
				}
			}
		}
	}
	if(!ZEQ) {
		float zrat0 = ZRAT(z);
		float zrat1 = ZRAT(-z);
		if(TRAT(zrat0)) {
			float cx = MRATX(zrat0);
			if(cx >= -x && cx < x) {
				float cy = MRATY(zrat0);
				if(cy >= -y && cy < y) {
					HIT(zrat0, cx,cy,z, 0,0,1, -1,-1,"cube z0");
				}
			}
		}
		if(TRAT(zrat1)) {
			float cx = MRATX(zrat1);
			if(cx >= -x && cx < x) {
				float cy = MRATY(zrat1);
				if(cy >= -y && cy < y) {
					HIT(zrat1, cx,cy,-z, 0,0,-1,  -1,-1,"cube z1");
				}
			}
		}
	}
}
			}

void Billboard_Prep(void *nod_){ /* GENERATED FROM HASH PrepC, MEMBER Billboard */
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
	GLdouble mod[16];
	GLdouble proj[16];
	struct pt vec, ax, cp, z = {0,0,1}, cp2,cp3, arcp;
	int align;
	double len; double len2;
	double angle;
	int sign;
	ax.x = ((this_->axisOfRotation).c[0]);
	ax.y = ((this_->axisOfRotation).c[1]);
	ax.z = ((this_->axisOfRotation).c[2]);
	align = (APPROX(VECSQ(ax),0));
	glPushMatrix();

	glGetDoublev(GL_MODELVIEW_MATRIX, mod);
	glGetDoublev(GL_PROJECTION_MATRIX, proj);
	gluUnProject(0,0,0,mod,proj,viewport,
		&vec.x,&vec.y,&vec.z);
	len = VECSQ(vec); if(APPROX(len,0)) {return;}
	VECSCALE(vec,1/sqrt(len));
	/* printf("Billboard: (%f %f %f) (%f %f %f)\n",vec.x,vec.y,vec.z,	
		ax.x, ax.y, ax.z); */
	if(!align) {
		VECCP(ax,z,arcp);
		VECCP(ax,arcp,cp3);
		len = VECSQ(ax); VECSCALE(ax,1/sqrt(len));
		VECCP(vec,ax,cp); /* cp is now 90deg to both vector and axis */
		len = sqrt(VECSQ(cp)); 
		if(APPROX(len,0)) {return;} /* Cant do a thing */
		VECSCALE(cp, 1/len)
		/* printf("Billboard: (%f %f %f) (%f %f %f)\n",cp.x,cp.y,cp.z,	
			cp3.x, cp3.y, cp3.z); */
		/* Now, find out angle between this and z axis */
		VECCP(cp,z,cp2);
		len2 = VECPT(cp,z); /* cos(angle) */
		len = sqrt(VECSQ(cp2)); /* this is abs(sin(angle)) */
		/* Now we need to find the sign first */
		if(VECPT(cp, arcp)>0) sign=-1; else sign=1;
		angle = atan2(len2,sign*len);
		/* printf("Billboard: sin angle = %f, cos angle = %f\n, sign: %d,
			atan2: %f\n", len, len2,sign,angle); */
		glRotatef(angle/3.1415926536*180, ax.x,ax.y,ax.z);
	} else {
		/* cp is the axis of the first rotation... */
		VECCP(z,vec,cp); len = sqrt(VECSQ(cp)); 
		VECSCALE(cp,1/len);
		VECCP(z,cp,cp2); 
		angle = asin(VECPT(cp2,vec));
		glRotatef(angle/3.1415926536*180, ax.x,ax.y,ax.z);
		
		/* XXXX */
		/* die("Cant do 0 0 0 billboard"); */

	}
}
			}

void Billboard_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Billboard */
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		int savedlight = curlight;
		extern struct VRML_Virt virt_DirectionalLight;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		if((this_->has_light)) {
			glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT);
			for(i=0; i<nc; i++) {
				void *p = ((this_->children).p[i]);
				if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
					render_node(p);
				}
			}
		}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			/* Hmm - how much time does this consume? */
			/* Not that much. */
			if(!(this_->has_light) || !
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				render_node(p);
			}
		}
		if((this_->has_light)) {
			glPopAttrib();
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
		curlight = savedlight;
	}
			}

void Billboard_Fin(void *nod_){ /* GENERATED FROM HASH FinC, MEMBER Billboard */
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
	glPopMatrix();
}
			}

void Billboard_Changed(void *nod_){ /* GENERATED FROM HASH ChangedC, MEMBER Billboard */
			struct VRML_Billboard *this_ = (struct VRML_Billboard *)nod_;
			{
		int i;
		int nc = ((this_->children).n); 
		extern struct VRML_Virt virt_DirectionalLight;
		(this_->has_light) = 0;
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				(this_->has_light) ++;
			}
		}
	}
			}

void ElevationGrid_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER ElevationGrid */
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		struct SFColor *colors; int ncolors=0;
		struct SFColor *normals; int nnormals=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD ElevationGrid color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD ElevationGrid normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			0, NULL,
			ncolors, colors,
			nnormals, normals
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}

void ElevationGrid_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER ElevationGrid */
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			0, NULL
		);
}
			}

void ElevationGrid_GenPolyRep(void *nod_){ /* GENERATED FROM HASH GenPolyRepC, MEMBER ElevationGrid */
			struct VRML_ElevationGrid *this_ = (struct VRML_ElevationGrid *)nod_;
			{
		int x,z;
		int nx = (this_->xDimension);
		float xs = (this_->xSpacing);
		int nz = (this_->zDimension);
		float zs = (this_->zSpacing);
		float *f = ((this_->height).p);
		float a[3],b[3];
		int *cindex; 
		float *coord;
		int *colindex;
		int ntri = (nx && nz ? 2 * (nx-1) * (nz-1) : 0);
		int triind;
		int nf = ((this_->height).n);
		int cpv = ((this_->colorPerVertex));
		struct SFColor *colors; int ncolors=0;
		struct VRML_PolyRep *rep_ = this_->_intern;
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD ElevationGrid color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		rep_->ntri = ntri;
		printf("Gen elevgrid %d %d %d\n", ntri, nx, nz);
		if(nf != nx * nz) {
			die("Elevationgrid: too many / too few: %d %d %d\n",
				nf, nx, nz);
		}
		if(ncolors) {
			if(!cpv && ncolors < (nx-1) * (nz-1)) {
				die("Elevationgrid: too few colors");
			}
			if(cpv && ncolors < nx*nz) {
				die("Elevationgrid: 2too few colors");
			}
		}
		cindex = rep_->cindex = malloc(sizeof(*(rep_->cindex))*3*(ntri));
		coord = rep_->coord = malloc(sizeof(*(rep_->coord))*nx*nz*3);
		colindex = rep_->colindex = malloc(sizeof(*(rep_->colindex))*3*(ntri));
		/* Flat */
		rep_->normal = malloc(sizeof(*(rep_->normal))*3*ntri);
		rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*ntri);
		/* Prepare the coordinates */
		for(x=0; x<nx; x++) {
		 for(z=0; z<nz; z++) {
		  float h = f[x+z*nx];
		  coord[(x+z*nx)*3+0] = x*xs;
		  coord[(x+z*nx)*3+1] = h;
		  coord[(x+z*nx)*3+2] = z*zs;
		 }
		}
		/* set the indices to the coordinates		*/
		{
		int A,B,C,D; /* should referr to the four vertices 
				of the polygon	
				(hopefully) counted counter-clockwise, like

				 D----C
				 |    |
				 |    |
				 |    |
				 A----B

				*/
		struct pt ac,bd,/* help vectors	*/
			ab,cd;	/* help vectors	for testing intersection */
		int E,F;	/* third point to be used for the triangles*/
			
		triind = 0;
		for(x=0; x<nx-1; x++) {
		 for(z=0; z<nz-1; z++) {
		  A=x+z*nx;
		  B=(x+1)+z*nx;
		  C=(x+1)+(z+1)*nx;
		  D=x+(z+1)*nx;
		/* calculate the distance A-C and see, 
			if it is smaller as B-D        			*/
		VEC_FROM_COORDDIFF(coord,C,coord,A,ac);
		VEC_FROM_COORDDIFF(coord,D,coord,B,bd);

		if(sqrt(VECSQ(ac))>sqrt(VECSQ(bd))) {
		      E=B; F=D;
		} else {
		      E=C; F=A;
		}
		  
		  /* 1: */
		  cindex[triind*3+0] = D;
		  cindex[triind*3+1] = A;
		  cindex[triind*3+2] = E;
		  if(cpv) {
			  colindex[triind*3+0] = D;
			  colindex[triind*3+1] = A;
			  colindex[triind*3+2] = E;
		  } else {
			  colindex[triind*3+0] = x+z*(nx-1);
			  colindex[triind*3+1] = x+z*(nx-1);
			  colindex[triind*3+2] = x+z*(nx-1);
		  }
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++;
		  /* 2: */
		  cindex[triind*3+0] = B;
		  cindex[triind*3+1] = C;
		  cindex[triind*3+2] = F;
		  if(cpv) {
			  colindex[triind*3+0] = B;
			  colindex[triind*3+1] = C;
			  colindex[triind*3+2] = F;
		  } else {
			  colindex[triind*3+0] = x+z*(nx-1);
			  colindex[triind*3+1] = x+z*(nx-1);
			  colindex[triind*3+2] = x+z*(nx-1);
		  }
		rep_->norindex[triind*3+0] = triind;
		rep_->norindex[triind*3+1] = triind;
		rep_->norindex[triind*3+2] = triind;
		  triind ++; 
		 }
		}
		} /* end of block */
		calc_poly_normals_flat(rep_);
	}
			}

void Extrusion_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Extrusion */
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			0, NULL,
			0, NULL,
			0, NULL
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}

void Extrusion_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER Extrusion */
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			0, NULL
		);
}
			}

void Extrusion_GenPolyRep(void *nod_){ /* GENERATED FROM HASH GenPolyRepC, MEMBER Extrusion */
			struct VRML_Extrusion *this_ = (struct VRML_Extrusion *)nod_;
			{
/*****begin of Member Extrusion	*/
/* This code originates from the file VRMLExtrusion.pm */
int nspi = ((this_->spine).n);			/* number of spine points	*/
int nsec = ((this_->crossSection).n);		/* no. of points in the 2D curve*/
int nori = ((this_->orientation).n);		/* no. of given orientators
					   which rotate the calculated SCPs =
					   spine-aligned cross-section planes*/ 
int nsca = ((this_->scale).n);			/* no. of scale parameters	*/
struct SFColor *spine =((this_->spine).p);	/* vector of spine vertices	*/
struct SFVec2f *curve =((this_->crossSection).p);/* vector of 2D curve points	*/
struct SFRotation *orientation=((this_->orientation).p);/*vector of SCP rotations*/

struct VRML_PolyRep *rep_=this_->_intern;/*internal rep, we want to fill*/
struct VRML_PolyRep tess_polyrep;	/* rep for tessellating the caps*/

/* the next four variables will point at members of *rep		*/
int   *cindex;				/* field containing indices into
					   the coord vector. Three together
					   indicate which points form a 
					   triangle			*/
float *coord;				/* contains vertices building the
					   triangles as x y z values	*/
int   *norindex;			/* indices into *normal		*/
float *normal;				/* (filled in a different function)*/ 


int ntri = 2 * (nspi-1) * (nsec-1);	/* no. of triangles to be used
					   to represent all, but the caps */
int nctri=0;				/* no. of triangles for both caps*/
int nctri_add=0;			/* max no. of add triangles for b.caps*/
int max_ncoord_add=0;			/* max no. of add coords	*/
int ncoord_add=0;			/* no. off added coords		*/
int ncoord=0;				/* no. of used coords		*/

int ncolinear_at_begin=0;		/* no. of triangles which need
					to be skipped, because curve-points
					are in one line at start of curve*/
int ncolinear_at_end=0;			/* no. of triangles which need
					to be skipped, because curve-points
					are in one line at end of curve*/

int spi,sec,triind,pos_of_last_zvalue;	/* help variables 		*/
int next_spi, prev_spi, help;
int t,i;				/* another loop var		*/


int closed = 0;				/* is spine  closed?		*/
int curve_closed=0;			/* is the 2D curve closed?	*/
int spine_is_one_vertix;		/* only one real spine vertix	*/

float spxlen,spylen,spzlen;		/* help vars for scaling	*/

					/* def:struct representing SCPs	*/
struct SCP { 				/* spine-aligned cross-section plane*/
	struct pt y;			/* y axis of SCP		*/
	struct pt z;			/* z axis of SCP		*/
	int prev,next;			/* index in SCP[]
					prev/next different vertix for 
					calculation of this SCP		*/
	   };

struct SCP *SCP;			/* dyn. vector rep. the SCPs	*/

struct pt spm1,spc,spp1,spcp,spy,spz,spoz,spx;	/* help vertix vars	*/


/* do we have a closed curve?						*/
if(curve[0].c[0] == curve[nsec-1].c[0] &&
   curve[0].c[1] == curve[nsec-1].c[1])
	curve_closed=1;

/* check if the spline is closed					*/

if(spine[0].c[0] == spine[nspi-1].c[0] &&
   spine[0].c[1] == spine[nspi-1].c[1] &&
   spine[0].c[2] == spine[nspi-1].c[2]) 
	closed = 1;
 
 

/************************************************************************
 * calc number of triangles per cap, if caps are enabled and possible	
 */

if(((this_->beginCap))||((this_->endCap))) {
	if(curve_closed?nsec<4:nsec<3) {
		die("Only two real vertices in crossSection. Caps not possible!");
	}

	if(verbose && closed && curve_closed) {
		printf("Spine and crossSection-curve are closed - how strange! ;-)\n");
		/* maybe we want to fly in this tunnel? Or it is semi 
		   transparent somehow? It is possible to create
		   nice figures if you rotate the cap planes... */
	}

	if(curve_closed)	nctri=nsec-3;
	else			nctri=nsec-2;	

		/* check if there are colinear points at the beginning of the curve*/
	sec=0;
	while(sec+2<=nsec-1 && 
		/* to find out if two vectors a and b are colinear, 
		   try a.x*b.y=a.y*b.x					*/
		APPROX(0,    (curve[sec+1].c[0]-curve[0].c[0])
			    *(curve[sec+2].c[1]-curve[0].c[1])
			  -  (curve[sec+1].c[1]-curve[0].c[1])
			    *(curve[sec+2].c[0]-curve[0].c[0]))	
	     ) ncolinear_at_begin++, sec++;

	/* check if there are colinear points at the end of the curve
		in line with the very first point, because we want to
		draw the triangle to there.				*/
	sec=curve_closed?(nsec-2):(nsec-1);
	while(sec-2>=0 && 
		APPROX(0,    (curve[sec  ].c[0]-curve[0].c[0])
			    *(curve[sec-1].c[1]-curve[0].c[1])
			  -  (curve[sec  ].c[1]-curve[0].c[1])
			    *(curve[sec-1].c[0]-curve[0].c[0]))	
	     ) ncolinear_at_end++,sec--;

	nctri-= ncolinear_at_begin+ncolinear_at_end;
	if(nctri<1) {
		/* no triangle left :(	*/
		die("All in crossSection points colinear. Caps not possible!");
 	}
 
 
	/* so we have calculated nctri for one cap, but we might have two*/
	nctri= ((((this_->beginCap)))?nctri:0) + ((((this_->endCap)))?nctri:0) ;
}
 
/* if we have non-convex polygons, we might need a few triangles more	*/
/* 	The unused memory will be freed with realloc later		*/
if(!((this_->convex))) {
	max_ncoord_add=(nspi-1)*(nsec-1) /* because of intersections	*/
			+nctri;		/* because of cap tesselation	*/
	nctri*=2;	/* we might need more trigs for the caps	*/
}

/************************************************************************
 * prepare for filling *rep
 */
 
rep_->ntri = ntri + nctri;	/* Thats the no. of triangles representing
				the whole Extrusion Shape.		*/
				

	
/* get some memory							*/
cindex  = rep_->cindex   = malloc(sizeof(*(rep_->cindex))*3*(rep_->ntri));
coord   = rep_->coord    =
		malloc(sizeof(*(rep_->coord))*(nspi*nsec+max_ncoord_add)*3);
 
normal  = rep_->normal   = malloc(sizeof(*(rep_->normal))*3*(rep_->ntri));
norindex= rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*(rep_->ntri));
 
/*memory for the SCPs. Only needed in this function. Freed later	*/
SCP     = malloc(sizeof(struct SCP)*nspi);
 
/* in C always check if you got the mem you wanted...  >;->		*/
if(!(cindex && coord && normal && norindex && SCP )) {
	die("Not enough memory for Extrusion node triangles... ;(");
} 
 

/************************************************************************
 * calculate all SCPs 
 */

spine_is_one_vertix=0;

/* fill the prev and next values in the SCP structs first
 *
 *	this is so complicated, because spine vertices can be the same
 *	They should have exactly the same SCP, therefore only one of
 *	an group of sucessive equal spine vertices (now called SESVs)
 *	must be used for calculation.
 *	For calculation the previous and next different spine vertix
 *	must be known. We save that info in the prev and next fields of
 *	the SCP struct. 
 *	Note: We have start and end SESVs which will be treated differently
 *	depending on whether the spine is closed or not
 *
 */
 
for(spi=0; spi<nspi;spi++){
	for(next_spi=spi+1;next_spi<nspi;next_spi++) {
		VEC_FROM_CDIFF(spine[spi],spine[next_spi],spp1);
		if(!APPROX(VECSQ(spp1),0))
			break;
	}
	if(next_spi<nspi) SCP[next_spi].prev=next_spi-1;

	if(verbose) printf("spi=%d next_spi=%d\n",spi,next_spi); /**/
	prev_spi=spi-1;
	SCP[spi].next=next_spi;
	SCP[spi].prev=prev_spi;
	
	while(next_spi>spi+1) { /* fill gaps */
		spi++;
		SCP[spi].next=next_spi;
		SCP[spi].prev=prev_spi;
	}
}
/* now:	start-SEVS .prev fields contain -1				*/
/* 	and end-SEVS .next fields contain nspi				*/


/* calculate the SCPs now...						*/

if(SCP[0].next==nspi) {
	spine_is_one_vertix=1;
	printf("All spine vertices are the same!\n");

	/* initialize all y and z values with zero, they will		*/
	/* be treated as colinear case later then			*/
	SCP[0].z.x=0; SCP[0].z.y=0; SCP[0].z.z=0;
	SCP[0].y=SCP[0].z;
	for(spi=1;spi<nspi;spi++) {
		SCP[spi].y=SCP[0].y;
		SCP[spi].z=SCP[0].z;
	}
}else{
	if(verbose) {
		for(spi=0;spi<nspi;spi++) {
			printf("SCP[%d].next=%d, SCP[%d].prev=%d\n",
				spi,SCP[spi].next,spi,SCP[spi].prev);
		}
	}
	
	/* find spine vertix different to the first spine vertix	*/
	spi=0; 		
	while(SCP[spi].prev==-1) spi++;

	/* find last spine vertix different to the last 		*/
	t=nspi-1; 
	while(SCP[t].next==nspi) t--;

	/* for all but the first + last really different spine vertix	*/
	for(; spi<=t; spi++) {
		/* calc y 	*/
		VEC_FROM_CDIFF(spine[SCP[spi].next],spine[SCP[spi].prev],SCP[spi].y);
		/* calc z	*/
		VEC_FROM_CDIFF(spine[SCP[spi].next],spine[spi],spp1);
		VEC_FROM_CDIFF(spine[SCP[spi].prev],spine[spi],spm1);
 		VECCP(spp1,spm1,SCP[spi].z);
 	}
 
 	if(closed) {
 		/* calc y for first SCP				*/
		VEC_FROM_CDIFF(spine[SCP[0].next],spine[SCP[nspi-1].prev],SCP[0].y); 
 		/* the last is the same as the first */	
 		SCP[nspi-1].y=SCP[0].y;	
        
		/* calc z */
		VEC_FROM_CDIFF(spine[SCP[0].next],spine[0],spp1);
		VEC_FROM_CDIFF(spine[SCP[nspi-1].prev],spine[0],spm1);
		VECCP(spp1,spm1,SCP[0].z);
		/* the last is the same as the first */	
		SCP[nspi-1].z=SCP[0].z;	
		
 	} else {
 		/* calc y for first SCP				*/
		VEC_FROM_CDIFF(spine[SCP[0].next],spine[0],SCP[0].y);

 		/* calc y for the last SCP			*/
		VEC_FROM_CDIFF(spine[nspi-1],spine[SCP[nspi-1].prev],SCP[nspi-1].y);
 
		/* z for the start SESVs is the same as for the next SCP */
		SCP[0].z=SCP[SCP[0].next].z; 
 		/* z for the last SCP is the same as for the one before the last*/
		SCP[nspi-1].z=SCP[SCP[nspi-1].prev].z; 
		
	} /* else */
	
	/* fill the other start SESVs SCPs*/
	spi=1; 
	while(SCP[spi].prev==-1) {
		SCP[spi].y=SCP[0].y;
		SCP[spi].z=SCP[0].z;
		spi++;
	}
	/* fill the other end SESVs SCPs*/
	t=nspi-2; 
	while(SCP[t].next==nspi) {
		SCP[t].y=SCP[nspi-1].y;
		SCP[t].z=SCP[nspi-1].z;
		t--;
	}

} /* else */


/* We have to deal with colinear cases, what means z=0			*/
pos_of_last_zvalue=-1;		/* where a zvalue is found */
for(spi=0;spi<nspi;spi++) {
	if(pos_of_last_zvalue>=0) { /* already found one?		*/
		if(APPROX(VECSQ(SCP[spi].z),0)) 
			SCP[spi].z= SCP[pos_of_last_zvalue].z;

		pos_of_last_zvalue=spi;	
	} else 
		if(!APPROX(VECSQ(SCP[spi].z),0)) {
			/* we got the first, fill the previous		*/
			if(verbose) printf("Found z-Value!\n");
			for(t=spi-1; t>-1; t--)
				SCP[t].z=SCP[spi].z;
 			pos_of_last_zvalue=spi;	
		}
}
 
if(verbose) printf("pos_of_last_zvalue=%d\n",pos_of_last_zvalue);
 
 
/* z axis flipping, if VECPT(SCP[i].z,SCP[i-1].z)<0 			*/
/* we can do it here, because it is not needed in the all-colinear case	*/
for(spi=(closed?2:1);spi<nspi;spi++) {
	if(VECPT(SCP[spi].z,SCP[spi-1].z)<0) {
		VECSCALE(SCP[spi].z,-1);
		if(verbose) 
		    printf("Extrusion.GenPloyRep: Flipped axis spi=%d\n",spi);
	}
} /* for */

/* One case is missing: whole spine is colinear				*/
if(pos_of_last_zvalue==-1) {
	printf("Extrusion.GenPloyRep:Whole spine is colinear!\n");

	/* this is the default, if we don`t need to rotate		*/
	spy.x=0; spy.y=1; spy.z=0;	
	spz.x=0; spz.y=0; spz.z=1;

	if(!spine_is_one_vertix) {
		/* need to find the rotation from SCP[spi].y to (0 1 0)*/
		/* and rotate (0 0 1) and (0 1 0) to be the new y and z	*/
		/* values for all SCPs					*/
		/* I will choose roation about the x and z axis		*/
		float alpha,gamma;	/* angles for the rotation	*/
		
		/* search a non trivial vector along the spine */
		for(spi=1;spi<nspi;spi++) {
			VEC_FROM_CDIFF(spine[spi],spine[0],spp1);
			if(!APPROX(VECSQ(spp1),0))
 				break;
 		}
 			
		/* normalize the non trivial vector */	
		spylen=1/sqrt(VECSQ(spp1)); VECSCALE(spp1,spylen);
		if(verbose)
			printf("Reference vector along spine=[%lf,%lf,%lf]\n",
				spp1.x,spp1.y,spp1.z);


		if(!(APPROX(spp1.x,0) && APPROX(spp1.z,0))) {
			/* at least one of x or z is not zero		*/

			/* get the angle for the x axis rotation	*/
			alpha=asin(spp1.z);

			/* get the angle for the z axis rotation	*/
			if(APPROX(cos(alpha),0))
				gamma=0;
			else {
				gamma=acos(spp1.y / cos(alpha) );
				if(fabs(sin(gamma)-(-spp1.x/cos(alpha))
					)>fabs(sin(gamma)))
					gamma=-gamma;
			}

			/* do the rotation (zero values are already worked in)*/
 			if(verbose)
				printf("alpha=%f gamma=%f\n",alpha,gamma);
			spy.x=cos(alpha)*(-sin(gamma));
			spy.y=cos(alpha)*cos(gamma);
			spy.z=sin(alpha);

			spz.x=sin(alpha)*sin(gamma);
			spz.y=(-sin(alpha))*cos(gamma);
			spz.z=cos(alpha);
		} /* if(!spine_is_one_vertix */
	} /* else */
 
	/* apply new y and z values to all SCPs	*/
	for(spi=0;spi<nspi;spi++) {
		SCP[spi].y=spy;
		SCP[spi].z=spz;
	}
 
} /* if all colinear */
 
if(verbose) {
	for(spi=0;spi<nspi;spi++) {
		printf("SCP[%d].y=[%lf,%lf,%lf], SCP[%d].z=[%lf,%lf,%lf]\n",
			spi,SCP[spi].y.x,SCP[spi].y.y,SCP[spi].y.z,
			spi,SCP[spi].z.x,SCP[spi].z.y,SCP[spi].z.z);
	}
}
 

/************************************************************************
 * calculate the coords 
 */

/* test for number of scale and orientation parameters			*/
if(nsca>1 && nsca <nspi)
	printf("Extrusion.GenPolyRep: Warning!\n"
	"\tNumber of scaling parameters do not match the number of spines!\n"
	"\tWill revert to using only the first scale value.\n");

if(nori>1 && nori <nspi)
	printf("Extrusion.GenPolyRep: Warning!\n"
	"\tNumber of orientation parameters "
		"do not match the number of spines!\n"
	"\tWill revert to using only the first orientation value.\n");


for(spi = 0; spi<nspi; spi++) {
	double m[3][3];		/* space for the rotation matrix	*/
	spy=SCP[spi].y; spz=SCP[spi].z;
	VECCP(spy,spz,spx);
	spylen = 1/sqrt(VECSQ(spy)); VECSCALE(spy, spylen);
	spzlen = 1/sqrt(VECSQ(spz)); VECSCALE(spz, spzlen);
	spxlen = 1/sqrt(VECSQ(spx)); VECSCALE(spx, spxlen);

	/* rotate spx spy and spz			*/
	if(nori) {
		int ori = (nori==nspi ? spi : 0);
		
		if(IS_ROTATION_VEC_NOT_NORMAL(orientation[ori]))
			printf("Extrusion.GenPolyRep: Warning!\n"
			  "\tRotationvector #%d not normal!\n"
			  "\tWon`t correct it, because it is bad VRML`97.\n",
			  ori+1); 
 			
		/* first variante:*/ 
		MATRIX_FROM_ROTATION(orientation[ori],m);
		VECMM(m,spx);
		VECMM(m,spy);
		VECMM(m,spz);
		/* */

		/* alternate code (second variant): */ 
		/*
		VECRROTATE(orientation[ori],spx);
		VECRROTATE(orientation[ori],spy);
		VECRROTATE(orientation[ori],spz);
		/* */
	} 
 
	for(sec = 0; sec<nsec; sec++) {
		struct pt point;
		float ptx = curve[sec].c[0];
		float ptz = curve[sec].c[1];
		if(nsca) {
			int sca = (nsca==nspi ? spi : 0);
			ptx *= ((this_->scale).p[sca]).c[0];
			ptz *= ((this_->scale).p[sca]).c[1];
 		}
		point.x = ptx;
		point.y = 0; 
		point.z = ptz;

	   coord[(sec+spi*nsec)*3+0] = 
	    spx.x * point.x + spy.x * point.y + spz.x * point.z
	    + ((this_->spine).p[spi]).c[0];
	   coord[(sec+spi*nsec)*3+1] = 
	    spx.y * point.x + spy.y * point.y + spz.y * point.z
	    + ((this_->spine).p[spi]).c[1];
	   coord[(sec+spi*nsec)*3+2] = 
	    spx.z * point.x + spy.z * point.y + spz.z * point.z
	    + ((this_->spine).p[spi]).c[2];

	} /* for(sec */
} /* for(spi */
ncoord=nsec*nspi;
 
 
/* freeing SCP coordinates. not needed anymore.				*/
if(SCP) free(SCP);
 
/************************************************************************
 * setting the values of *cindex to the right coords
 */
 
triind = 0;
{
int x,z; 
int A,B,C,D; /* should referr to the four vertices of the polygon	
		(hopefully) counted counter-clockwise, like
		 
		 D----C
		 |    |
		 |    |
		 |    |
		 A----B
		 
		*/
struct pt ac,bd,	/* help vectors	*/
	ab,cd;		/* help vectors	for testing intersection */
int E,F;		/* third point to be used for the triangles*/	
double u,r,		/* help variables for testing intersection */
	denominator,	/* ... */
	numerator;	/* ... */

if(verbose) {
	printf("Coords: \n");

	for(x=0; x<nsec; x++) {
	 for(z=0; z<nspi; z++) {
	 	int xxx = 3*(x+z*nsec);
	 	printf("[%f %f %f] ",
			coord[xxx], coord[xxx+1], coord[xxx+2]);
	 	
	 }
	printf("\n");
	}
	printf("\n");
}
	
for(x=0; x<nsec-1; x++) {
 for(z=0; z<nspi-1; z++) {
  A=x+z*nsec;
  B=(x+1)+z*nsec;
  C=(x+1)+(z+1)*nsec; 
  D= x+(z+1)*nsec;
  
  /* calculate the distance A-C and see, if it is smaller as B-D	*/
  VEC_FROM_COORDDIFF(coord,C,coord,A,ac);
  VEC_FROM_COORDDIFF(coord,D,coord,B,bd);

  if(sqrt(VECSQ(ac))>sqrt(VECSQ(bd))) {
  	E=B; F=D;
  } else {
  	E=C; F=A;
  }


  /* if concave polygons are expected, we also expect intersecting ones
  	so we are testing, whether A-B and D-C intersect	*/
  if(!((this_->convex))) {
    	VEC_FROM_COORDDIFF(coord,B,coord,A,ab);
  	VEC_FROM_COORDDIFF(coord,D,coord,C,cd);
	/* ca=-ac */
	if(verbose) {
		printf("ab=[%lf,%lf,%lf],cd=[%lf,%lf,%lf]\n",
			ab.x,ab.y,ab.z,cd.x,cd.y,cd.z);
		printf("Orig: %d %d  [%f %f %f] [%f %f %f] (%d, %d, %d) \n",
				D, C,
				coord[D*3], coord[D*3+1], coord[D*3+2],
				coord[C*3], coord[C*3+1], coord[C*3+2],
				ncoord, nsec, nspi
		);
	}
	denominator= ab.y*cd.x-ab.x*cd.y;
	numerator  = (-ac.x)*cd.y-(-ac.y)*cd.x;
	
	r=u=-1;
	if(!APPROX(denominator,0)) {
		u=numerator/denominator;
		r=((-ac.x)*ab.y-(-ac.y)*ab.x)/denominator;
	} else {
		/* lines still may be coincident*/
		if(APPROX(numerator,0)) {
			/* we have to calculate u and r using the z coord*/
			denominator=ab.z*cd.x-ab.x*cd.z;
			numerator  = (-ac.x)*cd.z-(-ac.z)*cd.x;
			if(!APPROX(denominator,0)) {
			u=numerator/denominator;
			r=((-ac.x)*ab.y-(-ac.y)*ab.x)/denominator;
			} 
		}
	} /* else */
	if(verbose) printf("u=%lf, r=%lf\n",u,r);
	if(u>=0 && u<=1 && r>=0 && r<=1 
		&& (-ac.x)+u*ab.x==r*cd.x
		&& (-ac.y)+u*ab.y==r*cd.y
		&& (-ac.z)+u*ab.z==r*cd.z ) {
		
		if(verbose) printf("Intersection found at P=[%lf,%lf,%lf]!\n",
			coord[A*3]+u*ab.x,
			coord[A*3+1]+u*ab.y,
			coord[A*3+2]+u*ab.y
			);
		coord[(ncoord)*3  ]=coord[A*3  ]+u*ab.x;
		coord[(ncoord)*3+1]=coord[A*3+1]+u*ab.y;
		coord[(ncoord)*3+2]=coord[A*3+2]+u*ab.z;
		E=ncoord;
		F=ncoord;
		ncoord_add++;
		ncoord++;
	}

  } 

  
  /* first triangle */
  cindex[triind*3+0] = D;
  cindex[triind*3+1] = A;
  cindex[triind*3+2] = E;
  norindex[triind*3+0] = triind;
  norindex[triind*3+1] = triind;
  norindex[triind*3+2] = triind;
  triind ++;
  /* second triangle*/
  cindex[triind*3+0] = B;
  cindex[triind*3+1] = C;
  cindex[triind*3+2] = F;
  norindex[triind*3+0] = triind;
  norindex[triind*3+1] = triind;
  norindex[triind*3+2] = triind;
  triind ++; 
 }
}

/* for the caps */

if(verbose) {
	if(((this_->beginCap))) 
		printf("Extrusion.GenPloyRep:We have a beginCap!\n"); 
	if(((this_->endCap))) 
		printf("Extrusion.GenPloyRep:We have a endCap!\n"); 
}
	
	
if(((this_->convex))) {
	/* this is the simple case with convex polygons	*/
	if(((this_->beginCap))) {
		for(x=0+ncolinear_at_begin; x<nsec-3-ncolinear_at_end; x++) {
			cindex[triind*3+0] = 0;
			cindex[triind*3+1] = x+2;
			cindex[triind*3+2] = x+1;
			norindex[triind*3+0] = triind;
			norindex[triind*3+1] = triind;
			norindex[triind*3+2] = triind;
			triind ++;
		}
		if(!curve_closed) {	/* non closed need one triangle more	*/
			cindex[triind*3+0] = 0;
			cindex[triind*3+1] = x+2;
			cindex[triind*3+2] = x+1;
			norindex[triind*3+0] = triind;
			norindex[triind*3+1] = triind;
			norindex[triind*3+2] = triind;
			triind ++;
 		}
	} /* if beginCap */
	
	if(((this_->endCap))) {
		for(x=0+ncolinear_at_begin; x<nsec-3-ncolinear_at_end; x++) {
			cindex[triind*3+0] = 0  +(nspi-1)*nsec;
			cindex[triind*3+1] = x+2+(nspi-1)*nsec;
			cindex[triind*3+2] = x+1+(nspi-1)*nsec;
			norindex[triind*3+0] = triind;
			norindex[triind*3+1] = triind;
			norindex[triind*3+2] = triind;
			triind ++;
		}
		if(!curve_closed) {	/* non closed needs one triangle more	*/
			cindex[triind*3+0] = 0  +(nspi-1)*nsec;
			cindex[triind*3+1] = x+2+(nspi-1)*nsec;
			cindex[triind*3+2] = x+1+(nspi-1)*nsec;
			norindex[triind*3+0] = triind;
			norindex[triind*3+1] = triind;
			norindex[triind*3+2] = triind;
			triind ++;
 		}
	} /* if endCap */
	
} else 
    if(((this_->beginCap))||((this_->endCap))) { 
	/* polygons might be concave-> do tessellation			*/

	GLdouble tess_v[3];		/*param.to gluTessVertex()*/
	GLdouble *tess_vs;		/* pointer to space needed */
	struct pt help_pt;		/* help vertix		*/
	int ncoord_new=0;		/* # of coords added	*/
	

    	if(verbose)printf("Extrusion.GenPolyRep: Trying to tessellate caps.\n");
	
	nctri=0;
	tess_polyrep.ntri= nsec*2 ;	
	tess_polyrep.alloc_tri= nsec*2 ;	
				/* max number of resulting tris -
				   2*nsec + caps */
		
					/* get memory	*/
	tess_polyrep.cindex=malloc(
			sizeof(*(tess_polyrep.cindex))*3*(tess_polyrep.ntri));
	tess_polyrep.coord=malloc(
			sizeof(*(tess_polyrep.coord))*9*(tess_polyrep.ntri));
	tess_vs=malloc(sizeof(*(tess_vs))*9*(tess_polyrep.ntri));
	if(!(tess_polyrep.cindex&&tess_polyrep.coord&&tess_vs))
		die("Got no memory!\n");
		
		
	if(((this_->beginCap))){	
		tess_polyrep.ntri=0;	/* first triangle index to be filled*/
		global_tess_polyrep=&tess_polyrep;
		gluBeginPolygon(global_tessobj);
		gluNextContour(global_tessobj,GLU_UNKNOWN);
		help=curve_closed?nsec-1:nsec;
		for(sec=0;sec<help;sec++) {
			tess_v[0]=tess_vs[sec*3]  =coord[sec*3];
			tess_v[1]=tess_vs[sec*3+1]=coord[sec*3+1];
			tess_v[2]=tess_vs[sec*3+2]=coord[sec*3+2];
			/* the third argument is the pointer, we get back*/
			gluTessVertex(global_tessobj,tess_v,&tess_vs[sec*3]);
		}
		gluEndPolygon(global_tessobj);
		
		
if(verbose) {
		for(t=0;t<tess_polyrep.ntri;t++) {
		    for(i=0;i<3;i++) {
	        	printf("coord[%dff]=%lf,%lf,%lf\n",
			   tess_polyrep.cindex[t*3+i]*3,
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3],
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+1],
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+2]);
		    }
		}
}
		
		ncoord_new=0;
		for(t=0;t<tess_polyrep.ntri;t++) {
		    for(i=0;i<3;i++) {
			/* see if the needed coords are already there	*/
			cindex[triind*3+i]=-1;
			for(sec=0;sec<help;sec++) {
				VEC_FROM_COORDDIFF(tess_polyrep.coord,tess_polyrep.cindex[t*3+i],coord,sec,help_pt);
				if(APPROX(VECSQ(help_pt),0)) {
		 			cindex[triind*3+i]=sec;
					break;  
		 		}
			}
			if(cindex[triind*3+i]==-1)
			    for(sec=ncoord-ncoord_new;sec<ncoord;sec++) {
				VEC_FROM_COORDDIFF(tess_polyrep.coord,tess_polyrep.cindex[t*3+i],coord,sec,help_pt);
				if(APPROX(VECSQ(help_pt),0)) {
		 			cindex[triind*3+i]=sec;
					break;
				}  
			    }

			if(cindex[triind*3+i]==-1) {
			  /* we need to add a new coord   */
			  coord[ncoord*3]  =
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3];
			  coord[ncoord*3+1]=
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+1];
			  coord[ncoord*3+2]=
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+2];
			  cindex[triind*3+i]=ncoord;
			  ncoord_add++;
			  ncoord_new++;
			  ncoord++;
			}	
			norindex[triind*3+i] = triind;
		    }
		    triind++; nctri++;
		}
	} /* if beginCap */
	
	
	
	if(((this_->endCap))){	
		tess_polyrep.ntri=0;	/* first triangle index to be filled*/
		global_tess_polyrep=&tess_polyrep;
		gluBeginPolygon(global_tessobj);
		gluNextContour(global_tessobj,GLU_UNKNOWN);
		help=curve_closed?nsec-1:nsec;
		for(sec=0;sec<help;sec++) {
		      tess_v[0]=tess_vs[sec*3]  =coord[((nspi-1)*nsec+sec)*3];
		      tess_v[1]=tess_vs[sec*3+1]=coord[((nspi-1)*nsec+sec)*3+1];
		      tess_v[2]=tess_vs[sec*3+2]=coord[((nspi-1)*nsec+sec)*3+2];
		      /* the third argument is the pointer, we get back*/
		      gluTessVertex(global_tessobj,tess_v,&tess_vs[sec*3]);
		}
		gluEndPolygon(global_tessobj);
		
		
if(verbose) {
		for(t=0;t<tess_polyrep.ntri;t++) {
		    for(i=0;i<3;i++) {
	        	printf("coord[%dff]=%lf,%lf,%lf\n",
			   tess_polyrep.cindex[t*3+i]*3,
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3],
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+1],
			   tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+2]);
		    }
		}
}

		help=(curve_closed?nsec-1:nsec)+(nspi-1)*nsec;
		ncoord_new=0;
		for(t=0;t<tess_polyrep.ntri;t++) {
		    for(i=0;i<3;i++) {
			/* see if the needed coords are already there	*/
			cindex[triind*3+i]=-1;
			for(sec=(nspi-1)*nsec;sec<help;sec++) {
				VEC_FROM_COORDDIFF(tess_polyrep.coord,tess_polyrep.cindex[t*3+i],coord,sec,help_pt);

/*printf("help_pt=[%lf,%lf,%lf]\n",help_pt.x,help_pt.y,help_pt.z);
 */
				if(APPROX(VECSQ(help_pt),0)) {

/*printf("vertex found at %d\n",sec);
 */
		 			cindex[triind*3+i]=sec;
					break;  
		 		}
			}
			if(cindex[triind*3+i]==-1)
			    for(sec=ncoord-ncoord_new;sec<ncoord;sec++) {
				VEC_FROM_COORDDIFF(tess_polyrep.coord,tess_polyrep.cindex[t*3+i],coord,sec,help_pt);
				if(APPROX(VECSQ(help_pt),0)) {

/*printf("vertex found at %d\n",sec);
 */
		 			cindex[triind*3+i]=sec;
					break;
				}  
			    }

			if(cindex[triind*3+i]==-1) {
			  /* we need to add a new coord   */
			  coord[ncoord*3]  =
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3];
			  coord[ncoord*3+1]=
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+1];
			  coord[ncoord*3+2]=
			     tess_polyrep.coord[tess_polyrep.cindex[t*3+i]*3+2];
			  cindex[triind*3+i]=ncoord;
			  ncoord_add++;
			  ncoord_new++;
			  ncoord++;
			}	
			norindex[triind*3+i] = triind;
		    }
		    triind++; nctri++;
		}
	} /* if endCap */	
	
	if(tess_polyrep.coord) free(tess_polyrep.coord);
	if(tess_polyrep.cindex) free(tess_polyrep.cindex);
	if(tess_vs) free(tess_vs);
	
    } /* elseif */
 

} /* end of block */

/* free memory we haven`t used	*/
if(!((this_->convex))) {
	if(ncoord_add<max_ncoord_add)
		realloc(coord,sizeof(*(rep_->coord))*(ncoord)*3);
	if(triind<rep_->ntri) {
		rep_->ntri=triind;
		realloc(cindex,sizeof(*(rep_->cindex))*3*(rep_->ntri));
		realloc(normal,sizeof(*(rep_->normal))*3*(rep_->ntri));
		realloc(norindex,sizeof(*(rep_->norindex))*3*(rep_->ntri));
	}
}


/* XXX if(verbose)*/
	printf("Extrusion.GenPloyRep: triind=%d  ntri=%d nctri=%d "
	"ncolinear_at_begin=%d ncolinear_at_end=%d\n",
	triind,ntri,nctri,ncolinear_at_begin,ncolinear_at_end);
 
 
calc_poly_normals_flat(rep_);
/*****end of Member Extrusion	*/
}
			}

void Switch_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Switch */
			struct VRML_Switch *this_ = (struct VRML_Switch *)nod_;
			{
		int wc = (this_->whichChoice);
		if(wc >= 0 && wc < ((this_->choice).n)) {
			void *p = ((this_->choice).p[wc]);
			render_node(p);
		}
	}
			}

void ImageTexture_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER ImageTexture */
			struct VRML_ImageTexture *this_ = (struct VRML_ImageTexture *)nod_;
			{
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data),na);
			if((this_->__depth) && (this_->__x) && (this_->__y)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x)) {rx /= 2;}
				ry = 1; sy = (this_->__y);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y)) {ry /= 2;}

				if(rx != (this_->__x) || ry != (this_->__y)) {
					/* We have to scale */
					dest = malloc((this_->__depth) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x), (this_->__y) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x), (this_->__y),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth),(this_->__x),(this_->__y));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth),  
					     rx, ry,
					     0,
					     ((this_->__depth)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

	
			glEndList()
			;
}
			}

struct SFVec2f *TextureCoordinate_Get2(void *nod_,int *n){ /* GENERATED FROM HASH Get2C, MEMBER TextureCoordinate */
			struct VRML_TextureCoordinate *this_ = (struct VRML_TextureCoordinate *)nod_;
			{
	*n = ((this_->point).n);
	return ((this_->point).p);
}
			}

void IndexedFaceSet_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER IndexedFaceSet */
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
		struct SFColor *points; int npoints;
		struct SFColor *colors; int ncolors=0;
		struct SFColor *normals; int nnormals=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD IndexedFaceSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD IndexedFaceSet normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		if(!((this_->solid))) {
			glPushAttrib(GL_ENABLE_BIT);
			glDisable(GL_CULL_FACE);
		}
		render_polyrep(this_, 
			npoints, points,
			ncolors, colors,
			nnormals, normals
		);
		if(!((this_->solid))) {
			glPopAttrib();
		}
		
			glEndList()
			;
}
			}

void IndexedFaceSet_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER IndexedFaceSet */
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
		struct SFColor *points; int npoints;
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
		if(!this_->_intern || 
			this_->_change != ((struct VRML_PolyRep *)this_->_intern)->_change)
				regen_polyrep(this_);;
		render_ray_polyrep(this_, 
			npoints, points
		);
}
			}

void IndexedFaceSet_GenPolyRep(void *nod_){ /* GENERATED FROM HASH GenPolyRepC, MEMBER IndexedFaceSet */
			struct VRML_IndexedFaceSet *this_ = (struct VRML_IndexedFaceSet *)nod_;
			{
	int i;
	int cin = ((this_->coordIndex).n);
	int cpv = ((this_->colorPerVertex));
	/* int npv = xf(normalPerVertex); */
	int curpoly;
	int ntri = 0;
	int nvert = 0;
	struct SFColor *c1,*c2,*c3;
	float a[3]; float b[3];
	struct SFColor *points; int npoints;
	struct SFColor *normals; int nnormals=0;
	struct VRML_PolyRep *rep_ = this_->_intern;
	int *cindex;
	int *colindex;
	if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedFaceSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedFaceSet coord "));};
	if(this_->normal) {
		  if(!(*(struct VRML_Virt **)(this_->normal))-> get3) {
		  	die("NULL METHOD IndexedFaceSet normal  get3");
		  }
		   normals =  ((*(struct VRML_Virt **)(this_->normal))-> get3(this_->normal,
		     &nnormals)) ;
		};
	
	for(i=0; i<cin; i++) {
		if(((this_->coordIndex).p[i]) == -1) {
			if(nvert < 3) {
				die("Too few vertices in indexedfaceset poly");
			}
			ntri += nvert-2;
			nvert = 0;
		} else {
			nvert ++;
		}
	}
	if(nvert>2) {ntri += nvert-2;}
	cindex = rep_->cindex = malloc(sizeof(*(rep_->cindex))*3*(ntri));
	colindex = rep_->colindex = malloc(sizeof(*(rep_->colindex))*3*(ntri));
	rep_->ntri = ntri;
	if(!nnormals) {
		/* We have to generate -- do flat only for now */
		rep_->normal = malloc(sizeof(*(rep_->normal))*3*ntri);
		rep_->norindex = malloc(sizeof(*(rep_->norindex))*3*ntri);
	} else {
		rep_->normal = NULL;
		rep_->norindex = NULL;
	}
	/* color = NULL; coord = NULL; normal = NULL;
		colindex = NULL; norindex = NULL;
	*/
	if(!((this_->convex))) {
		die("AAAAARGHHH!!!  Non-convex polygons! Help!");
		/* XXX Fixme using gluNewTess, gluTessVertex et al */
	} else {
		int initind=-1;
		int lastind=-1;
		int triind = 0;
		curpoly = 0;
		for(i=0; i<cin; i++) {
			if(((this_->coordIndex).p[i]) == -1) {
				initind=-1;
				lastind=-1;
				curpoly ++;
			} else {
				if(initind == -1) {
					initind = ((this_->coordIndex).p[i]);
				} else if(lastind == -1) {
					lastind = ((this_->coordIndex).p[i]);
				} else {
					cindex[triind*3+0] = initind;
					cindex[triind*3+1] = lastind;
					cindex[triind*3+2] = ((this_->coordIndex).p[i]);
					if(cpv) {
						colindex[triind*3+0] = initind;
						colindex[triind*3+1] = lastind;
						colindex[triind*3+2] = ((this_->coordIndex).p[i]);
					} else {
						colindex[triind*3+0] = curpoly;
						colindex[triind*3+1] = curpoly;
						colindex[triind*3+2] = curpoly;
					}
					if(rep_->normal) {
						c1 = &(points[initind]);
						c2 = &(points[lastind]); 
						c3 = &(points[((this_->coordIndex).p[i])]);
						a[0] = c2->c[0] - c1->c[0];
						a[1] = c2->c[1] - c1->c[1];
						a[2] = c2->c[2] - c1->c[2];
						b[0] = c3->c[0] - c1->c[0];
						b[1] = c3->c[1] - c1->c[1];
						b[2] = c3->c[2] - c1->c[2];
						rep_->normal[triind*3+0] =
							a[1]*b[2] - b[1]*a[2];
						rep_->normal[triind*3+1] =
							-(a[0]*b[2] - b[0]*a[2]);
						rep_->normal[triind*3+2] =
							a[0]*b[1] - b[0]*a[1];
						rep_->norindex[triind*3+0] = triind;
						rep_->norindex[triind*3+1] = triind;
						rep_->norindex[triind*3+2] = triind;
					}
					lastind = ((this_->coordIndex).p[i]);
					triind++;
				}
			}
		}
	}
}
			}

void Background_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Background */
			struct VRML_Background *this_ = (struct VRML_Background *)nod_;
			{
	GLdouble mod[16];
	GLdouble proj[16];
	GLdouble unit[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
	struct pt vec[4]; struct pt vec2[4]; struct pt vec3[4];
	int i,j; int ind=0;
	GLdouble x,y,z;
	GLdouble x1,y1,z1;
	GLdouble sx, sy, sz;
	struct SFColor *c1,*c2;
	int hdiv = horiz_div;
	int h,v;
	double va1, va2, ha1, ha2;	/* JS - vert and horiz angles 	*/

	if(!((this_->isBound))) {return;}
	/* Cannot start_list() because of moving center */

	glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT|GL_TEXTURE_BIT);
	glShadeModel(GL_SMOOTH);
	glPushMatrix();

	glGetDoublev(GL_MODELVIEW_MATRIX, mod);
	glGetDoublev(GL_PROJECTION_MATRIX, proj);
	/* Get origin */
	gluUnProject(0,0,0,mod,proj,viewport,&x,&y,&z);
	glTranslatef(x,y,z);


	gluUnProject(0,0,0,mod,unit,viewport,&x,&y,&z);
	/* Get scale */
	gluProject(x+1,y,z,mod,unit,viewport,&x1,&y1,&z1);
	sx = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );
	gluProject(x,y+1,z,mod,unit,viewport,&x1,&y1,&z1);
	sy = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );
	gluProject(x,y,z+1,mod,unit,viewport,&x1,&y1,&z1);
	sz = 1/sqrt( x1*x1 + y1*y1 + z1*z1*4 );

	/* Undo the translation and scale effects */
	glScalef(sx,sy,sz);
	 if(verbose)  printf("TS: %f %f %f,      %f %f %f\n",x,y,z,sx,sy,sz);
	glDisable(GL_LIGHTING);

	glScalef(200,200,200);

	if(((this_->skyColor).n) == 1) {
		c1 = &(((this_->skyColor).p[0]));
		glColor3f(c1->c[0], c1->c[1], c1->c[2]);

		/* Actually, one should do it... ? */
		/* XXX */

		glBegin(GL_TRIANGLES);
		for(h=0; h<hdiv; h++) {
			ha1 = h * 6.29 / hdiv;
			ha2 = (h+1) * 6.29 / hdiv;
			/* glNormal3f(sin(van) * cos(han), sin(van) * sin(han), cos(van)); */
			glVertex3f(0, 1, 0);
			glVertex3f(cos(ha1), 0, sin(ha1));
			glVertex3f(cos(ha2), 0, sin(ha2));
			glVertex3f(0, -1, 0);
			glVertex3f(cos(ha2), 0, sin(ha2));
			glVertex3f(cos(ha1), 0, sin(ha1));
		}
		glEnd();
	} else {
		glBegin(GL_QUADS);
		for(v=0; v<((this_->skyColor).n); v++) {
			if(v==0) {
				va1 = 0;
			} else {
				va1 = ((this_->skyAngle).p[v-1]);
			}
			c1 = &(((this_->skyColor).p[v]));
			if(v==((this_->skyColor).n)-1) {
				c2 = &(((this_->skyColor).p[v]));
				/* JS - should this be 3.142 or 1.57 depends if there is a groundcolor defd. */
				/* JS - 3.142 here gives us the full circle in case ground not defined. */
				/* JS - note, these are in radians, and va = vertical angle		*/
				if(((this_->groundColor).n)>0) {
					va2 = 1.57;
				} else {
                                	va2=3.142;
				}
			} else {
				c2 = &(((this_->skyColor).p[v+1]));
				va2 = ((this_->skyAngle).p[v]);
			}

			for(h=0; h<hdiv; h++) {
				ha1 = h * 6.29 / hdiv;
				ha2 = (h+1) * 6.29 / hdiv;

				/* glNormal3f(sin(van) * cos(han), sin(van) * sin(han), cos(van)); */
				glColor3f(c2->c[0], c2->c[1], c2->c[2]);
				glVertex3f(sin(va2) * cos(ha1), cos(va2), sin(va2) * sin(ha1));
				glVertex3f(sin(va2) * cos(ha2), cos(va2), sin(va2) * sin(ha2));
				glColor3f(c1->c[0], c1->c[1], c1->c[2]);
				glVertex3f(sin(va1) * cos(ha2), cos(va1), sin(va1) * sin(ha2));
				glVertex3f(sin(va1) * cos(ha1), cos(va1), sin(va1) * sin(ha1));
			}
		}
		glEnd();
	}
	glBegin(GL_QUADS);
	for(v=0; v<((this_->groundColor).n); v++) {
		/* JS - note, we go from 1.57 onwards...  va = vertical angle */
		if(v==0) {
			va1 = 1.57;
		} else {
			va1 = ((this_->groundAngle).p[v-1])+1.57;
		}

		c1 = &(((this_->groundColor).p[v]));
		if(v==((this_->groundColor).n)-1) {
			c2 = &(((this_->groundColor).p[v]));
			va2 = 3.142;
		} else {
			/* JS - these were skyColor and skyAngle in v0.17 */
			c2 = &(((this_->groundColor).p[v+1]));
			va2 = ((this_->groundAngle).p[v]) + 1.57;
		}

		for(h=0; h<hdiv; h++) {
			ha1 = (h * 6.29 / hdiv);
			ha2 = ((h+1) * 6.29 / hdiv);

			/* glNormal3f(sin(van) * cos(han), sin(van) * sin(han), cos(van)); */
			glColor3f(c2->c[0], c2->c[1], c2->c[2]);
			glVertex3f(sin(va2) * cos(ha1), cos(va2), sin(va2) * sin(ha1));
			glVertex3f(sin(va2) * cos(ha2), cos(va2), sin(va2) * sin(ha2));
			glColor3f(c1->c[0], c1->c[1], c1->c[2]);
			glVertex3f(sin(va1) * cos(ha2), cos(va1), sin(va1) * sin(ha2));
			glVertex3f(sin(va1) * cos(ha1), cos(va1), sin(va1) * sin(ha1));
		}
	}
	glEnd();
	
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_front),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_front),na);
			if((this_->__depth_front) && (this_->__x_front) && (this_->__y_front)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_front);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_front)) {rx /= 2;}
				ry = 1; sy = (this_->__y_front);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_front)) {ry /= 2;}

				if(rx != (this_->__x_front) || ry != (this_->__y_front)) {
					/* We have to scale */
					dest = malloc((this_->__depth_front) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_front), (this_->__y_front) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_front)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_front), (this_->__y_front),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_front),(this_->__x_front),(this_->__y_front));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_front),  
					     rx, ry,
					     0,
					     ((this_->__depth_front)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(0,0,1);
		TC(1,1);
		glVertex3f(x,y,z);
		TC(0,1);
		glVertex3f(-x,y,z);
		TC(0,0);
		glVertex3f(-x,-y,z);
		TC(1,0);
		glVertex3f(x,-y,z);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_back),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_back),na);
			if((this_->__depth_back) && (this_->__x_back) && (this_->__y_back)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_back);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_back)) {rx /= 2;}
				ry = 1; sy = (this_->__y_back);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_back)) {ry /= 2;}

				if(rx != (this_->__x_back) || ry != (this_->__y_back)) {
					/* We have to scale */
					dest = malloc((this_->__depth_back) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_back), (this_->__y_back) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_back)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_back), (this_->__y_back),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_back),(this_->__x_back),(this_->__y_back));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_back),  
					     rx, ry,
					     0,
					     ((this_->__depth_back)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(0,0,-(1));
		TC(1,1);
		glVertex3f(x,y,-(z));
		TC(0,1);
		glVertex3f(-x,y,-(z));
		TC(0,0);
		glVertex3f(-x,-y,-(z));
		TC(1,0);
		glVertex3f(x,-y,-(z));
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_top),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_top),na);
			if((this_->__depth_top) && (this_->__x_top) && (this_->__y_top)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_top);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_top)) {rx /= 2;}
				ry = 1; sy = (this_->__y_top);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_top)) {ry /= 2;}

				if(rx != (this_->__x_top) || ry != (this_->__y_top)) {
					/* We have to scale */
					dest = malloc((this_->__depth_top) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_top), (this_->__y_top) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_top)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_top), (this_->__y_top),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_top),(this_->__x_top),(this_->__y_top));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_top),  
					     rx, ry,
					     0,
					     ((this_->__depth_top)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(0,1,0);
		TC(1,1);
		glVertex3f(x,z,y);
		TC(0,1);
		glVertex3f(-x,z,y);
		TC(0,0);
		glVertex3f(-x,z,-y);
		TC(1,0);
		glVertex3f(x,z,-y);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_bottom),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_bottom),na);
			if((this_->__depth_bottom) && (this_->__x_bottom) && (this_->__y_bottom)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_bottom);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_bottom)) {rx /= 2;}
				ry = 1; sy = (this_->__y_bottom);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_bottom)) {ry /= 2;}

				if(rx != (this_->__x_bottom) || ry != (this_->__y_bottom)) {
					/* We have to scale */
					dest = malloc((this_->__depth_bottom) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_bottom), (this_->__y_bottom) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_bottom)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_bottom), (this_->__y_bottom),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_bottom),(this_->__x_bottom),(this_->__y_bottom));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_bottom),  
					     rx, ry,
					     0,
					     ((this_->__depth_bottom)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(0,-(1),0);
		TC(1,1);
		glVertex3f(x,-(z),y);
		TC(0,1);
		glVertex3f(-x,-(z),y);
		TC(0,0);
		glVertex3f(-x,-(z),-y);
		TC(1,0);
		glVertex3f(x,-(z),-y);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_left),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_left),na);
			if((this_->__depth_left) && (this_->__x_left) && (this_->__y_left)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_left);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_left)) {rx /= 2;}
				ry = 1; sy = (this_->__y_left);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_left)) {ry /= 2;}

				if(rx != (this_->__x_left) || ry != (this_->__y_left)) {
					/* We have to scale */
					dest = malloc((this_->__depth_left) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_left), (this_->__y_left) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_left)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_left), (this_->__y_left),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_left),(this_->__x_left),(this_->__y_left));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_left),  
					     rx, ry,
					     0,
					     ((this_->__depth_left)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(1,0,0);
		TC(1,1);
		glVertex3f(z,y,x);
		TC(0,1);
		glVertex3f(z,y,-x);
		TC(0,0);
		glVertex3f(z,-y,-x);
		TC(1,0);
		glVertex3f(z,-y,x);
		glEnd();
		}
		}
		{
		float x=0.5,y=0.5,z=0.5;
		unsigned int len;
		unsigned char *ptr = SvPV((this_->__data_right),len);
		if(ptr && len) {

		
		  {
			int rx,sx,ry,sy;
			unsigned char *ptr = SvPV((this_->__data_right),na);
			if((this_->__depth_right) && (this_->__x_right) && (this_->__y_right)) {
				unsigned char *dest = ptr;
				rx = 1; sx = (this_->__x_right);
				while(sx) {sx /= 2; rx *= 2;}
				if(rx/2 == (this_->__x_right)) {rx /= 2;}
				ry = 1; sy = (this_->__y_right);
				while(sy) {sy /= 2; ry *= 2;}
				if(ry/2 == (this_->__y_right)) {ry /= 2;}

				if(rx != (this_->__x_right) || ry != (this_->__y_right)) {
					/* We have to scale */
					dest = malloc((this_->__depth_right) * rx * ry);
					printf("Scaling %d %d to %d %d
",
						(this_->__x_right), (this_->__y_right) ,
						rx, ry);
					gluScaleImage(
					     ((this_->__depth_right)==1 ? GL_LUMINANCE : GL_RGB),
					     (this_->__x_right), (this_->__y_right),
					     GL_UNSIGNED_BYTE,
					     ptr,
					     rx, ry,
					     GL_UNSIGNED_BYTE,
					     dest
					);
				}


				printf("PTR: %d, %d %d %d %d %d %d %d %d %d %d
",
					dest, dest[0], dest[1], dest[2], dest[3], dest[4], dest[5],
					dest[6], dest[7], dest[8], dest[9]);

				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
				glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
				printf("Doing imagetext %d %d %d
",(this_->__depth_right),(this_->__x_right),(this_->__y_right));
				glDisable(GL_LIGHTING);
				glEnable(GL_TEXTURE_2D);
				glColor3f(1,1,1);
					
				glTexImage2D(GL_TEXTURE_2D,
					     0, 
					     (this_->__depth_right),  
					     rx, ry,
					     0,
					     ((this_->__depth_right)==1 ? GL_LUMINANCE : GL_RGB),
					     GL_UNSIGNED_BYTE,
					     dest
				);
				if(ptr != dest) free(dest);
			}
		     }
			;

		glBegin(GL_QUADS);
		glNormal3f(-(1),0,0);
		TC(1,1);
		glVertex3f(-(z),y,x);
		TC(0,1);
		glVertex3f(-(z),y,-x);
		TC(0,0);
		glVertex3f(-(z),-y,-x);
		TC(1,0);
		glVertex3f(-(z),-y,x);
		glEnd();
		}
		}
	glPopMatrix();
	glPopAttrib();
}
			}

void Text_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Text */
			struct VRML_Text *this_ = (struct VRML_Text *)nod_;
			{
	void (*f)(int n, SV **p,int nl, float *l, float maxext, double spacing,double size);
	double spacing = 1.0;
	double size = 1.0; 
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	/* We need both sides */
	glPushAttrib(GL_ENABLE_BIT);
	glDisable(GL_CULL_FACE);
	f = (void *)(this_->__rendersub);
	/* printf("Render text: %d \n", f); */
	if((this_->fontStyle)) {
		struct VRML_FontStyle *fsp = (this_->fontStyle);
		spacing = fsp->spacing;
		size = fsp->size;
	}
	if(f) {
		f(((this_->string).n),((this_->string).p),((this_->length).n),((this_->length).p),(this_->maxExtent),spacing,size );
	}
	glPopAttrib();
	
			glEndList()
			;
}
			}

void Cone_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Cone */
			struct VRML_Cone *this_ = (struct VRML_Cone *)nod_;
			{
		int div = horiz_div;
		float df = div;
		float h = (this_->height)/2;
		float r = (this_->bottomRadius); 
		float a,a1;
		int i;
		DECL_TRIG1
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(h <= 0 && r <= 0) {return;}
		INIT_TRIG1(div)
		if(((this_->bottom))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,-1,0);
			START_TRIG1
			for(i=div-1; i>=0; i--) {
				TC(0.5+0.5*-SIN1,0.5+0.5*COS1);
				glVertex3f(r*-SIN1,-h,r*COS1);
				UP_TRIG1
			}
			glEnd();
		}
		if(((this_->side))) {
			double ml = sqrt(h*h + r * r);
			double mlh = h / ml;
			double mlr = r / ml;
			glBegin(GL_TRIANGLES);
			START_TRIG1
			for(i=0; i<div; i++) {
				float lsin = SIN1;
				float lcos = COS1;
				UP_TRIG1;
				glNormal3f(mlh*lsin,mlr,-mlh*lcos);
				TC((i+0.5)/df,0);
				glVertex3f(0,h,0);
				glNormal3f(mlh*SIN1,mlr,-mlh*COS1);
				TC((i+1)/df,1);
				glVertex3f(r*SIN1,-h,-r*COS1);
				glNormal3f(mlh*lsin,mlr,-mlh*lcos);
				TC(i/df,1);
				glVertex3f(r*lsin,-h,-r*lcos);
			}
			glEnd();
		}
		
		
			glEndList()
			;
}
			}

void Cone_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER Cone */
			struct VRML_Cone *this_ = (struct VRML_Cone *)nod_;
			{
	float h = (this_->height)/2; /* pos and neg dir. */
	float y = h;
	float r = (this_->bottomRadius);
	float dx = t_r2.x-t_r1.x; float dz = t_r2.z-t_r1.z;
	float dy = t_r2.y-t_r1.y;
	float a = dx*dx + dz*dz - (r*r*dy*dy/(2*h*2*h));
	float b = 2*(dx*t_r1.x + dz*t_r1.z) +
		2*r*r*dy/(2*h)*(0.5-t_r1.y/(2*h));
	float tmp = (0.5-t_r1.y/(2*h));
	float c = t_r1.x * t_r1.x + t_r1.z * t_r1.z 
		- r*r*tmp*tmp;
	float und;
	b /= a; c /= a;
	und = b*b - 4*c;
	/* 
	printf("CONSOL0: (%f %f %f) (%f %f %f)\n",
		t_r1.x, t_r1.y, t_r1.z, t_r2.x, t_r2.y, t_r2.z);
	printf("CONSOL: (%f %f %f) (%f) (%f %f) (%f)\n",
		dx, dy, dz, a, b, c, und);
	*/
	if(und > 0) { /* HITS the infinite cylinder */
		float sol1 = (-b+sqrt(und))/2;
		float sol2 = (-b-sqrt(und))/2;
		float cy,cx,cz;
		float cy0;
		cy = MRATY(sol1);
		if(cy > -h && cy < h) {
			cx = MRATX(sol1);
			cz = MRATZ(sol1);
			/* XXX Normal */
			HIT(sol1, cx,cy,cz, cx/r,0,cz/r, -1,-1, "conside 1");
		}
		cy0 = cy;
		cy = MRATY(sol2);
		if(cy > -h && cy < h) {
			cx = MRATX(sol2);
			cz = MRATZ(sol2);
			HIT(sol2, cx,cy,cz, cx/r,0,cz/r, -1,-1, "conside 2");
		}
		/*
		printf("CONSOLV: (%f %f) (%f %f)\n", sol1, sol2,cy0,cy);
		*/
	}
	if(!YEQ) {
		float yrat0 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			float cz = MRATZ(yrat0);
			if(r*r > cx*cx + cz*cz) {
				HIT(yrat0, cx, -y, cz, 0, -1, 0, -1, -1, "conbot");
			}
		}
	}
}
			}

void Viewpoint_Prep(void *nod_){ /* GENERATED FROM HASH PrepC, MEMBER Viewpoint */
			struct VRML_Viewpoint *this_ = (struct VRML_Viewpoint *)nod_;
			{
	if(render_vp) {
		GLint vp[10];
		double a1;
		double angle;
		if(verbose) printf("Viewpoint: %d IB: %d..\n", 
			this_,((this_->isBound)));
		if(!((this_->isBound))) {return;}
		render_anything = 0; /* Stop rendering any more */
		/* These have to be in this order because the viewpoint
		 * rotates in its place */
		glRotatef(-(((this_->orientation).r[3]))/3.1415926536*180,((this_->orientation).r[0]),((this_->orientation).r[1]),((this_->orientation).r[2])
		);
		glTranslatef(-(((this_->position).c[0])),-(((this_->position).c[1])),-(((this_->position).c[2]))
		);
		glGetIntegerv(GL_VIEWPORT, vp);
		if(vp[2] > vp[3]) {
			a1=0;
			angle = (this_->fieldOfView)/3.1415926536*180;
		} else {
			a1 = (this_->fieldOfView);
			a1 = atan2(sin(a1),vp[2]/((float)vp[3]) * cos(a1));
			angle = a1/3.1415926536*180;
		}
		if(verbose) printf("Vp: %d %d %d %d %f %f\n", vp[0], vp[1], vp[2], vp[3],
			a1, angle);

		glMatrixMode(GL_PROJECTION);
		glPopMatrix(); /* This is so we do picking right */
		/* glLoadIdentity(); */
		gluPerspective(angle,vp[2]/(float)vp[3],0.1,vp_dist);
		glMatrixMode(GL_MODELVIEW);
	}
}
			}

void TextureTransform_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER TextureTransform */
			struct VRML_TextureTransform *this_ = (struct VRML_TextureTransform *)nod_;
			{
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	glMatrixMode(GL_TEXTURE);
	glTranslatef(((this_->translation).c[0]), ((this_->translation).c[1]), 0);
	glTranslatef(((this_->center).c[0]),((this_->center).c[1]), 0);
	glRotatef(0,0,1,(this_->rotation)/3.1415926536*180);
	glScalef(((this_->scale).c[0]),((this_->scale).c[1]),1);
	glTranslatef(-((this_->center).c[0]),-((this_->center).c[1]), 0);
	glMatrixMode(GL_MODELVIEW);
	
			glEndList()
			;
}
			}

void Group_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Group */
			struct VRML_Group *this_ = (struct VRML_Group *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		int savedlight = curlight;
		extern struct VRML_Virt virt_DirectionalLight;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		if((this_->has_light)) {
			glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT);
			for(i=0; i<nc; i++) {
				void *p = ((this_->children).p[i]);
				if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
					render_node(p);
				}
			}
		}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			/* Hmm - how much time does this consume? */
			/* Not that much. */
			if(!(this_->has_light) || !
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				render_node(p);
			}
		}
		if((this_->has_light)) {
			glPopAttrib();
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
		curlight = savedlight;
	}
			}

void Group_Changed(void *nod_){ /* GENERATED FROM HASH ChangedC, MEMBER Group */
			struct VRML_Group *this_ = (struct VRML_Group *)nod_;
			{
		int i;
		int nc = ((this_->children).n); 
		extern struct VRML_Virt virt_DirectionalLight;
		(this_->has_light) = 0;
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				(this_->has_light) ++;
			}
		}
	}
			}

void ProximitySensor_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER ProximitySensor */
			struct VRML_ProximitySensor *this_ = (struct VRML_ProximitySensor *)nod_;
			{
	/* Viewer pos = t_r2 */
	double cx,cy,cz;
	double len;
	struct pt dr1r2;
	struct pt dr2r3;
	struct pt vec;
	struct pt nor1,nor2;
	struct pt ins;
	static const struct pt yvec = {0,0.05,0};
	static const struct pt zvec = {0,0,-0.05};
	static const struct pt zpvec = {0,0,0.05};
	static const struct pt orig = {0,0,0};
	struct pt t_zvec, t_yvec, t_orig;
GLdouble modelMatrix[16]; 
GLdouble projMatrix[16];

	glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluUnProject(orig.x,orig.y,orig.z,modelMatrix,projMatrix,viewport,
		&t_orig.x,&t_orig.y,&t_orig.z);
	gluUnProject(zvec.x,zvec.y,zvec.z,modelMatrix,projMatrix,viewport,
		&t_zvec.x,&t_zvec.y,&t_zvec.z);
	gluUnProject(yvec.x,yvec.y,yvec.z,modelMatrix,projMatrix,viewport,
		&t_yvec.x,&t_yvec.y,&t_yvec.z);

	cx = t_orig.x - ((this_->center).c[0]);
	cy = t_orig.y - ((this_->center).c[1]);
	cz = t_orig.z - ((this_->center).c[2]);

	if(!((this_->enabled))) return;
	if(((this_->size).c[0]) == 0 || ((this_->size).c[1]) == 0 || ((this_->size).c[2]) == 0) return;

	if(fabs(cx) > ((this_->size).c[0])/2 ||
	   fabs(cy) > ((this_->size).c[1])/2 ||
	   fabs(cz) > ((this_->size).c[2])/2) return;

	(this_->__hit) = 1;

	((this_->__t1).c[0]) = t_orig.x;
	((this_->__t1).c[1]) = t_orig.y;
	((this_->__t1).c[2]) = t_orig.z;

	VECDIFF(t_zvec,t_orig,dr1r2);  /* Z axis */
	VECDIFF(t_yvec,t_orig,dr2r3);  /* Y axis */

	len = sqrt(VECSQ(dr1r2)); VECSCALE(dr1r2,1/len);
	len = sqrt(VECSQ(dr2r3)); VECSCALE(dr2r3,1/len);

	if(verbose) printf("PROX_INT: (%f %f %f) (%f %f %f) (%f %f %f)\n (%f %f %f) (%f %f %f)\n",
		t_orig.x, t_orig.y, t_orig.z, 
		t_zvec.x, t_zvec.y, t_zvec.z, 
		t_yvec.x, t_yvec.y, t_yvec.z,
		dr1r2.x, dr1r2.y, dr1r2.z, 
		dr2r3.x, dr2r3.y, dr2r3.z
		);
	
	if(fabs(VECPT(dr1r2, dr2r3)) > 0.001) {
		die("Sorry, can't handle unevenly scaled ProximitySensors yet :("
		  "dp: %f v: (%f %f %f) (%f %f %f)", VECPT(dr1r2, dr2r3),
		  	dr1r2.x,dr1r2.y,dr1r2.z,
		  	dr2r3.x,dr2r3.y,dr2r3.z
			);
	}


	if(APPROX(dr1r2.z,1.0)) {
		((this_->__t2).r[0]) = 0;
		((this_->__t2).r[1]) = 0;
		((this_->__t2).r[2]) = 1;
		((this_->__t2).r[3]) = atan2(-dr2r3.x,dr2r3.y);
	} else if(APPROX(dr2r3.y,1.0)) {
		((this_->__t2).r[0]) = 0;
		((this_->__t2).r[1]) = 1;
		((this_->__t2).r[2]) = 0;
		((this_->__t2).r[3]) = atan2(dr1r2.x,dr1r2.z);
	} else {
		/* Get the normal vectors of the possible rotation planes */
		nor1 = dr1r2;
		nor1.z -= 1.0;
		nor2 = dr2r3;
		nor2.y -= 1.0;
		/* Now, the intersection of the planes, obviously cp */
		VECCP(nor1,nor2,ins);
		if(APPROX(VECSQ(ins),0)) {
			printf ("Should die here: Proximitysensor problem!\n");
/*
# JAS			die("Proximitysensor problem!"
# JAS		  "dp: %f v: (%f %f %f) (%f %f %f)\n"
# JAS		  "Nor,I (%f %f %f) (%f %f %f) (%f %f %f)\n"
# JAS		, 
# JAS			VECPT(dr1r2, dr2r3),
# JAS		  	dr1r2.x,dr1r2.y,dr1r2.z,
# JAS		  	dr2r3.x,dr2r3.y,dr2r3.z,
# JAS		  	nor1.x,nor1.y,nor1.z,
# JAS		  	nor2.x,nor2.y,nor2.z,
# JAS		  	ins.x,ins.y,ins.z
# JAS			);
*/
		}
		len = sqrt(VECSQ(ins)); VECSCALE(ins,1/len);
		((this_->__t2).r[0]) = ins.x;
		((this_->__t2).r[1]) = ins.y;
		((this_->__t2).r[2]) = ins.z;
		/* Finally, the angle */
		VECCP(dr1r2,ins, nor1);
		VECCP(zpvec, ins, nor2);
		len = sqrt(VECSQ(nor1)); VECSCALE(nor1,1/len);
		len = sqrt(VECSQ(nor2)); VECSCALE(nor2,1/len);
		VECCP(nor1,nor2,ins);
		((this_->__t2).r[3]) = -atan2(sqrt(VECSQ(ins)), VECPT(nor1,nor2));
	}
	if(verbose) printf("NORS: (%f %f %f) (%f %f %f) (%f %f %f)\n",
		nor1.x, nor1.y, nor1.z,
		nor2.x, nor2.y, nor2.z,
		ins.x, ins.y, ins.z
	);
}
			}

void Material_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Material */
			struct VRML_Material *this_ = (struct VRML_Material *)nod_;
			{	float m[4]; int i;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		m[0] = ((this_->diffuseColor).c[0]);m[1] = ((this_->diffuseColor).c[1]);m[2] = ((this_->diffuseColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, m);
		for(i=0; i<3; i++) {
			m[i] *= (this_->ambientIntensity);
		}
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, m);
		m[0] = ((this_->specularColor).c[0]);m[1] = ((this_->specularColor).c[1]);m[2] = ((this_->specularColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, m);

		m[0] = ((this_->emissiveColor).c[0]);m[1] = ((this_->emissiveColor).c[1]);m[2] = ((this_->emissiveColor).c[2]);m[3] = 1;;
		glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, m);

		glColor3f(m[0],m[1],m[2]);

		if(fabs((this_->shininess) - 0.2) > 0.001) {
			printf("Set shininess: %f\n",(this_->shininess));
			glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 
				128 * (this_->shininess));
				/* 128*(this_->shininess)*(this_->shininess)); */
				/* 128-(128*(this_->shininess))); */
				/* 1.0/((",getf(Material,shininess),"+1)/128.0)); */
		}
		
			glEndList()
			;
}
			}

void Appearance_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Appearance */
			struct VRML_Appearance *this_ = (struct VRML_Appearance *)nod_;
			{
		if((this_->material)) {render_node((this_->material));}
		else {
			glDisable(GL_LIGHTING);
			glColor3f(1.0,1.0,1.0);
		} /* XXX */
		if((this_->texture)) {
			render_node((this_->texture));
		}
		if((this_->textureTransform)) {
			render_node((this_->textureTransform));
		}
	}
			}

void Shape_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Shape */
			struct VRML_Shape *this_ = (struct VRML_Shape *)nod_;
			{
		/* if(!(this_->appearance) || !(this_->geometry)) */
		if(!(this_->geometry)) {
			return;
		}
		glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT|GL_TEXTURE_BIT);
		/* glLightModeli(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE); */
		if((this_->appearance)) {
			render_node((this_->appearance));
		} else {
			glDisable(GL_LIGHTING);
			glColor3f(1.0,1.0,1.0);
		}
		render_node((this_->geometry));
		glPopAttrib();
	}
			}

void IndexedLineSet_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER IndexedLineSet */
			struct VRML_IndexedLineSet *this_ = (struct VRML_IndexedLineSet *)nod_;
			{
		int i;
		int cin = ((this_->coordIndex).n);
		int colin = ((this_->colorIndex).n);
		int cpv = ((this_->colorPerVertex));
		int plno = 0;
		int ind1,ind2;
		int ind;
		int c;
		struct SFColor *points; int npoints;
		struct SFColor *colors; int ncolors=0;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD IndexedLineSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD IndexedLineSet coord "));};
		if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD IndexedLineSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
		glDisable(GL_LIGHTING);
		if(ncolors && !cpv) {
			glColor3f(colors[plno].c[0],
				  colors[plno].c[1],
				  colors[plno].c[2]);
		}
		glBegin(GL_LINE_STRIP);
		for(i=0; i<cin; i++) {
			ind = ((this_->coordIndex).p[i]);
			if(verbose) printf("Line: %d %d\n",i,ind); 
			if(ind==-1) {
				glEnd();
				plno++;
				if(ncolors && !cpv) {
					c = plno;
					if((!colin && plno < ncolors) ||
					   (colin && plno < colin)) {
						if(colin) {
							c = ((this_->colorIndex).p[c]);
						}
						glColor3f(colors[c].c[0],
							  colors[c].c[1],
							  colors[c].c[2]);
					}
				}
				glBegin(GL_LINE_STRIP);
			} else {
				if(ncolors && cpv) {
					c = i;
					if(colin) {
						c = ((this_->colorIndex).p[c]);
					}
					glColor3f(colors[c].c[0],
						  colors[c].c[1],
						  colors[c].c[2]);
				}
				/* printf("Line: vertex %f %f %f\n",
					points[ind].c[0],
					points[ind].c[1],
					points[ind].c[2]
				);
				*/
				glVertex3f(
					points[ind].c[0],
					points[ind].c[1],
					points[ind].c[2]
				);
			}
		}
		glEnd();
		glEnable(GL_LIGHTING);
		
			glEndList()
			;
}
			}

void PointSet_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER PointSet */
			struct VRML_PointSet *this_ = (struct VRML_PointSet *)nod_;
			{
	int i; 
	struct SFColor *points; int npoints=0;
	struct SFColor *colors; int ncolors=0;
	
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
	if(this_->coord) {
		  if(!(*(struct VRML_Virt **)(this_->coord))-> get3) {
		  	die("NULL METHOD PointSet coord  get3");
		  }
		   points =  ((*(struct VRML_Virt **)(this_->coord))-> get3(this_->coord,
		     &npoints)) ;}
 	  else { (die("NULL FIELD PointSet coord "));};
	if(this_->color) {
		  if(!(*(struct VRML_Virt **)(this_->color))-> get3) {
		  	die("NULL METHOD PointSet color  get3");
		  }
		   colors =  ((*(struct VRML_Virt **)(this_->color))-> get3(this_->color,
		     &ncolors)) ;
		};
	if(ncolors && ncolors != npoints) {
		die("Not same number of colors and points");
	}
	glDisable(GL_LIGHTING);
	glBegin(GL_POINTS);
	if(verbose) printf("PointSet: %d %d\n", npoints, ncolors);
	for(i=0; i<npoints; i++) {
		if(ncolors) {
			if(verbose) printf("Color: %f %f %f\n",
				  colors[i].c[0],
				  colors[i].c[1],
				  colors[i].c[2]);
			glColor3f(colors[i].c[0],
				  colors[i].c[1],
				  colors[i].c[2]);
		}
		glVertex3f(
			points[i].c[0],
			points[i].c[1],
			points[i].c[2]
		);
	}
	glEnd();
	glEnable(GL_LIGHTING);
	
			glEndList()
			;
}
			}

void Cylinder_Rend(void *nod_){ /* GENERATED FROM HASH RendC, MEMBER Cylinder */
			struct VRML_Cylinder *this_ = (struct VRML_Cylinder *)nod_;
			{
		int div = horiz_div;
		float df = div;
		float h = (this_->height)/2;
		float r = (this_->radius);
		float a,a1,a2;
		DECL_TRIG1
		int i;
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		INIT_TRIG1(div)
		if(((this_->bottom))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,1,0);
			START_TRIG1
			for(i=0; i<div; i++) {
				TC(0.5+0.5*SIN1,0.5+0.5*SIN1);
				glVertex3f(r*SIN1,h,r*COS1);
				UP_TRIG1
			}
			glEnd();
		} 
		if(((this_->top))) {
			glBegin(GL_POLYGON);
			glNormal3f(0,-1,0);
			START_TRIG1
			for(i=div-1; i>=0; i--) {
				TC(0.5+0.5*-SIN1,0.5+0.5*COS1);
				glVertex3f(-r*SIN1,-h,r*COS1);
				UP_TRIG1
			}
			glEnd();
		}
		if(((this_->side))) {
				/* if(!nomode) {
				glPushAttrib(GL_LIGHTING);
				# glShadeModel(GL_SMOOTH);
				} */
			glBegin(GL_QUADS);
			START_TRIG1
			for(i=0; i<div; i++) {
				float lsin = SIN1;
				float lcos = COS1;
				UP_TRIG1;
				glNormal3f(lsin,0,lcos);
				TC(i/df,0);
				glVertex3f(r*lsin,-h,r*lcos);
				glNormal3f(SIN1,0,COS1);
				TC((i+1)/df,0);
				glVertex3f(r*SIN1,-h,r*COS1);
				/* glNormal3f(sin(a1),0,cos(a1));  (same) */
				TC((i+1)/df,1);
				glVertex3f(r*SIN1,h,r*COS1);
				glNormal3f(lsin,0,lcos);
				TC(i/df,1);
				glVertex3f(r*lsin,h,r*lcos);
			}
			glEnd();
				/*
				if(!nomode) {
				glPopAttrib();
				}
				*/
		}
		
			glEndList()
			;
}
			}

void Cylinder_RendRay(void *nod_){ /* GENERATED FROM HASH RendRayC, MEMBER Cylinder */
			struct VRML_Cylinder *this_ = (struct VRML_Cylinder *)nod_;
			{
	float h = (this_->height)/2; /* pos and neg dir. */
	float r = (this_->radius);
	float y = h;
	/* Caps */
	if(!YEQ) {
		float yrat0 = YRAT(y);
		float yrat1 = YRAT(-y);
		if(TRAT(yrat0)) {
			float cx = MRATX(yrat0);
			float cz = MRATZ(yrat0);
			if(r*r > cx*cx+cz*cz) {
				HIT(yrat0, cx,y,cz, 0,1,0, -1,-1, "cylcap 0");
			}
		}
		if(TRAT(yrat1)) {
			float cx = MRATX(yrat1);
			float cz = MRATZ(yrat1);
			if(r*r > cx*cx+cz*cz) {
				HIT(yrat1, cx,-y,cz, 0,-1,0, -1,-1, "cylcap 1");
			}
		}
	}
	/* Body -- do same as for sphere, except no y axis in distance */
	if((!XEQ) && (!ZEQ)) {
		float dx = t_r2.x-t_r1.x; float dz = t_r2.z-t_r1.z;
		float a = dx*dx + dz*dz;
		float b = 2*(dx * t_r1.x + dz * t_r1.z);
		float c = t_r1.x * t_r1.x + t_r1.z * t_r1.z - r*r;
		float und;
		b /= a; c /= a;
		und = b*b - 4*c;
		if(und > 0) { /* HITS the infinite cylinder */
			float sol1 = (-b+sqrt(und))/2;
			float sol2 = (-b-sqrt(und))/2;
			float cy,cx,cz;
			cy = MRATY(sol1);
			if(cy > -h && cy < h) {
				cx = MRATX(sol1);
				cz = MRATZ(sol1);
				HIT(sol1, cx,cy,cz, cx/r,0,cz/r, -1,-1, "cylside 1");
			}
			cy = MRATY(sol2);
			if(cy > -h && cy < h) {
				cx = MRATX(sol2);
				cz = MRATZ(sol2);
				HIT(sol2, cx,cy,cz, cx/r,0,cz/r, -1,-1, "cylside 2");
			}
		}
	}
}
			}

void Anchor_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Anchor */
			struct VRML_Anchor *this_ = (struct VRML_Anchor *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		int savedlight = curlight;
		extern struct VRML_Virt virt_DirectionalLight;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		if((this_->has_light)) {
			glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT);
			for(i=0; i<nc; i++) {
				void *p = ((this_->children).p[i]);
				if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
					render_node(p);
				}
			}
		}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			/* Hmm - how much time does this consume? */
			/* Not that much. */
			if(!(this_->has_light) || !
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				render_node(p);
			}
		}
		if((this_->has_light)) {
			glPopAttrib();
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
		curlight = savedlight;
	}
			}

void Anchor_Changed(void *nod_){ /* GENERATED FROM HASH ChangedC, MEMBER Anchor */
			struct VRML_Anchor *this_ = (struct VRML_Anchor *)nod_;
			{
		int i;
		int nc = ((this_->children).n); 
		extern struct VRML_Virt virt_DirectionalLight;
		(this_->has_light) = 0;
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				(this_->has_light) ++;
			}
		}
	}
			}

void NavigationInfo_Prep(void *nod_){ /* GENERATED FROM HASH PrepC, MEMBER NavigationInfo */
			struct VRML_NavigationInfo *this_ = (struct VRML_NavigationInfo *)nod_;
			{
        if(verbose) printf("NavigationInfo: %d IB: %d..\n",
                this_,((this_->isBound)));
        if(!((this_->isBound))) {return;}
        /* I have no idea what else should go in here -- John Breen */
}
			}

void Transform_Prep(void *nod_){ /* GENERATED FROM HASH PrepC, MEMBER Transform */
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
	glPushMatrix();
	if(!reverse_trans) {
		
		        if(!this_->_dlist) {
				this_->_dlist = glGenLists(1);
			}
			if(this_->_dlchange != this_->_change) {
				glNewList(this_->_dlist,GL_COMPILE_AND_EXECUTE);
				this_->_dlchange = this_->_change;
			} else {
				glCallList(this_->_dlist); return;
			};
		glTranslatef(((this_->translation).c[0]),((this_->translation).c[1]),((this_->translation).c[2])
		);
		glTranslatef(((this_->center).c[0]),((this_->center).c[1]),((this_->center).c[2])
		);
		glRotatef(((this_->rotation).r[3])/3.1415926536*180,((this_->rotation).r[0]),((this_->rotation).r[1]),((this_->rotation).r[2])
		);
		glRotatef(((this_->scaleOrientation).r[3])/3.1415926536*180,((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glScalef(((this_->scale).c[0]),((this_->scale).c[1]),((this_->scale).c[2])
		);
		glRotatef(-(((this_->scaleOrientation).r[3])/3.1415926536*180),((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glTranslatef(-(((this_->center).c[0])),-(((this_->center).c[1])),-(((this_->center).c[2]))
		);
		
			glEndList()
			;
	} else {
		
		        if(!this_->_dl2ist) {
				this_->_dl2ist = glGenLists(1);
			}
			if(this_->_dl2change != this_->_change) {
				glNewList(this_->_dl2ist,GL_COMPILE_AND_EXECUTE);
				this_->_dl2change = this_->_change;
			} else {
				glCallList(this_->_dl2ist); return;
			};
		glTranslatef(((this_->center).c[0]),((this_->center).c[1]),((this_->center).c[2])
		);
		glRotatef(((this_->scaleOrientation).r[3])/3.1415926536*180,((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glScalef(1.0/(((this_->scale).c[0])),1.0/(((this_->scale).c[1])),1.0/(((this_->scale).c[2]))
		);
		glRotatef(-(((this_->scaleOrientation).r[3])/3.1415926536*180),((this_->scaleOrientation).r[0]),((this_->scaleOrientation).r[1]),((this_->scaleOrientation).r[2])
		);
		glRotatef(-(((this_->rotation).r[3]))/3.1415926536*180,((this_->rotation).r[0]),((this_->rotation).r[1]),((this_->rotation).r[2])
		);
		glTranslatef(-(((this_->center).c[0])),-(((this_->center).c[1])),-(((this_->center).c[2]))
		);
		glTranslatef(-(((this_->translation).c[0])),-(((this_->translation).c[1])),-(((this_->translation).c[2]))
		);
		
			glEndList()
			;
	}
}
			}

void Transform_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER Transform */
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
		int nc = ((this_->children).n); 
		int i;
		int savedlight = curlight;
		extern struct VRML_Virt virt_DirectionalLight;
		if(verbose) {printf("RENDER GROUP START %d (%d)\n",this_, nc);}
		if((this_->has_light)) {
			glPushAttrib(GL_LIGHTING_BIT|GL_ENABLE_BIT);
			for(i=0; i<nc; i++) {
				void *p = ((this_->children).p[i]);
				if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
					render_node(p);
				}
			}
		}
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(verbose) {printf("RENDER GROUP %d CHILD %d\n",this_, p);}
			/* Hmm - how much time does this consume? */
			/* Not that much. */
			if(!(this_->has_light) || !
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				render_node(p);
			}
		}
		if((this_->has_light)) {
			glPopAttrib();
		}
		if(verbose) {printf("RENDER GROUP END %d\n",this_);}
		curlight = savedlight;
	}
			}

void Transform_Fin(void *nod_){ /* GENERATED FROM HASH FinC, MEMBER Transform */
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
	glPopMatrix();
}
			}

void Transform_Changed(void *nod_){ /* GENERATED FROM HASH ChangedC, MEMBER Transform */
			struct VRML_Transform *this_ = (struct VRML_Transform *)nod_;
			{
		int i;
		int nc = ((this_->children).n); 
		extern struct VRML_Virt virt_DirectionalLight;
		(this_->has_light) = 0;
		for(i=0; i<nc; i++) {
			void *p = ((this_->children).p[i]);
			if(
				(((struct VRML_Box *)p)->v == 	
					& virt_DirectionalLight)) {
				(this_->has_light) ++;
			}
		}
	}
			}

void SpotLight_Light(void *nod_){ /* GENERATED FROM HASH LightC, MEMBER SpotLight */
			struct VRML_SpotLight *this_ = (struct VRML_SpotLight *)nod_;
			{
		if(((this_->on))) {
			int light = nextlight();
			if(light >= 0) {
				float vec[4];
				glEnable(light);
				vec[0] = ((this_->direction).c[0]);
				vec[1] = ((this_->direction).c[1]);
				vec[2] = ((this_->direction).c[2]);
				vec[3] = 1;
				glLightfv(light, GL_SPOT_DIRECTION, vec);
				vec[0] = ((this_->location).c[0]);
				vec[1] = ((this_->location).c[1]);
				vec[2] = ((this_->location).c[2]);
				vec[3] = 1;
				glLightfv(light, GL_POSITION, vec);

				glLightf(light, GL_CONSTANT_ATTENUATION, 
					((this_->attenuation).c[0]));
				glLightf(light, GL_LINEAR_ATTENUATION, 
					((this_->attenuation).c[1]));
				glLightf(light, GL_QUADRATIC_ATTENUATION, 
					((this_->attenuation).c[2]));


				vec[0] = ((this_->color).c[0]) * (this_->intensity);
				vec[1] = ((this_->color).c[1]) * (this_->intensity);
				vec[2] = ((this_->color).c[2]) * (this_->intensity);
				vec[3] = 1;
				glLightfv(light, GL_DIFFUSE, vec);
				glLightfv(light, GL_SPECULAR, vec);
				vec[0] *= (this_->ambientIntensity);
				vec[1] *= (this_->ambientIntensity);
				vec[2] *= (this_->ambientIntensity);
				glLightfv(light, GL_AMBIENT, vec);

				/* XXX */
				glLightf(light, GL_SPOT_EXPONENT,
					0.5/((this_->beamWidth)+0.1));
				glLightf(light, GL_SPOT_CUTOFF,
					(this_->cutOffAngle)/3.1415926536*180);
			}
		}
	}
			}

void LOD_Child(void *nod_){ /* GENERATED FROM HASH ChildC, MEMBER LOD */
			struct VRML_LOD *this_ = (struct VRML_LOD *)nod_;
			{
		GLdouble mod[16];
		GLdouble proj[16];
		struct pt vec;
		double dist;
		int nran = ((this_->range).n);
		int nnod = ((this_->level).n);
		int i;
		if(!nran) {
			void *p = ((this_->level).p[ 0]);
			render_node(p);
			return;
		}

		glGetDoublev(GL_MODELVIEW_MATRIX, mod);
		glGetDoublev(GL_PROJECTION_MATRIX, proj);
		gluUnProject(0,0,0,mod,proj,viewport,
			&vec.x,&vec.y,&vec.z);
		vec.x -= ((this_->center).c[0]);
		vec.y -= ((this_->center).c[1]);
		vec.z -= ((this_->center).c[2]);
		dist = sqrt(VECSQ(vec));
		for(i=0; i<nran; i++) {
			if(dist < ((this_->range).p[i])) {
				void *p;
				if(i >= nnod) {i = nnod-1;}
				p = ((this_->level).p[i]);
				render_node(p);
			}
		}
		render_node(((this_->level).p[nnod-1]));

	}
			}

struct SFColor *Color_Get3(void *nod_,int *n){ /* GENERATED FROM HASH Get3C, MEMBER Color */
			struct VRML_Color *this_ = (struct VRML_Color *)nod_;
			{
	*n = ((this_->color).n); 
	return ((this_->color).p);
}
			}
static struct VRML_Virt virt_PointLight = { NULL,NULL,NULL,NULL,NULL,NULL,PointLight_Light,NULL,NULL,NULL,"PointLight"};
static struct VRML_Virt virt_DirectionalLight = { NULL,DirectionalLight_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"DirectionalLight"};
static struct VRML_Virt virt_Sphere = { NULL,Sphere_Rend,NULL,NULL,Sphere_RendRay,NULL,NULL,NULL,NULL,NULL,"Sphere"};
static struct VRML_Virt virt_Coordinate = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Coordinate_Get3,NULL,NULL,"Coordinate"};
static struct VRML_Virt virt_FontStyle = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"FontStyle"};
static struct VRML_Virt virt_Normal = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Normal_Get3,NULL,NULL,"Normal"};
static struct VRML_Virt virt_Box = { NULL,Box_Rend,NULL,NULL,Box_RendRay,NULL,NULL,NULL,NULL,NULL,"Box"};
static struct VRML_Virt virt_Billboard = { Billboard_Prep,NULL,Billboard_Child,Billboard_Fin,NULL,NULL,NULL,NULL,NULL,Billboard_Changed,"Billboard"};
static struct VRML_Virt virt_ElevationGrid = { NULL,ElevationGrid_Rend,NULL,NULL,ElevationGrid_RendRay,ElevationGrid_GenPolyRep,NULL,NULL,NULL,NULL,"ElevationGrid"};
static struct VRML_Virt virt_Extrusion = { NULL,Extrusion_Rend,NULL,NULL,Extrusion_RendRay,Extrusion_GenPolyRep,NULL,NULL,NULL,NULL,"Extrusion"};
static struct VRML_Virt virt_Switch = { NULL,NULL,Switch_Child,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Switch"};
static struct VRML_Virt virt_ImageTexture = { NULL,ImageTexture_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"ImageTexture"};
static struct VRML_Virt virt_TextureCoordinate = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,TextureCoordinate_Get2,NULL,"TextureCoordinate"};
static struct VRML_Virt virt_IndexedFaceSet = { NULL,IndexedFaceSet_Rend,NULL,NULL,IndexedFaceSet_RendRay,IndexedFaceSet_GenPolyRep,NULL,NULL,NULL,NULL,"IndexedFaceSet"};
static struct VRML_Virt virt_Background = { NULL,Background_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Background"};
static struct VRML_Virt virt_Text = { NULL,Text_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Text"};
static struct VRML_Virt virt_Cone = { NULL,Cone_Rend,NULL,NULL,Cone_RendRay,NULL,NULL,NULL,NULL,NULL,"Cone"};
static struct VRML_Virt virt_Viewpoint = { Viewpoint_Prep,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Viewpoint"};
static struct VRML_Virt virt_TextureTransform = { NULL,TextureTransform_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"TextureTransform"};
static struct VRML_Virt virt_Group = { NULL,NULL,Group_Child,NULL,NULL,NULL,NULL,NULL,NULL,Group_Changed,"Group"};
static struct VRML_Virt virt_ProximitySensor = { NULL,ProximitySensor_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"ProximitySensor"};
static struct VRML_Virt virt_Material = { NULL,Material_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Material"};
static struct VRML_Virt virt_Appearance = { NULL,NULL,Appearance_Child,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Appearance"};
static struct VRML_Virt virt_Shape = { NULL,NULL,Shape_Child,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"Shape"};
static struct VRML_Virt virt_IndexedLineSet = { NULL,IndexedLineSet_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"IndexedLineSet"};
static struct VRML_Virt virt_PointSet = { NULL,PointSet_Rend,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"PointSet"};
static struct VRML_Virt virt_Cylinder = { NULL,Cylinder_Rend,NULL,NULL,Cylinder_RendRay,NULL,NULL,NULL,NULL,NULL,"Cylinder"};
static struct VRML_Virt virt_Anchor = { NULL,NULL,Anchor_Child,NULL,NULL,NULL,NULL,NULL,NULL,Anchor_Changed,"Anchor"};
static struct VRML_Virt virt_NavigationInfo = { NavigationInfo_Prep,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"NavigationInfo"};
static struct VRML_Virt virt_Transform = { Transform_Prep,NULL,Transform_Child,Transform_Fin,NULL,NULL,NULL,NULL,NULL,Transform_Changed,"Transform"};
static struct VRML_Virt virt_SpotLight = { NULL,NULL,NULL,NULL,NULL,NULL,SpotLight_Light,NULL,NULL,NULL,"SpotLight"};
static struct VRML_Virt virt_LOD = { NULL,NULL,LOD_Child,NULL,NULL,NULL,NULL,NULL,NULL,NULL,"LOD"};
static struct VRML_Virt virt_Color = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,Color_Get3,NULL,NULL,"Color"};
/*********************************************************************
 * Code here again comes almost verbatim from VRMLC.pm 
 */

/*********************************************************************
 *********************************************************************
 *
 * render_polyrep : render one of the internal polygonal representations
 * for some nodes
 */
 

void render_polyrep(void *node, 
	int npoints, struct SFColor *points,
	int ncolors, struct SFColor *colors,
	int nnormals, struct SFColor *normals)
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	int prevcolor = -1;
	int i;
	int pt;
	int pti;
	int hasc;
	v = *(struct VRML_Virt **)node;
	p = node;
	r = p->_intern;
/*	printf("Render polyrep %d '%s' (%d %d): %d\n",node,v->name, 
		p->_change, r->_change, r->ntri);
 */
	hasc = (ncolors || r->color);
	if(hasc) {
		glEnable(GL_COLOR_MATERIAL);
	}
	glBegin(GL_TRIANGLES);
	for(i=0; i<r->ntri*3; i++) {
		int nori = i;
		int coli = i;
		int ind = r->cindex[i];
		GLfloat color[4];
		if(r->norindex) {nori = r->norindex[i];}
		else nori = ind;
		if(r->colindex) {coli = r->colindex[i];}
		else coli = ind;
		if(nnormals) {
			if(nori >= nnormals) {
				warn("Too large normal index -- help??");
			}
			glNormal3fv(normals[nori].c);
		} else if(r->normal) {
			glNormal3fv(r->normal+3*nori);
		}
		if(hasc && prevcolor != coli) {
			if(ncolors) {
				/* ColorMaterial -> these set Material too */
				glColor3fv(colors[coli].c);
			} else if(r->color) {
				glColor3fv(r->color+3*coli);
			}
		}
		prevcolor = coli;
		if(points) {
			glVertex3fv(points[ind].c);
		} else if(r->coord) {
			glVertex3fv(r->coord+3*ind);
		}
	}
	glEnd();
	if(hasc) {
		glDisable(GL_COLOR_MATERIAL);
	}
}

/*********************************************************************
 *********************************************************************
 *
 * render_ray_polyrep : get intersections of a ray with one of the
 * polygonal representations
 */

void render_ray_polyrep(void *node,
	int npoints, struct SFColor *points)
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	int i;
	int pt;
	int pti;
	float *point[3];
	struct pt v1, v2, v3;
	struct pt x1, x2, x3;
	struct pt ray;
	float pt1, pt2, pt3;
	struct pt hitpoint;
	float tmp1,tmp2,tmp3;
	float v1len, v2len, v3len;
	float v12pt;
	ray.x = t_r2.x - t_r1.x;
	ray.y = t_r2.y - t_r1.y;
	ray.z = t_r2.z - t_r1.z;
	v = *(struct VRML_Virt **)node;
	p = node;
	r = p->_intern;
/*	printf("Render polyrepray %d '%s' (%d %d): %d\n",node,v->name, 
		p->_change, r->_change, r->ntri);
 */
	for(i=0; i<r->ntri; i++) {
		float len;
		for(pt = 0; pt<3; pt++) {
			int ind = r->cindex[i*3+pt];
			if(points) {
				point[pt] = (points[ind].c);
			} else if(r->coord) {
				point[pt] = (r->coord+3*ind);
			}
		}
		/* First we need to project our point to the surface */
		/* Poss. 1: */
		/* Solve s1xs2 dot ((1-r)r1 + r r2 - pt0)  ==  0 */
		/* I.e. calculate s1xs2 and ... */
		v1.x = point[1][0] - point[0][0];
		v1.y = point[1][1] - point[0][1];
		v1.z = point[1][2] - point[0][2];
		v2.x = point[2][0] - point[0][0];
		v2.y = point[2][1] - point[0][1];
		v2.z = point[2][2] - point[0][2];
		v1len = sqrt(VECSQ(v1)); VECSCALE(v1, 1/v1len);
		v2len = sqrt(VECSQ(v2)); VECSCALE(v2, 1/v2len);
		v12pt = VECPT(v1,v2);
		/* v3 is our normal to the surface */
		VECCP(v1,v2,v3);
		v3len = sqrt(VECSQ(v3)); VECSCALE(v3, 1/v3len);
		pt1 = VECPT(t_r1,v3);
		pt2 = VECPT(t_r2,v3);
		pt3 = v3.x * point[0][0] + v3.y * point[0][1] + 
			v3.z * point[0][2]; 
		/* Now we have (1-r)pt1 + r pt2 - pt3 = 0
		 * r * (pt1 - pt2) = pt1 - pt3
		 */
		 tmp1 = pt1-pt2;
		 if(!APPROX(tmp1,0)) {
		 	float ra, rb;
			float k,l;
			struct pt p0h;
		 	tmp2 = (pt1-pt3) / (pt1-pt2);
			hitpoint.x = MRATX(tmp2);
			hitpoint.y = MRATY(tmp2);
			hitpoint.z = MRATZ(tmp2);
			/* Now we want to see if we are in the triangle */
			/* Projections to the two triangle sides */
			p0h.x = hitpoint.x - point[0][0];
			p0h.y = hitpoint.y - point[0][1];
			p0h.z = hitpoint.z - point[0][2];
			ra = VECPT(v1, p0h);
			if(ra < 0) {continue;}
			rb = VECPT(v2, p0h);
			if(rb < 0) {continue;}
			/* Now, the condition for the point to
			 * be inside 
			 * (ka + lb = p)
			 * (k + l b.a = p.a)
			 * (k b.a + l = p.b)
			 * (k - (b.a)**2 k = p.a - (b.a)*p.b)
			 * k = (p.a - (b.a)*(p.b)) / (1-(b.a)**2)
			 */
			 k = (ra - v12pt * rb) / (1-v12pt*v12pt);
			 l = (rb - v12pt * ra) / (1-v12pt*v12pt);
			 k /= v1len; l /= v2len;
			 if(k+l > 1 || k < 0 || l < 0) {
			 	continue;
			 }
			 HIT(tmp2, hitpoint.x,hitpoint.y,hitpoint.z,
			 	v3.x,v3.y,v3.z, -1,-1, "polyrep");
		 }

#ifdef FOOEIFJOESFIJESF
		/* But maybe easier: calc. (ray1->p1) x ray,
		 * (ray1->p2) x ray and (ray1->p3) x ray 
		 * and dot products of these. if sum > -180, ok.
		 * XXX Doesn't give us point/normal easily.
		 */
		v1.x = point[0][0] - t_r1.x;
		v1.y = point[0][1] - t_r1.y;
		v1.z = point[0][2] - t_r1.z;
		v2.x = point[1][0] - t_r1.x;
		v2.y = point[1][1] - t_r1.y;
		v2.z = point[1][2] - t_r1.z;
		v3.x = point[2][0] - t_r1.x;
		v3.y = point[2][1] - t_r1.y;
		v3.z = point[2][2] - t_r1.z;
		VECCP(v1, ray, x1);
		VECCP(v2, ray, x2);
		VECCP(v3, ray, x3);
		len = 1/sqrt(VECSQ(x1)); VECSCALE(x1,len);
		len = 1/sqrt(VECSQ(x2)); VECSCALE(x2,len);
		len = 1/sqrt(VECSQ(x3)); VECSCALE(x3,len);
		pt1 = VECPT(x1,x2);
		pt2 = VECPT(x2,x3);
		pt3 = VECPT(x3,x1);
		/* Now the simple condition: one of the angles 
		if( acos(pt1) + acos(pt2) + acos(pt3)
		*/
#endif FOEIJFOEJFOIEJ
	}
}

void regen_polyrep(void *node) 
{
	struct VRML_Virt *v;
	struct VRML_Box *p;
	struct VRML_PolyRep *r;
	v = *(struct VRML_Virt **)node;
	p = node;
	printf("Regen polyrep %d '%s'\n",node,v->name);
	if(!p->_intern) {
		p->_intern = malloc(sizeof(struct VRML_PolyRep));
		r = p->_intern;
		r->ntri = -1;
		r->cindex = 0; r->coord = 0; r->colindex = 0; r->color = 0;
		r->norindex = 0; r->normal = 0;
	}
	r = p->_intern;
	r->_change = p->_change;
#define FREE_IF_NZ(a) if(a) {free(a); a = 0;}
	FREE_IF_NZ(r->cindex);
	FREE_IF_NZ(r->coord);
	FREE_IF_NZ(r->colindex);
	FREE_IF_NZ(r->color);
	FREE_IF_NZ(r->norindex);
	FREE_IF_NZ(r->normal);
	v->mkpolyrep(node);
}

/* Assuming that norindexes set */
void calc_poly_normals_flat(struct VRML_PolyRep *rep) 
{
	int i;
	float a[3],b[3], *v1,*v2,*v3;
	for(i=0; i<rep->ntri; i++) {
		v1 = rep->coord+3*rep->cindex[i*3+0];
		v2 = rep->coord+3*rep->cindex[i*3+1];
		v3 = rep->coord+3*rep->cindex[i*3+2];
		a[0] = v2[0]-v1[0];
		a[1] = v2[1]-v1[1];
		a[2] = v2[2]-v1[2];
		b[0] = v3[0]-v1[0];
		b[1] = v3[1]-v1[1];
		b[2] = v3[2]-v1[2];
		rep->normal[i*3+0] =
			a[1]*b[2] - b[1]*a[2];
		rep->normal[i*3+1] =
			-(a[0]*b[2] - b[0]*a[2]);
		rep->normal[i*3+2] =
			a[0]*b[1] - b[0]*a[1];
	}
}

/*********************************************************************
 *********************************************************************
 *
 * render_node : call the correct virtual functions to render the node
 * depending on what we are doing right now.
 */

void render_node(void *node) {
	struct VRML_Virt *v;
	struct VRML_Box *p;
	int srg;
	int sch;
	struct currayhit srh;
	if(verbose) printf("Render_node %d\n",node);
	if(!node) {return;}
	v = *(struct VRML_Virt **)node;
	p = node;
	if(verbose) printf("Render_node_v %d (%s) %d %d %d %d RAY: %d HYP: %d\n",v,
		v->name, v->prep, v->rend, v->children, v->fin, v->rendray,
		hypersensitive);
	if(verbose) printf("Render_state any %d geom %d light %d sens %d\n",
		render_anything, render_geom, render_light, render_sensitive);

	if(p->_change != p->_ichange && v->changed) {
		v->changed(node);
		p->_ichange = p->_change;
	}

	if(render_anything && v->prep) {
		v->prep(node);
		if(render_sensitive && !hypersensitive) { upd_ray(); }
	}
	if(render_anything && render_geom && !render_sensitive && v->rend) {v->rend(node);}
	if(render_anything && render_light && v->light) {v->light(node);}
	/* Future optimization: when doing VP/Lights, do only 
	 * that child... further in future: could just calculate
	 * transforms myself..
	 */
	if(render_anything &&
	   render_sensitive &&
	   p->_sens) {
	   	srg = render_geom;
		render_geom = 1;
		if(verbose) printf("CH1 %d: %d\n",node, cur_hits, p->_hit);
		sch = cur_hits;
		cur_hits = 0;
		/* HP */
		srh = rph;
		rph.node = node;
		glGetDoublev(GL_MODELVIEW_MATRIX, rph.modelMatrix);
		glGetDoublev(GL_PROJECTION_MATRIX, rph.projMatrix);
	}
	if(render_anything && render_geom && render_sensitive &&
		!hypersensitive && v->rendray) {v->rendray(node);}
	if(hypersensitive == node) {
		hyper_r1 = t_r1;
		hyper_r2 = t_r2;
		hyperhit = 1;
	}
	if(render_anything && v->children) {v->children(node);}
	if(render_anything &&
	   render_sensitive &&
	   p->_sens) {
		render_geom = srg;
		cur_hits = sch;
		if(verbose) printf("CH3: %d %d\n",cur_hits, p->_hit);
		/* HP */
		rph = srh;
	}
	if(render_anything && v->fin) {v->fin(node);
		if(render_sensitive && v == &virt_Transform) { upd_ray(); }
	}
}

/*
 * The following code handles keeping track of the parents of a given
 * node. This enables us to traverse the scene on C level for optimizations.
 *
 * We use this array code because VRML nodes usually don't have
 * hundreds of children and don't usually shuffle them too much.
 */

#define NODE_ADD_PARENT(a) add_parent(a,ptr)

void add_parent(void *node_, void *parent_) {
	struct VRML_Box *node = node_;
	struct VRML_Box *parent = parent_;
	if(!node) return;
	node->_nparents ++;
	if(node->_nparents > node->_nparalloc) {
		node->_nparalloc += 10;
		node->_parents = 
		 (node->_parents ? 
			realloc(node->_parents, sizeof(node->_parents[0])*
							node->_nparalloc) 
							:
			malloc(sizeof(node->_parents[0])* node->_nparalloc) 
		 );
	}
	node->_parents[node->_nparents-1] = parent_;
}

#define NODE_REMOVE_PARENT(a) add_parent(a,ptr)

void remove_parent(void *node_, void *parent_) {
	struct VRML_Box *node = node_;
	struct VRML_Box *parent = parent_;
	int i;
	if(!node) return;
	node->_nparents --;
	for(i=0; i<node->_nparents; i++) {
		if(node->_parents[i] == parent) {
			break;
		}
	}
	for(; i<node->_nparents; i++) {
		node->_parents[i] = node->_parents[i+1];
	}
}


MODULE = VRML::VRMLFunc PACKAGE = VRML::VRMLFunc

PROTOTYPES: ENABLE

void *
alloc_struct(siz,virt)
	int siz
	void *virt
CODE:
	void *ptr = malloc(siz);
	struct VRML_Box *p = ptr;
	if(verbose) printf("Alloc: %d %d -> %d\n", siz, virt, ptr); 
	*(struct VRML_Virt **)ptr = (struct VRML_Virt *)virt;
	p->_sens = p->_hit = 0;
	p->_intern = 0;
	p->_change = 153;
	p->_dlchange = 0;
	p->_dlist = 0;
	p->_dl2change = 0;
	p->_dl2ist = 0;
        p->_parents = 0;
        p->_nparents = 0;
        p->_nparalloc = 0;
	p->_ichange = 0;
	RETVAL=ptr;
OUTPUT:
	RETVAL

void
release_struct(ptr)
	void *ptr
CODE:
	struct VRML_Box *p = ptr;
	if(p->_parents) free(p->_parents);
	if(p->_dlist) glDeleteLists(p->_dlist,1);
	if(p->_dl2ist) glDeleteLists(p->_dl2ist,1);
	free(ptr); /* COULD BE MEMLEAK IF STUFF LEFT INSIDE */

void
set_sensitive(ptr,sens)
	void *ptr
	int sens
CODE:
	/* Choose box randomly */
	struct VRML_Box *p = ptr;
	p->_sens = sens;

void 
set_hypersensitive(ptr)
	void *ptr
CODE:	
	hypersensitive = ptr;
	hyperhit = 0;

int
get_hyperhit(x1,y1,z1,x2,y2,z2)
	double x1
	double y1
	double z1
	double x2
	double y2
	double z2
CODE:
	GLdouble projMatrix[16];
	/*
	if(hyperhit) {
		x1 = hyper_r1.x;
		y1 = hyper_r1.y;
		z1 = hyper_r1.z;
		x2 = hyper_r2.x;
		y2 = hyper_r2.y;
		z2 = hyper_r2.z;
		RETVAL=1;
	} else RETVAL = 0;
	*/
	glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
	gluUnProject(r1.x, r1.y, r1.z, rhhyper.modelMatrix,
		projMatrix, viewport, &x1, &y1, &z1);
	gluUnProject(r2.x, r2.y, r2.z, rhhyper.modelMatrix,
		projMatrix, viewport, &x2, &y2, &z2);
	RETVAL=1;
OUTPUT:
	RETVAL
	x1
	y1
	z1
	x2
	y2
	z2
	

int
get_hits(ptr)
	void *ptr
CODE:
	struct VRML_Box *p = ptr;
	RETVAL = p->_hit;
	p->_hit = 0;
OUTPUT:
	RETVAL

void
zero_hits(ptr)
	void *ptr
CODE:
	struct VRML_Box *p = ptr;
	p->_hit = 0;

void 
render_verbose(i)
	int i;
CODE:
	verbose=i;

void
render_geom(p)
	void *p
CODE:
	struct VRML_Virt *v;
	if(!p) {
		die("Render_geom null!??");
	}
	v = *(struct VRML_Virt **)p;
	v->rend(p);

void 
render_hier(p,revt,rvp,rgeom,rlight,rsens,wvp)
	void *p
	int revt
	int rvp
	int rgeom
	int rlight
	int rsens
	void *wvp
CODE:
	reverse_trans = revt;
	render_vp = rvp;
	render_geom =  rgeom;
	render_light = rlight;
	render_sensitive = rsens;
	curlight = 0;
	what_vp = wvp;
	render_anything = 1;
	hpdist = -1;
	if(!p) {
		die("Render_hier null!??");
	}
	if(verbose) printf("Render_hier %d %d %d %d %d %d\n", p, revt, rvp, rgeom, rlight, wvp);
	if(render_sensitive) upd_ray();
	render_node(p);
	if(render_sensitive) { /* Get raycasting results */
		if(hpdist >= 0) {
			if(verbose) printf("RAY HIT!\n");
		}
	}

void *
get_rayhit(x,y,z,nx,ny,nz,tx,ty)
	double x
	double y
	double z
	double nx
	double ny
	double nz
	double tx
	double ty
CODE:
	if(hpdist >= 0) {
		gluUnProject(hp.x,hp.y,hp.z,rh.modelMatrix,rh.projMatrix,viewport,
			&x,&y,&z);
		RETVAL = rh.node;
	} else {
		RETVAL=0;
	}
OUTPUT:
	RETVAL
	x
	y
	z
	nx
	ny
	nz
	tx
	ty

void 
get_proximitysensor_vecs(node,hit,x1,y1,z1,x2,y2,z2,q2)
	void *node
	int hit
	double x1
	double y1
	double z1
	double x2
	double y2
	double z2
	double q2
CODE:
	struct VRML_ProximitySensor *px = node;
	hit = px->__hit;
	px->__hit = 0;
	x1 = px->__t1.c[0];
	y1 = px->__t1.c[1];
	z1 = px->__t1.c[2];
	x2 = px->__t2.r[0];
	y2 = px->__t2.r[1];
	z2 = px->__t2.r[2];
	q2 = px->__t2.r[3];
OUTPUT:
	hit
	x1
	y1
	z1
	x2
	y2
	z2
	q2

void
set_divs(horiz,vert)
int horiz
int vert
CODE:
	horiz_div = horiz;
	vert_div = vert;

void
set_vpdist(dist)
int dist
CODE:
	vp_dist = dist;



void 
set_offs_SFFloat(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvNV(sv_);



void 
alloc_offs_SFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	

void
free_offs_SFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	



void 
set_offs_MFFloat(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFFloat bM == 0");
				}
				
				((*ptr_).p[iM]) = SvNV((*bM));

			}
		}
	}
	


void 
alloc_offs_MFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFFloat(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Float *ptr_ = (struct Multi_Float *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFRotation(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			(*ptr_).r[0] = 0;
			(*ptr_).r[1] = 1;
			(*ptr_).r[2] = 0;
			(*ptr_).r[3] = 0;
			/* die("Help! SFRotation without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! SFRotation without being arrayref");
			}
			a = (AV *) SvRV(sv_);
			for(i=0; i<4; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				(*ptr_).r[i] = SvNV(*b);
			}
		}
	}
	


void 
alloc_offs_SFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	

void
free_offs_SFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFRotation *ptr_ = (struct SFRotation *)(((char *)ptr)+offs);
	



void 
set_offs_MFRotation(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFRotation bM == 0");
				}
				
				{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			((*ptr_).p[iM]).r[0] = 0;
			((*ptr_).p[iM]).r[1] = 1;
			((*ptr_).p[iM]).r[2] = 0;
			((*ptr_).p[iM]).r[3] = 0;
			/* die("Help! SFRotation without being ref"); */
		} else {
			if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
				die("Help! SFRotation without being arrayref");
			}
			a = (AV *) SvRV((*bM));
			for(i=0; i<4; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				((*ptr_).p[iM]).r[i] = SvNV(*b);
			}
		}
	}
	
			}
		}
	}
	


void 
alloc_offs_MFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFRotation(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Rotation *ptr_ = (struct Multi_Rotation *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFVec3f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			(*ptr_).c[0] = 0;
			(*ptr_).c[1] = 0;
			(*ptr_).c[2] = 0;
			/* die("Help! SFColor without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! SFColor without being arrayref");
			}
			a = (AV *) SvRV(sv_);
			for(i=0; i<3; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				(*ptr_).c[i] = SvNV(*b);
			}
		}
	}
	


void 
alloc_offs_SFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	

void
free_offs_SFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	



void 
set_offs_MFVec3f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFVec3f bM == 0");
				}
				
				{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			((*ptr_).p[iM]).c[0] = 0;
			((*ptr_).p[iM]).c[1] = 0;
			((*ptr_).p[iM]).c[2] = 0;
			/* die("Help! SFColor without being ref"); */
		} else {
			if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
				die("Help! SFColor without being arrayref");
			}
			a = (AV *) SvRV((*bM));
			for(i=0; i<3; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				((*ptr_).p[iM]).c[i] = SvNV(*b);
			}
		}
	}
	
			}
		}
	}
	


void 
alloc_offs_MFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFVec3f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec3f *ptr_ = (struct Multi_Vec3f *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFBool(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvIV(sv_);



void 
alloc_offs_SFBool(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	

void
free_offs_SFBool(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	



void 
set_offs_SFInt32(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvIV(sv_);



void 
alloc_offs_SFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	

void
free_offs_SFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	int *ptr_ = (int *)(((char *)ptr)+offs);
	



void 
set_offs_MFInt32(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFInt32 bM == 0");
				}
				
				((*ptr_).p[iM]) = SvIV((*bM));

			}
		}
	}
	


void 
alloc_offs_MFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFInt32(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Int32 *ptr_ = (struct Multi_Int32 *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFNode(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = (void *)SvIV(sv_); NODE_ADD_PARENT((*ptr_));


void 
alloc_offs_SFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	(*ptr_) = 0;

void
free_offs_SFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	void **ptr_ = (void **)(((char *)ptr)+offs);
	NODE_REMOVE_PARENT((*ptr_)); (*ptr_) = 0;



void 
set_offs_MFNode(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFNode bM == 0");
				}
				(*ptr_).p[iM] = 0;
				((*ptr_).p[iM]) = (void *)SvIV((*bM)); NODE_ADD_PARENT(((*ptr_).p[iM]));
			}
		}
	}
	


void 
alloc_offs_MFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFNode(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Node *ptr_ = (struct Multi_Node *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFColor(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			(*ptr_).c[0] = 0;
			(*ptr_).c[1] = 0;
			(*ptr_).c[2] = 0;
			/* die("Help! SFColor without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! SFColor without being arrayref");
			}
			a = (AV *) SvRV(sv_);
			for(i=0; i<3; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				(*ptr_).c[i] = SvNV(*b);
			}
		}
	}
	


void 
alloc_offs_SFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	

void
free_offs_SFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFColor *ptr_ = (struct SFColor *)(((char *)ptr)+offs);
	



void 
set_offs_MFColor(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFColor bM == 0");
				}
				
				{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			((*ptr_).p[iM]).c[0] = 0;
			((*ptr_).p[iM]).c[1] = 0;
			((*ptr_).p[iM]).c[2] = 0;
			/* die("Help! SFColor without being ref"); */
		} else {
			if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
				die("Help! SFColor without being arrayref");
			}
			a = (AV *) SvRV((*bM));
			for(i=0; i<3; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				((*ptr_).p[iM]).c[i] = SvNV(*b);
			}
		}
	}
	
			}
		}
	}
	


void 
alloc_offs_MFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFColor(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Color *ptr_ = (struct Multi_Color *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFTime(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	(*ptr_) = SvNV(sv_);



void 
alloc_offs_SFTime(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	

void
free_offs_SFTime(ptr,offs)
	void *ptr
	int offs
CODE:
	float *ptr_ = (float *)(((char *)ptr)+offs);
	



void 
set_offs_SFString(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	sv_setsv((*ptr_),sv_);


void 
alloc_offs_SFString(ptr,offs)
	void *ptr
	int offs
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	(*ptr_) = newSVpv("",0);

void
free_offs_SFString(ptr,offs)
	void *ptr
	int offs
CODE:
	SV **ptr_ = (SV **)(((char *)ptr)+offs);
	SvREFCNT_dec((*ptr_));



void 
set_offs_MFString(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFString bM == 0");
				}
				(*ptr_).p[iM] = newSVpv("",0);
				sv_setsv(((*ptr_).p[iM]),(*bM));
			}
		}
	}
	


void 
alloc_offs_MFString(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFString(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_String *ptr_ = (struct Multi_String *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;



void 
set_offs_SFVec2f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *a;
		SV **b;
		int i;
		if(!SvROK(sv_)) {
			(*ptr_).c[0] = 0;
			(*ptr_).c[1] = 0;
			/* die("Help! SFVec2f without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! SFVec2f without being arrayref");
			}
			a = (AV *) SvRV(sv_);
			for(i=0; i<2; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				(*ptr_).c[i] = SvNV(*b);
			}
		}
	}
	


void 
alloc_offs_SFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	

void
free_offs_SFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct SFVec2f *ptr_ = (struct SFVec2f *)(((char *)ptr)+offs);
	



void 
set_offs_MFVec2f(ptr,offs,sv_)
	void *ptr
	int offs
	SV *sv_
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	{struct VRML_Box *p;
	 p = ptr;
	 p->_change ++;
	}
	{
		AV *aM;
		SV **bM;
		int iM;
		int lM;
		if(!SvROK(sv_)) {
			(*ptr_).n = 0;
			(*ptr_).p = 0;
			/* die("Help! Multi without being ref"); */
		} else {
			if(SvTYPE(SvRV(sv_)) != SVt_PVAV) {
				die("Help! Multi without being arrayref");
			}
			aM = (AV *) SvRV(sv_);
			lM = av_len(aM)+1;
			/* XXX Free previous p */
			(*ptr_).n = lM;
			(*ptr_).p = malloc(lM * sizeof(*((*ptr_).p)));
			/* XXX ALLOC */
			for(iM=0; iM<lM; iM++) {
				bM = av_fetch(aM, iM, 1); /* LVal for easiness */
				if(!bM) {
					die("Help: Multi VRML::Field::SFVec2f bM == 0");
				}
				
				{
		AV *a;
		SV **b;
		int i;
		if(!SvROK((*bM))) {
			((*ptr_).p[iM]).c[0] = 0;
			((*ptr_).p[iM]).c[1] = 0;
			/* die("Help! SFVec2f without being ref"); */
		} else {
			if(SvTYPE(SvRV((*bM))) != SVt_PVAV) {
				die("Help! SFVec2f without being arrayref");
			}
			a = (AV *) SvRV((*bM));
			for(i=0; i<2; i++) {
				b = av_fetch(a, i, 1); /* LVal for easiness */
				if(!b) {
					die("Help: SFColor b == 0");
				}
				((*ptr_).p[iM]).c[i] = SvNV(*b);
			}
		}
	}
	
			}
		}
	}
	


void 
alloc_offs_MFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	(*ptr_).n = 0; (*ptr_).p = 0;

void
free_offs_MFVec2f(ptr,offs)
	void *ptr
	int offs
CODE:
	struct Multi_Vec2f *ptr_ = (struct Multi_Vec2f *)(((char *)ptr)+offs);
	if((*ptr_).p) {free((*ptr_).p);(*ptr_).p=0;} (*ptr_).n = 0;


void *
get_PointLight_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_PointLight, radius);
	*ptr_++ = offsetof(struct VRML_PointLight, location);
	*ptr_++ = offsetof(struct VRML_PointLight, direction);
	*ptr_++ = offsetof(struct VRML_PointLight, attenuation);
	*ptr_++ = offsetof(struct VRML_PointLight, on);
	*ptr_++ = offsetof(struct VRML_PointLight, color);
	*ptr_++ = offsetof(struct VRML_PointLight, ambientIntensity);
	*ptr_++ = offsetof(struct VRML_PointLight, intensity);
	*ptr_++ = sizeof(struct VRML_PointLight);
RETVAL=&(virt_PointLight);
	if(verbose) printf("PointLight virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_DirectionalLight_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, direction);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, on);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, ambientIntensity);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, color);
	*ptr_++ = offsetof(struct VRML_DirectionalLight, intensity);
	*ptr_++ = sizeof(struct VRML_DirectionalLight);
RETVAL=&(virt_DirectionalLight);
	if(verbose) printf("DirectionalLight virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Sphere_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Sphere, radius);
	*ptr_++ = sizeof(struct VRML_Sphere);
RETVAL=&(virt_Sphere);
	if(verbose) printf("Sphere virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Coordinate_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Coordinate, point);
	*ptr_++ = sizeof(struct VRML_Coordinate);
RETVAL=&(virt_Coordinate);
	if(verbose) printf("Coordinate virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_FontStyle_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(9+1)*sizeof(int));
	SvCUR_set(p,(9+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_FontStyle, style);
	*ptr_++ = offsetof(struct VRML_FontStyle, family);
	*ptr_++ = offsetof(struct VRML_FontStyle, language);
	*ptr_++ = offsetof(struct VRML_FontStyle, spacing);
	*ptr_++ = offsetof(struct VRML_FontStyle, horizontal);
	*ptr_++ = offsetof(struct VRML_FontStyle, topToBottom);
	*ptr_++ = offsetof(struct VRML_FontStyle, size);
	*ptr_++ = offsetof(struct VRML_FontStyle, leftToRight);
	*ptr_++ = offsetof(struct VRML_FontStyle, justify);
	*ptr_++ = sizeof(struct VRML_FontStyle);
RETVAL=&(virt_FontStyle);
	if(verbose) printf("FontStyle virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Normal_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Normal, vector);
	*ptr_++ = sizeof(struct VRML_Normal);
RETVAL=&(virt_Normal);
	if(verbose) printf("Normal virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Box_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Box, size);
	*ptr_++ = sizeof(struct VRML_Box);
RETVAL=&(virt_Box);
	if(verbose) printf("Box virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Billboard_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(4+1)*sizeof(int));
	SvCUR_set(p,(4+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Billboard, children);
	*ptr_++ = offsetof(struct VRML_Billboard, axisOfRotation);
	*ptr_++ = offsetof(struct VRML_Billboard, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Billboard, bboxSize);
	*ptr_++ = sizeof(struct VRML_Billboard);
RETVAL=&(virt_Billboard);
	if(verbose) printf("Billboard virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_ElevationGrid_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(11+1)*sizeof(int));
	SvCUR_set(p,(11+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, zDimension);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, colorPerVertex);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, height);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, normal);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, creaseAngle);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, solid);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, xSpacing);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, xDimension);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, normalPerVertex);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, color);
	*ptr_++ = offsetof(struct VRML_ElevationGrid, zSpacing);
	*ptr_++ = sizeof(struct VRML_ElevationGrid);
RETVAL=&(virt_ElevationGrid);
	if(verbose) printf("ElevationGrid virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Extrusion_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(10+1)*sizeof(int));
	SvCUR_set(p,(10+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Extrusion, convex);
	*ptr_++ = offsetof(struct VRML_Extrusion, scale);
	*ptr_++ = offsetof(struct VRML_Extrusion, beginCap);
	*ptr_++ = offsetof(struct VRML_Extrusion, creaseAngle);
	*ptr_++ = offsetof(struct VRML_Extrusion, solid);
	*ptr_++ = offsetof(struct VRML_Extrusion, endCap);
	*ptr_++ = offsetof(struct VRML_Extrusion, orientation);
	*ptr_++ = offsetof(struct VRML_Extrusion, ccw);
	*ptr_++ = offsetof(struct VRML_Extrusion, crossSection);
	*ptr_++ = offsetof(struct VRML_Extrusion, spine);
	*ptr_++ = sizeof(struct VRML_Extrusion);
RETVAL=&(virt_Extrusion);
	if(verbose) printf("Extrusion virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Switch_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Switch, choice);
	*ptr_++ = offsetof(struct VRML_Switch, whichChoice);
	*ptr_++ = sizeof(struct VRML_Switch);
RETVAL=&(virt_Switch);
	if(verbose) printf("Switch virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_ImageTexture_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(7+1)*sizeof(int));
	SvCUR_set(p,(7+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __data);
	*ptr_++ = offsetof(struct VRML_ImageTexture, url);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __depth);
	*ptr_++ = offsetof(struct VRML_ImageTexture, repeatS);
	*ptr_++ = offsetof(struct VRML_ImageTexture, repeatT);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __x);
	*ptr_++ = offsetof(struct VRML_ImageTexture, __y);
	*ptr_++ = sizeof(struct VRML_ImageTexture);
RETVAL=&(virt_ImageTexture);
	if(verbose) printf("ImageTexture virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_TextureCoordinate_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_TextureCoordinate, point);
	*ptr_++ = sizeof(struct VRML_TextureCoordinate);
RETVAL=&(virt_TextureCoordinate);
	if(verbose) printf("TextureCoordinate virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_IndexedFaceSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(13+1)*sizeof(int));
	SvCUR_set(p,(13+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, texCoordIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, normalIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, convex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, colorPerVertex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, coord);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, colorIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, texCoord);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, normal);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, creaseAngle);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, solid);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, ccw);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, coordIndex);
	*ptr_++ = offsetof(struct VRML_IndexedFaceSet, color);
	*ptr_++ = sizeof(struct VRML_IndexedFaceSet);
RETVAL=&(virt_IndexedFaceSet);
	if(verbose) printf("IndexedFaceSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Background_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(37+1)*sizeof(int));
	SvCUR_set(p,(37+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Background, __y_left);
	*ptr_++ = offsetof(struct VRML_Background, __data_left);
	*ptr_++ = offsetof(struct VRML_Background, __depth_back);
	*ptr_++ = offsetof(struct VRML_Background, backUrl);
	*ptr_++ = offsetof(struct VRML_Background, __depth_top);
	*ptr_++ = offsetof(struct VRML_Background, topUrl);
	*ptr_++ = offsetof(struct VRML_Background, __y_back);
	*ptr_++ = offsetof(struct VRML_Background, __depth_bottom);
	*ptr_++ = offsetof(struct VRML_Background, __data_back);
	*ptr_++ = offsetof(struct VRML_Background, __x_top);
	*ptr_++ = offsetof(struct VRML_Background, bottomUrl);
	*ptr_++ = offsetof(struct VRML_Background, __y_top);
	*ptr_++ = offsetof(struct VRML_Background, __y_bottom);
	*ptr_++ = offsetof(struct VRML_Background, bindTime);
	*ptr_++ = offsetof(struct VRML_Background, __data_bottom);
	*ptr_++ = offsetof(struct VRML_Background, __depth_right);
	*ptr_++ = offsetof(struct VRML_Background, __x_right);
	*ptr_++ = offsetof(struct VRML_Background, isBound);
	*ptr_++ = offsetof(struct VRML_Background, __y_right);
	*ptr_++ = offsetof(struct VRML_Background, groundAngle);
	*ptr_++ = offsetof(struct VRML_Background, skyColor);
	*ptr_++ = offsetof(struct VRML_Background, __data_front);
	*ptr_++ = offsetof(struct VRML_Background, __x_left);
	*ptr_++ = offsetof(struct VRML_Background, __x_back);
	*ptr_++ = offsetof(struct VRML_Background, set_bind);
	*ptr_++ = offsetof(struct VRML_Background, __data_top);
	*ptr_++ = offsetof(struct VRML_Background, __x_bottom);
	*ptr_++ = offsetof(struct VRML_Background, groundColor);
	*ptr_++ = offsetof(struct VRML_Background, rightUrl);
	*ptr_++ = offsetof(struct VRML_Background, __data_right);
	*ptr_++ = offsetof(struct VRML_Background, __depth_front);
	*ptr_++ = offsetof(struct VRML_Background, frontUrl);
	*ptr_++ = offsetof(struct VRML_Background, __depth_left);
	*ptr_++ = offsetof(struct VRML_Background, leftUrl);
	*ptr_++ = offsetof(struct VRML_Background, skyAngle);
	*ptr_++ = offsetof(struct VRML_Background, __x_front);
	*ptr_++ = offsetof(struct VRML_Background, __y_front);
	*ptr_++ = sizeof(struct VRML_Background);
RETVAL=&(virt_Background);
	if(verbose) printf("Background virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Text_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Text, fontStyle);
	*ptr_++ = offsetof(struct VRML_Text, __rendersub);
	*ptr_++ = offsetof(struct VRML_Text, length);
	*ptr_++ = offsetof(struct VRML_Text, maxExtent);
	*ptr_++ = offsetof(struct VRML_Text, string);
	*ptr_++ = sizeof(struct VRML_Text);
RETVAL=&(virt_Text);
	if(verbose) printf("Text virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Cone_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(4+1)*sizeof(int));
	SvCUR_set(p,(4+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Cone, height);
	*ptr_++ = offsetof(struct VRML_Cone, bottomRadius);
	*ptr_++ = offsetof(struct VRML_Cone, side);
	*ptr_++ = offsetof(struct VRML_Cone, bottom);
	*ptr_++ = sizeof(struct VRML_Cone);
RETVAL=&(virt_Cone);
	if(verbose) printf("Cone virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Viewpoint_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Viewpoint, fieldOfView);
	*ptr_++ = offsetof(struct VRML_Viewpoint, description);
	*ptr_++ = offsetof(struct VRML_Viewpoint, isBound);
	*ptr_++ = offsetof(struct VRML_Viewpoint, position);
	*ptr_++ = offsetof(struct VRML_Viewpoint, set_bind);
	*ptr_++ = offsetof(struct VRML_Viewpoint, bindTime);
	*ptr_++ = offsetof(struct VRML_Viewpoint, jump);
	*ptr_++ = offsetof(struct VRML_Viewpoint, orientation);
	*ptr_++ = sizeof(struct VRML_Viewpoint);
RETVAL=&(virt_Viewpoint);
	if(verbose) printf("Viewpoint virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_TextureTransform_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(4+1)*sizeof(int));
	SvCUR_set(p,(4+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_TextureTransform, rotation);
	*ptr_++ = offsetof(struct VRML_TextureTransform, scale);
	*ptr_++ = offsetof(struct VRML_TextureTransform, center);
	*ptr_++ = offsetof(struct VRML_TextureTransform, translation);
	*ptr_++ = sizeof(struct VRML_TextureTransform);
RETVAL=&(virt_TextureTransform);
	if(verbose) printf("TextureTransform virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Group_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(3+1)*sizeof(int));
	SvCUR_set(p,(3+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Group, children);
	*ptr_++ = offsetof(struct VRML_Group, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Group, bboxSize);
	*ptr_++ = sizeof(struct VRML_Group);
RETVAL=&(virt_Group);
	if(verbose) printf("Group virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_ProximitySensor_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(11+1)*sizeof(int));
	SvCUR_set(p,(11+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, center);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, __hit);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, __t1);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, __t2);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, orientation_changed);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, isActive);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, exitTime);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, size);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, enabled);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, enterTime);
	*ptr_++ = offsetof(struct VRML_ProximitySensor, position_changed);
	*ptr_++ = sizeof(struct VRML_ProximitySensor);
RETVAL=&(virt_ProximitySensor);
	if(verbose) printf("ProximitySensor virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Material_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(6+1)*sizeof(int));
	SvCUR_set(p,(6+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Material, transparency);
	*ptr_++ = offsetof(struct VRML_Material, emissiveColor);
	*ptr_++ = offsetof(struct VRML_Material, shininess);
	*ptr_++ = offsetof(struct VRML_Material, diffuseColor);
	*ptr_++ = offsetof(struct VRML_Material, specularColor);
	*ptr_++ = offsetof(struct VRML_Material, ambientIntensity);
	*ptr_++ = sizeof(struct VRML_Material);
RETVAL=&(virt_Material);
	if(verbose) printf("Material virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Appearance_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(3+1)*sizeof(int));
	SvCUR_set(p,(3+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Appearance, texture);
	*ptr_++ = offsetof(struct VRML_Appearance, textureTransform);
	*ptr_++ = offsetof(struct VRML_Appearance, material);
	*ptr_++ = sizeof(struct VRML_Appearance);
RETVAL=&(virt_Appearance);
	if(verbose) printf("Appearance virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Shape_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Shape, appearance);
	*ptr_++ = offsetof(struct VRML_Shape, geometry);
	*ptr_++ = sizeof(struct VRML_Shape);
RETVAL=&(virt_Shape);
	if(verbose) printf("Shape virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_IndexedLineSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, colorPerVertex);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, coord);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, color);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, colorIndex);
	*ptr_++ = offsetof(struct VRML_IndexedLineSet, coordIndex);
	*ptr_++ = sizeof(struct VRML_IndexedLineSet);
RETVAL=&(virt_IndexedLineSet);
	if(verbose) printf("IndexedLineSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_PointSet_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(2+1)*sizeof(int));
	SvCUR_set(p,(2+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_PointSet, color);
	*ptr_++ = offsetof(struct VRML_PointSet, coord);
	*ptr_++ = sizeof(struct VRML_PointSet);
RETVAL=&(virt_PointSet);
	if(verbose) printf("PointSet virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Cylinder_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(5+1)*sizeof(int));
	SvCUR_set(p,(5+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Cylinder, radius);
	*ptr_++ = offsetof(struct VRML_Cylinder, height);
	*ptr_++ = offsetof(struct VRML_Cylinder, top);
	*ptr_++ = offsetof(struct VRML_Cylinder, side);
	*ptr_++ = offsetof(struct VRML_Cylinder, bottom);
	*ptr_++ = sizeof(struct VRML_Cylinder);
RETVAL=&(virt_Cylinder);
	if(verbose) printf("Cylinder virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Anchor_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(6+1)*sizeof(int));
	SvCUR_set(p,(6+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Anchor, children);
	*ptr_++ = offsetof(struct VRML_Anchor, parameter);
	*ptr_++ = offsetof(struct VRML_Anchor, url);
	*ptr_++ = offsetof(struct VRML_Anchor, description);
	*ptr_++ = offsetof(struct VRML_Anchor, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Anchor, bboxSize);
	*ptr_++ = sizeof(struct VRML_Anchor);
RETVAL=&(virt_Anchor);
	if(verbose) printf("Anchor virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_NavigationInfo_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, set_bind);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, speed);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, avatarSize);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, headlight);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, type);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, bindTime);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, isBound);
	*ptr_++ = offsetof(struct VRML_NavigationInfo, visibilityLimit);
	*ptr_++ = sizeof(struct VRML_NavigationInfo);
RETVAL=&(virt_NavigationInfo);
	if(verbose) printf("NavigationInfo virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Transform_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(8+1)*sizeof(int));
	SvCUR_set(p,(8+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Transform, rotation);
	*ptr_++ = offsetof(struct VRML_Transform, center);
	*ptr_++ = offsetof(struct VRML_Transform, scaleOrientation);
	*ptr_++ = offsetof(struct VRML_Transform, bboxSize);
	*ptr_++ = offsetof(struct VRML_Transform, scale);
	*ptr_++ = offsetof(struct VRML_Transform, children);
	*ptr_++ = offsetof(struct VRML_Transform, bboxCenter);
	*ptr_++ = offsetof(struct VRML_Transform, translation);
	*ptr_++ = sizeof(struct VRML_Transform);
RETVAL=&(virt_Transform);
	if(verbose) printf("Transform virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_SpotLight_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(10+1)*sizeof(int));
	SvCUR_set(p,(10+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_SpotLight, direction);
	*ptr_++ = offsetof(struct VRML_SpotLight, beamWidth);
	*ptr_++ = offsetof(struct VRML_SpotLight, ambientIntensity);
	*ptr_++ = offsetof(struct VRML_SpotLight, intensity);
	*ptr_++ = offsetof(struct VRML_SpotLight, radius);
	*ptr_++ = offsetof(struct VRML_SpotLight, location);
	*ptr_++ = offsetof(struct VRML_SpotLight, attenuation);
	*ptr_++ = offsetof(struct VRML_SpotLight, on);
	*ptr_++ = offsetof(struct VRML_SpotLight, cutOffAngle);
	*ptr_++ = offsetof(struct VRML_SpotLight, color);
	*ptr_++ = sizeof(struct VRML_SpotLight);
RETVAL=&(virt_SpotLight);
	if(verbose) printf("SpotLight virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_LOD_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(3+1)*sizeof(int));
	SvCUR_set(p,(3+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_LOD, level);
	*ptr_++ = offsetof(struct VRML_LOD, center);
	*ptr_++ = offsetof(struct VRML_LOD, range);
	*ptr_++ = sizeof(struct VRML_LOD);
RETVAL=&(virt_LOD);
	if(verbose) printf("LOD virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL

void *
get_Color_offsets(p)
	SV *p;
CODE:
	int *ptr_;
	SvGROW(p,(1+1)*sizeof(int));
	SvCUR_set(p,(1+1)*sizeof(int));
	ptr_ = (int *)SvPV(p,na);
	*ptr_++ = offsetof(struct VRML_Color, color);
	*ptr_++ = sizeof(struct VRML_Color);
RETVAL=&(virt_Color);
	if(verbose) printf("Color virtual: %d\n", RETVAL);
OUTPUT:
	RETVAL


BOOT:
	I_OPENGL;
	new_tessellation();
	
