/*
 *
 */

typedef struct ent_struct {

  int type; /*  ENTITIY_TYPES */
  int class; /* ENTITY_CLASS */
  int mode; /*  ENTITY_MODES */
  int x, y;
  int x_v, y_v; /* x & y velocity. */
  int height;
  int width;
  int health;
  int speed;
  int weapon;
  int owner_id; /* ent_id of owner (only used for projectiles) */
  int dir;
  int frame;
  int img_no; /* Which image to draw? */
  int ent_id;
  struct timeval last_frame; /* For animation */
  struct ent_struct *next; /* Next in list */

} entity;


/* Keep first of each type the first!!! */
enum ENTITY_TYPES { TUX,
		    TUX_G,
		    GOWN,
		    BSD,
		    GNU,
		    VI,
		    MSCP,       /* BADDIES */
		    MSCP_DIE,
		    CLIPPY,
		    CLIPPY_DIE,
		    TROLL,
		    FLAMER,
		    FLAMER_DIE,
		    COBOL,
		    COBOL_DIE,
		    BUG,
		    BUNNY,       /* NEUTRALS */
		    BUNNY_G,    /* Grooming bunny */
		    BUNNY_HEAD,
		    BUNNY_DEAD,
		    BLOOD_SPOT,
		    CD,         /* PROJECTILES */
		    FIREBALL,
		    NUKE,
		    NUKE_CRATE, /* Items */
		    CAN,
		    DISK,
		    NODOZE,
		    SPOON,
		    /* KEEP THIS LAST!!!!! */
		    NUM_ENTITIES
};

#define BADDIE_OFFSET MSCP
#define NEUTRAL_OFFSET BUNNY
#define PROJECTILE_OFFSET CD
#define ITEM_OFFSET NUKE_CRATE

#define NUM_CHARACTER_TYPES PROJECTILE_OFFSET
#define CAN_HEALTH 15

enum ENTITY_MODES { DEAD,
		    DYING,
		    GIB,
		    ALIVE,
		    GROOMING, /* for bunny */
		    SLEEP,
		    ATTACKING };

enum ENTITY_CLASS { GOODIE,
		    BADDIE,
		    NEUTRAL,
		    PROJECTILE,
		    ITEM };

entity *create_entity(int type);
entity *remove_entity(int ent_id);
void remove_all_entities(void);
