/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>

#include "image.h"
#include "xsoldier.h"
#include "extern.h"
#include "star.h"

#define MAXSTAR 4

typedef struct {
    int x, y; /* ΰ */
    int cpat; /* ɽƤѥֹ */
} Point;

typedef struct {
    Point *point;
    Image **image;
    unsigned int sW, sH;

    int pattern;
    int speed;
    int nstar;
} Star;

static Star     star[MAXSTAR];
static int      cust;
static unsigned int dW, dH;

void InitStarModule(unsigned int w, unsigned int h)
{
    dW = w; dH = h;
    cust = 0;
    return;
}

int CreateStar(char *filename, int pattern, int speed, int nstar)
{
    Image *tmp;
    Star  *S = &(star[cust]);
    int i;

    if (cust >= MAXSTAR)
    {
	fprintf(stderr, "CreateStar: can't create star!\n");
	fflush(stderr);
	return -1;
    }

    ReadFileToImage(filename,&tmp);
    SplitImage(tmp,&(S->image),pattern);
    FreeImage(tmp);

    S->pattern   = pattern;
    S->speed     = speed;
    S->nstar     = nstar;

    S->point = (Point *)malloc(sizeof(Point) * nstar);
    S->sW    = dW+(S->image[0])->width;
    S->sH    = dH+(S->image[0])->height;
    for (i=0; i<nstar; i++)
    {
	S->point[i].cpat = random() % pattern;
	S->point[i].x    = random() % S->sW;
	S->point[i].y    = random() % S->sH;
    }
    
    return cust++;
}

void DrawStar(int id)
{
    static Image *I;
    static Star *S;
    static Point *p;
    int i;


    S = &(star[id]);
    for (i=0; i<S->nstar; i++)
    {
	p = &(S->point[i]);
	I = S->image[(p->cpat)++];
	PutImage(I,p->x - I->width,p->y - I->height);
	if (p->cpat >= S->pattern) p->cpat = 0;
    }
    
    for (i=0; i<S->nstar; i++)
    {
	p = &(S->point[i]);
	p->y += S->speed;
	if (p->y < 0 || p->y > S->sH)
	{
	    p->x = random() % S->sW;
	    p->y = (S->speed > 0)?0:S->sH;
	}
    }

    return;
}

void ChangeStarParameter(int id, int speed)
{
    static Star *S;

    S = &(star[id]);
    S->speed     = speed;
    return;
}
