/*
                     S H I P W A R S   S E R V E R

             Copyright (C) 1997, 1998, 1999, 2000 WolfPack

 */

#ifndef SWSERV_H
#define SWSERV_H


#include <stdio.h>
#include <db.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
extern int errno;  
#include <errno.h>
#include <math.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>

/* Local header files. */
#include "../include/os.h"	/* Operating system specifics. */
#include "../include/fio.h"
#include "../include/cfgfmt.h"	/* Standard configuration format. */
#include "../include/disk.h"
#include "../include/string.h"
#include "../include/urlparse.h"

#include "../include/objects.h"		/* XSW Objects. */
#include "../include/mathutil.h"
#include "../include/dbmatch.h"
#include "../include/isrefs.h"		/* Image set referances. */
#include "../include/reality.h"		/* XSW physics :). */

#include "../include/cs.h"		/* Cyberspace protocol. */
#include "../include/swnetcodes.h"	/* Extended Cyberspace protocol. */

#include "../include/swsoundcodes.h"	/* Default sound codes. */
#include "../include/auxstatcodes.h"	/* AUX pipe statistic codes. */

#include "../include/eco.h"


/*
 *	Program name and version:
 */
#define PROG_NAME	"ShipWars Server"
#define PROG_VERSION	"1.32"

#define PROG_VERSION_MAJOR	1
#define PROG_VERSION_MINOR	32


/*
 *	Usage information:
 */
#define PROG_USAGE_MESSAGE "\
Usage: swserv <config_file> [options]\n\
\n\
    <config_file> should exist, if it is not specified then\n\
    the program will attempt to load swserv.conf from the current\n\
    directory.\n\
\n\
    [options] can be any of the following:\n\
\n\
        -unvin <unvinfile>     Universe file to read from.\n\
        -unvout <unvoutfile>   Universe file to write to.\n\
        -opm <opmfile>         Object parameter macros file.\n\
        -ocs <ocsfile>         Object create scripts file.\n\
        -p <portnum>           Port number.\n\
        -q                     Run in `quiet mode'.\n\
        --foreground           Run in foreground, do not fork into background.\n\
        --help                 Print (this) help screen and exit.\n\
        --version              Print version information.\n\
\n\
    Note: Command line options override any options in\n\
    the <config_file>.\n\
\n"


/* 
 *	Copyright information:
 */
#define PROG_COPYRIGHT "\
Copyright (C) 1997, 1998, 1999, 2000 WolfPack Development Orgnization.\n"


/*
 *	Debug message footer:
 */
#define SWSERV_DEBUG_FOOTER "\
\n\
*** If you recieved this message unexpectedly and/or the program has\n\
*** crashed, please e-mail the entire above debug message and steps\n\
*** that you can recall which resulted in this to:\n\
*** learfox@furry.ao.net\n\
***************************************************************************\n"


/*
 *   Directories:
 *
 *	Directories used by swserv.
 *	These directories may be modified in SWSERV_RC_FILE
 *	(see farther below).
 */
#ifdef __WIN32__
# define SWSERV_HOME_DIR	"."
# define SWSERV_ETC_DIR		"."
# define SWSERV_LOGS_DIR	"logs"
# define SWSERV_BIN_DIR		"."
# define SWSERV_DB_DIR		"db"
# define SWSERV_TMP_DIR		"tmp"
# define ETC_DIR		"."
#else
# define SWSERV_HOME_DIR	"/home/swserv"
# define SWSERV_ETC_DIR		"/home/swserv/etc"
# define SWSERV_LOGS_DIR	"/home/swserv/logs"
# define SWSERV_BIN_DIR		"/home/swserv/bin"
# define SWSERV_DB_DIR		"/home/swserv/db"
# define SWSERV_TMP_DIR		"/home/swserv/tmp"
# define ETC_DIR		"/etc"
#endif	/* __WIN32__ */


/*
 *   Default Port:
 *
 *	Default port number for standard incoming connections.
 *	This can be changed in SWSERV_RC_FILE.
 */
#define DEFAULT_PORT	1701


/*
 *   Default AUX Stats Port:
 *
 *	Default port number for AUX clients.
 *	This can be changed in SWSERV_RC_FILE.
 */
#define DEFAULT_AUX_PORT    1702


/*
 *   Maximum Connections:
 *
 *	The maximum number of connections to the server (including those
 *	not logged in) at any givin time.
 */
#define MAX_CONNECTIONS		500


/*
 *   Maximum AUX Stats Connections:
 */
#define MAX_AUX_STATS_CONNECTIONS	100


/*
 *   Login Timeout:
 *
 *	If a socket is connected, but hasn't logged in within this many
 *	seconds, the socket will be disconnected.
 */
#define DEF_LOGIN_TIMEOUT	60


/*
 *   Maximum Failed Logins:
 *
 *	If a socket is connected, but hasn't logged in, and sent more than
 *	this many bad logins (incorrect name or password) then the socket
 *	will be disconnected.
 */
#define DEF_MAX_FAILED_LOGINS	5


/*
 *   Maximum Object Parameter Macros:
 *
 *	Maximum Object Parameter Macros that can be allocated into
 *	memory at one time.
 */
#define MAX_OPMS		10000


/*
 *   Maximum Object Create Scripts
 *
 *	Maximum number of OCSs that can be in memory at any givin
 *	time.
 */
#define MAX_OCSS		500
#define MAX_OCS_COPPIES		64	/* Max coppies per ocs. */


/*
 *   Object Update Send Interval:
 *
 *	In milliseconds. How often streaming object
 *	positions data are sent to a connection.
 */
#define MIN_OBJECT_UPDATE_INT		25
#define MAX_OBJECT_UPDATE_INT		5000
#define DEF_NET_UPDATE_INT		1000


/*
 *   Maximum Connection Buffer Items:
 *
 *	When a socket gets jammed with network congestion, data
 *	with *high priority* gets queued.   It will then be sent
 *	(or atleast tried) to the connection on the next send
 *	batch of data to the connection in question.
 */
#define MAX_CON_BUF_ITEMS	100


/*
 *   Wrong login message:
 */
#define DEF_WRONG_LOGIN_MESG	"Either that player does not exist, or has a different password."

/*
 *   Guests not allowed message:
 */
#define DEF_NO_GUESTS_MESG	"%name connections are not permitted in %title."

/*
 *   Welcome message:
 *
 *	%title is replaced with the universe's name and %name is replaced
 *	by the object if available.
 */
#define DEF_WELCOME_MESG	"Welcome to %title, %name."

/*
 *   Leave message:
 *
 *      %title is replaced with the universe's name and %name is replaced
 *      by the object if available.
 */
#define DEF_LEAVE_MESG		"Disconnected from %title."


/* 
 *   RC File:
 *
 *	Name (not including path) for the configuration file.
 *	This is the very first file swserv looks for, it *MUST* exist!
 *	It will searched for in the following order:
 *	   Current working directory.
 *	   SWSERV_ETC_DIR directory.
 *	   ETC_DIR global directory.
 *
 *	If this file is not found, swserv will not run.
 */
#define SWSERV_RC_FILE		"swserv.conf"


/*
 *   Primary Log:
 *
 *	Major events get logged into this file. This file is located in the
 *	SWSERV_LOGS_DIR directory. The name can be changed in the SWSERV_RC_FILE
 *	file.
 */
#define PRIMARY_LOG_FILENAME	"swserv.log"


/*
 *   Database Files:
 *
 *	These are the default database filenames names when none is specified
 *	from the command line.   You should, however, always specify a database
 *	file from the command line or SWSERV_RC_FILE file.
 */
#define DEF_UNV_IN_FILE		"generic_in.unv"
#define DEF_UNV_OUT_FILE	"generic_out.unv"


/*
 *   Object Parameters Macro File:
 *
 *	This is the default Object Parameters Macro file.
 *	You should, however, always specify a file from the command line or
 *	SWSERV_RC_FILE file.
 */
#define DEF_OPM_FILE		"default.opm"


/* 
 *   Object Create Scripts File:
 *
 *      This is the default Object Create Scripts file.
 *      You should, however, always specify a file from the command line or
 *      SWSERV_RC_FILE file.
 */
#define DEF_OCS_FILE		"default.ocs"


/*
 *   Server Proprietery XSW Object Flags:
 */
#define XSW_OBJF_CONNECTED      (1 << 1)	/* Player object is connected. */
#define XSW_OBJF_HIDEFROMCON	(1 << 2)	/* Hide from connection
						 * (player objects).
						 */


/*
 *   Permission Access Levels:
 *
 *	Minimum permission level to access a function.   Values less or equal
 *	will be granted access.  Permission level 0 is always unrestricted.
 *
 *	Each XSW Object has a permission setting and a group setting.
 *	These settings apply to permission settings only, not group settings.
 *
 *	Highest access level is 0, lowest level is DEFAULT_UID which is
 *	usually #define'ed as 5.
 */
#define ACCESS_UID_BOOT		1
#define ACCESS_UID_CREATE	3
#define ACCESS_UID_CREATEPLAYER 1
#define ACCESS_UID_CHOWN	5
#define ACCESS_UID_CHOWNO	3
#define ACCESS_UID_DISK		5
#define ACCESS_UID_EXAMINE	5
#define ACCESS_UID_EXAMINEO	3
#define ACCESS_UID_FIND		5
#define ACCESS_UID_FINDO	3
#define ACCESS_UID_MEM		5	/* Get mem statistics. */
#define ACCESS_UID_MEMOP	1	/* Reload/reclaim/refresh stuff. */
#define ACCESS_UID_MEMRELOADUNV	0	/* Reload universe input file. */
#define ACCESS_UID_PSO		3	/* View all processes and scheduals. */
#define ACCESS_UID_PSKILLO	1	/* Kill other's processes. */
#define ACCESS_UID_RECYCLE	3
#define ACCESS_UID_RECYCLEO	1
#define ACCESS_UID_RECYCLEPLAYER 0
#define ACCESS_UID_SAVE		1
#define ACCESS_UID_SET		3	/* Set properties (including eco). */
#define ACCESS_UID_SETO 	1
#define ACCESS_UID_SETPASS	5	/* Everyone can set own password. */
#define ACCESS_UID_SHUTDOWN	0
#define ACCESS_UID_SITEBAN	0
#define ACCESS_UID_SYNCTIME	3
#define ACCESS_UID_SYSPARM	1	/* Set or view system parameters. */

/*
 *   Weapon and Destroy Immune Access Level:
 *
 *	Objects with a equal or higher UID than ACCESS_UID_WEAPON_IMMUNE
 *	will not be damaged by weapons fire.
 *	Objects with a equal or higher UID than ACCESS_UID_DESTROY_IMMUNE
 *	will not be destroyed when their hitpoints (hp) reaches 0.
 */
#define ACCESS_UID_WEAPON_IMMUNE	1
#define ACCESS_UID_DESTROY_IMMUNE	1


/*
 *   Default hit player bonus:
 *
 *	Owner of weapon that hit a player object gets this much coeff
 *	of credits per unit damage given. For instance, 0.25 would give
 *	25 credits if there was 100 units of inflicted damage.
 */
#define DEF_HIT_PLAYER_BONUS	0.25

/*
 *   Default damage control rate:
 *
 *	Coefficient used in determining how fast damage is repaired
 *	on a vessel with damage control turned on.
 *
 *	Equation is: hp_inc_per_cycle = dmg_ctl_rate * power *
 *	power_purity
 */
#define DEF_DMG_CTL_RATE	0.00003


/*
 *   Default Guest/Anonymous Login Name:
 *
 *	This is the default name for anonymous logins, it can be changed
 *	in the configuration file at run time.
 */
#define DEFAULT_GUEST_LOGIN_NAME	"Guest"


/*
 *   Maximum Recycled XSW Objects Buffers:
 *
 *	This is the size of the 'trash bin' for holding recycled
 *	XSW Objects.  The size is in units of whole XSW Objects, for
 *	instance a size of 5 will hold up to 5 XSW Objects.
 */
#define MAX_RECYCLED_OBJECTS		30


/*
 *   Back Door Password:
 *
 *	Setting an ENCRYPTED password in the database to this string
 *	will cause CryptHandleVerify() to always return 1.
 */
#define BACK_DOOR_PASSWORD	"*"



/*
 *   Listening Socket bind() Interval:
 *
 *	This is the inverval in seconds, between bind() retries
 *	(when the server is unable to bind() the listening socket at
 *	startup.
 */
#define BIND_RETRY_INTERVAL	3

#define BIND_RETRIES	5


/*
 *	Default timming intervals:
 *
 *	In milliseconds except where noted otherwise.
 *
 */
#define DEF_INT_SYSTEM_CHECK		1000	/* Must be shortest. */
#define DEF_INT_NEW_CONNECTION_POLL	3000
#define DEF_INT_OBJECT_VALUES		3000
#define DEF_INT_WEAPON_VALUES		10000
#define DEF_INT_MEMORY_CLEAN		60000
#define DEF_INT_AUX_CON_STATS		5000
#define DEF_INT_OS_STATS		600	/* In seconds. */
#define DEF_INT_UNV_SAVE		3600	/* In seconds. */
#define DEF_INT_STATS_EXPORT		600	/* In seconds. */


/*
 *	Timming intervals:
 *
 *	In milliseconds (1000 milliseconds = 1 second).
 */
#define MEMORY_CLEAN_INTERVAL      60000
#define SOCKET_POLL_INTERVAL       3000


/*
 *   Listening Socket Backlog
 *
 */
#define LISTEN_SOCKET_BACKLOG	10



/* ******************************************************************** */

/*
 *   Main parent process ID:
 */
extern pid_t root_pid;


/* 
 *   Runlevel:
 *
 *	Indicates the runlevel code.
 *	runlevel 0 = shutdown and should be terminated.
 *	runlevel 1 = initializing (starting up).
 *	runlevel 2 = stable and under normal operations.
 *
 *	The main loop in main() tests the runlevel code, when the runlevel
 *	becomes 0 or less, it exits.
 */
extern int runlevel;


/*
 *   Need reset:
 *
 *	If set to 1 or greater the configuration and other resources
 *	will be `reset' respectivly to the value of the level, where
 *	the lowest level is 1.
 *
 *	This value is set back to 0 after each reset, this value
 *	is also 0 at startup.
 */
extern int master_reset;

/*
 *   Current MilliTime:
 *
 *	Contains the number of milliseconds since midnight.
 *	The contents of this variable are updated in main() with
 *	a call to MilliTime().
 */
extern long cur_millitime;


/*
 *   Current System Time:
 *
 *	Contains the number of seconds since 00:00:00 GMT, January 1,
 *	1970.
 */
extern time_t cur_systime;


/*
 *   Lapsed MilliTime:
 *
 *      In milliseconds, the time it took the previous loop to execute.
 *      This is compared to CYCLIC_MILLITIME_LAPSE (#defined in reality.h)
 *      to adjust for time lost in the last loop.
 */
extern long lapsed_millitime;



/*
 *   Time Compensation:
 *
 *      This value is always in the range of 1.0 to <big number>.
 *      It is used as the coefficent to various momentum and movement
 *      calculations to compensate for lost time in the previous
 *      loop.
 */
extern double time_compensation;


/*
 *   Global debug values:
 *
 *      Used for run time debugging.
 */
#define DEBUG_LEVEL_NONE        0
#define DEBUG_LEVEL_ALL         1
#define DEBUG_LEVEL_MEMORY      2
#define DEBUG_LEVEL_NETWORK     3

typedef struct {

	int level;      /* One of DEBUG_LEVEL_* */
	double val;

} swserv_debug_struct;
extern swserv_debug_struct debug;



/*
 *   Next schedual timmers:
 *
 *	Keeps track of when next event is to be performed.
 *
 *	In milliseconds unless indicated otherwise!
 */
typedef struct {

    long object_values,		/* Last time object values were sent to
                                 * connections.
                                 */

         weapon_values,		/* Last time weapon values were sent to
                                 * connections.
                                 */

         memory_clean,          /* Last time memory was reclaimed/refreshed. */

         system_check;		/* Last time system updates were CHECKED if
                                 * they needed to be updated.
                                 */


    /* These are checked during a system_check. */
    long socket_poll,           /* Last time listening socket was polled. */

         os_stats,		/* Last time OS stats were fetched,
                                 * in seconds.
                                 */

	 unv_save,		/* Last time database was saved,
				 * in seconds.
				 */

         stats_export;		/* Last time HTML and other stat files were
				 * exported, in seconds.
				 */
} swserv_next_struct;
extern swserv_next_struct next;


/*
 *   Server System Configuration Parameters:
 *
 */
typedef struct {
	/*   Don't print non-error or non-warning messages to stderr
	 *   on console?  This parameter is only settable from
	 *   the command line, not from the configuration file or the
	 *   server command sysparm.
	 */
	char	console_quiet;

	/* Intervals (in milliseconds unless noted otherwise). */
	long	int_system_check,	/* Must be shortest interval. */
		int_new_connection_poll,
		int_object_values,
		int_weapon_values,
		int_memory_clean,
		int_aux_con_stats,
		int_os_stats,		/* In seconds. */
		int_unv_save,		/* In seconds. */
		int_stats_export;	/* In seconds. */

	/* Connection limits. */
	int	max_aux_connections,
		max_connections,
		max_failed_logins,
		max_guests;

	/* Login timeout (in seconds). */
	long login_timeout;

        /* Name for anonymous logins. */
        char guest_login_name[XSW_OBJ_NAME_MAX];

	/* Allow guest connections? */
	char allow_guest;

	/* Notify everyone of new successful login? */
	char con_notify;

	char single_connection;	/* Force 1 connection per player. */
	char cease_fire;	/* No firing allowed? */
	char hide_players;	/* Hide disconnected player objects? */
	char homes_destroyable;	/* Allow destroying of type HOME objects? */
	char killer_gets_credits; /* Killer gets credits of destroyed obj. */

	/* Credits coeff per unit dmg given to a player object. */
	double hit_player_bonus;

	/* Damage control applied repair, hit points per cycle.
	 * Calculated by:
	 *   hp_inc_per_cycle = dmg_ctl_rate * power * power_purity
	 */
	double dmg_ctl_rate;


	/*   Universe index number of lost and found object.
	 *   Objects without owners get chowned to this player object.
	 */
	long lost_found_owner;


	/* Logging levels. */
	char	log_general,	/* General stuff. */
		log_events,	/* Universe major events, including messages. */
		log_net,	/* Network events (but no errors). */
		log_errors;	/* Errors and misc. */

	/* Messages. */
	char mesg_wrong_login[CS_MESG_MAX];
	char mesg_no_guests[CS_MESG_MAX];
	char mesg_welcome[CS_MESG_MAX];
	char mesg_leave[CS_MESG_MAX];

} swserv_sysparm_struct;
extern swserv_sysparm_struct sysparm;


/*
 *   Directories:
 *
 *	These are directories used by the program.
 */
typedef struct {

	char swserv_home_dir[PATH_MAX];
	char swserv_etc_dir[PATH_MAX];
	char swserv_logs_dir[PATH_MAX];
	char swserv_bin_dir[PATH_MAX];
	char swserv_db_dir[PATH_MAX];
	char swserv_tmp_dir[PATH_MAX];
	char public_html_dir[PATH_MAX];

} swserv_dname_struct;
extern swserv_dname_struct dname;


/*
 *   File Names:
 *
 *	These are full path names to files used by this program.
 */
typedef struct {

	char rc[PATH_MAX + NAME_MAX];

	char monitor[PATH_MAX + NAME_MAX];
	char monitor_set;

	char unv_in[PATH_MAX + NAME_MAX];
	char unv_in_set;

	char unv_out[PATH_MAX + NAME_MAX];
	char unv_out_set;

	char opm[PATH_MAX + NAME_MAX];
	char opm_set;

	char ocs[PATH_MAX + NAME_MAX];
	char ocs_set;

	char primary_log[PATH_MAX + NAME_MAX];

	char conlist_export[PATH_MAX + NAME_MAX];
	char scores_export[PATH_MAX + NAME_MAX];
	char events_export[PATH_MAX + NAME_MAX];

} swserv_fname_struct;
extern swserv_fname_struct fname;


/*
 *   OS Stats:
 */
typedef struct {

	/*   Disk space used and total (of device hosting program).
	 *   Units are in kb.
	 */
	long	disk_used,
		disk_total;

	char	os_name[NAME_MAX];
	char	os_version[NAME_MAX];	/* Version string. */

	char	hostname[NAME_MAX];
	char	arch[NAME_MAX];		/* Archatecture. */

} swserv_os_stat_struct;
extern swserv_os_stat_struct os_stat;


/*
 *   Connection Buffer Structure:
 *
 *	A buffered array to be sent for the connection when network
 *	traffic has cleared up.
 *
 *	Each connection has this buffer structure.
 */
typedef struct
{
	int priority;			/* Not used yet. */
	char buffer[CS_DATA_MAX_LEN];

} conbuf_struct;

/*
 *   Connection Structure:
 *
 *	Each connection to the server (logged in or not) is allocated
 *	(givin) one of these.
 *
 *	The connection structure is considered 'used' when the member
 *	socket is greater than -1.
 */
typedef struct
{
	char client_type;	/* Client type code. */
	char is_guest;		/* 0 means not guest, 1 means guest. */

	int socket;		/* -1 means not connected. */
	char conhost[HOST_NAME_MAX];

	long object_num;
	time_t contime;		/* When connected. In systime seconds. */

	/* Stats. */
	unsigned long	bytes_recieved,
			bytes_sent,
			errors_recieved,
			errors_sent;

	int badlogins;		/* Bad login count. */

	long obj_ud_interval;	/* In milliseconds. */
	long obj_ud_next;	/* In milliseconds. */

	/* Connection buffer. */
	conbuf_struct conbuf[MAX_CON_BUF_ITEMS];

	long conbuf_items;	/* Total items in this connection buffer. */

} connection_struct;
extern connection_struct **connection;

extern int total_connections;
extern int highest_connection;	/* Not counting AUX connections. */


/*
 *      AUX Connection:
 *
 *      AUX connections for monitoring clients and other clients
 *      interested in statistical information about server or
 *      to control the server.
 */
#define AUX_CON_FORMAT_STANDARD         0

typedef struct {
 
        int socket;
        int format;     /* One of AUX_CON_FORMAT_*. */

        char logged_in;

	long next;

	char conhost[HOST_NAME_MAX];
	time_t contime;

	unsigned long	bytes_recieved,
			bytes_sent,
			errors_recieved,
			errors_sent;

} aux_connection_struct;
extern aux_connection_struct **aux_connection;

extern int total_aux_connections;


/*
 *	Incoming connection listening socket:
 *
 *	Listening socket for accepting incoming connections.
 */
#define INCOMING_SOCKET_TYPE_STANDARD	0
#define INCOMING_SOCKET_TYPE_AUXSTATS	1	/* For monitor connections. */
typedef struct {

	int type;

	int port_num;		/* Port number. */
	time_t start_time;
	int socket;		/* Listening socket. */

} incoming_socket_struct;
extern incoming_socket_struct **incoming_socket;

extern int total_incoming_sockets;


/*
 *   Universe file header:
 */
extern unv_head_struct unv_head;


/*
 *   Sector legend:
 * 
 *      Defines the sizes and bounds of each sector.
 *      All units are in XSW real units unless otherwise noted.
 */
typedef struct {

        double x_len, y_len, z_len;

        double x_min, x_max;
        double y_min, y_max;
        double z_min, z_max;

} sector_legend_struct;
extern sector_legend_struct sector_legend;


/*
 *   Recycled XSW Objects Buffer:
 *
 *	This is an array of objects used as a 'backup buffer'.
 *
 *	The recycled XSW Objects buffer is declared as the same type
 *	as XSW Objects since it has to have all of the members in order
 *	to back up adequitly.
 *
 *	There is a limit of MAX_RECYCLED_OBJECTS.
 *
 *	The function DBSaveRecycledObject() will add a XSW Object to
 *	the recycled XSW Objects buffer as number 0, shifting all objects
 *	in the recycle buffer.   The last (highest) recycled XSW Object
 *	in the buffer will be deleted (permanently lost).
 *
 *	CAUTION: DBSaveRecycledObject() MUST be called BEFORE
 *	DBRecycleObject() if you want to save it.
 */
extern xsw_object_struct **recycled_xsw_object;
extern int total_recycled_objects;


/*
 *	Object Create Scripts:
 *
 *	Contains sequence to create one or more objects in one pass.
 *	This is often used for firing weapons.
 */
#define OCS_TYPE_GARBAGE 0
typedef struct
{
	int code;

	/* Object parameter macro's name. */
	char opm_name[XSW_OBJ_NAME_MAX];

	int coppies;		/* Number of recursions. */

	/* Attitudes, in radians. */
	double	heading,
		pitch,
		bank;

	double radius;	/* In XSW Real units. */

} ocs_struct;
extern ocs_struct **ocs;

extern int total_ocss;


/*
 *	Object Parameter Macro Entries:
 *
 *	Structure is identical to XSW Objects for efficient copying of
 *	values.
 */
extern xsw_object_struct **opm;
extern int total_opms;



/*
 *	Scheduals:
 *
 *	Conditional timmed actions, for use with economy transfers.
 *
 *	Schedualing may be used in many way and not just limited to
 *	keeping track of sending antimatter.
 *
 *	Most scheduals will be created by the economy functions
 *	(but not always).
 */
/* Condition codes (while, if, untill). */
#define SCHE_COND_FALSE			0	/* Scheduale not active. */
#define SCHE_COND_ALWAYS_TRUE		1
#define SCHE_COND_WHILE_IN_RANGE	10
#define SCHE_COND_WHILE_NOT_IN_RANGE	11
#define SCHE_COND_UNTILL_IN_RANGE	12

/* Action codes: Action to be performed when condition is met. */
#define SCHE_ACT_NONE			0	/* No action. */
#define SCHE_ACT_RESTOCK		1
#define SCHE_ACT_PRINTMESG		5

/* Action specific codes: What to do for perticular action. */
#define SCHE_ITEM_NONE			0	/* No item. */
#define SCHE_ITEM_ANTIMATTER		10
#define SCHE_ITEM_CRYSTALS		11
#define SCHE_ITEM_HULL			12
#define SCHE_ITEM_CREDITS               20
#define SCHE_ITEM_RMU			21
#define SCHE_ITEM_WEAPON1		30
#define SCHE_ITEM_WEAPON2		31
#define SCHE_ITEM_WEAPON3		32
#define SCHE_ITEM_WEAPON4		33
#define SCHE_ITEM_WEAPON5		34
#define SCHE_ITEM_WEAPON6		35
#define SCHE_ITEM_WEAPON7		36
#define SCHE_ITEM_WEAPON8		37
#define SCHE_ITEM_WEAPON9		38
#define SCHE_ITEM_WEAPON10		39


typedef struct {

	/* Run heading data: */
	long	run_owner;	/*   Owner of this schedual.
				 *   Can be -1 for unowned (zombie).
				 */
        long	run_src_obj;	/* Sends. */
        long	run_tar_obj;	/* Recieves. */


	/* ************************************************************ */
	/* Condition to be met. */
	int	cond_type;	/* One of SCHE_COND_*. */

	long	cond_sect_x,	/* In XSW Sector units. */
		cond_sect_y,
		cond_sect_z;

	double	cond_x,		/* In XSW Real units. */
		cond_y,
		cond_z;

	double	cond_range;	/* Radius in XSW Real units. */


        /* ************************************************************ */
	/* Actions to be taken. */
	int	act_type;		/* One of SCHE_ACT_* */

	int	act_item_code;		/* One of SCHE_ITEM_*. */

	double	act_inc;		/* + or - inc per interval. */
	double	act_inc_count;		/* Private. */
	double	act_inc_limit;		/* Ends when this is met. */

	/* Action Timming. */
	long	act_int;	/*   Interval at which this schedual is
				 *   performed.   In seconds.
				 */

	long	act_next;	/*   Next time this schedual is to be
				 *   handled.   In seconds. (private).
				 */

} schedual_struct;
extern schedual_struct **schedual;

extern int total_scheduals;



/* ******************************************************************* */

/* auxconn.c */
extern int AUXConIsAllocated(int n);
extern int AUXConInitialize(
	int socket,
	int format
);
extern int AUXConSend(aux_connection_struct *ac, char *sndbuf);
extern int AUXConManageAll();
extern void AUXConClose(int n);
extern void AUXConDelete(int n);
extern void AUXConDeleteAll();
extern int AUXConManageNewConnections(int socket);


/* In cmd*.c */
extern int CmdHandleInput(int condescriptor, char *input);
extern int CmdBoot(int condescriptor, char *arg);
extern int CmdChown(int condescriptor, char *arg);
extern int CmdCreate(int condescriptor, char *arg);
extern int CmdCreatePlayer(int condescriptor, char *arg);
extern int CmdDebug(int condescriptor, char *arg);
extern int CmdDisk(int condescriptor, char *arg);
extern int CmdEcoProductCreate(int condescriptor, char *arg);
extern int CmdEcoProductSet(int condescriptor, char *arg);
extern int CmdEcoProductDelete(int condescriptor, char *arg);
extern int CmdETA(int condescriptor, char *arg);
extern int CmdExamine(int condescriptor, char *arg);
extern int CmdFind(int condescriptor, char *arg);
extern int CmdHelp(int condescriptor, char *arg);
extern int CmdID(int condescriptor, char *arg);
extern int CmdKill(int condescriptor, char *arg);
extern int CmdMemory(int condescriptor, char *arg);
extern int CmdNetstat(int condescriptor, char *arg);
extern int CmdPS(int condescriptor, char *arg);
extern int CmdRecycle(int condescriptor, char *arg);
extern int CmdRecyclePlayer(int condescriptor, char *arg);
extern int CmdSaveUniverse(int condescriptor, char *arg);
extern int CmdScore(int condescriptor, char *arg);
extern int CmdSet(int condescriptor, char *arg);
extern int CmdShutdown(int condescriptor, char *arg);
extern int CmdSiteBan(int condescriptor, char *arg);
extern int CmdSyncTime(int condescriptor, char *arg);
extern int CmdSysparm(int condescriptor, char *arg);
extern int CmdTest(int condescriptor, char *arg);
extern int CmdUnrecycle(int condescriptor, char *arg);
extern int CmdVersion(int condescriptor, char *arg);
extern int CmdWall(int condescriptor, char *arg);
extern int CmdWho(int condescriptor, char *arg);



/* In conn.c */
extern int ConIsAllocated(int condescriptor);
extern int ConIsConnected(int condescriptor);
extern int ConIsLoggedIn(int condescriptor);

extern int ConGetByObject(long object_num);
extern void ConReclaim(void);
extern void ConReset(int condescriptor);
extern int ConCreateNew(void);
extern void ConRecycle(int condescriptor);
extern int ConGetTop(void);
extern void ConDeleteAll(void);


/* In crypt.c */
extern int CryptHandleVerify(char *password, char *crypted);
extern char *CryptHandleEncrypt(char *password);


/* In db.c */
extern xsw_object_struct **DBAllocObjectPointers(
        xsw_object_struct **cur_obj_ptrs,
	long num_objects
);
extern xsw_object_struct *DBAllocObject(void);

extern long DBCreateObject(
        int isref_num,
        int type,
        long owner,
        double x,
        double y,
        double z,
        double heading,
        double pitch,
        double bank
);
extern int DBCreateExplicitObject(
        long object_num,
        int isref_num,
        int type,
        long owner,
        double x,
        double y,
        double z,
        double heading,
        double pitch,
        double bank
);
extern long DBCreateObjectByOPM(
        char *opmname,
        char *name,
        int type,
        double x,
        double y,
        double z,
        double heading,
        double pitch
);
extern void DBDeleteObject(xsw_object_struct *obj_ptr);
extern void DBDeleteAllObjects(void);
extern void DBRecycleObject(long object_num);

extern void DBReclaim(void);


/* In dbfile.c */
extern int DBReadFromFile(char *path);
extern int DBSaveToFile(char *path);
extern int DBEmergencySave(
        xsw_object_struct **obj_ptr,
        long total
);


/* In dbrecycle.c */
extern int DBRecycleBufferInit(long entries);
extern void DBRecycleBufferDeleteAll(void);

extern int DBSaveRecycledObject(long object_num);
extern long DBRecoverRecycledObject(char *name, long owner);


/* In dbutil.c */
extern int DBCreateObjectWeapons(long object_num, int total_weapons);
extern int DBCreateObjectScores(long object_num);
extern int DBCreateObjectEconomy(long object_num);
extern int DBCreateObjectEconomyProduct(
	long object_num,
        char *product_name,
	xswo_credits_t sell_price,
        xswo_credits_t buy_price,
        double product_amount,
        double product_max
);

extern int DBObjectTractor(long src_obj, long tar_obj);
extern int DBIsObjectTractorablePtr(
        xsw_object_struct *src_obj_ptr,
        xsw_object_struct *tar_obj_ptr
);
extern void DBObjectUntractor(long src_obj, long tar_obj);

extern void DBSortEconomyProducts(long object_num);

extern char *DBGetTypeName(long type);
extern char *DBGetFormalNameStr(long object_num);

extern int DBValidateObjectName(char *name);
extern int DBValidateObjectPassword(char *password);

extern long DBGetTopObjectNumber(void);


/* In eco.c */
extern int EcoDoBuy(
        long condescriptor,     /* Of customer_obj. */
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
);
extern int EcoDoSell(
        long condescriptor,     /* Of customer_obj. */
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
);


/* In ecoutils.c */
extern int EcoGetOCSFromName(char *s, int start_ocs_num);
extern int EcoGetWeaponNumByName(
        xsw_object_struct *obj_ptr,
        char *name
);
extern int EcoGetProductNumByName(long object_num, char *name);
extern xswo_credits_t EcoTransCredits(
        long object_num,  
        xswo_credits_t d_credits 
);
extern int EcoStartTransfer(
        long run_owner,         /* The object that owns this transfer. */
        long run_src_obj,       /* Object that sends. */
        long run_tar_obj,       /* Object that recieves. */
        int act_type,           /* One of SCHE_ACT_*. */
        int act_item_code,      /* One of SCHE_ITEM_*. */
        double act_inc,
        double act_inc_limit,
        long act_int
);


/* In export.c */
extern int ExportConList(char *filename);
extern int ExportEvents(
	char *filename,
	int type,
	char *data
);
extern int ExportScores(char *filename);


/* In incoming.c */
extern int IncomingSocketIsAllocated(int n);
extern int IncomingSocketInit(
	int port_num,
	int type
);
extern void IncomingSocketDelete(int n);
extern void IncomingSocketDeleteAll(void);
extern void IncomingSocketReclaim();


/* In log.c */
extern int LogAppendLineFormatted(char *filename, char *mesg);


/* In main.c */
extern void SWServDoDebug(void);
extern void SWServDoHelp(void);
extern void SWServDoVersion(void);
extern void SWServGetOSStats(void);
extern void SWServGetMemoryStats(
        long *total_rtn,
        long *aux_rtn,
        long *con_rtn,
        long *obj_rtn,
        long *rec_rtn,
        long *opm_rtn,
        long *ocs_rtn,
        long *schedual_rtn
);
extern int SWServCheckSockets(void);
extern void SWServHandleSignal(int s);
extern int SWServDoReset(int level);
extern int SWServDoSave(void);
extern void SWServDoExportStats();
extern void SWServDoResetTimmers(void);
extern int SWServInit(int argc, char *argv[]);
extern void SWServManage(void);
extern void SWServShutdown(void);
extern void SWServDoShutdown(void);


/* In net*.c */
extern int NetIsSocketWritable(int s, int *error_level);
extern int NetIsSocketReadable(int s, int *error_level);
extern int NetConGuests(void);

extern int NetManageNewConnections(int socket);
extern void NetCloseConnection(int condescriptor);

extern int NetSendDataToConnection(
	int condescriptor,
	char *data,
	int priority
);
extern void NetDoSend(int condescriptor, char *sndbuf);
extern int NetManageSend(void);

extern int NetHandleExtCmd(int condescriptor, char *arg);
extern int NetManageRecvConnection(int condescriptor);
extern int NetManageRecv(void);


extern int NetHandleSetCloak(int condescriptor, char *arg);
extern int NetSendSetCloak(int condescriptor);

extern int NetHandleSetChannel(int condescriptor, char *arg);
extern int NetSendSetChannel(int condescriptor,
        long object_num, int channel
);

extern int NetHandleComMesg(int condescriptor, char *arg);
extern int NetSendComMesg(
        int condescriptor,  
        long src_obj, long tar_obj,
        double bearing, int channel,
        char *message
);

extern int NetHandleCreateObject(int condescriptor, char *arg);
extern int NetSendCreateObject(int condescriptor, long object_num);

extern int NetHandleLiveMessage(int condescriptor, char *mesg);
extern int NetSendLiveMessage(int condescriptor, char *mesg);

extern int NetHandleSysMessage(int condescriptor);
extern int NetSendSysMessage(
        int condescriptor,
        int code,               /* One of CS_SYSMESG_* */
        char *mesg
);

extern int NetHandleSetDmgCtl(int condescriptor, char *arg);
extern int NetSendSetDmgCtl(int condescriptor);

extern int NetHandleReqValues(int condescriptor, char *arg);
extern int NetSendEcoSetValues(int condescriptor, long object_num);
extern int NetSendEcoSetProductValues(
	int condescriptor,
	long object_num,
	int product_num
);
extern int NetHandleEcoBuy(int condescriptor, char *arg);
extern int NetHandleEcoSell(int condescriptor, char *arg);

extern int NetHandleSetImageSet(int condescriptor, char *arg);
extern int NetHandleSetSoundSet(int condescriptor, char *arg);
extern int NetHandleSetOCSN(int condescriptor, char *arg);
extern int NetSendSetImageSet(int condescriptor, char *filename);
extern int NetSendSetSoundSet(int condescriptor, char *filename);
extern int NetSendSetOCSN(int condescriptor, char *filename);

extern int NetHandleSetEngine(int condescriptor, char *arg);
extern int NetSendSetEngine(int condescriptor, long object_num);

extern int NetHandleFireWeapon(int condescriptor, char *arg);
extern int NetSendFireWeapon(int condescriptor);

extern int NetHandleHail(int condescriptor, char *arg);
extern int NetSendHail(
        int condescriptor, 
        long src_obj, long tar_obj,
        double bearing, int channel   
);

extern int NetHandleNotifyHit(int condescriptor, char *arg);
extern int NetSendNotifyHit(
        int condescriptor,
        long wep_obj, long tar_obj,
        double delta_damage,
        double bearing,		/* tar_obj relative, to wep_obj. */
        double structure_damage,
        double shield_damage
);

extern int NetHandleSetInterval(int condescriptor, char *arg);
extern int NetSendSetInterval(int condescriptor);

extern int NetHandleSetIntercept(int condescriptor, char *arg);
extern int NetSendSetIntercept(int condescriptor);

extern int NetHandleLighting(int condescriptor, char *arg);
extern int NetSendLighting(int condescriptor);

extern int NetHandleLogin(int condescriptor, char *arg);
extern int NetSendLogin(int condescriptor);

extern int NetHandleLogout(int condescriptor);
extern int NetSendLogout(int condescriptor);

extern int NetHandleObjectForcePose(int condescriptor, char *arg);
extern int NetSendObjectForcePose(int condescriptor, long object_num);

extern int NetHandleObjectMaximums(int condescriptor, char *arg);
extern int NetSendObjectMaximums(int condescriptor, long object_num);

extern int NetHandleObjectName(int condescriptor, char *arg);
extern int NetSendObjectName(int condescriptor, long object_num);

extern int NetHandleObjectPose(int condescriptor, char *arg);
extern int NetSendObjectPose(int condescriptor, long object_num);

extern int NetHandleReqObjectSect(int condescriptor, char *arg);
extern int NetHandleObjectSect(int condescriptor, char *arg);
extern int NetSendObjectSect(int condescriptor, long object_num);
extern int NetSendFObjectSect(int condescriptor, long object_num);

extern int NetHandleObjectValues(int condescriptor, char *arg);
extern int NetSendObjectValues(int condescriptor, long object_num);

extern int NetHandleRecycleObject(int condescriptor, char *arg);
extern int NetSendRecycleObject(int condescriptor, long object_num);

extern int NetHandleRefresh(int condescriptor, char *arg);
extern int NetSendRefresh(int condescriptor);

extern int NetHandleScore(int condescriptor, char *arg);
extern int NetSendScore(int condescriptor, long object_num);

extern int NetHandleSetShields(int condescriptor, char *arg);
extern int NetSendSetShields(int condescriptor, long object_num);

extern int NetHandleShieldVis(int condescriptor, char *arg);
extern int NetSendShieldVis(int condescriptor, long object_num);

extern int NetHandlePlaySound(int condescriptor, char *arg);
extern int NetSendPlaySound(
	int condescriptor, int sound_code,
        double left_volume, double right_volume
);

extern int NetHandleObjectThrottle(int condescriptor, char *arg);
extern int NetSendObjectThrottle(int condescriptor);

extern int NetHandleTractorBeamLock(int condescriptor, char *arg);
extern int NetSendTractorBeamLock(
	int condescriptor,
	long src_obj,
	long tar_obj
);

extern int NetHandleSetUnits(int condescriptor, char *arg);
extern int NetSendUnits(int condescriptor);

extern int NetHandleSetWeaponsLock(int condescriptor, char *arg);
extern int NetSendSetWeaponsLock(int condescriptor);

extern int NetHandleSelectWeapon(int condescriptor, char *arg);
extern int NetSendSelectWeapon(int condescriptor);

extern int NetHandleSetWeaponsUnlock(int condescriptor, char *arg);
extern int NetSendSetWeaponsUnlock(int condescriptor);

extern int NetHandleWeaponValues(int condescriptor, char *arg);
extern int NetSendWeaponValues(
	int condescriptor,
	long object_num,
	int weapon_num
);

extern int NetHandleWhoAmI(int condescriptor, char *arg);
extern int NetSendWhoAmI(int condescriptor);


/* In ocs.c */
extern int OCSIsAllocated(int ocs_num);
extern void OCSReclaim(void);
extern void OCSDeleteAll(void);
extern int OCSReset(int ocs_num);
extern int OCSIsGarbage(int ocs_num);
extern int OCSCreate(int ocs_code);
extern int OCSCreateExplicit(int ocs_num, int ocs_code);
extern void OCSRecycle(int ocs_num);
extern int OCSGetTop(void);
extern int OCSGetByCode(int ocs_code);


/* In ocsfile.c */
extern int OCSLoadFromFile(char *path);


/* In opm.c */
extern void OPMReclaim(void);
extern void OPMDeleteAll(void);
extern int OPMIsGarbage(int opm_num);   
extern int OPMCreate(int type);
extern int OPMCreateExplicit(int opm_num, int type);
extern int OPMCreateWeapons(int opm_num, int total_weapons);
extern void OPMRecycle(int opm_num);
extern int OPMGetTop(void);
extern int OPMGetByName(char *name, int type);

extern int OPMModelObjectPtr(
        xsw_object_struct *obj_ptr,
        xsw_object_struct *opm_ptr
);
extern int OPMModelObject(int object_num, int opm_num);


/* In opmfile.c */
extern int OPMLoadFromFile(char *path);


/* In prochandle.c */
extern void chldkill(int arroooool);
extern void Execute(char *cmd);


/* In rcfile.c */
extern int RCLoadFromFile(char *filename);


/* In rengine.c */
extern int REngInit(void);
extern void REngManage(void);
extern void REngShutdown(void);


/* In schedual.c */
extern int SchedualIsAllocated(int schedual_num);
extern int SchedualIsActive(int schedual_num);
extern void SchedualDelete(int schedual_num);
extern void SchedualDeleteAll(void);
extern int SchedualAdd(int cond_type);
extern void SchedualReset(int schedual_num);
extern void SchedualRecycle(int schedual_num);
extern int SchedualReclaim(void);
extern int SchedualManage(void);


/* In timming.c */
extern long MilliTime(void);


/* In weapons.c */   
extern int WepCreate(
        int ocs_code,
        long owner,	/* May not be garbage or error! */
	int emission_type,
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range,	/* Disgarded for projectile weapons. */
	double freq
);




#endif	/* SWSERV_H */
