#include "swserv.h"
 
 
int CmdRecycle(int condescriptor, char *arg)
{
        char name1[256];
        char name2[256];
        
        long object_num;
        long con_object_num;
        
        char sndbuf[CS_DATA_MAX_LEN];
        
        char stringa[CS_DATA_MAX_LEN];
        
        
        /* Copy arg to stringa. */
        strncpy(stringa, arg, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';   
        StringStripSpaces(stringa);
        
        
        /* If no argument, print usage. */
        if(strlen(stringa) < 1)
        {
            NetSendLiveMessage(condescriptor,
                "Usage: `recycle <object>'"  
            );
            return(-1);
        }

        /* Get con_object_num (assumed valid). */
        con_object_num = connection[condescriptor]->object_num;

 
        /* Get object_num. */ 
        object_num = MatchObjectByName(stringa, -1);
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "%s: No such object.",
                stringa
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-1);
        }
        else if(xsw_object[object_num]->type == XSW_OBJ_TYPE_PLAYER)
        {
            sprintf(sndbuf,
                "recycle: Permission denied, use `recycleplayer'."
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-1);
        }


        /* Check permissions, allowed to recycle? */
        if(xsw_object[con_object_num]->permission.uid > ACCESS_UID_RECYCLE)
        {     
            sprintf(sndbuf,
                "chown: Requires access level %i: Permission denied.",
                ACCESS_UID_RECYCLE
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }
        /* If object owned by other, allowed to chown from other? */
        else if((xsw_object[con_object_num]->permission.uid >
                    ACCESS_UID_RECYCLEO) &&
                (xsw_object[object_num]->owner > -1) &&
                (xsw_object[object_num]->owner != con_object_num)
        )
        {
            sprintf(sndbuf,
   "recycle: Requires access level %i: Permission denied, owned by other.",
                ACCESS_UID_RECYCLEO
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }
        /* Cannot recycle something with a UID greater than yours. */
        else if(xsw_object[con_object_num]->permission.uid >
                xsw_object[object_num]->permission.uid
        )
        {
            sprintf(sndbuf,
       "recycle: Permission: Target object UID %i exceeds your UID %i.",
                xsw_object[object_num]->permission.uid,
                xsw_object[con_object_num]->permission.uid
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


        /* Print and log. */
        sprintf(sndbuf,
            "%s: Placed into recycle backup buffer.",
            DBGetFormalNameStr(object_num)
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        strncpy(name1, DBGetFormalNameStr(con_object_num), 256); 
        name1[255] = '\0';
        strncpy(name2, DBGetFormalNameStr(object_num), 256);
        name2[255] = '\0'; 

        sprintf(stringa,
                "%s: Recycled %s and placed into recycle backup buffer.",
                name1, name2
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Recycle object. */
        DBSaveRecycledObject(object_num);
        DBRecycleObject(object_num);
        NetSendRecycleObject(-1, object_num);


        return(0);
}
