#!/bin/sh

if test "$4" = ""; then
  echo usage `basename $0` "Helmet/Face" "Body/Hands" "Arms/BackPack", "Mask"
  exit
fi

HeFa=$1
BoHa=$2
ArBa=$3
Mask=$4

#
# divive ppms intro rgb channels
#
cat $HeFa | ppmtorgb3
mmv noname.\* HeFa.\#1
 
cat $BoHa | ppmtorgb3
mmv noname.\* BoHa.\#1
 
cat $ArBa | ppmtorgb3
mmv noname.\* ArBa.\#1
 
cat $Mask | ppmtorgb3
mmv noname.\* Mask.\#1
 
#
# create separate pgms
#
pnmarith -sub HeFa.red HeFa.blu >helmet.pgm
pnmarith -sub HeFa.grn HeFa.blu >face.pgm
pnmarith -sub BoHa.red BoHa.blu >body.pgm
pnmarith -sub BoHa.grn BoHa.blu >handsfeet.pgm
pnmarith -sub ArBa.red ArBa.blu >armslegs.pgm
pnmarith -sub ArBa.grn ArBa.blu >backpack.pgm

pgmtoppm Black-White HeFa.blu > HeFa.tmp 2>/dev/null
pgmtoppm Black-White BoHa.blu > BoHa.tmp 2>/dev/null
pgmtoppm Black-White ArBa.blu > ArBa.tmp 2>/dev/null


ppmmix 0.5 HeFa.tmp ArBa.tmp >tmp.tmp
ppmmix 0.333 tmp.tmp BoHa.tmp | ppmtopgm >highlight.pgm

pnmarith -sub Mask.red highlight.pgm | pgmtopbm -threshold -value 0.5 >mask.pbm

rm *.red *.blu *.grn *.tmp