## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, string, sys, types, Tkinter

# PySol imports
from mfxutil import destruct, Struct, kwdefault, KwStruct           #bundle#
from util import *                                                  #bundle#
from stats import PysolStatsWriter                                  #bundle#

# Toolkit imports
from tkutil import bind, unbind_destroy, getFont                    #bundle#
from tkwidget import _ToplevelDialog, MfxDialog                     #bundle#
from tkwidget import MfxScrolledCanvas                              #bundle#


# /***********************************************************************
# // FIXME - this a quick hack and needs a rewrite
# ************************************************************************/

class StatsDialogScrolledCanvas(MfxScrolledCanvas):
    pass


class StatsDialog(MfxDialog):
    def __init__(self, parent, title, app, player, header, **kw):
        kw = self.initKw(kw)
        _ToplevelDialog.__init__(self, parent, title, kw.resizable)
        top_frame, bottom_frame = self.createFrames(kw)
        self.createBitmaps(top_frame, kw)
        #
        self.top.wm_minsize(200, 200)
        self.num = kw.default
        self.font = kw.font
        self.sc = StatsDialogScrolledCanvas(top_frame)
        self.canvas = self.sc.canvas
        self.canvas.config(width=kw.c_width, height=kw.c_height)
        self.sc.frame.pack(fill=Tkinter.BOTH, expand=1, padx=kw.padx, pady=kw.pady)
        self.fillCanvas(app, player, header)
        bbox = self.canvas.bbox("all")
        ##print bbox
        ##self.canvas.config(scrollregion=bbox)
        self.canvas.config(scrollregion=(0,0,bbox[2],bbox[3]))
        #
        focus = self.createButtons(bottom_frame, kw)
        self.mainloop(focus, kw.timeout)

    def initKw(self, kw):
        kw = KwStruct(kw,
            strings=("Ok", "Reset game", "Reset all", "Print to file"), default=0,
            separatorwidth=2, resizable=1,
            padx=10, pady=10,
            c_width=500, c_height=25*16,
        )
        return MfxDialog.initKw(self, kw)

    def getDefaultFont(self):
        return getFont("small")

    #
    #
    #

    class CanvasWriter:
        def __init__(self, canvas, font, h):
            self.canvas = canvas
            self.font = font
            self.h = h
            self.x = self.y = 0
            self.canvas.config(yscrollincrement=h)

        def p(self, s):
            if self.y > 16000:
                return
            h1, h2 = 0, 0
            while s and s[0] == "\n":
                s = s[1:]
                h1 = h1 + self.h
            while s and s[-1] == "\n":
                s = s[:-1]
                h2 = h2 + self.h
            self.y = self.y + h1
            if s:
                id = self.canvas.create_text(self.x, self.y, text=s, anchor="nw", font=self.font)
            self.y = self.y + h2
            return h1 + h2

        def pp(self, x, y, **kw):
            kwdefault(kw, font=self.font)
            id = apply(self.canvas.create_text, (x, y), kw)
            return self.h
            ##bbox = self.canvas.bbox(id)
            ##return bbox[3] - bbox[1]

        def eline(self):
            self.y = self.y + self.h
            return self.h

        def pline(self, x, y, gameid, text):
            h = 0
            h = max(h, self.pp(x    , y, anchor="nw", text=str(text[0])))
            h = max(h, self.pp(x+200, y, anchor="ne", text=str(text[1])))
            h = max(h, self.pp(x+250, y, anchor="ne", text=str(text[2])))
            h = max(h, self.pp(x+300, y, anchor="ne", text=str(text[3])))
            h = max(h, self.pp(x+350, y, anchor="ne", text=str(text[4])))
            self.pperc(x+372, y, str(text[4]))
            return h

        def pperc(self, x, y, t):
            if not (t and "0" <= t[0] <= "9"):
                return
            perc = int(round(string.atof(str(t))))
            if perc < 1:
                return
            rx, ry, rw, rh = x, y+1, 2 + 8*10, self.h-5
            ##fill = "#ffffff"
            ##fill = self.canvas["bg"]
            fill = None
            self.canvas.create_rectangle(rx, ry, rx+rw, ry+rh, width=1,
                                         fill=fill, outline="#808080")
            p = 1.0
            ix = rx + 2
            for i in (1, 11, 21, 31, 41, 51, 61, 71, 81, 91):
                if perc < i:
                    break
                ##c = "#ff8040"
                r, g, b = 255, 128*p, 64*p
                c = "#%02x%02x%02x" % (int(r), int(g), int(b))
                self.canvas.create_rectangle(ix, ry+2, ix+6, ry+rh-2, width=0,
                                             fill=c, outline=c)
                ix = ix + 8
                p = max(0.0, p - 0.1)


    def fillCanvas(self, app, player, header):
        a = PysolStatsWriter(app)
        writer = self.CanvasWriter(self.canvas, self.font, 16)
        if not a.writeStats(writer, player, header):
            writer.p("No entries for player " + str(player) + "\n")
        destruct(a)


class StatsLogDialog(StatsDialog):
    def fillCanvas(self, app, player, header=""):
        a = PysolStatsWriter(app)
        writer = self.CanvasWriter(self.canvas, self.font, 16)
        if not a.writeLog(writer, player):
            writer.p("No log entries for player " + str(player) + "\n")
        destruct(a)

    def initKw(self, kw):
        char_w = 7
        if os.name == "nt": char_w = 8
        if os.name == "mac": char_w = 6
        kw = KwStruct(kw,
            strings=("Ok",), default=0,
            font=getFont("canvas_fixed"),
            c_width=76*char_w,
        )
        return StatsDialog.initKw(self, kw)

