## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import math, os, re, string, sys
from gtk import *

# PySol imports
from mfxutil import destruct, Struct                                #bundle#
from util import PACKAGE, VERSION                                   #bundle#
from actions import PysolMenubarActions                             #bundle#
from tkutil import setTransient                                     #bundle#
from tkutil import color_tk2gtk, color_gtk2tk                       #bundle#


# /***********************************************************************
# // - create menubar
# // - update menubar
# // - menu actions
# ************************************************************************/

class PysolMenubar(PysolMenubarActions):
    def __init__(self, app, top):
        PysolMenubarActions.__init__(self, app, top)
        self.menus = None
        self.menu_items = None
        # create menus
        menubar, accel = self.createMenus()
        # additional key bindings
        ### FIXME
        ###self.accel.add("Space", None, None, None, None)
        # delete the old menubar
        # set the menubar
        accel.attach(self.top)
        w = menubar.get_widget('<main>')
        self.top.vbox.add(w, expand=FALSE, fill=FALSE)
        self.top.vbox.reorder_child(w, 0)
        self.__menubar = menubar
        self.__accel = accel
        self.menus = menubar


    #
    # create menubar
    #

    def m(self, *args):
        ##print args
        pass

    def _initItemFactory(self):
        self.menu_items = (
            ["/_File", None, None, 0, "<Branch>"],
            ["/File/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/File/_New Game", "<control>N", self.mNewGame, 0, ""],
            ["/File/Select _game", None, None, 0, "<Branch>"],
        )

        mi, radio = [], "<RadioItem>"
        games = self.app.getGamesIdSortedByName()
        i = 0
        path = "/File/Select game"
        for id in games:
            columnbreak = i > 0 and (i % 25) == 0
            p = path + '/' + self.app.getGameMenuitemName(id)
            mi.append([p, None, self.mSelectGame, id, radio])
            if radio[0] == '<':
                radio = re.sub('_', '', p)
            i = i + 1
        self.menu_items = self.menu_items + tuple(mi)
        self.tkopt.gameid.path = radio

        self.menu_items = self.menu_items + (
            ["/File/Select game by ID...", None, self.mNewGame, 0, ""],
            ["/File/<sep>", None, None, 0, "<Separator>"],
            ["/File/_Open", "<control>O", self.m, 0, ""],
            ["/File/_Save", "<control>S", self.mSave, 0, ""],
            ["/File/Save _as...", None, self.m, 0, ""],
            ["/File/<sep>", None, None, 0, "<Separator>"],
            ["/File/_Quit", "<control>Q", self.mQuit, 0, ""],
            ["/_Edit", None, None, 0, "<Branch>"],
            ["/Edit/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/Edit/_Undo", "Z", self.mUndo, 0, ""],
            ["/Edit/_Redo", "R", self.mRedo, 0, ""],
            ["/Edit/Redo _all", None, self.mRedoAll, 0, ""],
            ["/Edit/<sep>", None, None, 0, "<Separator>"],
            ["/Edit/Restart _game", "<control>G", self.mRestart, 0, ""],
            ["/_Game", None, None, 0, "<Branch>"],
            ["/Game/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/Game/_Deal cards", "D", self.mDeal, 0, ""],
            ["/Game/_Auto drop", "A", self.mDrop, 0, ""],
            ["/Game/<sep>", None, None, 0, "<Separator>"],
            ["/Game/S_tatus...", "T", self.mStatus, 0, ""],
            ["/_Assist", None, None, 0, "<Branch>"],
            ["/Assist/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/Assist/_Hint", "H", self.mHint, 0, ""],
            ["/Assist/Highlight _piles", "Shift", self.mHighlightPiles, 0, ""],
            ["/Assist/<sep>", None, None, 0, "<Separator>"],
            ["/Assist/_Demo", "<control>D", self.mDemo, 0, ""],
            ["/Assist/Demo (all games)", "", self.mMixedDemo, 0, ""],
            ["/_Options", None, None, 0, "<Branch>"],
            ["/Options/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/Options/_Confirm", None, self.mOptConfirm, 0, "<ToggleItem>"],
            ["/Options/Auto_play", "P", self.mOptAutoplay, 0, "<ToggleItem>"],
            ["/Options/_Automatic _face up", "F", self.mOptAutoFaceUp, 0, "<ToggleItem>"],
            ["/Options/Highlight _matching cards", None, self.mOptHighlightMatchingCards, 0, "<ToggleItem>"],
            ["/Options/<sep>", None, None, 0, "<Separator>"],
        )

        mi, radio = [], "<RadioItem>"
        path = "/Options/Cards_et"
        mi.append([path, None, None, 0, "<Branch>"])
        for i in range(self.app.cm.len()):
            columnbreak = i > 0 and (i % 25) == 0
            p = path + '/' + self.app.cm.get(i).name
            mi.append([p, None, self.mOptCardset, i, radio])
            if radio[0] == '<':
                radio = re.sub('_', '', p)
        self.menu_items = self.menu_items + tuple(mi)
        self.tkopt.cardset.path = radio

        self.menu_items = self.menu_items + (
            ["/Options/Table color...", None, self.mOptTableColor, 0, ""],
        )

        mi, radio = [], "<RadioItem>"
        path = "/Options/_Animations"
        mi.append([path, None, None, 0, "<Branch>"])
        i = 0
        for k in ("_None", "_Fast", "_Timer based"):
            p = path + '/' + k
            mi.append([p, None, self.mOptAnimations, i, radio])
            if radio[0] == '<':
                radio = re.sub('_', '', p)
            i = i + 1
        self.menu_items = self.menu_items + tuple(mi)
        self.tkopt.animations.path = radio

        self.menu_items = self.menu_items + (
            ["/Options/Card shadow", None, self.mOptShadow, 0, "<ToggleItem>"],
            ["/Options/Shade legal moves", None, self.mOptShade, 0, "<ToggleItem>"],
            ["/Options/<sep>", None, None, 0, "<Separator>"],
            ["/Options/_Hint speed...", None, self.mOptHintSpeed, 0, ""],
            ["/Options/_Demo speed...", None, self.mOptDemoSpeed, 0, ""],
            ["/Options/<sep>", None, None, 0, "<Separator>"],
            ["/Options/_Save options", None, self.mOptSave, 0, ""],
            ["/_Help", None, None, 0, "<LastBranch>"],
            ["/Help/<tearoff>", None, None, 0, "<Tearoff>"],
            ["/Help/_Contents", "F1", self.mHelp, 0, ""],
            ["/Help/_Rules", None, self.mHelpRules, 0, ""],
            ["/Help/<sep>", None, None, 0, "<Separator>"],
            ["/Help/_About PySol...", None, self.mHelpAbout, 0, ""],
        )


    def createMenus(self):
        if not self.menu_items:
            self._initItemFactory()
        accel = GtkAccelGroup()
        item_factory = GtkItemFactory(
            type=GtkMenuBar.get_type(),
            path='<main>',
            accel_group=accel)
        item_factory.create_items(self.menu_items)
        return item_factory, accel


    #
    # menu updates
    #

    def setMenuState(self, state, path):
        w = self.__menubar.get_widget(path)
        w.set_sensitive(state)

    def setToolbarState(self, state, path):
        w = getattr(self.app.toolbar, path + "_button")
        w.set_sensitive(state)


    #
    # menu actions
    #

    def mOptTableColor(self, *args):
        win = GtkColorSelectionDialog("Select table color")
        win.help_button.destroy()
        win.set_position(WIN_POS_MOUSE)
        win.colorsel.set_color(color_tk2gtk(self.app.opt.tablecolor))
        ##win.colorsel.set_update_policy(UPDATE_CONTINUOUS)
        def delete_event(widget, *event):
            widget.destroy()
        def ok_button_clicked(_button, self=self, win=win):
            c = win.colorsel.get_color()
            win.destroy()
            self.app.opt.tablecolor = color_gtk2tk(c)
            self.game.canvas.config(bg=self.app.opt.tablecolor)
            self.top.config(bg=self.app.opt.tablecolor)
        win.connect("delete_event", delete_event)
        win.ok_button.connect("clicked", ok_button_clicked)
        win.cancel_button.connect("clicked", win.destroy)
        setTransient(win, self.top)
        win.show()


