/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#include <stdio.h>
#include "snipes.h"
#include "coords.h"

/*
 * coords_check_on_screen( screen_coords *sc, coordinate *c )
 * 
 * Check that the position specified by the coordinates in c is
 * on screen.  0=no, 1=yes.
 */ 

int coords_check_on_screen( screen_coords *sc, coordinate c, int p )
{
  FILE *fptr;
  int retval = 1;
  
  /* Check that X coordinate is in the screen's x range */

  if( sc->maze_x1 < sc->maze_x2 ) {
    /* Maze X coordinate wrap-around is off screen. */
    if( c.x < sc->maze_x1 || c.x > sc->maze_x2 )
      retval = 0;
  }
  else
    /* Maze X coordinate wrap-around is on screen. */
    if( c.x < sc->maze_x1 && c.x > sc->maze_x2 )
      retval = 0;
  
  /* Check that Y coordinate is in the screen's y range */

  if( sc->maze_y1 < sc->maze_y2 ) {
    /* Maze Y coordinate wrap-around is off screen. */
    if( c.y < sc->maze_y1 || c.y > sc->maze_y2 )
      retval = 0;
  }
  else
    /* Maze Y coordinate wrap-around is on screen. */
    if( c.y < sc->maze_y1 && c.y > sc->maze_y2 )
      retval = 0;

  if( p ) {
    fptr = fopen( "jeremy.info", "a" );
    fprintf( fptr, "X:(%ld,%ld) Y:(%ld,%ld) c.x=%d c.y=%d ",
	     sc->maze_x1, sc->maze_x2, sc->maze_y1, sc->maze_y2,
	     c.x, c.y );
    fprintf( fptr, "%d\n", retval );
    fclose(fptr);
  }

  return retval;
}


/*
 * coords_to_screen_pos( screen_coords *sc, coordinate *c, coordinate *s )
 * 
 * Convert the coordinates in c to the corresponding screen
 * coordinates.  Result is undefined if the coordinates are
 * not on the screen, so check that first.
 */ 
  
void coords_to_screen_pos( screen_coords *sc, coordinate c, coordinate *s )
{
  if( (c.x - sc->maze_x1) >= 0 )
    /* No X coordinate wrap between left edge of screen and coordinate. */
    s->x = sc->screen_x1 + (c.x - sc->maze_x1);
  else
    /* X coordinate wrap is on screen and coordinate is right of wrap. */
    s->x = sc->screen_x2 + (c.x - sc->maze_x2);
  
  if( (c.y - sc->maze_y1) >= 0 )
    /* No Y coordinate wrap between top edge of screen and coordinate. */
    s->y = sc->screen_y1 + (c.y - sc->maze_y1);
  else
    /* Y coordinate wrap is on screen and coordinate is below wrap. */
    s->y = sc->screen_y2 + (c.y - sc->maze_y2);
}


/*
 *  coords_add_delta( screen_coords *sc, coordinate *c, coordinate delta )
 * 
 * Add the values in delta to the corresponding values in c, adjusting
 * for coordinate wrap as needed.
 */

void coords_add_delta( screen_coords *sc, coordinate *c, coordinate delta )
{
  c->x = (c->x + delta.x + sc->max_x + 1) % (sc->max_x+1);
  c->y = (c->y + delta.y + sc->max_y + 1) % (sc->max_y+1);
}
