#include "lletters.h"

/* prototype std lib functions */
extern int alphasort ();

/* local prototypes */
int file_select (struct direct *entry);

GSList *
lln_dir_list (GSList * file_list, gchar * directory_name, char letter)
{
  int count, i;
  struct direct **files;

  if (directory_name == NULL)
    {
/* Begin change JPV - 1999/03/06 */
      g_print (_("Error getting path\n"));
/* End change JPV - 1999/03/06 */
      return NULL;

    }

  count = scandir (directory_name, &files, file_select, alphasort);

  if (count <= 0)
    {
/* Begin change JPV - 1999/03/06 */
      g_print (_("No files in this directory\n"));
/* End change JPV - 1999/03/06 */
      return NULL;
    }

  for (i = 1; i < count + 1; ++i)
    {
      if (letter == lln_get_1st_letter (files[i - 1]->d_name))
	file_list = g_slist_append (file_list, 
				    g_strdup(files[i - 1]->d_name));
      free(files[i-1]);
    }
  free(files);

  return (file_list);
}
int
file_select (struct direct *entry)
{                               /* ignore . and .. entries */
    if ((strcmp (entry->d_name, ".") == 0) ||
	      (strcmp (entry->d_name, "..") == 0))
	      return (FALSE);
    else
	      return (TRUE);
}

char
lln_get_1st_letter (char *filename)
{
  char letter;

  letter = toupper (filename[0]);
  return (letter);
}

char *
lln_get_word (char *filename)
{
/* Parse the word out of the filename, and
 * format it to Proper Case */

  char *word;
  int len, i;
  word = g_strdup (filename);
  len = strlen (filename);

  word[0] = toupper (word[0]);
  for (i = 0; i < len; i++)
    {
      if (i != 0)
	word[i] = tolower (word[i]);
      if (word[i] == '.')
	word[i] = '\0';
      if (word[i] == '_' || word[i] == '-')
	word[i] = ' ';
    }
  return word;
}

char *
lln_get_number (char *filename)
{
/* Parse the number's caption out of the filename, and
 * format it to Proper Case. We start at the first letter, 
 * because the first character will be a digit. Number files 
 * should have the format 2Two_Apples.xpm. */

  GString *caption;
  char *tmp;
  int len, i;
  
  tmp = g_strdup(filename);
  len = strlen (filename);

  tmp[1] = toupper (tmp[1]);
  for (i = 1; i < len; i++)
    {
      if (i != 1)
	tmp[i] = tolower (tmp[i]);
      if (tmp[i] == '.')
	tmp[i] = '\0';
      if (tmp[i] == '_' || tmp[i] == '-')
	tmp[i] = ' ';
      tmp[i] = tmp[i];
    }
  
  caption = g_string_new(tmp);
  caption = g_string_erase(caption,0,1);
  
  return caption->str;
}

char *
lln_get_file (char letter)
{
  int i = 1, files, random_file;
  char *file;
  GSList *image_files, *tmp;
  gchar *imgdir;
  
  imgdir = g_strconcat (lln_image_dir, NULL);
  
  image_files = lln_dir_list (NULL, imgdir, letter);
  tmp = image_files;

  files = g_slist_length (tmp);
  random_file = lln_get_random ((double) files);
  /*  g_print ("** DEBUG **: files = %d, random_file = %d\n", 
   *     files, random_file);
   */
  if (files == 0)
    {

/* Begin change JPV - 1999/03/06 */
      g_print (_("lln-message:\n"));
      g_print (_("No Matching image files for %c\n\n"), letter);
/* End change JPV - 1999/03/06 */

      return NULL;
    }
  while (i != random_file)
    {
      tmp = tmp->next;
      i++;
    }
  file = g_strdup (tmp->data);
  return file;

}

int
lln_get_random (double max)
{
  int i;
  time_t t1;

  (void) time (&t1);
  /* use time in seconds to set seed */
  srand ((int) t1);

  i = 1 + (int) (max * rand () / (RAND_MAX + 1.0));
  //1+(rand() % max);

  return (i);
}







