/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "../ballistics.h"
#include "../terrain.h"
#include "../aiexterns.h"
#include "../log.h"
#include "mirv.h"

Shellstat_bal wepMIRVGuidance(void* info, struct Projectilepos_bal *prjpos, 
							  Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
															 void** explosioninfo), 
							  void **explosioninfo)
{
	Weapon_wep *bs;
	struct Projectilelist_bal *prj;
	Shellstat_bal res;
	int ix, iy;
	Player_pl *plhit;
	
    prjpos->ox=prjpos->x;
    prjpos->oy=prjpos->y;          
    prjpos->x+=prjpos->vx;
    prjpos->y+=prjpos->vy;
    prjpos->vy-=bal_grav/bal_lerp_tweak;
   
    if((res=balEnvironmentAdjustProjPos(prjpos))!=FLYING
	   || balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy))
    {
		if(plLookupPlayer(prjpos->id)) 
		{
			logPrintf(DEBUG, "Intersection at (%i, %i) of %s's shot\n", ix, iy,
					  plLookupPlayer(prjpos->id)->name);
		}
		else 
		{
			logPrintf(DEBUG, "Intersection at (%i, %i) of null's shot\n", ix, iy);
		}
		if(plhit!=NULL) logPrintf(DEBUG, "and hit %s\n", plhit->name);
		switch(res) 
		{
		case HOLDING:
			/* wtf ??? */
			break;
		case FLYING:
			prjpos->x=ix;
			prjpos->y=iy;
			/* fall through */
		case EXPLODING:
			return initexplosion(prjpos, explosioninfo);
			break;
		case FREEING:
			return FREEING;
			break;
		}
    }

	if(prjpos->vy>0 && 
	   prjpos->vy - (bal_grav/bal_lerp_tweak) < 0) 
	{
		bs=wepLookupWeapon("Basic Shell");
		prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx, prjpos->vy, bs);
		prj->stat=INITSHOT(prj);
		prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx+5, prjpos->vy, bs);
		prj->stat=INITSHOT(prj);
		prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx+10, prjpos->vy, bs);
		prj->stat=INITSHOT(prj);
		prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx-5, prjpos->vy, bs);
		prj->stat=INITSHOT(prj);
		prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx-10, prjpos->vy, bs);
		prj->stat=INITSHOT(prj);
		return initexplosion(prjpos, explosioninfo);
	}	
	return FLYING;
}
