#ifndef main_gameitems_h
#define main_gameitems_h

#include "membertable.h"
#include <stdlib.h>

struct LevelOptions
{
 int fruitSkill;
 int ghostEyesSpeed;
 int pelletScore;
 char* fruitAset;
 char* ghostAset;
 char* filename;
 int ghostCantHide;
 int ghostSpeed;
 int playerEatingPause;
 int fruitSpeed;
 int fruitChance;
 int fruit;
 int dotScore;
 int ghostScaredSpeed;
 int ghostScore;
 char* hatmanAset;
 int fruitScore;
 int playerSlowSpeed;
 int ghostSkill;
 char* background;
 int ghostScaredTime;
 int mouthDelay;
 int playerSpeed;
};

#ifdef main_gameitems_c
struct MemberTable levelOptionsMembers[] =
{
 { mt_int, "fruitSkill", &(((struct LevelOptions*)0)->fruitSkill) },
 { mt_int, "ghostEyesSpeed", &(((struct LevelOptions*)0)->ghostEyesSpeed) },
 { mt_int, "pelletScore", &(((struct LevelOptions*)0)->pelletScore) },
 { mt_str, "fruitAset", &(((struct LevelOptions*)0)->fruitAset) },
 { mt_str, "ghostAset", &(((struct LevelOptions*)0)->ghostAset) },
 { mt_str, "filename", &(((struct LevelOptions*)0)->filename) },
 { mt_int, "ghostCantHide", &(((struct LevelOptions*)0)->ghostCantHide) },
 { mt_int, "ghostSpeed", &(((struct LevelOptions*)0)->ghostSpeed) },
 { mt_int, "playerEatingPause", &(((struct LevelOptions*)0)->playerEatingPause) },
 { mt_int, "fruitSpeed", &(((struct LevelOptions*)0)->fruitSpeed) },
 { mt_int, "fruitChance", &(((struct LevelOptions*)0)->fruitChance) },
 { mt_int, "fruit", &(((struct LevelOptions*)0)->fruit) },
 { mt_int, "dotScore", &(((struct LevelOptions*)0)->dotScore) },
 { mt_int, "ghostScaredSpeed", &(((struct LevelOptions*)0)->ghostScaredSpeed) },
 { mt_int, "ghostScore", &(((struct LevelOptions*)0)->ghostScore) },
 { mt_str, "hatmanAset", &(((struct LevelOptions*)0)->hatmanAset) },
 { mt_int, "fruitScore", &(((struct LevelOptions*)0)->fruitScore) },
 { mt_int, "playerSlowSpeed", &(((struct LevelOptions*)0)->playerSlowSpeed) },
 { mt_int, "ghostSkill", &(((struct LevelOptions*)0)->ghostSkill) },
 { mt_str, "background", &(((struct LevelOptions*)0)->background) },
 { mt_int, "ghostScaredTime", &(((struct LevelOptions*)0)->ghostScaredTime) },
 { mt_int, "mouthDelay", &(((struct LevelOptions*)0)->mouthDelay) },
 { mt_int, "playerSpeed", &(((struct LevelOptions*)0)->playerSpeed) },
 { mt_end, NULL, NULL }
};
struct LevelOptions levelOptionsDefaultStruct =
{
 128,
 1200,
 100,
 "graphics/fruit.aset.gz",
 "graphics/ghost.aset",
 "",
 0,
 350,
 50,
 250,
 100000,
 0,
 10,
 200,
 100,
 "graphics/hatman.aset",
 100,
 350,
 128,
 "backgrounds/hatman.spr.gz",
 10000,
 50,
 400,
};
struct LevelOptions* levelOptionsDefault = &levelOptionsDefaultStruct;
#else
# ifdef __cplusplus
extern "C" MemberTable levelOptionsMembers[];
extern "C" LevelOptions* levelOptionsDefault;
# else
extern struct MemberTable levelOptionsMembers[];
extern struct LevelOptions* levelOptionsDefault;
# endif
#endif

struct CutsceneOptions
{
 char* filename;
};

#ifdef main_gameitems_c
struct MemberTable cutsceneOptionsMembers[] =
{
 { mt_str, "filename", &(((struct CutsceneOptions*)0)->filename) },
 { mt_end, NULL, NULL }
};
struct CutsceneOptions cutsceneOptionsDefaultStruct =
{
 "",
};
struct CutsceneOptions* cutsceneOptionsDefault = &cutsceneOptionsDefaultStruct;
#else
# ifdef __cplusplus
extern "C" MemberTable cutsceneOptionsMembers[];
extern "C" CutsceneOptions* cutsceneOptionsDefault;
# else
extern struct MemberTable cutsceneOptionsMembers[];
extern struct CutsceneOptions* cutsceneOptionsDefault;
# endif
#endif

struct GameOptions
{
 char* scores;
};

#ifdef main_gameitems_c
struct MemberTable gameOptionsMembers[] =
{
 { mt_str, "scores", &(((struct GameOptions*)0)->scores) },
 { mt_end, NULL, NULL }
};
struct GameOptions gameOptionsDefaultStruct =
{
 "",
};
struct GameOptions* gameOptionsDefault = &gameOptionsDefaultStruct;
#else
# ifdef __cplusplus
extern "C" MemberTable gameOptionsMembers[];
extern "C" GameOptions* gameOptionsDefault;
# else
extern struct MemberTable gameOptionsMembers[];
extern struct GameOptions* gameOptionsDefault;
# endif
#endif

#endif
