#ifndef _TUBE_H_
#define _TUBE_H_

#include "element.h"

class Ball;

class Tube : public Element {
public:
   typedef enum {Right, Left} Direction;
   Tube(Tube::Direction direction);
   void ConnectLeft(Element* element);
   void ConnectTop(Element* element);
   void ConnectRight(Element* element);
   void ConnectBottom(Element* element);
   void ToggleDirection();
   void MoveBall(Ball* ball);
   Element* GetStart();
   Element* GetEnd();
private:
   Element* _start;
   Element* _end;
   Direction _direction;
};

#endif // _TUBE_H_
