/* Groundhog -- a simple logic game
 * Copyright (C) 1998-1999 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ball.h"
#include "element.h"

Ball::Ball(Ball::Color color) : _element(0), _direction(Ball::NotMoving), 
   _color(color)
{
}

void
Ball::Move()
{
   _element->MoveBall(this);
}

void
Ball::SetElement(Element* element)
{
   _element = element;
}

Ball::Color
Ball::GetColor()
{
   return _color;
}

void
Ball::SetDirection(Ball::Direction direction)
{
   _direction = direction;
}

Ball::Direction
Ball::GetDirection()
{
   return _direction;
}

bool
SetOffBalls::Move()
{
   bool one_has_moved = false;
   for (list<Ball*>::iterator i = _set.begin(); i != _set.end(); i++) {
      Ball* ball = *i;
      if (ball->GetDirection() != Ball::NotMoving) {
	 ball->Move();
	 one_has_moved = true;
      }
   }
   return one_has_moved;
}

