/* 
 * Copyright (C) 1999 Peter Zelezny
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gnome.h>
#include <string.h>
#include <ctype.h>
#include "zvt.h"

int colconv[] =
{7, 0, 4, 2, 1, 3, 5, 3, 3 + 10, 2 + 10, 6, 6 + 10, 4 + 10, 5 + 10, 10 + 0, 0};

void zvt_print_raw_text(GtkWidget *widget, unsigned char *text) {
   char num[8];
   int reverse = 0, under = 0, bold = 0,
       comma, k, i = 0, j = 0, len = strlen (text);
   unsigned char *newtext = malloc (len + 1024);

   while (i < len) {
      switch (text[i]) {
      case 3:
         i++;
         if (!isdigit (text[i])) {
            newtext[j] = 27;
            j++;
            newtext[j] = '[';
            j++;
            newtext[j] = '0';
            j++;
            newtext[j] = 'm';
            j++;
            i--;
            goto jump2;
         }
         k = 0;
         comma = FALSE;
         while (i < len)
         {
            if (text[i] >= '0' && text[i] <= '9' && k < 2)
            {
               num[k] = text[i];
               k++;
            } else
            {
               int col, mirc;
               num[k] = 0;
               newtext[j] = 27;
               j++;
               newtext[j] = '[';
               j++;
               if (k == 0)
               {
                  newtext[j] = '0';
                  j++;
                  newtext[j] = 'm';
                  j++;
               } else
               {
                  if (comma)
                     col = 40;
                  else
                     col = 30;
                  mirc = atoi (num);
                  mirc = colconv[mirc];
                  if (mirc > 9)
                  {
                     mirc -= 10;
                     sprintf ((char *) &newtext[j], "1;%dm", mirc + col);
                  } else
                  {
                     sprintf ((char *) &newtext[j], "0;%dm", mirc + col);
                  }
                  j = strlen (newtext);
               }
               switch (text[i])
               {
               case ',':
                  comma = TRUE;
                  break;
               default:
                  goto jump;
               }
               k = 0;
            }
            i++;
         }
         break;
      case '\026':             /* REVERSE */
         if (reverse)
         {
            reverse = FALSE;
            strcpy (&newtext[j], "\033[27m");
         } else
         {
            reverse = TRUE;
            strcpy (&newtext[j], "\033[7m");
         }
         j = strlen (newtext);
         break;
      case '\037':             /* underline */
         if (under)
         {
            under = FALSE;
            strcpy (&newtext[j], "\033[24m");
         } else
         {
            under = TRUE;
            strcpy (&newtext[j], "\033[4m");
         }
         j = strlen (newtext);
         break;
      case '\002':             /* bold */
         if (bold)
         {
            bold = FALSE;
            strcpy (&newtext[j], "\033[22m");
         } else
         {
            bold = TRUE;
            strcpy (&newtext[j], "\033[1m");
         }
         j = strlen (newtext);
         break;
      case '\007':
            newtext[j] = text[i];
            j++;
	    break;
      case '\017':             /* reset all */
         strcpy (&newtext[j], "\033[0m");
         j = strlen (newtext);
         reverse = FALSE;
         bold = FALSE;
         under = FALSE;
         break;
      case '\n':
         newtext[j] = '\r';
         j++;
      default:
         newtext[j] = text[i];
         j++;
      }
    jump2:
      i++;
    jump:
   }
   newtext[j] = 0;
   zvt_term_feed ((ZvtTerm *) widget, newtext, j);
   free (newtext);
}

void zvt_clear (GtkWidget * widget){
   zvt_term_set_scrollback ((ZvtTerm *) widget, 0);
   zvt_term_set_scrollback ((ZvtTerm *) widget, 5);
   zvt_term_feed ((ZvtTerm *) widget, "\e[2J\e[1H", 8);
}
