#ifndef IIRSCRAM_DECLARATION_HH
#define IIRSCRAM_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Swaminathan Subramanian     ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Declaration.hh,v 1.4 1999/06/09 00:45:51 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_Declaration.hh"
#include "IRBasicDataTypes.hh"
#include "savant.hh"

class IIR_AttributeSpecification;
class IIR_AttributeSpecificationList;
class ostream;
class IIR_Declaration;
class IIR_List;
class IIR_PortList;
class IIR_GenericList;
class IIR_Name;
class IIR_Attribute;

template <class type> class set;

#define numSignalAttributes 10

class IIRScram_Declaration : public IIRBase_Declaration {
public:
  virtual void _publish_vhdl(ostream &);
  virtual void _publish_vhdl_decl(ostream &);

  void _publish_cc_declarator();
  virtual void _publish_cc_declarative_region();
  virtual void _publish_cc_constructor_args();
  virtual void _publish_cc_sigdest();
  virtual void _publish_cc_decl();
  virtual void _publish_cc_init_signal();
  virtual void _publish_cc_init_function();
  virtual void _publish_cc_locatesignal();
  virtual void _publish_cc_value();
  virtual void _publish_cc_name();
  virtual void _publish_cc_state_object_init();
  virtual void _publish_cc_constant_object_init();
  virtual void _publish_cc_implicit_signal_type();
  virtual void _publish_cc_binding_name(ostream& outstream = _cc_out);
  virtual void _publish_cc_implicit_signal_attributes();
  virtual void _publish_cc_implicit_state_objects_init();
  virtual void _publish_cc_decl_with_constructor_args();
  virtual void _publish_cc_type_info();
  virtual void _publish_cc_extern_type_info();
  virtual void _publish_cc_implicit_signal_attributes_copying();
  virtual void _publish_cc_implicit_signal_attributes_read_or_write(const char *functionName, const char *streamName);
  virtual void _publish_cc_necessary_copying();
  virtual void _publish_cc_read_or_write(const char *functionName,
					 const char *streamName);
  
  IIR_Boolean _is_iir_declaration() { return TRUE; }
  virtual IIR_Boolean _is_resolved() { return TRUE; }
  virtual IIR_Boolean _is_overloadable() { return FALSE; }
  virtual IIR_Boolean _is_specification() { return FALSE; }
  // This method tells us if a declaration is a an IIR_TypeDeclaration or
  // IIR_SubtypeDeclaration.
  virtual IIR_Boolean _is_type() { return FALSE; }
  virtual IIR_Boolean _is_access_type() { return FALSE; }
  virtual IIR_Boolean _is_file() { return FALSE; }
  virtual IIR_Boolean _is_read_file() { return FALSE; }
  virtual IIR_Boolean _is_write_file() { return FALSE; }
  virtual IIR_Boolean _is_object() { return FALSE; }
  virtual IIR_Boolean _is_enumeration_literal() { return FALSE; }
  virtual IIR_Boolean _is_signal() { return FALSE; }
  virtual IIR_Boolean _is_element() { return FALSE; }
  virtual IIR_Boolean _is_signal_in_outerscope();

  virtual IIR_Boolean _contains_body(){ return FALSE; }

  // This method returns TRUE if this declaration is a homograph of the one
  // passed in, and FALSE otherwise.
  virtual IIR_Boolean _is_homograph_of( IIR_Declaration * );
  
  // There are special circumstances that two declarations that _are_
  // homographs can be in the same region.  For instance, a subprogram
  // declaration and a subprogram body, or an incomplete type declaration
  // and it's complete type.  These are mainly due to implentation issues
  // and AIRE specific quirks.  The following method tells us if these
  // two homographs can be in the same region or not.
  virtual IIR_Boolean _can_be_in_same_region( IIR_Declaration * ){ return FALSE; }

  virtual IIR_Boolean _is_textio();
  virtual IIR_Boolean _is_standard();

  virtual IIR_Boolean _is_composite_resolved_signal();
  virtual IIR_Boolean _is_implicit_operator(){ return FALSE; }

  // Tells us if this is a scalar type - or an object of a scalar type.
  virtual IIR_Boolean _is_scalar_type() { return FALSE; }
  // Tells us if this is a array type - or an object of a array type.
  virtual IIR_Boolean _is_array_type() { return FALSE; }
  virtual IIR_Boolean _is_physical_type();
  virtual IIR_Boolean _is_enumeration_type();

  // An implicit declaration is one that exists, but doesn't appear in the
  // source. The two basic cases that this occurs in are declarations that
  // represent the values of attributes, and implicit operators that go
  // with their types.
  virtual IIR_Boolean _is_implicit_declaration(){ return _implicit_flag; }
  void _set_is_implicit( IIR_Boolean new_flag ){ _implicit_flag = new_flag; }

  // Sometimes implicit declarations need to be visible in the symbol table
  // and sometimes they should.  deallocate( foo : some_access_type )
  // should be visible.  foo'quiet will create "foo_quiet" which definitely
  // shouldn't.
  IIR_Boolean _is_visible(){ return _visible_flag; }
  void _set_is_visible( IIR_Boolean new_flag ){ _visible_flag = new_flag; }

  virtual IIR_Boolean _is_resolved_signal();
  
  virtual IIR_Boolean _is_incomplete_type_declaration(){ return FALSE; }
  virtual IIR_Boolean _designates_incomplete_type(){ return FALSE; }

  virtual IIR_Boolean _have_added_driver() {
    return FALSE;
  }
  virtual void _set_driver_addition_flag(IIR_Boolean);

  virtual IIR_PortList *_get_port_list(){ return NULL; }
  virtual IIR_GenericList *_get_generic_list(){ return NULL; }
  virtual IIR_DesignatorList *_get_instantiation_list();
  // This method returns a pointer to a string holding the "type" of the
  // declaration.  For instance, an entity declaration would return
  // "entity", a variable declaration "variable", and so forth.
  virtual char * _get_type_string() { return "(unknown)"; }
  virtual IIR_TextLiteral *_get_declarator();
  
  // This method looks in the declaration's declarative region for the
  // declaration named by "look_for"
  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * ){
    return NULL;
  }
  
  // (See IIRScram.hh for a description of this method.)
  IIR_Declaration *_find_formal_declaration(){
    return (IIR_Declaration *)this;
  }

  // This method looks in the declaration's declarative region for
  // the declaration named by "look_for"
  virtual set<IIR_Declaration> *_find_declarations( IIR_TextLiteral *look_for ){
    _report_undefined_scram_fn("_find_declarations( IIR_TextLiteral *)");
    return NULL;
  }

  IIR_Boolean _is_published_attribute_in_constructor(SignalAttribute);
  void _add_published_attribute_in_constructor(SignalAttribute);

  IIR_Boolean _is_published_attribute_in_state(SignalAttribute);
  void _add_published_attribute_in_state(SignalAttribute);

  IIR_Boolean _is_published_attribute_in_initstate(SignalAttribute);
  void _add_published_attribute_in_initstate(SignalAttribute);

  // This enumeration defines all of the types of declarations.  The
  // enumeration LAST_TYPE is so that we can get the number of elements
  // in the enumeration easily.  This is needed in the symbol_table.
  enum declaration_type { ERROR = 0, UNDEFINED, VARIABLE, SHARED_VARIABLE,
			  TYPE, SUBTYPE,
                          SIGNAL, PROCEDURE, INTERFACE, FUNCTION,
                          S_FILE, ENTITY, CONSTANT, CONFIGURATION, COMPONENT,
                          ATTRIBUTE, ALIAS, ARCHITECTURE, PACKAGE,
                          PACKAGE_BODY, INTERFACE_VARIABLE, INTERFACE_SIGNAL,
                          INTERFACE_CONSTANT, INTERFACE_FILE, LABEL,
			  LITERAL, UNITS, GROUP, GROUP_TEMPLATE, LIBRARY, ELEMENT,
			  LAST_DECLARATION_TYPE };

  virtual declaration_type _get_type();
  void _type_check( set<IIR_TypeDefinition> * ){}

  // Get the attribute specification correspoiding to the attribute
  // declaration passed as argument.  This is required by UserAttribute to
  // get it's attribute specification.  User attribute calls this method
  // on it's prefix to get it's attribute spec.
  IIR_AttributeSpecification* _get_attribute_specification(IIR*);

  // This method checks to see if the type of argument "arg_num" matches
  // that passed in and returns a boolean.
  virtual bool _check_param( IIR_TypeDefinition *decl, int arg_num );

  // This seems unnecessary, but it gets called when a symbol has already
  // been resolved and something else in the same statement is getting
  // resolved..
  set<IIR_Declaration> *_symbol_lookup();
  set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> * );

  virtual IIR_Declaration *_get_prefix_declaration();

  void _publish_cc_anonymous_addChild();
  void _publish_cc_addChild();
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);

  virtual void _get_headers(set<IIR>&);

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean(IIR::*constraint_function)()=0);
  IIR *_decl_to_decl( IIR_Declaration * );

  // Since an implicit declaration has its prefix a signal declaration
  // This function extracts that declaration from the implied declaration.
  // It returns NULL if this isn't an implicit declaration.
  virtual IIR_Declaration* _get_signal_decl();
  void _clear();


  // This method returns the element subtype of an array for the index
  // passed in.  If the array is multidimensional, the returned subtype
  // will be another array type definition.  If the number passed in is
  // higher than the number of indexes of the array, or if the object
  // the method is called on isn't an array, the return value is NULL.
  virtual IIR_TypeDefinition *_get_type_of_element( int );

  virtual IIR_TypeDefinition *_get_type_of_param( int );

  // This returns the dimension of an array type.  It returns "0" if
  // the declaration isn't for an array object..
  virtual IIR_Int32 _get_num_indexes();

  // This returns how many arguments are required by a subprogram
  // declaration.  "0" is returned for non-subprograms.
  virtual IIR_Int32 _num_required_args();

  // This is the method that "object declarations" have defined in the
  // spec to return their type.  It turns out to be convenient to have
  // this virtual here, and seems to not be violating the spec to 
  // have it visible here.
  virtual IIR_TypeDefinition *_get_subtype(){ return NULL; }

  virtual IIR_TypeDefinition *_get_name_type();

  virtual ostream & _print( ostream & );
  
  // This array contains the enum of all the attributes of "this" signal
  // for which code generation has been done.
  IIR_Boolean *implemented_attributes_in_constructor;
  IIR_Boolean *implemented_attributes_in_state;
  IIR_Boolean *implemented_attributes_in_initstate;

  IIR_TextLiteral *_get_prefix_string();

  IIR *_clone();
  void _clone(IIR*);
#ifdef PROCESS_COMBINATION
  void _static_elaborate_decl(char *);
#endif

  // These methods are referring to the region that this declaration is IN.
  IIR *_get_declarative_region();
  void _set_declarative_region( IIR * );

  // This method will add the set to this declaration's declarative region.
  virtual void _add_to_declarative_region( set<IIR_Declaration> * );
  void _add_to_declarative_region( IIR_DeclarationList &, set<IIR_Declaration> * );


  //The following function returns true if the declaration is in the 
  //process statement's declarative part
  IIR_Boolean _in_process_statement();

  void _build_sensitivity_list(IIR_DesignatorList *sensitivity_list);

  //The following function adds the object and interface declarations that 
  //appear as initialization objects in declarations
  virtual void _add_declarations_in_initializations();
  virtual void _add_decl_into_cgen_symbol_table();

  // This method adds this declaration, adds it to the symbol table,
  // and opens a new scope
  void _add_declaration_and_open_scope( );

  // This method simply adds this declaration to the symbol table
  void _add_declaration();
  void _close_scope();
  virtual void _make_interface_visible( symbol_table *sym_tab = NULL );

  //An implicit signal declaration's prefix is a signal; this function
  //returns the implicit signal declaration's prefix.  This is not an
  //equivalent of _get_signal_decl().  This is only is used in the code
  //generation phase.
  virtual IIR_Declaration* _get_signal_prefix();

  // Since we can now have implicit declarations due to attributes,
  // we need to be able to tell if THIS declaration is the result
  // of an attribute.
  IIR_Attribute *_get_attribute_name();
  void _set_attribute_name( IIR_Attribute * );
  IIR_Declaration* _get_implicit_declaration_for_attribute ( IIR_Attribute *findAttrib );
  
  // There is a set of implicit declarations associated with some
  // declarations.  For instance, type declarations defining a file type
  // implictly declare "read" and "write" procedures.  These methods are
  // used to access the set of implicit declarations.  If there are none
  // associated with this declaration, this method will return NULL.
  set<IIR_Declaration> *_get_implicit_declarations();
  void _set_implicit_declarations( set<IIR_Declaration> * );

  virtual const IIR_Char* _get_mangling_prefix();
  IIR_Identifier* _get_mangled_declarator();
  void _set_mangled_declarator(char *);
  virtual void _mangle_declarator();

  void _set_scoping_prefix();
  void _reset_scoping_prefix();
  
protected:
  IIRScram_Declaration();
  virtual ~IIRScram_Declaration() = 0;

private:
  IIR_Boolean _visible_flag;
  IIR_Boolean _implicit_flag;

  IIR_Attribute *attribute_name;

  IIR *declarative_region;

  IIR_Identifier *mangledDeclarator;

  // This is the set of implicit declarations associated with this declaration.
  // For instance, type declarations for new file types
  set<IIR_Declaration> *implicit_declarations;
};
#endif

