// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ComponentInstantiationStatement.cc,v 1.12 1999/10/26 16:44:40 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_ComponentInstantiationStatement.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_Identifier.hh"
#include "IIR_IndexedName.hh"
#include "IIR_SelectedName.hh"
#include "IIR_Label.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_SubprogramDeclaration.hh"
#include "IIR_SimpleName.hh"
#include "error_func.hh"
#include "set.hh"
#include "library_manager.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_ComponentConfiguration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_DesignatorExplicit.hh"

extern bool parse_error;

void 
IIRScram_ComponentInstantiationStatement::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT( get_instantiated_unit() != NULL );
  
  get_label()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";

  if (get_instantiated_unit()->_is_entity_decl() == TRUE) {
    _vhdl_out << "entity ";
  }
  if (get_instantiated_unit()->_is_configuration_decl() == TRUE) {
    _vhdl_out << "configuration ";
  }
  if (get_instantiated_unit()->_is_component_decl() == TRUE) {
    _vhdl_out << "component ";
  }
  
  get_instantiated_unit()->_publish_vhdl(_vhdl_out);
  if(generic_map_aspect.num_elements() != 0) {
    _vhdl_out << " generic map ( ";
    generic_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";    
  }
  if(port_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n port map ( ";
    port_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  _vhdl_out << ";\n";
}


IIRScram_ComponentInstantiationStatement::
IIRScram_ComponentInstantiationStatement(){
  my_instantiation_type = IIR_COMPONENT_DECLARATION;
  my_configuration = NULL;
}


IIRScram_ComponentInstantiationStatement::
~IIRScram_ComponentInstantiationStatement(){}


void 
IIRScram_ComponentInstantiationStatement::
_set_instantiation_type( IIR_Kind instantiation_type ){
  my_instantiation_type = instantiation_type;
}


IIR_TypeDefinition * 
IIRScram_ComponentInstantiationStatement::_get_port_type( int port_num ){
  return get_instantiated_unit()->_get_port_type( port_num );
}


IIR_Kind 
IIRScram_ComponentInstantiationStatement::_get_instantiation_type(){
  return my_instantiation_type;
}

void 
IIRScram_ComponentInstantiationStatement::_type_check_instantiated_unit(){
  set<IIR_Declaration> *instantiated_unit_decls = NULL;
  IIR_IndexedName *as_indexed_name = NULL;
  
  ASSERT( get_instantiated_unit() != NULL );
  
  IIR *entity_name = NULL;
  IIR *arch_name = NULL;
  IIR_EntityDeclaration *entity_decl = NULL;  
  IIR_ArchitectureDeclaration *arch_decl = NULL;
  
  switch( _get_instantiation_type() ){
  case IIR_ENTITY_DECLARATION:{
    if( get_instantiated_unit()->get_kind() == IIR_INDEXED_NAME ){
      // The prefix of the indexed name is the entity.  The suffix is 
      // the architecture.
      as_indexed_name = (IIR_IndexedName *)get_instantiated_unit();
      entity_name = as_indexed_name->get_prefix();
      arch_name = as_indexed_name->get_suffix();
      
      ASSERT( entity_name->_is_iir_name() == TRUE );
      entity_decl = _get_library_manager()->_lookup_entity( TRUE, (IIR_Name *)entity_name );
      
      if( entity_decl == NULL ){
	return;
      }
      
      ASSERT( arch_name->_is_iir_name() == TRUE );
      arch_decl = _get_library_manager()->_lookup_architecture( TRUE,
								entity_decl,
								(IIR_Name *)arch_name );
    
      as_indexed_name->set_prefix( entity_name->_decl_to_decl( entity_decl ) );
      as_indexed_name->set_suffix( arch_name->_decl_to_decl( arch_decl ) );

      ASSERT( as_indexed_name->_is_resolved() == TRUE );
    }
    else{
      entity_name = get_instantiated_unit();
      ASSERT( entity_name->_is_iir_name() == TRUE );
      entity_decl = _get_library_manager()->_lookup_entity( TRUE, (IIR_Name *)entity_name );
      
      if( entity_decl == NULL ){
	return;
      }
      
      set_instantiated_unit( get_instantiated_unit()->_decl_to_decl( entity_decl ) );
    }

    break;
  }
  case IIR_COMPONENT_DECLARATION:{
    instantiated_unit_decls=get_instantiated_unit()->_symbol_lookup(&IIR::_is_iir_component_declaration);
    if( instantiated_unit_decls == NULL ){
      report_undefined_symbol( get_instantiated_unit() );
    }

    // This needs to get pushed into a separate method.
    switch( instantiated_unit_decls->num_elements() ){
    case 0:{
      ostrstream err;
      err << "|" << *get_instantiated_unit() << "| was not declared as a";
    
      switch( _get_instantiation_type() ){
      case IIR_ENTITY_DECLARATION:
	err << "n entity";
	break;
      case IIR_COMPONENT_DECLARATION:
	err << " component";
	break;
      case IIR_CONFIGURATION_DECLARATION:
	err << " configuration";
	break;
      default:
	err << " (unknown type)";
      }
      err << " in this scope." << ends;
    
      report_error( this, err );
      break;
    }
    case 1:{
      IIR_Declaration *instantiated_decl = instantiated_unit_decls->get_element();
      set_instantiated_unit( get_instantiated_unit()->_decl_to_decl( instantiated_decl ) );

      break;
    }
    default:{
      report_ambiguous_error( get_instantiated_unit(), instantiated_unit_decls );
    }
    }

    delete instantiated_unit_decls;
 
    break;
  }
  case IIR_CONFIGURATION_DECLARATION:
    cerr << "IIRScram_ComponentInstantiationStatement::_type_check() :ERROR " 
	 << "\n - configurations in instantiation stmt not handled yet\n";
    break;
  default:
    cerr << "IIRScram_ComponentInstantiationStatement::_type_check() :ERROR " 
	 << "\n - Illegal declaration type\n";
    break;
  }
}

void 
IIRScram_ComponentInstantiationStatement::_type_check(){
  // So, the instantiated unit should be resolved, unless there was an error.
  if( get_instantiated_unit()->_is_resolved() == TRUE ){

    // All that's left is to resolved the map.  To do this, we need to have
    // our configuration information available.  That should have happened in
    // a second pass, when _type_check_configuration_specifications() ran on
    // our declarative region.
    if( _get_configuration() != NULL ){
      
      if( get_instantiated_unit()->_is_resolved() == TRUE && 
	  _get_configuration()->_get_entity_aspect() != NULL ){
	
	// The locals are in "get_instantiated_unit()->_get_generic_list()"
	generic_map_aspect._resolve_and_order( get_instantiated_unit()->_get_generic_list(), 0 );
	// The locals are in "get_instantiated_unit()->_get_port_list()"
	port_map_aspect._resolve_and_order( get_instantiated_unit()->_get_port_list(), 0 );
      }
    }
    else{
      // No configuration - we'll resolve with no map to associate to.
      generic_map_aspect._resolve_and_order( get_instantiated_unit()->_get_generic_list(), 
					     NULL );
      port_map_aspect._resolve_and_order( get_instantiated_unit()->_get_port_list(), 
					  NULL );

    }
  }
}

void
IIRScram_ComponentInstantiationStatement::_publish_cc_binding_name(ostream& outstream) {
  ASSERT(get_instantiated_unit() != NULL);
  this->get_instantiated_unit()->_publish_cc_binding_name(outstream);
}

void
IIRScram_ComponentInstantiationStatement::_publish_createNetInfo() {
  ASSERT(get_instantiated_unit()->_is_iir_declaration());
  
  IIR_Declaration* decl = (IIR_Declaration *) get_instantiated_unit();
  IIR_AssociationElement* actual_clause = NULL;
  IIR* formal = NULL;
  IIR_Label *label = _get_label();

  if(decl->get_kind() == IIR_COMPONENT_DECLARATION) {
    actual_clause = port_map_aspect.first();
    if(actual_clause == NULL){
      return;
    }
    label->_publish_cc_elaborate();

    if (_get_currently_publishing_unit() == GENERATE_FOR) {
      _cc_out << "_elab_obj[i - generateLeft].getBoundEntityInfo();\n";
    }
    else {
      _cc_out << "_elab_obj->getBoundEntityInfo();\n";
    }
    
    while(actual_clause != NULL) {
      formal = actual_clause->get_formal();
      
      if (actual_clause->_get_actual() == NULL) {
	// This could be an open oprt. So flag an error and bail out
	cerr << "Warning - IIRScram_ComponentInstantiationStatement::"
	     << "_publish_createNetInfo() - open ports have not yet been"
	     << " handled.\n";
      }
      
      if (formal != NULL) {
	ASSERT(formal->_is_resolved() == TRUE);
	ASSERT(actual_clause->_get_actual() != NULL);
	
	switch(formal->_get_mode()) {
	case IIR_IN_MODE:
	  _publish_cc_elaborate_Add(actual_clause, label);
	  if (actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL)
	    _publish_cc_elaborate_UpType(actual_clause,label);
	  break;
	case IIR_OUT_MODE:
	  // Code for adding the resolution information tree
	  _publish_cc_elaborate_addChild(actual_clause, label);
	  if (formal->get_kind() == IIR_FUNCTION_CALL)
	    _publish_cc_elaborate_UpType(actual_clause, label);
	  break;
	case IIR_INOUT_MODE:
	  _publish_cc_elaborate_Add(actual_clause, label);
	  // Code for adding the resolution information tree
	  _publish_cc_elaborate_addChild(actual_clause, label);
	  if (formal->get_kind() == IIR_FUNCTION_CALL)
	    _publish_cc_elaborate_UpType(actual_clause,label);
	  break;
	default:
	  cerr << "Buffer and linkage mode not yet supported in "
	       << "Component instantiation statements\n";
	  break;
	}
      }
      actual_clause = port_map_aspect.successor(actual_clause);
    }
  }
}


void 
IIRScram_ComponentInstantiationStatement::
_publish_cc_elaborate_Add(IIR_AssociationElement *actual_clause,
			  IIR_Label *label) {
  IIR* decl = actual_clause->get_formal();
  IIR_FunctionCall *upTypeConversionFn = NULL;
  IIR_FunctionCall *downTypeConversionFn = NULL;
  IIR_Declaration* tempDeclaration = NULL;
  
  if ((actual_clause->_get_actual() != NULL) &&
      (actual_clause->_get_actual()->get_kind() != IIR_FUNCTION_CALL) &&
      (actual_clause->get_formal()->get_kind() != IIR_FUNCTION_CALL)) {
    _cc_out << "Add(";
    ASSERT(actual_clause->_get_actual() != NULL);
    if(actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL) {
      downTypeConversionFn = (IIR_FunctionCall *)actual_clause->_get_actual();
      downTypeConversionFn->_publish_cc_elaborate_arg();
    } else {
      if(actual_clause->_get_actual()->_is_iir_declaration() == TRUE) {
	ASSERT ( actual_clause->_get_actual()->_is_iir_declaration() == TRUE );
	tempDeclaration = (IIR_Declaration *) actual_clause->_get_actual();
	
	ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
	_publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this);
      }
      else if(actual_clause->_get_actual()->_is_name() == TRUE) {
	tempDeclaration = (IIR_Declaration *) actual_clause->_get_actual()->_get_prefix_declaration();
	ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
	_publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this);
      }
      else {
	cerr << "Error : IIRScram_ComponentInstantiationStatement::_publish_cc_elaborate_addChild() - declaration kind not handled yet.\n";
      }
      actual_clause->_get_actual()->_publish_cc_elaborate();
    }
    
    _cc_out << ", ";
    label->_publish_cc_elaborate();
    
    if (_get_currently_publishing_unit() == GENERATE_FOR) {
      _cc_out << "_elab_obj[i - generateLeft].";
    }
    else {
      _cc_out << "_elab_obj->";
    }
    
    if(decl->get_kind() == IIR_FUNCTION_CALL) {
      upTypeConversionFn = (IIR_FunctionCall *)decl;
      upTypeConversionFn->_publish_cc_elaborate_arg();
    } else {
      decl->_publish_cc_elaborate();
    }    
    _cc_out << ");\n";
    
    if(upTypeConversionFn != NULL) {
      _cc_out << "setUpConversionFunctionId(";
      label->_publish_cc_elaborate();
      
      if (_get_currently_publishing_unit() == GENERATE_FOR) {
	_cc_out << "_elab_obj[i - generateLeft].";
      }
      else {
	_cc_out << "_elab_obj->";
      }
      
      upTypeConversionFn->_publish_cc_elaborate_arg();
      _cc_out << ", ";
      upTypeConversionFn->get_implementation()->_publish_cc_type_conversion_function_name();
      _cc_out << ");\n";
    }
  }
}


void 
IIRScram_ComponentInstantiationStatement::
_publish_cc_elaborate_addChild(IIR_AssociationElement *actual_clause,
			       IIR_Label *label) {
  IIR* decl = actual_clause->get_formal();
  IIR_Declaration* tempDeclaration;

  if (actual_clause->_get_actual() == NULL) {
    cerr << "Warning: the actual in the association was NULL. Assuming to be"
	 << "open clause and ignoring.\n";
    return;
  }
 
  if (actual_clause->_get_actual()->get_kind() != IIR_FUNCTION_CALL &&
      actual_clause->get_formal()->get_kind() != IIR_FUNCTION_CALL){
     _cc_out << "addChild(";
  if(actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL) {
    //((IIR_FunctionCall *)actual_clause->_get_actual())->_publish_cc_elaborate_arg();
  } else {
    if(actual_clause->_get_actual()->_is_iir_declaration() == TRUE) {
      ASSERT ( actual_clause->_get_actual()->_is_iir_declaration() == TRUE );
      tempDeclaration = (IIR_Declaration *) actual_clause->_get_actual();
      ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
      _publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this );
    }
    else if(actual_clause->_get_actual()->_is_name() == TRUE) {
      tempDeclaration = (IIR_Declaration *) actual_clause->_get_actual()->_get_prefix_declaration();
      ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
      _publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this );
    }
    else {
      cerr << "Error : IIRScram_ComponentInstantiationStatement::_publish_cc_elaborate_addChild() - declaration kind not handled yet.\n";
    }
    actual_clause->_get_actual()->_publish_cc_elaborate();
  }
  
  
  _cc_out << ", ";
  label->_publish_cc_elaborate();

  if (_get_currently_publishing_unit() == GENERATE_FOR) {
    _cc_out << "_elab_obj[i - generateLeft].";
  }
  else {
    _cc_out << "_elab_obj->";
  }
  
  if(decl->get_kind() == IIR_FUNCTION_CALL) {
    //upTypeConversionFn = (IIR_FunctionCall *)decl;
    //upTypeConversionFn->_publish_cc_elaborate_arg();
  } else {
    if ( decl->_is_iir_declaration() == TRUE ) {
      tempDeclaration = (IIR_Declaration *) decl;
      ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
    }
    else if ( decl->_is_name() == TRUE ) {
      tempDeclaration = (IIR_Declaration *) decl->_get_prefix_declaration();
      ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
      _publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this );
    }
    else {
      cerr << "Error : IIRScram_ComponentInstantiationStatement::_publish_cc_elaborate_addChild() - declaration kind not handled yet.\n";
    }
    
    decl->_publish_cc_elaborate();
  }    
  _cc_out << ");\n";
  }
}


void
IIRScram_ComponentInstantiationStatement::_publish_connect() {
  
  IIR_Label *label = _get_label();
  int noofinputsignals =0;
  int noofoutputsignals =0;
  IIR_Boolean first = false;
  IIR_Declaration* tempDeclaration = NULL;
   ASSERT(get_instantiated_unit()->_is_iir_declaration() == TRUE);
  IIR_AssociationElement* actual_clause = port_map_aspect.first();

 
  while(actual_clause != NULL) {
    if (actual_clause->get_formal() != NULL) {
      switch (actual_clause->get_formal()->_get_mode()) {
      case IIR_OUT_MODE:
	if (actual_clause->get_formal()->get_kind() == IIR_FUNCTION_CALL) {
	  _publish_cc_elaborate_DownType(actual_clause,label);
	}
	break;
      case IIR_IN_MODE:
      case IIR_INOUT_MODE:
	if (actual_clause->_get_actual() != NULL) {
	  if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL)
	    _publish_cc_elaborate_DownType(actual_clause,label);
	
	  if(actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL) {
	  }
	}
	break;
      }
    }
    actual_clause = port_map_aspect.successor(actual_clause);
  }

  actual_clause = port_map_aspect.first(); 
  
  if(actual_clause == NULL){
    label->_publish_cc_elaborate();
    if (_get_currently_publishing_unit() == GENERATE_FOR) {
      _cc_out << "_elab_obj[i - generateLeft].connect(0, 0);\n";
    }
    else {
      _cc_out << "_elab_obj->connect(0,0);\n";
    }
    return;
  }
  label->_publish_cc_elaborate();
  if (_get_currently_publishing_unit() == GENERATE_FOR) {
    _cc_out << "_elab_obj[i - generateLeft].connect(";
  }
  else {
    _cc_out << "_elab_obj->connect(";
  }
  
  //Find out if the formals and actuals of port_map_aspect are present
  //If they are present use them otherwise get the order from component decl
  while(actual_clause != NULL) {
    if (actual_clause->get_formal() != NULL) {
      switch(actual_clause->get_formal()->_get_mode()) {
      case IIR_IN_MODE:
	noofinputsignals++;
	first = true;
	break;
      case IIR_OUT_MODE:
      case IIR_INOUT_MODE:
	noofoutputsignals++;
	first = true;
	break;
      }
    }
    actual_clause = port_map_aspect.successor(actual_clause);
  }
  
  _cc_out << noofinputsignals << ", " << noofoutputsignals;
  
  if(first == true) {
    actual_clause = port_map_aspect.first();  
    while(actual_clause != NULL) {
      if (actual_clause->get_formal() != NULL) {
	switch(actual_clause->get_formal()->_get_mode()) {
	case IIR_IN_MODE:
	  _cc_out << ", ";
	  if (actual_clause->_get_actual()->get_kind()!=IIR_FUNCTION_CALL)
	    _cc_out << "&";  
	  
	  ASSERT(actual_clause->_get_actual() != NULL);
	  if (actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL) {
	    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	      ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
	    else
	      ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	    _cc_out << "_tmpSigNetInfo";
	  }
	  else if (actual_clause->_get_actual()->get_kind() == IIR_INDEXED_NAME){
	    IIR_IndexedName *tempIdxName = (IIR_IndexedName *) actual_clause->_get_actual();
	    ASSERT ( tempIdxName->get_kind() == IIR_INDEXED_NAME );
	    if (tempIdxName->get_prefix()->_is_iir_declaration() == TRUE) {
	      tempDeclaration = (IIR_Declaration *) tempIdxName->get_prefix();
	      ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
	      _publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this->_get_enclosing_scope());
	    }
	    actual_clause->_get_actual()->_publish_cc_elaborate();
	  }
	  else {
	    _publish_cc_scoping_prefix(actual_clause->_get_actual(), _get_enclosing_scope());
	    actual_clause->_get_actual()->_publish_cc_elaborate();
	  }
	  break;
	}
      }
      actual_clause = port_map_aspect.successor(actual_clause);
    }
    
    actual_clause = port_map_aspect.first();  
    for(;actual_clause != NULL; ) {
      if (actual_clause->_get_actual() == NULL) {
	cerr << "Warning: actual in port map was NULL. Assuming open clause"
	     << " and generating defaults.\n";
	ASSERT ( actual_clause->get_formal() != NULL );
	ASSERT ( actual_clause->get_formal()->_get_subtype() != NULL );
	
	_cc_out << ", new ";
	actual_clause->get_formal()->_get_subtype()->_publish_cc_type_name();
	_cc_out << "(ObjectBase::SIGNAL_NETINFO)";
	actual_clause = port_map_aspect.successor(actual_clause);
	continue;
      }

      if (actual_clause->get_formal() != NULL) {
	switch(actual_clause->get_formal()->_get_mode()) {
	case IIR_OUT_MODE:
	case IIR_INOUT_MODE:
	  _cc_out << ", ";
	  if (actual_clause->get_formal()->get_kind() != IIR_FUNCTION_CALL) {
	    _cc_out << "&";
	  }
	  
	  if (((actual_clause->_get_actual() != NULL) &&
	       (actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL))||
	      (actual_clause->get_formal()->get_kind() == IIR_FUNCTION_CALL)) {
	    if (actual_clause->get_formal()->_get_mode()==IIR_INOUT_MODE){
	      if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
		((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
	      else
		((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	      _cc_out << "_tmpSigNetInfo";
	    }
	    if (actual_clause->get_formal()->_get_mode()==IIR_OUT_MODE){
	      if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
		((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
	      else
		((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	      _cc_out << "_tmpSigNetInfo";
	    }  
	  }
	  else {
	    if (actual_clause->_get_actual()->_is_iir_declaration() == TRUE) {
	      tempDeclaration = (IIR_Declaration *) actual_clause->_get_actual();
	      ASSERT (tempDeclaration->_is_iir_declaration() == TRUE );
	      _publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this->_get_enclosing_scope());
	    }
	    else if (actual_clause->_get_actual()->get_kind() == IIR_INDEXED_NAME) {
	      IIR_IndexedName *tempIdxName = (IIR_IndexedName *) actual_clause->_get_actual();
	      ASSERT ( tempIdxName->get_kind() == IIR_INDEXED_NAME );
	      if (tempIdxName->get_prefix()->_is_iir_declaration() == TRUE) {
		tempDeclaration = (IIR_Declaration *) tempIdxName->get_prefix();
		ASSERT ( tempDeclaration->_is_iir_declaration() == TRUE );
		_publish_cc_scoping_prefix( tempDeclaration->_get_declarative_region(),this->_get_enclosing_scope());
	      }
	    }
	    
	    actual_clause->_get_actual()->_publish_cc_elaborate();
	  }
	  
	  break;
	}
      }
      actual_clause = port_map_aspect.successor(actual_clause);
    }
  }
  _cc_out << ");\n";
}

#ifdef PROCESS_GRAPH
void
IIRScram_ComponentInstantiationStatement::_publish_cc_driver_info() {
  IIR_AssociationElement* actual_clause = port_map_aspect.first();
  while(actual_clause != NULL) {
    if (actual_clause->get_formal() != NULL) {
      if (actual_clause->_get_actual()->get_kind()!=IIR_FUNCTION_CALL &&
	  actual_clause->_get_actual()->get_kind()!= IIR_INDEXED_NAME &&
	  actual_clause->_get_actual()->_get_subtype()->_is_scalar_type() == TRUE) {
	_cc_out << "fp << \"Signal:";
	actual_clause->_get_actual()->_publish_cc_elaborate();
	_cc_out << " \"<< endl;" << endl;
	_publish_cc_scoping_prefix(actual_clause->_get_actual(), _get_enclosing_scope());
	actual_clause->_get_actual()->_publish_cc_elaborate();
	_cc_out << ".dump_connectivity_info(fp);" << endl;
	_publish_cc_scoping_prefix(actual_clause->_get_actual(), _get_enclosing_scope());
      }
      actual_clause = port_map_aspect.successor(actual_clause);
    }
  }
}
#endif

#ifdef PROCESS_COMBINATION
void
IIRScram_ComponentInstantiationStatement::
_static_elaborate(IIR_ArchitectureDeclaration *arch,
		  IIR_DeclarationList *cfglist,
		  char *hier_location) {
  IIR_ComponentDeclaration *compDecl;
  IIR_ConfigurationSpecification *configSpec;

  char *comp_name, *cfg_name;
  IIR_Declaration *decl;
  char *hier_ptr;
  int hier_length = 0;

  // Add to hierarchy string
  hier_length = strlen( hier_location );
  hier_ptr = hier_location + hier_length;
  for (int i = 0; i < get_label()->get_declarator()->get_text_length(); i++) {
    hier_ptr[i] = get_label()->get_declarator()->get_text()[i];
  }
  hier_ptr[get_label()->get_declarator()->get_text_length()] = '_';
  hier_ptr[get_label()->get_declarator()->get_text_length() + 1] = '\0';

  // get component being instantiated
  compDecl = (IIR_ComponentDeclaration*)get_instantiated_unit();
  ASSERT(compDecl->get_kind() == IIR_COMPONENT_DECLARATION);
  comp_name = compDecl->get_declarator()->_convert_to_c_string();
#ifdef DEBUG_ELAB
  cout << "Elaborating instance " << hier_location << " of component |"
       << comp_name << "|\n";
#endif
  // walk through arch_decl_part to find the correct configSpec
  decl = arch->architecture_declarative_part.first();
  while (decl != NULL) {
    if (decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
      configSpec = (IIR_ConfigurationSpecification*)decl;
      IIR_ComponentDeclaration *name;
      name = (IIR_ComponentDeclaration*)configSpec->get_component_name();
      ASSERT (name->get_kind() == IIR_COMPONENT_DECLARATION);
      cfg_name = name->get_declarator()->_convert_to_c_string();

      if (!strcmp(cfg_name, comp_name)) {
	delete [] cfg_name;
	break;
      }
      delete [] cfg_name;
    }
    decl = arch->architecture_declarative_part.successor(decl);
  }
  if (decl == NULL) {
    cout << "ERROR: could not find configuration for component " 
	 << *((IIR_Declaration*)compDecl)->get_declarator() << " instantiated at "
	 << hier_location << "\n";
    exit(1);
  }
  else {
#ifdef DEBUG_ELAB
    cout << "Found configuration for component |" << comp_name << "|\n";
#endif
  }

  // OK, I've got everything I need now.  I have:
  //       compInstStmt (this)--has g&p maps (local->actual)
  //       compDecl (compDecl)--defines locals
  //       configSpec (configSpec)--has entity_aspect, g&p maps (formal->local)
  if (generic_map_aspect.num_elements() != 0) {
    cout << "ERROR:  Sorry, generics in component instantiation statements "
	 << "not supported during static elaboration yet\n";
    exit(1);
  }

  // This checks the limitations on statically elaborated components
  compDecl->_static_elaborate(arch, cfglist, hier_location);

  // make the actual signal of the port map the clone of the formal.  The
  // local is needed to connect the two port maps together. The configSpec
  // maps formal to local, compInsStmt maps local to actual.
#define IIR_AEBX IIR_AssociationElementByExpression
  IIR_AEBX *formal_assoc, *actual_assoc;
  IIR_SignalInterfaceDeclaration *formal, *flocal, *alocal;
  IIR_Declaration *actual;
  
  formal_assoc = (IIR_AEBX*)configSpec->port_map_aspect.first();
  while (formal_assoc != NULL) {
    ASSERT(formal_assoc->get_kind() == IIR_ASSOCIATION_ELEMENT_BY_EXPRESSION);
    formal = (IIR_SignalInterfaceDeclaration*)formal_assoc->get_formal();
    flocal = (IIR_SignalInterfaceDeclaration*)formal_assoc->get_actual();
    ASSERT(formal->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION);
    ASSERT(flocal->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION);

    actual_assoc = (IIR_AEBX*)port_map_aspect.first();
    while (actual_assoc != NULL) {
      ASSERT(actual_assoc->get_kind() ==IIR_ASSOCIATION_ELEMENT_BY_EXPRESSION);
      alocal = (IIR_SignalInterfaceDeclaration*)actual_assoc->get_formal();
      ASSERT(alocal->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION);
      if (0 == IIRScram_TextLiteral::_cmp(alocal->_get_declarator(), 
					  flocal->get_declarator() )) {
	break; // found the matching association
      }
      actual_assoc = (IIR_AEBX*)port_map_aspect.successor(actual_assoc);
    }
    if (actual_assoc == NULL) {
      ostrstream err;
      err << "Internal scram error: unable to locate actual for |"
	  << *formal->_get_declarator() << "| in port map for component |" 
	  << *compDecl->_get_declarator() << "|" << ends;
      report_error(this, err);
      ASSERT(actual_assoc != NULL);
    }

    actual = (IIR_Declaration*)actual_assoc->get_actual();

    ASSERT( actual->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION
	    || actual->get_kind() == IIR_SIGNAL_DECLARATION
	    || actual->get_kind() == IIR_INDEXED_NAME );

    formal->_my_clone = (IIR_SignalInterfaceDeclaration*)actual->_clone();
#ifdef DEBUG_ELAB
    cout << "formal: " << *formal->_get_declarator() << "\tlocal: "
	 << *flocal->_get_declarator() << "\tactual: "
	 << *actual->_get_declarator() << "\n";
#endif

    IIR_Declaration *impclone, *impsig;

    if( formal->_get_implicit_declarations() != NULL ){
      impsig = formal->_get_implicit_declarations()->get_element();
      while (impsig != NULL) {
	impclone = (IIR_Declaration*)impsig->_clone();
	// memory leak--stupid protected stuff!
	// delete impclone->_get_declarator(); 

	// figure out the correct name for the elaborated implicit signal
	IIR_TextLiteral *signame;
	signame = ((IIR_SignalDeclaration*)actual)->_clone()->_get_declarator();
	char *oldname = impclone->_get_declarator()->_convert_to_c_string();
	char *attrname = strrchr(oldname, '_');
	ASSERT(attrname != NULL);
	ostrstream str;
	str << *signame << attrname << ends;
	char *newname = str.str();
	delete [] oldname;
	impclone->set_declarator(IIR_Identifier::get(newname, strlen(newname)));
	if ( NULL == formal->_my_clone->_get_implicit_declarations() ) {
	  formal->_my_clone->_set_implicit_declarations( new set<IIR_Declaration> );
	}
	formal->_my_clone->_get_implicit_declarations()->add(impclone);
	impsig = formal->_get_implicit_declarations()->get_next_element();
      }
    }

    formal_assoc = 
      (IIR_AEBX*)configSpec->port_map_aspect.successor(formal_assoc);
  }
#undef IIR_AEBX

  // Elaborate the specified architecture
  configSpec->_static_elaborate(arch, cfglist, hier_location);

  hier_location[hier_length] = '\0';
  delete [] comp_name;

#ifdef DEBUG_ELAB
  cout << "Completed elaboration of component instance; ascending to \"" 
       << hier_location << "\"\n";
#endif
}
#endif


void
IIRScram_ComponentInstantiationStatement::_publish_cc_concurrent_stmt_init(IIR_DeclarationList* decl_list) {

  IIR_ComponentDeclaration* componentname = NULL;

  _cc_out << "{\n";
  componentname = (IIR_ComponentDeclaration *) this->get_instantiated_unit();
  ASSERT(componentname->get_kind() == IIR_COMPONENT_DECLARATION);

  if (_get_currently_publishing_unit() != GENERATE_FOR) {
    (this->_get_label())->_publish_cc_elaborate();
    _cc_out << "_elab_obj";
    _cc_out << " = new ";
    componentname->_publish_cc_binding_name();
    _cc_out << "_elab(";
    this->_get_generic_map_aspect()->_publish_cc();
    _cc_out << ");\n";
  }
  
  _current_publish_node->_publish_cc_binding_name();
  _cc_out << "_elab* enclosingArch = this;\n";
  this->_get_label()->_get_declarator()->_publish_cc();
  _cc_out << "_elab_obj";
  
  if (_get_currently_publishing_unit() == GENERATE_FOR) {
    _cc_out << "[i].boundedEntity = ";
  }
  else {
    _cc_out << "->boundedEntity = ";
  }
  
  if (_get_configuration() != NULL) {
    if ((_get_configuration()->get_kind() == IIR_CONFIGURATION_SPECIFICATION)){
      IIR_ConfigurationSpecification* config_spec_decl = (IIR_ConfigurationSpecification*) _get_configuration();
      
      if(config_spec_decl == NULL) {
	_cc_out << " NULL;\n";	
      } 
      else if(config_spec_decl->get_entity_aspect() != NULL) {
	_cc_out << " new ";
	config_spec_decl->get_entity_aspect()->_publish_cc_binding_name();
	_cc_out << "_elab(";
	IIR* tempNode = _current_publish_node;
	_current_publish_node = this;
	config_spec_decl->generic_map_aspect._publish_cc_generic_map_aspect();
	_cc_out << ");\n";
	config_spec_decl->_publish_cc_port_map_aspect();
	_current_publish_node = tempNode;
      } else {
	_cc_out << " NULL;\n";
      }
    }
    if (_get_configuration()->get_kind() == IIR_COMPONENT_CONFIGURATION)  {
      IIR_ComponentConfiguration* config_spec_decl = (IIR_ComponentConfiguration*) _get_configuration();
      if(config_spec_decl == NULL) {
	_cc_out << " NULL;\n";	
      } 
      else if(config_spec_decl->get_entity_aspect() != NULL) {
	_cc_out << " new ";
	config_spec_decl->get_entity_aspect()->_publish_cc_binding_name();
	_cc_out << "_elab(";
	IIR* tempNode = _current_publish_node;
	_current_publish_node = this;
	config_spec_decl->generic_map_aspect._publish_cc_generic_map_aspect();
	_cc_out << ");\n";
	if (config_spec_decl->get_entity_aspect()->_get_port_list() != NULL) {
	  IIR_Char* old_elab_name = _current_elab_name;
	  ostrstream elabStream;
	  elabStream << *_get_declarator() << "_elab_obj->" << ends;
	  _current_elab_name = elabStream.str();
	  _current_publish_node = get_instantiated_unit();
	  config_spec_decl->get_entity_aspect()->_get_port_list()->_publish_cc_port_map_aspect();
	  delete [] _current_elab_name;
	  _current_elab_name = old_elab_name;
	}
	_current_publish_node = tempNode;
      } else {
	_cc_out << " NULL;\n";
      }
    }
  }
  else {
    _cc_out << " NULL;\n";
  }
  
  _cc_out << "};\n";
  
  port_map_aspect._set_passed_through_out_port(TRUE);
}

IIR_ConfigurationSpecification*
IIRScram_ComponentInstantiationStatement::_get_configuration_specification(IIR_DeclarationList* decl_list) {
  
  IIR_ComponentDeclaration* componentname = NULL;
  IIR_ConfigurationSpecification* config_spec_decl = NULL;
  
  componentname = (IIR_ComponentDeclaration *) this->get_instantiated_unit();
  ASSERT(componentname->get_kind() == IIR_COMPONENT_DECLARATION);

  // Searching for configuration specification
  IIR_Declaration* decl = decl_list->first();
  while(decl != NULL) {
    if(decl->_is_iir_configuration_specification() == TRUE) {
      config_spec_decl = (IIR_ConfigurationSpecification*)decl;
      if(config_spec_decl->_has_same_component((IIR_ComponentInstantiationStatement*)this) == TRUE) {
	if (_get_enclosing_scope()->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT) {
	  return config_spec_decl;
	}
	if(config_spec_decl->_configures_this_component((IIR_ComponentInstantiationStatement*)this) == TRUE) {
	  return config_spec_decl;
	}
      }
    }
    decl = decl_list->successor(decl);
  }
  return NULL;
}

IIR_ConfigurationSpecification*
IIRScram_ComponentInstantiationStatement::_get_configuration_specification_from_any_scope(IIR_DeclarationList *decl_list) {
  // This method iteratively searches the outer scope(s) to locate a
  // configuration specification if one was not found in the inner scope
  IIR_ConfigurationSpecification *config_spec = NULL;
  IIR* current_scope                          = _get_enclosing_scope();
  
  do {
    config_spec = _get_configuration_specification(decl_list);
    if (config_spec != NULL) {
      return config_spec;
    }
    
    if (current_scope != NULL) {
      decl_list     = current_scope->_get_declaration_list();
      ASSERT ( decl_list != NULL );
      current_scope = current_scope->_get_enclosing_scope();
    }
    else {
      decl_list = NULL;
    }
  } while (decl_list != NULL);

  return NULL;
}

void
IIRScram_ComponentInstantiationStatement::_publish_cc_elaborate_UpType(IIR_AssociationElement *actual_clause, IIR_Label *label){

  IIR_FunctionCall  *upTypeConversionFn = (IIR_FunctionCall *)actual_clause->get_formal();

  if (actual_clause->get_formal()->_get_mode() == IIR_IN_MODE || 
      actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE){
      
    _cc_out << "Addall(";
       ((IIR_FunctionCall *) actual_clause->_get_actual())->parameter_association_list.first()->_publish_cc_elaborate();
    _cc_out << ", ";
    label->_publish_cc_elaborate();
    _cc_out << "_elab_obj->";
    if (actual_clause->get_formal()->_get_mode()==IIR_IN_MODE)
    ((IIR_FunctionCall *) actual_clause->get_formal())->_publish_cc_elaborate();
    if (actual_clause->get_formal()->_get_mode()==IIR_INOUT_MODE)
    ((IIR_FunctionCall *) actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
    _cc_out << ");\n\n";

  }


  if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE ||
      actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE){
    // New TypeConvert ptr
    _cc_out << "TypeConvert* ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr = new TypeConvert;\n\n";

    //New signalnetinfo of actual
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if(((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type()==TRUE && 
	 ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }
	_cc_out << "* ";
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSigNetInfo = new ";
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
       ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
       ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }

     //--------------------------------------------------------
    //  Code added for handling arrays
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE && 
        (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark()) != NULL &&
     (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type())){
      _cc_out << "(ObjectBase::SIGNAL_NETINFO, ";
      ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else 
      if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE &&
         ((IIR_AssociationElementByExpression*)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark() != NULL  &&
     ((IIR_AssociationElementByExpression*)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type()){
      _cc_out << "(ObjectBase::SIGNAL_NETINFO, ";
      ((IIR_AssociationElementByExpression *)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else
	_cc_out << "(ObjectBase::SIGNAL_NETINFO);\n\n";
    // Code added for handling arrays
    //----------------------------------------------

	//New variable of actual
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
       ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
       ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }
	_cc_out << "* ";
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSigVariable = new ";
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }

     if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE &&
         (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark()) != NULL &&
     (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type())){
      _cc_out << "(ObjectBase::VARIABLE, ";
      ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else 
      if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE &&
      ((IIR_AssociationElementByExpression*)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark() != NULL &&
     ((IIR_AssociationElementByExpression*)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type()){
      _cc_out << "(ObjectBase::VARIABLE, ";
      ((IIR_AssociationElementByExpression *)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else
	_cc_out << "(ObjectBase::VARIABLE);\n\n";

	//New signal of formal
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }
	_cc_out << "* ";
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSignal = new ";
    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE) {
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();
      }
    if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE)
      if (((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else{
	((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }
	_cc_out << "(ObjectBase::SIGNAL);\n\n";
    
	//addTypeConversionFn(UptypeFn)
    _cc_out << "int ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_id";
    _cc_out << " = addTypeConversionFn("; 
    upTypeConversionFn->get_implementation()->_publish_cc_type_conversion_function_name();
    _cc_out << ");\n\n";

    //Typeconvertptr->setSignal(formal_signal)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setSignal(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal);\n\n";
    
    //TypeConvertptr->setVariable(actual_variable)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setVariable(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigVariable);\n\n";
 
    //TypeConvertptr->setSignalNetinfo(actual_signalnetinfo)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setSignalNetinfo(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo);\n\n";
    
    //TypeConvertptr->setConversionFunctionId(formal_fnID)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setConversionFunctionId(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_id);\n\n";

    //formal_signal->setElaborationinfo(formal)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal->setElaborationInfo(";
    // if (actual_clause->get_formal()->get_kind() == IIR_FUNCTION_CALL)
    // ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_//list.first()->get_formal()->_publish_cc();
    // else
       label->_publish_cc_elaborate();
       _cc_out << "_elab_obj->";
       ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
    _cc_out << ");\n\n";
    
    //addUpConvertDriver(*actual_signetinfo, *actual_variable, TCptr)
    _cc_out << "addUpConvertDriver(*";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo, *";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigVariable, ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr);\n\n";
    
    //addChild(actual, *actual_signetinfo)
    _cc_out << "addChild(";
    if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL)
       ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->_publish_cc_elaborate();
    else
       ((IIR_AssociationElementByExpression*)actual_clause)->get_actual()->_publish_cc_elaborate();
    _cc_out << ", *";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo);\n\n";

    //addDriver(actual, *formal_signal)
    _cc_out << "addDriver(";
    if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL)
       ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->_publish_cc_elaborate();
    else
    ((IIR_AssociationElementByExpression*)actual_clause)->get_actual()->_publish_cc_elaborate();
    _cc_out << ", *";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal);\n\n";
    }
}

void 
IIRScram_ComponentInstantiationStatement::
_publish_cc_elaborate_DownType(IIR_AssociationElement *actual_clause,
			  IIR_Label *label){

  IIR_FunctionCall *downTypeConversionFn =  (IIR_FunctionCall *)actual_clause->_get_actual();

  if (actual_clause->get_formal()->_get_mode() == IIR_OUT_MODE){
    if (((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE &&
	((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE){
      ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
    }
    else {
      ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
    }
      _cc_out << "* ";
      if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
      //label->_publish_cc_elaborate();
       _cc_out << "_tmpSigNetInfo = new ";
       if (((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	   ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
       }
       else {
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
       }
       _cc_out << "(ObjectBase::SIGNAL_NETINFO);\n\n";

    _cc_out << "Addall(*";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo, ";
       ((IIR_FunctionCall *) actual_clause->_get_actual())->_publish_cc_elaborate();
    _cc_out << ");\n\n";

  }


  if (actual_clause->get_formal()->_get_mode() == IIR_IN_MODE ||
      actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE){
     
    //New TypeConvert 
    _cc_out << "TypeConvert* ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    // label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr = new TypeConvert;\n\n";
    
    //New SignalNetinfo of formal
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
      if (((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
	((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
      }
    else
      if (((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_scalar_type() == TRUE &&
	  ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_kernel_type() == FALSE){
	((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_kernel_type();
      }
      else {
        ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_type_name();
      }
    	_cc_out << "* ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSigNetInfo = new ";
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL){
	  if (((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
	  }
	}
	else {
	  if (((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_type_name();
	  }
	}
   	_cc_out << "(ObjectBase::SIGNAL_NETINFO);\n\n";

	//New Variable of formal
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL){
	  if (((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
	  }
	}
	else {
	  if (((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_type_name();
	  }
	}
  	_cc_out << "* ";
        if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSigVariable = new ";
	if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL){
	  if (((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	  ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
	  }
	}
	else {
	  if (((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->get_formal())->_get_subtype()->_publish_cc_type_name();
	  }
	}
   	_cc_out << "(ObjectBase::VARIABLE);\n\n";

	//New Signal of actual
      	if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL){
	  if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
         ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
	  }
	}
	else {
	  if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE) {
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name();  
	  }
	}
	_cc_out << "* ";
        if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
	//label->_publish_cc_elaborate();
	_cc_out << "_tmpSignal = new ";
	if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL){
	  if (((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_kernel_type() == FALSE &&
	      ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_is_scalar_type() == TRUE){
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first()->get_formal()->_get_subtype()->_publish_cc_type_name();
	  }
	}
	else {
	  if (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_scalar_type() == TRUE &&
	      ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_is_kernel_type() == FALSE){
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_kernel_type();
	  }
	  else {
	    ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_type_name(); 
	  }
	}

      if (actual_clause->_get_actual()->get_kind() != IIR_FUNCTION_CALL &&
          (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark())!=NULL &&
     (((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type())){
      _cc_out << "(ObjectBase::SIGNAL";
      ((IIR_FunctionCall *)actual_clause->_get_actual())->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else 
      if (actual_clause->_get_actual()->get_kind() == IIR_FUNCTION_CALL &&
      ((IIR_AssociationElementByExpression*)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark() != NULL && 
     ((IIR_AssociationElementByExpression *)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_get_type_mark()->_is_unconstrained_array_type()){
      _cc_out << "(ObjectBase::SIGNAL, ";
      ((IIR_AssociationElementByExpression *)((IIR_FunctionCall *)actual_clause->_get_actual())->parameter_association_list.first())->get_actual()->_get_subtype()->_publish_cc_range();
      _cc_out << ");\n\n";
    }
    else
	_cc_out << "(ObjectBase::SIGNAL);\n\n";
    
	 //addTypeConversionFn(DownTypeFn) 
    _cc_out << "int ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    _cc_out << "_id";
    _cc_out << " = addTypeConversionFn("; 
    downTypeConversionFn->get_implementation()->_publish_cc_type_conversion_function_name();
    _cc_out << ");\n\n";

    //TCptr->setSignal(actual_signal)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setSignal(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal);\n\n";
    
    //TCptr->setVariable(formal_variable)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setVariable(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigVariable);\n\n";
 
    //TCptr->setSignalNetinfo(formal_signetinfo)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setSignalNetinfo(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo);\n\n";
    
    //TCptr->setConversionFunctionId(actual_fn_id)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr->";
    _cc_out << "setConversionFunctionId(";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_id);\n\n";

    //actual_signal->setElaborationInfo(actual)
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal->setElaborationInfo(";
    // if (actual_clause->get_formal()->get_kind() == IIR_FUNCTION_CALL)
    // ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_//list.first()->get_formal()->_publish_cc();
    // else
             ((IIR_FunctionCall*)actual_clause->_get_actual())->parameter_association_list.first()->_publish_cc_elaborate();
    _cc_out << ");\n\n";
    
    //addUpConvertDriver(*formal_signetinfo, *formal_variable, TCptr)
    _cc_out << "addUpConvertDriver(*";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigNetInfo, *";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_tmpSigVariable, ";
    if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
    //label->_publish_cc_elaborate();
    _cc_out << "_typeConvertptr);\n\n";

    //addDriver(formal, *actual_signal)
    _cc_out << "addDriver(*";
      if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
    ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
    else
     ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
     _cc_out << "_tmpSigNetInfo, *";
     if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall *)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
     //label->_publish_cc_elaborate();
    _cc_out << "_tmpSignal);\n\n";

    if (actual_clause->get_formal()->_get_mode() == IIR_INOUT_MODE){
      _cc_out << "Addall(*";
      if (actual_clause->get_formal()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall*)actual_clause->get_formal())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->get_formal())->_publish_cc_elaborate();
      _cc_out << "_tmpSigNetInfo, ";
      if (actual_clause->_get_actual()->get_kind()==IIR_FUNCTION_CALL)
	 ((IIR_FunctionCall*)actual_clause->_get_actual())->parameter_association_list.first()->_publish_cc_elaborate();
      else
	 ((IIR_FunctionCall*)actual_clause->_get_actual())->_publish_cc_elaborate();
      _cc_out << ");\n\n";
    }
 }
}


IIR_Label *
IIRScram_ComponentInstantiationStatement::_find_instantiate_label( IIR_SimpleName *to_find ){
  IIR_Label *retval = NULL;
  if( get_label() != NULL ){
    if( IIR_TextLiteral::_cmp( get_label()->get_declarator(), to_find ) == 0 ){
      retval = get_label();
    }
  }

  return retval;
}

IIR_ComponentDeclaration*
IIRScram_ComponentInstantiationStatement::_build_implicit_component_declaration(IIR_EntityDeclaration *entity, char *compName) {
  IIR_ComponentDeclaration *componentDecl = new IIR_ComponentDeclaration;
  
  copy_location(this, componentDecl);
  componentDecl->local_generic_clause = entity->generic_clause;
  componentDecl->local_port_clause    = entity->port_clause;
  componentDecl->set_declarator(IIR_Identifier::get(compName, strlen(compName)));

  return componentDecl;
}

IIR_ConfigurationSpecification*
IIRScram_ComponentInstantiationStatement::_build_implicit_configuration_specification(IIR_LibraryUnit *instantiatedUnit, IIR_ComponentDeclaration *compDecl) {
  IIR_ConfigurationSpecification *configSpec;
  ostrstream declString;

  configSpec = new IIR_ConfigurationSpecification;
  copy_location(this, configSpec);
  configSpec->set_component_name(compDecl);
  configSpec->set_entity_aspect(instantiatedUnit);

  declString << compDecl->get_declarator() << configSpec << ends;
  configSpec->set_declarator(IIR_Identifier::get(declString.str(), strlen(declString.str())));
  delete [] declString.str();
  
  return configSpec;
}

void
IIRScram_ComponentInstantiationStatement::_add_to_configuration_specification(IIR_DeclarationList *searchList, IIR_ComponentDeclaration *compDecl, IIR_ComponentInstantiationStatement *newStmt) {
  IIR_ConfigurationSpecification *configSpec = NULL;
  IIR_Declaration                *decl;
  
  decl = searchList->first();
  while (decl != NULL) {
    if (decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
      configSpec = (IIR_ConfigurationSpecification *) decl;
      if (configSpec->get_component_name() == compDecl) {
	break;
      }
      configSpec = NULL;
    }
    decl = searchList->successor(decl);
  }
  
  if (configSpec == NULL) {
    cerr << "Error :- Unable to locate configuration specification for"
	 << " anonymous component declaration.\n";
    return;
  }
  
  ASSERT (configSpec != NULL);
  
  IIR_DesignatorExplicit *newDesignator = new IIR_DesignatorExplicit;
  copy_location(this, newDesignator);
  newDesignator->set_name(newStmt->get_label());
  configSpec->instantiation_list.append(newDesignator);
}
  
IIR*
IIRScram_ComponentInstantiationStatement::_transmute() {
  // Code to transmute direct component instantiations to a component
  // declaration, configuration specification and a new instantiation.

  IIR_ComponentInstantiationStatement *newStmt = (IIR_ComponentInstantiationStatement *) this;
  IIR_ArchitectureDeclaration *arch    = NULL;
  IIR_EntityDeclaration       *entity  = NULL;
  IIR_LibraryUnit             *lib     = NULL;
  
  ASSERT ( get_instantiated_unit() != NULL );
  
  // The instantiated unit it not a component declaration. Check and see
  // if this is something that we can understand and work with.
  
  switch (get_instantiated_unit()->get_kind()) {
  case IIR_COMPONENT_DECLARATION:
    return (IIR *) newStmt;
    
  case IIR_INDEXED_NAME: {
    IIR_IndexedName *idxName   = NULL;
    IIR_SelectedName *selName = NULL;
    // This is a direct component instantiation that needs to be transmuted.
    idxName = (IIR_IndexedName *) get_instantiated_unit();
    ASSERT(idxName->get_prefix() != NULL);
    ASSERT(idxName->_get_suffix() != NULL);
    ASSERT(idxName->_get_suffix()->get_kind() == IIR_ARCHITECTURE_DECLARATION);
    
    arch = (IIR_ArchitectureDeclaration *) idxName->_get_suffix();
    lib  = (IIR_LibraryUnit *) idxName->get_prefix();
    
    if (lib->get_kind() == IIR_SELECTED_NAME) {
      selName = (IIR_SelectedName *) lib;
      entity  = (IIR_EntityDeclaration *) selName->_get_suffix();
    }
    
    break;
  }
  
  default:
    cerr << "Warning - IIRScram_ComponentInstantiationStatement::_transmute()"
	 << " - case (" << get_instantiated_unit()->get_kind() << ")"
	 << " not handled yet.\n";
    return (IIR *) newStmt;
  }

  ASSERT (arch != NULL);
  ASSERT (entity != NULL);

  ostrstream componentStream;
  char       *componentName;
  componentStream << "AC" << entity << "_" << arch << ends;
  componentName = componentStream.str();
  
  IIR_ComponentDeclaration*  componentDecl;
  IIR_ConfigurationSpecification *configSpec;
  IIR_DeclarationList *enclosingDecls;
  set<IIR_Declaration>* compSet;
  
  enclosingDecls = _get_enclosing_scope()->_get_declaration_list();
  ASSERT (enclosingDecls != NULL);
  
  compSet = enclosingDecls->_find_declarations(IIR_Identifier::get(componentName, strlen(componentName)));
  
  if (compSet == NULL) {
    // A component declaration and cofiguration specification does not exist
    // so create a new one and add them to the list.
    componentDecl = _build_implicit_component_declaration(entity, componentName);
    configSpec    = _build_implicit_configuration_specification(arch, componentDecl);
    configSpec->generic_map_aspect = generic_map_aspect;
    configSpec->port_map_aspect    = port_map_aspect;
    
    enclosingDecls->append(componentDecl);
    enclosingDecls->append(configSpec);
  }
  else {
    ASSERT ( compSet->get_element()->get_kind() == IIR_COMPONENT_DECLARATION );
    componentDecl = (IIR_ComponentDeclaration *) compSet->get_element();
  }
  
  newStmt = new IIR_ComponentInstantiationStatement;
  
  copy_location(this, newStmt);
  newStmt->set_label(get_label());
  newStmt->generic_map_aspect    = generic_map_aspect;
  newStmt->port_map_aspect       = port_map_aspect;
  newStmt->set_instantiated_unit( componentDecl );
  
  _add_to_configuration_specification( enclosingDecls, componentDecl, newStmt );

  delete [] componentName;
  
  return (IIR *) newStmt;
}

