#ifndef IIRSCRAM_COMPONENT_DECLARATION_HH
#define IIRSCRAM_COMPONENT_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ComponentDeclaration.hh,v 1.3 1999/03/25 02:57:18 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ComponentDeclaration.hh"

class IIR_List ;
class IIR_Name;

class IIRScram_ComponentDeclaration : public IIRBase_ComponentDeclaration {

public:
  declaration_type _get_type();
  IIR_PortList *_get_port_list();
  IIR_GenericList *_get_generic_list();
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _make_interface_visible( symbol_table * );

  IIR_TypeDefinition *_get_port_type( int );

  void _publish_vhdl_decl(ostream &);
  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc_elaborate();
  void _publish_cc_headerfile();
  void _publish_cc_ccfile();
  void _publish_cc_class();
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_destructor();
  void _publish_cc_instantiate();
  void _publish_cc_createNetInfo();
  void _publish_cc_connect();
  void _publish_cc_getboundentityinfo();

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,  char*);
#endif

  IIR_Boolean _is_iir_component_declaration(){ return TRUE; }
  IIR_Boolean _is_component_decl() { return TRUE; }

  IIR_AttributeSpecificationList* _get_attribute_specification_list(){ return &attributes; }
  
protected:
  IIRScram_ComponentDeclaration() {}
  virtual ~IIRScram_ComponentDeclaration() = 0;
    
private:
};
#endif
