
#ifndef IIRBASE_FUNCTION_CALL_HH
#define IIRBASE_FUNCTION_CALL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_FunctionCall.hh,v 1.2 1999/03/09 20:50:11 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Expression.hh"
#include "IIR_AssociationList.hh"

class IIR_SubprogramDeclaration;

class IIRBase_FunctionCall : public IIR_Expression {

public:
  IIR_Kind get_kind() {return IIR_FUNCTION_CALL;}
  IIR_Char *get_kind_text() {return "IIR_FunctionCall";}

  void set_implementation( IIR_SubprogramDeclaration* implementation );
  IIR_SubprogramDeclaration* get_implementation();

  IIR_AssociationList parameter_association_list;

protected:
  IIRBase_FunctionCall();
  virtual ~IIRBase_FunctionCall() = 0;
    
private:
  IIR_SubprogramDeclaration* implementation;

};
#endif
