/*$Id: io_getln.cc,v 14.12 1999/07/23 10:13:54 al Exp $ -*- C++ -*-
 * get a bunch of lines, from a file
 * interface is just line fgets.
 * hooks together extension lines
 * not recommended for getting from stdin.  use for files only.
 * is always a line ahead
 * start with + is extension line, spice compatibility.
 */
#include "io_.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
std::string getlines(FILE *fileptr)
{
  assert(fileptr);
  const int buffer_size = BIGBUFLEN;
  std::string s;

  bool more = true;  // get another line (extend)
  while (more){
    char buffer[buffer_size+1];
    char* got = fgets(buffer, buffer_size, fileptr);
    {if (!got){ // probably end of file
      more = false;
    }else{
      trim(buffer);
      int count = strlen(buffer);
      {if (buffer[count-1] == '\\'){
	untested();
	buffer[count-1] = '\0';
      }else{
	int c = fgetc(fileptr);
	{if (c == '+'){
	  more = true;
	}else{
	  more = false;
	  ungetc(c,fileptr);
	}}
      }}
      s += buffer;
      s += ' ';
    }}
  }
  return s;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
