/*$Id: io_.h,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * shared data for all io functions
 * other io related stuff, like files and formatting
 */
#ifndef IO_H
#define IO_H
#include "md.h"
#include "l_lib.h"
/*--------------------------------------------------------------------------*/
class CS;
const int MAXHANDLE = CHAR_BIT*sizeof(int)-1;
/*--------------------------------------------------------------------------*/
class OMSTREAM {
private:
  int _mask;
  int _fltdig;			/* max precision for float/double numbers */
  int _fltwid;			/* fixed(min)width for float/double numbers */
  int _format;			/* how to format io.  Basic option. */
  static int _cpos[MAXHANDLE+1];/* character counter */
  bool _cipher;			/* flag: encrypt output file */
  bool _pack;			/* flag: convert whitespace to tabs on out */
public:
  /*implicit*/ OMSTREAM(int m=0)
    :_mask(m),_fltdig(7),_fltwid(0),_format(0),_cipher(false),_pack(false){}
  OMSTREAM& operator=(const OMSTREAM& x)  {_mask = x._mask; return *this;}
  OMSTREAM& operator|=(const OMSTREAM& x)
				{untested(); _mask |= x._mask; return *this;}
  OMSTREAM& operator&=(const OMSTREAM& x) {_mask &= x._mask; return *this;}
  OMSTREAM& operator<<=(const OMSTREAM& x){_mask <<= x._mask; return *this;}
  OMSTREAM  operator~()const		{return OMSTREAM(~_mask);}
  bool	    any()const			{return _mask != 0;}
  bool	    cipher()const		{return _cipher;}
  bool	    pack()const			{return _pack;}
  int	    format()const		{return _format;}
  OMSTREAM& setcipher(bool x=true)	{untested(); _cipher=x; return *this;}
  OMSTREAM& setpack(bool x=true)	{untested(); _pack=x;   return *this;}
  OMSTREAM& setfloatwidth(int d,int w=0){_fltdig=d; _fltwid=w; return *this;}
  OMSTREAM& setformat(int f)		{untested(); _format=f; return *this;}
  OMSTREAM& reset()
    {_fltdig=7;_fltwid=0;_format=0; _cipher=_pack=false; return *this;}
  /* out */
  OMSTREAM& tab(int);
  OMSTREAM& form(const char*,...);
  OMSTREAM& operator<<(char c);
  OMSTREAM& operator<<(const char* s);
  OMSTREAM& operator<<(double x)
    {return (*this)<<ftos(x,_fltwid,_fltdig,_format);}
  OMSTREAM& operator<<(bool x)		{return form("%d", x);}
  OMSTREAM& operator<<(int x)		{return form("%d", x);}
  OMSTREAM& operator<<(unsigned x)	{untested(); return form("%u", x);}
  OMSTREAM& operator<<(const std::string& s) {return operator<<(s.c_str());}
};
inline OMSTREAM operator&(OMSTREAM x, const OMSTREAM& y) {x &= y; return x;}
inline OMSTREAM operator|(OMSTREAM x, const OMSTREAM& y)
					{untested(); x |= y; return x;}
inline bool any(const OMSTREAM& m)	{return m.any();}
const char* octal(int x);
/*--------------------------------------------------------------------------*/
class IO {
public:
  static OMSTREAM mstdout;
  static OMSTREAM error;
  static OMSTREAM plotout;		/* where to send ascii graphics */
  static bool	  plotset;		/* plot on by default flag */
  static int	  formaat;		/* how to format io.  Basic option. */
  static FILE*	  whence;		/* get file from.  std C file. */
  static bool	  suppresserrors;
  static bool	  incipher;		/* flag: decrypt input file */
  static FILE*	  stream[MAXHANDLE+1];	/* reverse of fileno() */
};
/*--------------------------------------------------------------------------*/
/* contrl */  void	  initio(OMSTREAM,FILE*);
	      void	  decipher(char*);
	      void	  outreset();
	      OMSTREAM*   outset(CS&,OMSTREAM*);
/* findf */   std::string findfile(const std::string&,const std::string&,int);
/* getln */   std::string getlines(FILE*);
/* xopen */   void	  xclose(FILE**);
	      FILE*	  xopen(CS&,const char*,const char*);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
