/*$Id: e_ccsrc.h,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 $ current controlled source base
 */
#ifndef E_CCSRC_H
#define E_CCSRC_H
#include "l_denoise.h"
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class CCSRC_BASE : public ELEMENT {
  friend class DEV_MUTUAL_L;
protected:
  explicit	CCSRC_BASE()
    :ELEMENT(), _input_label(), _input(0) {}
  explicit	CCSRC_BASE(const CCSRC_BASE& p)
    :ELEMENT(p), _input_label(p._input_label), _input(p._input) {untested();}
private: // override virtual
  void	   parse_more_nodes(CS&, int);
  void	   print(OMSTREAM where, int detail)const;
  void	   expand();
  bool	   tr_needs_eval()	{untested(); return true;}
  void	   tr_queue_eval()	{q_eval();}
  void	   tr_unload()		{untested(); tr_unload_active();}
  double   tr_involts()const
			{untested(); return dn_diff(n[IN1].v0(), n[IN2].v0());}
  COMPLEX  ac_involts()const{untested();return n[IN1].vac()-n[IN2].vac();}
  int	   numnodes()const		{return 4;}
  bool	   is_2port()const		{return true;}  
protected:
  std::string	_input_label;
  ELEMENT*	_input;
private:
  enum	{PRINTNODES = 2};
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
