/*$Id: e_aux.cc,v 15.2 1999/09/17 14:24:57 al Exp $ -*- C++ -*-
 * helper functions, etc., that sort of belong to circuit elements
 */
#ifndef E_AUX_CC
#define E_AUX_CC
#include "e_aux.h"
/*--------------------------------------------------------------------------*/
template <class T>
T port_impedance(const node_t& n1, const node_t& n2,
		 BSMATRIX<T>& mat, const T& parallel)
{
  T* zapit = new T[mat.size()+2];

  for (int ii = 0;  ii < mat.size()+2;  ++ii){
    zapit[ii] = 0.;
  }
  if (n1.m != 0)
    zapit[n1.m] =  1.;
  if (n2.m != 0)
    zapit[n2.m] = -1.;

  mat.fbsub(zapit);
  T raw_z = zapit[n1.m] - zapit[n2.m];
  delete [] zapit;
  return (parallel != 0.) 
    ? 1. / ((1./raw_z)-parallel)
    : raw_z;
}
/*--------------------------------------------------------------------------*/
#if defined(MANUAL_TEMPLATES)
  template double
  port_impedance(const node_t& a, const node_t& b,
		 BSMATRIX<double> &c, const double &d);
  template COMPLEX
  port_impedance(const node_t& a, const node_t& b,
		 BSMATRIX<COMPLEX> &c,const COMPLEX &d);
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
