/*$Id: d_trln.cc,v 15.18 1999/10/30 08:04:59 al Exp $ -*- C++ -*-
 * Transmission line. (ideal lossless.  for now, AC only)
 */
#include "ap.h"
#include "d_trln.h"
/*--------------------------------------------------------------------------*/
const double LINLENTOL = .000001;
const double default_nl = 0.25;
const double default_z0 = 50;
const char* default_z0_string = "50";
static TRANSLINE_COMMON Default_TRANSLINE(CC_STATIC);
/*--------------------------------------------------------------------------*/
TRANSLINE_COMMON::TRANSLINE_COMMON(int c)
  :COMPONENT_COMMON(c),
   z0(NOT_INPUT),
   td(NOT_INPUT),
   f(NOT_INPUT),
   nl(NOT_INPUT),
   icset(false)
{
  for (int i = 0;  i < NUM_INIT_COND;  ++i){
    ic[i] = 0.;
  }
}
/*--------------------------------------------------------------------------*/
TRANSLINE_COMMON::TRANSLINE_COMMON(const TRANSLINE_COMMON& p)
  :COMPONENT_COMMON(p),
   z0(p.z0),
   td(p.td),
   f(p.f),
   nl(p.nl),
   icset(p.icset)
{
  for (int i = 0;  i < NUM_INIT_COND;  ++i){
    ic[i] = p.ic[i];
  }
}
/*--------------------------------------------------------------------------*/
DEV_TRANSLINE::DEV_TRANSLINE()
  :ELEMENT(),
   _forward(), _reflect(),
   _if0(0), _ir0(0), _if1(0), _ir1(0)
{
  attach_common(&Default_TRANSLINE);
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::parse(CS& cmd)
{
  const TRANSLINE_COMMON* cc = prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(cc);
  TRANSLINE_COMMON* c = new TRANSLINE_COMMON(*cc);
  assert(c);

  parse_Label(cmd);
  parse_nodes(cmd,numnodes(),numnodes());
  cmd.stuck();
  do{
    cmd.get("Z0",   &c->z0);
    cmd.get("Zo",   &c->z0);
    cmd.get("TD",   &c->td);
    cmd.get("Freq", &c->f,  mPOSITIVE);
    cmd.get("Nl",   &c->nl, mPOSITIVE);
    if (cmd.pmatch("Ic")){
      untested();
      c->icset = true;
      for (int i = 0;  i < NUM_INIT_COND;  i++){
	untested();
	c->ic[i] = cmd.ctof();
      }
    }
  }while (cmd.more() && !cmd.stuck());
  cmd.check(bWARNING, "what's this?");

  if (c->z0 == NOT_INPUT){
    untested();
    error(bDANGER, short_label() + " missing Z0, assuming " 
	  + default_z0_string + "\n");
    c->z0 = default_z0;
  }
  {if (c->td != NOT_INPUT){
    // have td.  fill in the rest for show.
    {if (c->f == NOT_INPUT){
      {if (c->nl == NOT_INPUT){
	untested();
	c->nl = default_nl;
      }else{
	untested();
      }}
      c->f = c->nl / c->td;
    }else{
      {if (c->nl == NOT_INPUT){
	untested();
	c->nl = c->td * c->f;
      }else{
	{if (!conchk(c->td, c->nl/c->f, OPT::vntol)){
	  untested();
	  error(bDANGER, short_label() + " td, f&nl conflict.  using td\n");
	}else{
	  untested();
	}}
	// leave bogus values alone.
      }}
    }}
  }else{
    // try to calculate td by nl/f
    if (c->nl == NOT_INPUT){
      untested();
      c->nl = default_nl;
    }
    {if (c->f == NOT_INPUT){
      untested();
      error(bDANGER, short_label() 
	    + " neither f or td, can't determine length\n");
      // leave bogus values alone.
    }else{
      c->td = c->nl / c->f;      
    }}
  }}
  attach_common(c);
  set_converged();
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::print(OMSTREAM where, int)const
{
  const TRANSLINE_COMMON*c=prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(c);
  where << short_label();
  printnodes(where,numnodes());
  where.setfloatwidth(7)
    << "  Z0=" << c->z0
    << "  TD=" << c->td
    << "  F="  << c->f
    << "  NL=" << c->nl;
  if (c->icset){
    untested();
    where << "  IC=";
    for (int i = 0;  i < NUM_INIT_COND;  i++){
      untested();
      where << c->ic[i] << ' ';
    }
  }
  where << '\n';
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::precalc()
{
  const TRANSLINE_COMMON* c=prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(c);
  _forward.set_delay(c->td);
  _reflect.set_delay(c->td);
}
/*--------------------------------------------------------------------------*/
/* first setup, initial dc, empty the lines
 */
void DEV_TRANSLINE::tr_begin()
{
  _forward.initialize();
  _reflect.initialize();
}
/*--------------------------------------------------------------------------*/
/* before anything else .. see what is coming out
 */
void DEV_TRANSLINE::tr_advance()
{
  const TRANSLINE_COMMON* c=prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(c);
  _if0 = _forward.v_out(SIM::time0)/c->z0;
  _ir0 = _reflect.v_out(SIM::time0)/c->z0;
}
/*--------------------------------------------------------------------------*/
/* usually nothing, always converged.  It is all done in advance and accept.
 * UNLESS ... it is a very short line .. then we fake it here.
 * very short line means delay is less than internal time step.
 */
bool DEV_TRANSLINE::do_tr()
{
  // code to deal with short lines goes here.
  {if (_if0 != _if1  ||  _ir0 != _ir1){
    q_load();
  }else{
    untested();
  }}
  assert(converged());
  return true;
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::tr_load()
{
  double lvf = NOT_VALID; // load value, forward
  double lvr = NOT_VALID; // load value, reflected
  {if (!SIM::inc_mode){
    const TRANSLINE_COMMON* 
      c = prechecked_cast<const TRANSLINE_COMMON*>(common());
    assert(c);
    aa.load_symmetric(n[OUT1].m, n[OUT2].m, 1/c->z0);
    aa.load_symmetric(n[IN1].m,  n[IN2].m,  1/c->z0);
    lvf = _if0;
    lvr = _ir0;
  }else{
    lvf = dn_diff(_if0, _if1);
    lvr = dn_diff(_ir0, _ir1);
  }}
  if (lvf != 0.){
    {if (n[OUT1].m != 0){
      n[OUT1].i() += lvf;
    }else{
      untested();
    }}
    if (n[OUT2].m != 0){
      untested();
      n[OUT2].i() -= lvf;
    }
  }
  if (lvr != 0.){
    {if (n[IN1].m != 0){
      n[IN1].i() += lvr;
    }else{
      untested();
    }}
    if (n[IN2].m != 0){
      untested();
      n[IN2].i() -= lvr;
    }
  }
  _if1 = _if0;
  _ir1 = _ir0;
}
/*--------------------------------------------------------------------------*/
/* limit the time step to no larger than a line length.
 */
double DEV_TRANSLINE::tr_review()
{
  q_accept();
  const TRANSLINE_COMMON* c=prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(c);
  return SIM::time0 + c->td; // ok to miss the spikes, for now
}
/*--------------------------------------------------------------------------*/
/* after this step is all done, determine the reflections and send them on.
 */
void DEV_TRANSLINE::tr_accept()
{
  _reflect.push(SIM::time0, _forward.v_reflect(SIM::time0, tr_outvolts()));
  _forward.push(SIM::time0, _reflect.v_reflect(SIM::time0, tr_involts()));
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::tr_unload()
{
  untested();
}
/*--------------------------------------------------------------------------*/
void DEV_TRANSLINE::do_ac()
{
  const TRANSLINE_COMMON*c=prechecked_cast<const TRANSLINE_COMMON*>(common());
  assert(c);
  double lenth = SIM::freq * c->td * 4;	/* length in quarter waves */
  double dif = lenth - floor(lenth+.5);	/* avoid divide by zero if close to */
  if (fabs(dif) < LINLENTOL){		/* resonance by tweeking a little */
    error(bDEBUG,
	  long_label() + ": transmission line too close to resonance\n");
    lenth = (dif<0.) ? floor(lenth+.5)-LINLENTOL : floor(lenth+.5)+LINLENTOL;
  }
  lenth *= (kPId2);	/* now in radians */
  
  COMPLEX y12 = COMPLEX(0., -1. / (c->z0 * sin(lenth)));
  COMPLEX y11 = COMPLEX(0., tan(lenth/2) / c->z0) + y12;
  
  acx.load_symmetric(n[OUT1].m, n[OUT2].m, y11);
  acx.load_symmetric(n[IN1].m,  n[IN2].m,  y11);
  acx.load_asymmetric(n[OUT1].m,n[OUT2].m, n[IN2].m,  n[IN1].m,  y12);
  acx.load_asymmetric(n[IN1].m, n[IN2].m,  n[OUT2].m, n[OUT1].m, y12);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
