/*$Id: d_switch.h,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * data structures for voltage (and current) controlled switch
 */
#ifndef D_SWITCH_H
#define D_SWITCH_H
#include "e_model.h"
#include "e_oneport.h"
/*--------------------------------------------------------------------------*/
class MODEL_SWITCH : public MODEL_CARD {
friend class SWITCH_BASE;
private:
  explicit	MODEL_SWITCH(const MODEL_SWITCH& p) 
				:MODEL_CARD(p) {unreachable();}
public:
  explicit	MODEL_SWITCH();
private: // override virtual
  CARD*		clone()const	{untested(); return new MODEL_SWITCH(*this);}
  void		parse(CS&);
  void		print(OMSTREAM,int)const;
private:
  double    vt;		/* threshold voltage */
  double    vh;		/* hysteresis voltage */
  double    ron;	/* on resistance */
  double    roff;	/* off resistance */
  enum control_t {VOLTAGE, CURRENT};
  control_t type;	/* current or voltage controlled */
};
/*--------------------------------------------------------------------------*/
class SWITCH_COMMON : public COMPONENT_COMMON {
public:
  explicit SWITCH_COMMON(int c=0)		:COMPONENT_COMMON(c) {}
  explicit SWITCH_COMMON(const SWITCH_COMMON& p):COMPONENT_COMMON(p) {}
  const char* name()const			{untested(); return "switch";}
};
/*--------------------------------------------------------------------------*/
class SWITCH_BASE : public ONEPORT {
protected:
  explicit	SWITCH_BASE();
  explicit	SWITCH_BASE(const SWITCH_BASE& p);
  void		parse_sb(CS&,int);
  void		expand_sb();
private: // override virtual
  int	   numnodes()const	{return 4;}
  const char* dev_type()const	= 0;
  CARD*	   clone()const		= 0;
  void	   parse(CS&)		= 0;
  void     print(OMSTREAM,int)const;
  void     expand()		= 0;		
  void     precalc();

  void	   dc_begin();
  void	   tr_begin()		{dc_begin();}
  //void   tr_restore();	//CARD/nothing
  void     dc_advance()		{_previous_state = _current_state;}
  void     tr_advance()		{_previous_state = _current_state;}
  bool	   tr_needs_eval()	{untested(); return true;}
  void	   tr_queue_eval()	{q_eval();}
  bool	   do_tr();
  //void   tr_load();		//ONEPORT
  //double tr_review();		//CARD/nothing
  //void   tr_accept();		//CARD/nothing
  //void   tr_unload();		//ONEPORT
  //double tr_involts()const;	//ONEPORT

  void	    ac_begin()		{ev = y0.f1; acg = m0.c1;}
  void	    do_ac();
  //COMPLEX ac_involts()const;	//ONEPORT
protected:
  std::string	_input_label;		/*this is here instead of in Cswitch*/
  ELEMENT*	_input;		        /* due to bad design and lazyness */
private:
  enum state_t {_UNKNOWN, _ON, _OFF};
  state_t	_ic;		/* initial state, belongs in common */
  state_t	_current_state;	/* state 1 iter ago (may be bad) */
  state_t	_previous_state;/* state 1 time or step ago (known good) */
};
/*--------------------------------------------------------------------------*/
class DEV_VSWITCH : public SWITCH_BASE {
private:
  explicit  DEV_VSWITCH(const DEV_VSWITCH& p):SWITCH_BASE(p){untested();}
public:
  explicit  DEV_VSWITCH()	:SWITCH_BASE(){}
private: // override virtual
  CARD*	    clone()const	{untested();return new DEV_VSWITCH(*this);}
  void	    parse(CS& cmd)	{parse_sb(cmd,4);}
  void	    expand()		{expand_sb();}
  const char* dev_type()const	{return "vswitch";}
};
/*--------------------------------------------------------------------------*/
class DEV_CSWITCH : public SWITCH_BASE {
private:
  explicit  DEV_CSWITCH(const DEV_CSWITCH& p) :SWITCH_BASE(p){untested();}
public:
  explicit  DEV_CSWITCH()	:SWITCH_BASE(){}
private: // override virtual
  CARD*	    clone()const	{untested();return new DEV_CSWITCH(*this);}
  void	    parse(CS& cmd)	{parse_sb(cmd,2);}
  void	    expand();
  const char* dev_type()const	{return "iswitch";}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
