//  UUXKinput.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//
#include "UUXKinput.h"

UUXKinput::UUXKinput (UTop* top_, UWidgetX* uwidgetIn) : 
	UXKinput (uwidgetIn)
{
	int	i;

	for (i=0; i<U_MAX_EVENT; i++)
	{
		handlers[i] = False;
	}
	top = top_;
}

UUXKinput::~UUXKinput()
{
	int	i;
	uEnd ();
	for (i=0; i<U_MAX_EVENT; i++)
	{
		if (handlers[i] == True) removeEventHandler ((UInputEvent)i);
	}
}

void
UUXKinput::addEventHandler (const UInputEvent eventType)
{
	switch (eventType)
	{
	case	UPROPERTY_CHANGE:
		if (handlers[eventType] == True) return;
		top->addEventHandler (this, PropertyNotify);
		// HERE
		handlers[eventType] = True;
		break;
	case 	UNO_EVENT:
		if (handlers[eventType] == True) return;
		top->addEventHandler (this, NoEventMask);
		// HERE
		handlers[eventType] = True;
		break;
	default:
		cerr << "error: UUXKinput::addEventHandler unknown event type"
			<< eventType << ".\n";
	}
	return;
}

void
UUXKinput::removeEventHandler (const UInputEvent eventType)
{
	switch (eventType)
	{
	case	UPROPERTY_CHANGE:
		if (handlers[eventType] == False) return;
		top->removeEventHandler (this, PropertyNotify);
		// HERE
		handlers[eventType] = False;
		break;
	case 	UNO_EVENT:
		if (handlers[eventType] == False) return;
		top->removeEventHandler (this, NoEventMask);
		// HERE
		handlers[eventType] = False;
		break;
	default:
		cerr << "error: UUXKinput::removeEventHandler unknown event type"
			<< eventType << ".\n";
	}
	return;
}

void
UUXKinput::getEvent (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::X:
		if (handlers[UPROPERTY_CHANGE] == True)
		{
			if (event->xevent.xany.type == PropertyNotify)
			{
				propertyChangeHandler (&event->xevent);
			}
		}
		if (handlers[UNO_EVENT] == True)
		{
			if (event->xevent.xany.send_event)
			{
				noEventHandler (&event->xevent);
			}
		}
#if 0
		if (event->xevent.xany.type == PropertyNotify)
		{
//			propertyChangeHandler (&event->xevent);
cerr << "Got propchange\n";
		}
		else if (event->xevent.xany.send_event)
		{
//			noEventHandler (&event->xevent);
cerr << "Got noevent\n";
		}
		break;
#endif
	default:
		break;
	}
}

