//  UPopUp.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __upopup_h__
#define __upopup_h__

#include "UShell.h"
#include "UPopUp.h"
#include "UMenu.h"
#include "UTextMenu.h"

//
// It consists of a button and a shell width buttons.
// Note that only the cascade button will be the child of parent.
// This frame can be used to add components to it.
//
class UPopUp : public UShell
{
public:
	enum	UStatus	{OK, ERROR};

			UPopUp (UFrame* parent_, UComponent* cascade_, 
				int frameSize_=2);

			// Text only version
			UPopUp (UFrame* parent_, const char* name_,
				const char* text_=0,
				UMenu::UMenuLeft left_=UMenu::NO_LEFT,
				UMenu::UMenuArrow arrow_=UMenu::NO_ARROW ,
				int frameSize_=2);
				
	virtual		~UPopUp ();

	//virtual void	eventUp (UEvent* event);
	//virtual void	eventDown (UEvent* event);
	
	// This is the only guys who's parent is parent_
	UComponent*	cascade; 

	// This makes sure the position is allright.
	UStatus		addMenuItem (UComponent* item, int pos=-1);
	UStatus		deleteMenuItem (UComponent* item);
	virtual void	addChild (UComponent* child);
	virtual void	deleteChild (UComponent* child);

	// This will call deleteThis also!
	UStatus		deleteMenuPos (int pos=-1);

	void		packItems ();

	int		highlightItem (int x, int y);
	int		unhighlightItem ();
	//virtual void	resize (int w, int h);
	int 		getSelected (UPopUp** selectedPopUp, 
				UComponent** selectedItem, int*	selectedPos);
	virtual void	hide ();
	void		uncheckAllItems ();
	void		checkItemPos (int	pos);
	UComponent*	itemAt (int pos);
	int		getSize() { return itemSize; }
	virtual void	setFont (UFont *font);

	virtual int	isA (UComponent::UType type);
protected:
	int		itemSize;
	int		highlightedItem;
	UComponent**	item;
	UComponent*	realParent;
	UPopUp*		poppedUp;
};

#endif /* __upopup_h__ */
