//  UPopUp.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UPopUp.h"
#include "UMenuBar.h"
#include "UChoice.h"

UPopUp::UPopUp (UFrame* parent_, UComponent* cascade_, int frameSize_) : 
	UShell ((UTop*) parent_->top, parent_, frameSize_)
{
	realParent = parent_;
	highlightedItem = -1;
	UMenuItem*	menuItem;

	if (realParent->isA (UComponent::MENUBAR))
	{
		((UMenuBar*)realParent)->addMenuItem (this);
	}
	else if (realParent->isA (UComponent::CHOICE))
	{
		((UChoice*)realParent)->addMenuItem (this);
	}
	else if ( !realParent->isA (UComponent::POPUP))
	{
		cerr << "warn: popup can be added to menubar or popup only.\n";
	}

	menuItem = (UMenuItem*) cascade->getMenu();
	if (menuItem==0)
	{
		cerr << "error: cascase does not have a menu.\n";
		cascade = 0;
	}
	else
	{
		cascade = cascade_;
	}

	if (menuItem) menuItem->setPopUp (this);
	if (cascade) cascade->select (ButtonPressMask | ButtonReleaseMask);
	font = parent_->getFont();
	poppedUp = 0;
	itemSize = 0;
	item = 0;
	
}

//
// Create a menu with a text cascade button
//
UPopUp::UPopUp (UFrame* parent_, 
	const char* name_, 
	const char* text_, 
	UMenu::UMenuLeft left_,
	UMenu::UMenuArrow arrow_,
	int frameSize_):
	UShell ((UTop*) parent_->top, parent_, frameSize_)
{
	UMenuItem*	menuItem;

	realParent = parent_;
	highlightedItem = -1;
	cascade = new UTextMenu (parent_, name_, text_, left_, arrow_);
	if (realParent->isA (UComponent::MENUBAR))
	{
		((UMenuBar*)realParent)->addMenuItem (this);
	}
	else if (realParent->isA (UComponent::CHOICE))
	{
		((UChoice*)realParent)->addMenuItem (this);
	}
	else if ( !realParent->isA (UComponent::POPUP))
	{
		cerr << "warn: popup can be added to menubar or popup only.\n";
	}
	menuItem = (UMenuItem*) cascade->getMenu();
	if (menuItem==0)
	{
		cerr << "error: cascase does not have a menu.\n";
		delete cascade;
		cascade = 0;
	}
	if (menuItem) menuItem->setPopUp (this);
	font = parent_->getFont();
	poppedUp = 0;
	itemSize = 0;
	item = 0;
}

UPopUp::~UPopUp ()
{
	int		i;
	UPopUp*		pup;
	UMenuItem*	menuItem;

	// delete all cascade menus
	for (i=0; i<itemSize; i++)
	{
		if (item[i] ==0) continue;
		// get the selected value here!!
		menuItem = (UMenuItem*) item[i]->getMenu();
		if (menuItem)
		{
			pup = (UPopUp*) menuItem->getPopUp();
			if (pup!=0 && pup!=this) delete pup;
		}
	}
	if (item) delete item;

	// menu items are autodelete
	if (cascade) delete cascade; 
	if (realParent->isA (UComponent::MENUBAR))
	{
		((UMenuBar*)realParent)->deleteMenuItem (this);
	}
	else if (realParent->isA (UComponent::CHOICE))
	{
		((UChoice*)realParent)->deleteMenuItem (this);
	}
	if (realParent->isA (UComponent::POPUP))
	{
		((UPopUp*)realParent)->deleteMenuItem (this);
	}
}

void
UPopUp::addChild (UComponent* child)
{
	children.addItem ( child->window, child);
	addMenuItem (child);
}

void
UPopUp::deleteChild (UComponent* child)
{
	deleteMenuItem (child);
	children.deleteItem (child->window, child);
}

void
UPopUp::hide ()
{
	UMenuItem*	menuItem;
	// get the selected value here!!
	if (cascade)
	{
		menuItem = (UMenuItem*) cascade->getMenu();
		if (menuItem) menuItem->unhighlight();
	}
	unhighlightItem();
	if (poppedUp) poppedUp->hide();
	poppedUp=0;
	UShell::hide ();
}

void
UPopUp::packItems()
{
	int		i;
	int		height;
	int		width;
	UBestSize 	bs;
	UMenuItem*	menuItem;
	UPopUp*		pop;

	// Determine who is the widest...
	width = 0;
	for (i=0; i<itemSize; i++)
	{
		if (item[i]==0) continue;
		menuItem = (UMenuItem*) item[i]->getMenu();
		if (menuItem!=0)
		{
			pop = (UPopUp*) menuItem->getPopUp();
			if (pop != 0) pop->packItems();
		}
		bestSize = item[i]->getBestSize();
		if (bestSize.width > width)
		{
			width = bestSize.width;
		}
	}
	// place the items one after the other
	height = frameSize;
	for (i=0; i<itemSize; i++)
	{
		if (item[i]==0) continue;
		bs = item[i]->getBestSize();
		item[i]->place (frameSize, height, 
			frameSize, -(height+bs.height));
		height += bs.height;
	}
	bestSize.width = width + 4 * frameSize;
	bestSize.height = height + frameSize;
	//resize (bestSize.width, bestSize.height);
	rectangle.width = bestSize.width;
	rectangle.height = bestSize.height;
	XResizeWindow (UTOP->display, window, bestSize.width, bestSize.height);
}

UPopUp::UStatus
UPopUp::deleteMenuPos (int pos)
{
	int	i;
	if (pos > 0 && pos < itemSize)
	{
		if (item[pos] == 0) return ERROR;
		delete item[pos];
		item[pos]=0;
		return OK;
	}
	for (i=itemSize; i>=0; i++)
	{
		if (item[i] == 0) continue;
		delete item[i];
		item[i]=0;
		return OK;
	}
	return ERROR;
}

UPopUp::UStatus
UPopUp::deleteMenuItem (UComponent *item_)
{
	int		i;

	if (!item_->isA (UComponent::COMPONENT))
	{
		return ERROR;
	}
	for (i=0; i<itemSize; i++)
	{
		if (item[i] == item_)
		{
			item[i]=0;
			return OK;
		}
	}
	return ERROR;
}

UPopUp::UStatus
UPopUp::addMenuItem (UComponent* item_, int pos)
{
	UComponent**	newArray;
	int		newSize;
	int		i;

	if (!item_->isA (UComponent::COMPONENT))
	{
		return ERROR;
	}
	newSize = (pos < 0) ? itemSize +1 : pos + 1;
	if (newSize <= itemSize)
	{
		item[pos] = item_;
		return OK;
	}
	newArray = new UComponent* [newSize];
	if (newArray==0) return ERROR;
	if (itemSize>0)
	{
		memcpy (newArray, item, sizeof (UComponent*) * itemSize);
		delete item;
	}
	for (i=itemSize; i< newSize; i++) newArray[i] = 0;
	itemSize = newSize;
	item = newArray;
	item[itemSize-1] = item_;
	return OK;
}

#if 0
void
UPopUp::resize (int w, int h)
{
	UFrame::resize (w, h);
}
#endif

int
UPopUp::getSelected (UPopUp** selectedPopUp, 
	UComponent** selectedItem, int*	selectedPos)
{
	if (highlightedItem<0) return 0;
	if (poppedUp)
	{
		// have to query the popped up cascade.
		return poppedUp->getSelected (selectedPopUp,
			selectedItem, selectedPos);
	}
	*selectedPopUp = this;
	*selectedItem = item[highlightedItem];
	*selectedPos = highlightedItem;
	return 1;
}

//
// x and y is root coord
int
UPopUp::highlightItem (int x_, int y_)
{
	UPlacement		pl;
	UComponent*		comp;
	int			i;
	int			x, y;
	UMenu::UMenuArrow	arrow;
	UMenuItem*		menuItem;
	int			rootX;
	int			rootY;
	Window			w;

	if (itemSize==0) return -1;
	x = x_-rectangle.x; y = y_-rectangle.y;
	if (y<0  || y > rectangle.height
		|| x<0 || x > rectangle.width)
	{
		if (poppedUp)
		{
			return poppedUp->highlightItem(x_, y_);
		}
		else
		{
			unhighlightItem();
		}
		return -1;
	}
	// find out which item to highlight
	for (i=itemSize-1; i>=0; i--)
	{
		if (item[i] == 0) continue;
		if (item[i]->isA (UComponent::SEPARATOR)) continue;
		if (!item[i]->getMenu ()) continue;
		pl = item[i]->getPlacement();
		if (pl.edges[UPlacement::NORTH]<y) break;
	}
	// This contains only seperators.
	if (i==highlightedItem) return highlightedItem;
	if (poppedUp) poppedUp->hide ();
	poppedUp=0;
	unhighlightItem();
	if (i<0) return -1;
	unhighlightItem ();
	highlightedItem = i;
	menuItem = (UMenuItem*) item[highlightedItem]->getMenu();
	if (menuItem)
	{
		menuItem->highlight ();
		comp = menuItem->getPopUp ();
		if (comp!=0 && comp->isA(UComponent::POPUP)) poppedUp = (UPopUp*) comp;
		arrow = menuItem->getArrow ();
		// This is a popup.
		if (poppedUp)
		{
			if (arrow==UMenu::DOWN)
			{
				XTranslateCoordinates (top->display,
				   item[highlightedItem]->window, top->root,
				   -frameSize, 
				    item[highlightedItem]->rectangle.height+frameSize, 
				   &rootX, &rootY, &w);
			}
			else
			{
				XTranslateCoordinates (top->display,
				   item[highlightedItem]->window, top->root,
				   item[highlightedItem]->rectangle.width+
					frameSize, -frameSize,
				   &rootX, &rootY, &w);
			}
			poppedUp->move (rootX, rootY);
			poppedUp->show();
		}
	}
	return 0;
}

int
UPopUp::unhighlightItem ()
{
	int	retVle;
	if (highlightedItem < 0) return -1;
	UMenuItem* menuItem = (UMenuItem*) item[highlightedItem]->getMenu();
	if (menuItem) menuItem->unhighlight ();
	retVle = highlightedItem;
	highlightedItem = -1;
	return retVle;
}

int
UPopUp::isA (UComponent::UType type_)
{
	if (type_ == UComponent::POPUP) return 1;
	return UShell::isA (type_);
}

void
UPopUp::uncheckAllItems()
{
	int		i;
	UMenuItem*	menuItem;

	for (i=itemSize-1; i>=0; i--)
	{
		if (item[i] == 0) continue;
		if (item[i]->isA (UComponent::SEPARATOR)) continue;
		if (!(menuItem=(UMenuItem*)item[i]->getMenu ())) continue;
		menuItem->uncheck ();
	}
	return;
}

void
UPopUp::checkItemPos(int pos)
{
	UMenuItem*	menuItem;
	if (itemSize <= pos || pos < 0) return;
	if (item[pos] == 0) return;
	if (item[pos]->isA (UComponent::SEPARATOR)) return;
	if (!(menuItem=(UMenuItem*)item[pos]->getMenu ())) return;
	menuItem->check ();
}

UComponent*
UPopUp::itemAt(int pos)
{
	if (itemSize <= pos || pos < 0) return 0;
	if (item[pos] == 0) return 0;
	return item[pos];
}

void
UPopUp::setFont (UFont* font_)
{
	int		i;
	UComponent*	comp;
	UPopUp*		p;
	UMenuItem*	menuItem;

	for (i=0; i<itemSize; i++)
	{
		if (item[i]==0) continue;
		comp = item[i];
		comp->setFont(font_);
		menuItem = (UMenuItem*) comp->getMenu();
		if (menuItem==0) continue;
		p = (UPopUp*) menuItem->getPopUp();
		if (p==0) continue;
		p->setFont(font_);
	}
	font = font_;
}
