//  UComponent.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __ucomponent_h__
#define __ucomponent_h__

#include <X11/Xlib.h>
#include "UEvent.h"
#include "UColor.h"
#include "UTopContext.h"
#include <UFont.h>
#include "UMenu.h"

#define UTOP ((UTop*)top)

// Geometry managers can "work" on this data.
// Now ther is no geometry management, so we have to 
// set these values manually.
class UBestSize
{
public:
					UBestSize (void);
					~UBestSize ();

	int				width;	
	int				height;	

};

class UPlacement
{
public:
	enum UEdgeGap	{GAP=2};
	enum USide	{NORTH, SOUTH, EAST, WEST, USIDE_MAX };
	enum UStyle	{PLACE, POSITION};
			UPlacement (void);
			~UPlacement ();

	void		place (USide side, int p);
	void		place (int w, int n, int e, int s);
	void		position (USide side, int p);
	void		position (int w, int n, int e, int s);

	// Manager manipulates these
	short		margin;
	// You should consiger edgeGap
	short		edges[USIDE_MAX];
	char		flags[USIDE_MAX];
	
};

class UComponent
{
public:
	enum UType		{COMPONENT, SHELL, FRAME, ARROW, BUTTON, 
					POPUP, MENUBAR, CHOICE, SEPARATOR,
					SCROLL, TEXT_FRAME, TEXT_AREA,
					TEXT_LABEL, TEXT_BUTTON, TEXT_LIST,
					MENU, TEXT_MENU, CASCADE,
					MENU_ITEM, MAX_CTYPE};
				UComponent(UTopContext* topLevel, 	
					Display* display);
	virtual			~UComponent();
	virtual void 		eventUp (UEvent* event);
	virtual void 		eventDown (UEvent* event);
	const UColor&		getBackground ();
	virtual void		setBackground (const UColor &color);

	const UColor&		getForeground ();
	virtual void		setForeground (const UColor &color);

	// The font is actually constant
	virtual void 		setFont (UFont* font);
	UFont*			getFont ();

	virtual void		resize (int width, int height);
	virtual void		move (int x, int y);
	virtual void		redraw (int x, int y, int width, int height);
	virtual int		isShown(UComponent* parent_);
	virtual UComponent*	getParent ();
	virtual void		setMargin(int m) { placement.margin=m; }
	

	virtual const UBestSize& 	getBestSize();
	const UPlacement&		getPlacement ();
	void			place (UPlacement::USide side, int p);
	void			place (int w, int n, int e, int s);
	void			position (UPlacement::USide side, int p);
	void			position (int w, int n, int e, int s);

	void			select (long masks);

	Window			window;
	UTopContext*		top;
	XRectangle		rectangle;
	virtual void		clearSelection ();
	virtual int		isA (UComponent::UType type);
	virtual UMenu*		getMenu() { return 0;}
protected:

	UPlacement		placement;
	UBestSize		bestSize;
	UFont*			font;
	long			masks;
	UColor			background;
	UColor			foreground;
};

class UMenuItem : public UMenu
{
public:
			UMenuItem (UComponent* parent_, 
				UMenuLeft left, UMenuArrow arrow);	
	virtual		~UMenuItem();	


	void		setPopUp (UComponent* popUp);
	UComponent*	getPopUp () { return popUpLink; }
	virtual void	highlight();
	virtual void	unhighlight();
	virtual void	check();
	virtual void	uncheck();
protected:
	UComponent*	parent;
	UComponent*	popUpLink;
};

#endif /* __ucomponent_h__ */
