//  UColor.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UColor.h"
#include "UBinArray.h"
#include "iostream.h"
#include <memory.h>
#include <strings.h>

// For some poor guys...
static char* rgbTxt[] = {
	"white", 	"#FFFFFF",
	"black", 	"#000000",
	"darkGray", 	"#A9A9A9",
	"gray", 	"#BEBEBE",
	"lightGray", 	"#D3D3D3",
	"red", 		"#FF0000",
	"green", 	"#00FF00",
	"blue", 	"#0000FF",
	"cyan", 	"#00FFFF",
	"magenta", 	"#FF00FF",
	"yellow", 	"#FFFF00",
	"darkRed", 	"#8B0000",
	"darkGreen", 	"#006400",
	"darkBlue", 	"#00008B",
	"darkCyan", 	"#008B8B",
	"darkMagenta", 	"#8B008B",
	"darkYellow", 	"#8B8B00",
	"metal", 	"#AFB49F",
	0, 0
};
	


// BUG:
// Later we should care about freeing up UDisplayCache items
// in this array (exit)
UBinArray	displayCache;

UDisplayCache::UDisplayCache (Display* display_)
{
	display = display_;
	screen = XDefaultScreen (display);
	visual = DefaultVisual (display, screen);

	// Get the colormap.
	colormap = XDefaultColormap (display, screen);
	cellCount = XDisplayCells (display, screen);
}

UDisplayCache::~UDisplayCache ()
{
	XFree (visual);
}

UColor::UColor (void)
{
	display = 0;
}

//
// The color should be initialized
UColor::UColor (Display *display_)
{
	display = display_;
}

UColor::UColor (const UColor& color)
{
	display = color.display;
	pixel = color.pixel;
	rgb = color.rgb;
}

UColor::~UColor()
{
}

UColor&
UColor::operator= (const UColor& color)
{
	display = color.display;
	pixel = color.pixel;
	rgb = color.rgb;
	return *this;
}

UColor&
UColor::operator= (const char* color)
{
	UDisplayCache*	dcache;
	XColor		scolor;

	if (display == 0)
	{
		cerr << "error: UColor::operator= color is no initialized.\n";
		return *this;
	}
	// Get the pixel value...

	// get the rish cache, calculate rgb value, try cache, allocate.
	dcache = (UDisplayCache*) displayCache.findItem (
			(unsigned long) display);
	if (dcache == 0)
	{
		dcache = new UDisplayCache (display);
		displayCache.addItem ((unsigned long) display, dcache);
	}

	if (XParseColor (display, dcache->colormap, color, &scolor)==0)
	{
		// color hack we should know at least our default colors.
		int i; 
		for (i=0; rgbTxt[i]!=0; i=i+2)
		{
			if (strcasecmp (rgbTxt[i], color)==0 &&
				XParseColor (display, dcache->colormap, 
					rgbTxt[i+1], &scolor)!=0) break;
		}
		if (rgbTxt[i]==0) 
		{
			cerr << "warn: unknown color '" << color << "'.\n";
			assign (0, 0, 0);
			return *this;
		}
	}
	assign (scolor.red, scolor.green, scolor.blue);
	return *this;
}

void
UColor::lighter (int damp)
{
	unsigned short r, g, b;

	r = (rgb >> 16) & 0xff; g = (rgb >> 8) & 0xff; b =  rgb & 0xff;
	r += r>>damp; g += g>>damp; b += b>>damp;
	if (r>255) r=255; if (g>255) g=255; if (b>255) b=255;
	assign (r<<8, g<<8, b<<8);
}

void
UColor::darker (int damp)
{
	unsigned short r, g, b;

	r = (rgb >> 16) & 0xff; g = (rgb >> 8) & 0xff; b =  rgb & 0xff;
	r -= r>>damp; g -= g>>damp; b -= b>>damp;
	// usigned 
	if (r>255) r=0; if (g>255) g=0; if (b>255) b=0;
	assign (r<<8, g<<8, b<<8);
}

void
UColor::assign (unsigned short r, unsigned short g, unsigned short b)
{
	UDisplayCache*	dcache;
	XColor		scolor;
	XColor*		pcolor;
	unsigned long	rgbGot;

	if (display == 0)
	{
		cerr << "error: UColor::operator= color is no initialized.\n";
		return;
	}
	// Get the pixel value...

	// get the rish cache, calculate rgb value, try cache, allocate.
	dcache = (UDisplayCache*) displayCache.findItem (
			(unsigned long) display);
	if (dcache == 0)
	{
		dcache = new UDisplayCache (display);
		displayCache.addItem ((unsigned long) display, dcache);
	}

	scolor.red=r;
	scolor.green=g;
	scolor.blue=b;
	
	// we go with 8 bit rgb. should be good enough for this widget set :)
	rgbGot = ((scolor.red & 0xff00) << 8) 
		| (scolor.green & 0xff00) | ((scolor.blue & 0xff00)>>8);

	pcolor = (XColor*) dcache->cache.findItem ((unsigned long) rgbGot);
	if (pcolor == 0)
	{
		pcolor = allocateColor (dcache, &scolor, rgbGot);
		if (pcolor==0) return;
		dcache->cache.addItem ((unsigned long) rgbGot, pcolor);
		pixel = pcolor->pixel;
		rgb = rgbGot;
		return;
	}
	pixel = pcolor->pixel;
	rgb = rgbGot;
	return;
}

XColor *
UColor::allocateColor (UDisplayCache* dcache, XColor* color, unsigned long key)
{
	XColor		scol;
	XColor* 	retVle;
	XColor*		colors;
	char*		flags;

	unsigned long	r,g,b;
	int		bestMatch;
	unsigned long	bestDistance;
	unsigned long	d;
	int		i;
	
	scol = *color;
	if (dcache->visual->c_class != PseudoColor)
	{
		if (XAllocColor (dcache->display, dcache->colormap, &scol)==0)
		{
			return 0;
		}
		retVle = new XColor[1];
		*retVle = scol;
		return retVle;
	}
	if (XAllocColor (dcache->display, dcache->colormap, &scol)!=0)
	{
		retVle = new XColor[1];
		*retVle = scol;
		return retVle;
	}
	// Fuzzy logic to get "some" good color. 
	if (dcache->cellCount<=0) return 0;

	colors = new XColor [dcache->cellCount];
	flags = new char [dcache->cellCount];
	if (colors==0 || flags ==0) return 0;

	memset (flags, 0, dcache->cellCount);

	// Find best match
	for (i=0; i<dcache->cellCount; i++)
	{
		colors[i].pixel = i;
	}
	while (1)
	{
		XQueryColors (dcache->display, dcache->colormap,
			colors, dcache->cellCount);
		
		bestMatch = -1;
		bestDistance =  0;
		for (i=0; i<dcache->cellCount; i++)
		{
			if (flags[i]) continue;

			r = (colors[i].red>>2)-(color->red>>2);
			g = (colors[i].green>>2)-(color->green>>2);
			b = (colors[i].blue>>2)-(color->blue>>2);
			d = r*r+g*g+b*b;
			if (bestMatch<0 || d< bestDistance)
			{
				bestDistance = d;
				bestMatch = i;
			}
		}
		if (bestMatch<0) break;
		scol = colors[bestMatch];
		if (XAllocColor (dcache->display, dcache->colormap, &scol)!=0)
		{
			break;
		}
		// can not use this cell
		flags[i] = 1;
	}

	delete colors;
	delete flags;

	if (bestMatch<0)
	{
		// No way to get any colors. All cells are private
		return 0;
	}
	retVle = new XColor[1];
	*retVle = scol;
	return retVle;
}

