#   include	"config.h"

#   include	<bitmap.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<debugon.h>

int bmSelect(	unsigned char **		pBuffer,
		BitmapDescription *		bdOut,
		const unsigned char *		inputBuffer,
		const BitmapDescription *	bdIn,
		int				x0,
		int				y0,
		int				wide,
		int				high		)
    {
    BitmapDescription	bd;
    int			bytesPerRow;
    int			originBit;
    int			originByte;
    unsigned char *	buffer;
    int			row;

    /************************************************************/
    /*  Derive properties of output bitmap from input.		*/
    /************************************************************/
    bmCopyDescription( &bd, bdIn );
    bd.bdPixelsHigh= high;
    bd.bdPixelsWide= wide;
    bytesPerRow= ( bd.bdBitsPerPixel* bd.bdPixelsWide+ 7 )/ 8;
    bd.bdBytesPerRow= bytesPerRow;
    bd.bdBufferLength= high* bytesPerRow;

    /************************************************************/
    /*  How many bits to shift?					*/
    /************************************************************/
    originBit=  ( x0* bdIn->bdBitsPerPixel )% 8;
    originByte= ( x0* bdIn->bdBitsPerPixel )/ 8;

    /************************************************************/
    /*  Allocate new buffer.					*/
    /************************************************************/
    buffer= (unsigned char *)malloc( bd.bdBufferLength );
    if  ( ! buffer )
	{ LLDEB(bd.bdBufferLength,buffer); return -1;	}

    if  ( originBit == 0 )
	{
	for ( row= 0; row < high; row++ )
	    {
	    memcpy( buffer+ row* bytesPerRow, inputBuffer+
		    ( row+ y0 )* bdIn->bdBytesPerRow+ originByte, bytesPerRow );
	    }
	}
    else{
	int	rightShift= 8- originBit;

	for ( row= 0; row < high; row++ )
	    {
	    int				byte;
	    unsigned char *		to;
	    const unsigned char *	from;

	    to= buffer+ row* bytesPerRow;
	    from= inputBuffer+ ( row+ y0 )* bdIn->bdBytesPerRow+ originByte;

	    for ( byte= 1; byte < bytesPerRow; byte++ )
		{
		*to= *(from++) << originBit;
		*(to++) |= *from >> rightShift;
		}
	    *to= *from << originBit;
	    }
	}

    *pBuffer= buffer;
    *bdOut= bd;

    return 0;
    }
