#   include	"config.h"

#   include	"bmintern.h"
#   include	<limits.h>
#   include	<float.h>
#   include	<debugon.h>

/************************************************************************/
/*  Expand a palette from one buffer to another one. Do it in such a	*/
/*  way ( reverse order ) that it works with from == to.		*/
/************************************************************************/
#   define	setBytes(t,p,f)	\
    { *(t--)= p[f].rgb8Red; *(t--)= p[f].rgb8Green; *(t--)= p[f].rgb8Blue; }
#   define	setAlpha(t,p,f)	\
    { *(t--)= (f)?0xff:0x00; }

void bmExpandRGB8Palette(	unsigned char *		to,
				const unsigned char *	from,
				int			pixelsWide,
				int			bitsPerPixel,
				RGB8Color *		palette,
				int			hasAlpha	)	
    {
    unsigned char	f1, f2;

    if  ( hasAlpha )
	{ to += ( 32*           pixelsWide - 1 )/8; }
    else{ to += ( 24*           pixelsWide - 1 )/8; }
    from +=     ( bitsPerPixel* pixelsWide - 1 )/8;

    switch( bitsPerPixel )
	{
	case	16:
	    if  ( ! hasAlpha )
		{ LLDEB(bitsPerPixel,hasAlpha); return; }

	    while( pixelsWide > 0 )
		{
		*(to--)= *(from--);
		f1= *(from--);
		setBytes(to,palette,f1);
		pixelsWide--;
		}
	    break;
	case	8:
	    if  ( hasAlpha )
		{
		while( pixelsWide > 0 )
		    {
		    f1= *(from--);
		    *(to--)= ( ( f1 & 0x0f ) << 4 ) | ( f1 & 0x0f );
		    f2= ( f1 >> 4 ) & 0x0f;	setBytes(to,palette,f2);
		    pixelsWide--;
		    }
		}
	    else{
		while( pixelsWide > 0 )
		    {
		    f1= *(from--);
		    setBytes(to,palette,f1);
		    pixelsWide--;
		    }
		}
	    break;
	case	4:
	    if  ( hasAlpha )
		{ LDEB(hasAlpha); return;	}
	    while( pixelsWide > 0 )
		{
		f1= *(from--);
		f2=   f1        & 0x0f;	setBytes(to,palette,f2);
		f2= ( f1 >> 4 ) & 0x0f;	setBytes(to,palette,f2);
		pixelsWide -= 2;
		}
	    break;
	case	2:
	    if  ( hasAlpha )
		{
		while( pixelsWide > 0 )
		    {
		    f1= *(from--);
		    f2=   f1        & 0x01;	setAlpha(to,palette,f2);
		    f2= ( f1 >> 1 ) & 0x01;	setBytes(to,palette,f2);
		    f2= ( f1 >> 2 ) & 0x01;	setAlpha(to,palette,f2);
		    f2= ( f1 >> 3 ) & 0x01;	setBytes(to,palette,f2);
		    f2= ( f1 >> 4 ) & 0x01;	setAlpha(to,palette,f2);
		    f2= ( f1 >> 5 ) & 0x01;	setBytes(to,palette,f2);
		    f2= ( f1 >> 6 ) & 0x01;	setAlpha(to,palette,f2);
		    f2= ( f1 >> 7 ) & 0x01;	setBytes(to,palette,f2);
		    pixelsWide -= 4;
		    }
		}
	    else{
		while( pixelsWide > 0 )
		    {
		    f1= *(from--);
		    f2=   f1        & 0x03;	setBytes(to,palette,f2);
		    f2= ( f1 >> 2 ) & 0x03;	setBytes(to,palette,f2);
		    f2= ( f1 >> 4 ) & 0x03;	setBytes(to,palette,f2);
		    f2= ( f1 >> 6 ) & 0x03;	setBytes(to,palette,f2);
		    pixelsWide -= 4;
		    }
		}
	    break;
	case	1:
	    while( pixelsWide > 0 )
		{
		f1= *(from--);
		f2=   f1        & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 1 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 2 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 3 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 4 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 5 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 6 ) & 0x01;	setBytes(to,palette,f2);
		f2= ( f1 >> 7 ) & 0x01;	setBytes(to,palette,f2);
		pixelsWide -= 8;
		}
	    break;
	default:
	    LDEB(bitsPerPixel); return;
	}

    return;
    }
