/************************************************************************/
/*									*/
/*  Print Dialog.							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Frame.h>
#   include	<Xm/DrawingA.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/PanedW.h>

#   include	<appFrame.h>
#   include	"appUnit.h"
#   include	"appGeoString.h"
#   include	"appPaper.h"

#   include	"appUtil.h"

/************************************************************************/
/*  Represents a print tool.						*/
/************************************************************************/
#   define	FILEL	400

typedef struct AppPrintDialog
    {
    Widget			apdTopWidget;
    Widget			apdDialog;

    Widget			apdPrintButton;
    Widget			apdCancelButton;

    Widget			apdPrinterPulldown;
    Widget			apdPrinterMenu;

    Widget			apdFaxNumberText;

    int				apdPrinterCount;
    int				apdDestinationChosen;

    int				apdActivateFaxOptions;
    int				apdFileDestination;
    int				apdFaxDestination;

    void *			apdTarget;
    int				apdResponse;

    char *			apdPrinterText;
    char *			apdNoneText;
    char *			apdCancelText;
    char *			apdPrintText;
    char *			apdPrintToFileText;

    char *			apdFaxText;
    } AppPrintDialog;

static AppPrintDialog *	APP_PrintDialog;

# define xx(x)	x,x

static XtResource APP_PrintDialogresourceTable[]=
    {
	{ xx("printDialogPrinter"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdPrinterText),
		    XtRString, "Printer" },
	{ xx("printDialogNone"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdNoneText),
		    XtRString, "None" },
	{ xx("printDialogCancel"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdCancelText),
		    XtRString, "Cancel" },
	{ xx("printDialogPrint"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdPrintText),
		    XtRString, "Print" },
	{ xx("printDialogPrintToFile"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdPrintToFileText),
		    XtRString, "Print to File" },

	{ xx("printDialogFax"), XtRString, sizeof(char *),
		    offsetof(AppPrintDialog,apdFaxText),
		    XtRString, "Fax" },
    };

static void appPrintDialogShowPrinter(	AppPrintDialog *	apd )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    XtVaGetValues( apd->apdPrinterPulldown,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( apd->apdDestinationChosen >= 0		&&
	  apd->apdDestinationChosen < (int)childCount	)
	{
	XtVaSetValues( apd->apdPrinterMenu,
			XmNmenuHistory,	children[apd->apdDestinationChosen],
			NULL );
	}
    else{
	XtVaSetValues( apd->apdPrinterMenu,
			    XmNmenuHistory,	(Widget)0,
			    NULL );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Fax number changed.							*/
/*									*/
/************************************************************************/

static void appPrintCheckFaxNumber(	AppPrintDialog *	apd )
    {
    char *	faxNumber;
    char *	s;

    s= faxNumber= XmTextGetString( apd->apdFaxNumberText );

    while( *s == ' ' )
	{ s++;	}

    XtSetSensitive( apd->apdPrintButton, *s != '\0' );

    XtFree( faxNumber );

    return;
    }

static void appPrintFaxChanged(	Widget		w,
				XtPointer	voidapd,
				XtPointer	call_data )
    {
    AppPrintDialog *	apd= (AppPrintDialog *)voidapd;

    appPrintCheckFaxNumber( apd );

    return;
    }

/************************************************************************/
/*									*/
/*  A printer was chosen.						*/
/*									*/
/************************************************************************/

static void appPrinterAdaptToDestination(	AppPrintDialog *	apd )
    {
    if  ( apd->apdDestinationChosen == apd->apdFaxDestination )
	{
	if  ( apd->apdFaxNumberText )
	    {
	    appEnableText( apd->apdFaxNumberText, 1 );

	    appPrintCheckFaxNumber( apd );
	    }
	}
    else{
	if  ( apd->apdFaxNumberText )
	    {
	    appEnableText( apd->apdFaxNumberText, 0 );
	    }

	XtSetSensitive( apd->apdPrintButton, True );

	XtVaSetValues( apd->apdDialog,
			XmNdefaultButton,	apd->apdPrintButton,
			NULL );
	}
    }

static void appDestinationChosen(	Widget		w,
					XtPointer	voidapd,
					XtPointer	voidpbcs	 )
    {
    AppPrintDialog *	apd= (AppPrintDialog *)voidapd;
    short		deviceChosen= -1;

    XtVaGetValues( w,
			XmNpositionIndex,	&deviceChosen,
			NULL );

    apd->apdDestinationChosen= deviceChosen;

    appPrinterAdaptToDestination( apd );

    return;
    }

/************************************************************************/
/*  The buttons have been pushed.					*/
/************************************************************************/
static void appPrintDialogCancelPushed(	Widget		w,
					XtPointer	voidapd,
					XtPointer	voidpbcs	 )
    {
    AppPrintDialog *	apd= (AppPrintDialog *)voidapd;

    apd->apdResponse= AQDrespCANCEL;

    return;
    }

static void appPrintDialogPrintPushed(	Widget		w,
					XtPointer	voidapd,
					XtPointer	voidpbcs	 )
    {
    AppPrintDialog *	apd= (AppPrintDialog *)voidapd;

    if  ( apd->apdDestinationChosen < 0	)
	{ LDEB(apd->apdDestinationChosen); return;	}

    apd->apdResponse= AQDrespOK;

    return;
    }

/************************************************************************/
/*									*/
/*  Fill the list of printers.						*/
/*									*/
/************************************************************************/

static void appPrintDialogFillPrinterMenu( AppPrintDialog *	apd,
					int			printerCount,
					int			defaultPrinter,
					PrintDestination *	pd )
    {
    Dimension		width;
    int			i;
    Widget		defaultChild= (Widget)0;
    Widget		fresh;

    XtVaGetValues( apd->apdPrinterMenu,
			XmNwidth,		&width,
			NULL );

    appEmptyPulldownList( apd->apdPrinterPulldown );

    for ( i= 0; i < printerCount; pd++, i++ )
	{
	fresh= appPulldownMakeOption( apd->apdPrinterPulldown,
		    pd->pdPrinterName, width, appDestinationChosen,
		    (void *)apd );

	if  ( i == defaultPrinter )
	    { defaultChild= fresh;	}
	if  ( i == 0 )
	    { defaultChild= fresh;	}
	}

    fresh= appPulldownMakeOption( apd->apdPrinterPulldown,
		    apd->apdFaxText, width, appDestinationChosen, (void *)apd );

    if  ( apd->apdActivateFaxOptions )
	{
	if  ( ! defaultChild )
	    { defaultChild= fresh;	}
	}
    else{ XtSetSensitive( fresh, False ); }

    apd->apdFaxDestination= i++;
    
    fresh= appPulldownMakeOption( apd->apdPrinterPulldown,
	    apd->apdPrintToFileText, width, appDestinationChosen, (void *)apd );

    if  ( ! defaultChild )
	{ defaultChild= fresh;	}

    apd->apdFileDestination= i++;
    
    if  ( defaultChild )
	{
	XtVaSetValues( apd->apdPrinterMenu,
			    XmNmenuHistory,		defaultChild,
			    NULL );
	}

    apd->apdPrinterCount= printerCount;

    if  ( defaultPrinter >= 0 )
	{ apd->apdDestinationChosen= defaultPrinter;	}
    else{ apd->apdDestinationChosen= 0;			}

    appPulldownSetWidth( apd->apdPrinterMenu, width );
    }

/************************************************************************/
/*  A find tool must be destroyed.					*/
/************************************************************************/
static void editClosePrintDialog(		Widget		w,
						XtPointer	voidapd,
						XtPointer	voidlcs	 )
    {
    AppPrintDialog *	apd= (AppPrintDialog *)voidapd;

    apd->apdResponse= AQDrespCANCEL;

    return;
    }

/************************************************************************/
/*  Make the frame for selecting a printer.				*/
/************************************************************************/

static Widget appPrintDialogMakePrinterFrame( Widget		parent,
					AppPrintDialog *	apd )
    {
    Widget	frame;
    Widget	bboard;
    Widget	paned;

    /**********************/

    appMakeVerticalFrame( &frame, &bboard, &paned,
						parent, apd->apdPrinterText );

    /**********************/

    appMakePulldownList( &apd->apdPrinterPulldown,
					    &apd->apdPrinterMenu, paned );

    /**********************/

    appMakeColumnText( &apd->apdFaxNumberText, paned, 20, True );

    XtAddCallback( apd->apdFaxNumberText, XmNvalueChangedCallback,
					    appPrintFaxChanged, (void *)apd );

    /**********************/

    XtManageChild( apd->apdPrinterMenu );

    XtManageChild( paned );
    XtManageChild( bboard );
    XtManageChild( frame );

    return frame;
    }

/************************************************************************/
/*  Make the form with the two buttons.					*/
/************************************************************************/
static Widget appPrintDialogMakeButtonRow(	Widget			parent,
						AppPrintDialog *	apd )
    {
    Widget	row;

    row= appMakeButtonRow( parent, 2 );

    /**********************/

    apd->apdPrintButton= appMakeRowButton( row, apd->apdPrintText,
			appPrintDialogPrintPushed, (void *)apd, 0, True );

    /**********************/

    apd->apdCancelButton= appMakeRowButton( row, apd->apdCancelText,
			appPrintDialogCancelPushed, (void *)apd, 1, False );

    XtVaSetValues( apd->apdDialog,
			XmNcancelButton,	apd->apdCancelButton,
			NULL );

    /**********************/

    XtManageChild( row );

    return row;
    }

/************************************************************************/
/*									*/
/*  make a page tool.							*/
/*									*/
/************************************************************************/

static AppPrintDialog * appMakePrintDialog( EditApplication *	ea,
					EditDocument *		ed,
					Widget			printOption,
					const char *		pixmapName )
    {
    AppPrintDialog *	apd;
    
    Widget		printerFrame;
    Widget		paned;
    Widget		buttonRow;

    Dimension		width;

    const int		withSeparator= 0;
    Pixmap		iconPixmap= (Pixmap)0;

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return (AppPrintDialog *)0;	}

    if  ( ea->eaPrintDestinationCount == 0				&&
	  utilPrinterGetPrinters( &(ea->eaPrintDestinationCount),
				    &(ea->eaDefaultPrintDestination),
				    &(ea->eaPrintDestinations) )	)
	{ LDEB(1); return (AppPrintDialog *)0;	}

    apd= (AppPrintDialog *)malloc( sizeof(AppPrintDialog) );
    if  ( ! apd )
	{ XDEB(apd); return (AppPrintDialog *)0;	}

    XtGetApplicationResources( ea->eaTopWidget, apd,
				    APP_PrintDialogresourceTable,
				    XtNumber(APP_PrintDialogresourceTable),
				    NULL, 0 );

    if  ( ea->eaFaxCommand )
	{ apd->apdActivateFaxOptions= 1;	}
    else{ apd->apdActivateFaxOptions= 0;	}

    apd->apdTarget= (void *)ea;
    apd->apdPrinterCount= 0;
    apd->apdFileDestination= -1;
    apd->apdFaxDestination= -1;

    appMakeVerticalDialog( &(apd->apdTopWidget), &(apd->apdDialog),
			    &paned, ea, editClosePrintDialog, (void *)apd,
			    iconPixmap, withSeparator, ea->eaPrintDialogName );

    appSetShellTitle( apd->apdTopWidget, printOption, ea->eaApplicationName );

    XtAddEventHandler( apd->apdTopWidget, StructureNotifyMask, False,
						    appFixSize, (void *)apd );

    printerFrame= appPrintDialogMakePrinterFrame( paned, apd );
    buttonRow= appPrintDialogMakeButtonRow( paned, apd );

    appSetRelativeCallback( ed->edTopWidget, apd->apdDialog );
    appSetFocusCallback( apd->apdDialog );

    XtManageChild( paned );

    appPrintDialogFillPrinterMenu( apd,
				    ea->eaPrintDestinationCount,
				    ea->eaDefaultPrintDestination,
				    ea->eaPrintDestinations );

    XtManageChild( apd->apdDialog );

    appDialogRelative( ed->edTopWidget, apd->apdDialog );

    XtVaGetValues( apd->apdPrinterMenu,
			    XmNwidth,		&width,
			    NULL );

    appPulldownSetWidth( apd->apdPrinterMenu, width );

    return apd;
    }

/************************************************************************/
/*									*/
/*  Show the 'Print...' dialog.						*/
/*									*/
/*  1)	Make or just show it.						*/
/*									*/
/************************************************************************/

void appRunPrintDialog(			EditApplication *	ea,
					EditDocument *		ed,
					Widget			printOption,
					const char *		pixmapName )
    {
    AppPrintDialog *	apd= APP_PrintDialog;

    /*  1  */
    if  ( ! apd )
	{
	apd= APP_PrintDialog= appMakePrintDialog( ea, ed, printOption,
								pixmapName );
	if  ( ! apd )
	    { XDEB(apd); return;	}

	/*  2  */
	if  ( ea->eaDefaultPrintDestination >= 0			  &&
	      ea->eaDefaultPrintDestination < ea->eaPrintDestinationCount )
	    { apd->apdDestinationChosen= ea->eaDefaultPrintDestination; }
	else{ apd->apdDestinationChosen= 0;				}
	}
    else{
	appSetShellTitle( apd->apdTopWidget, printOption,
						    ea->eaApplicationName );

	appSetRelativeCallback( ed->edTopWidget, apd->apdDialog );
	appDialogRelative( ed->edTopWidget, apd->apdDialog );

	appSetFocusCallback( apd->apdDialog );

	XtManageChild( apd->apdDialog );
	}

    appPrintDialogShowPrinter( apd );
    appPrinterAdaptToDestination( apd );

    apd->apdResponse= AQDrespNONE;

    while( apd->apdResponse == AQDrespNONE )
	{ XtAppProcessEvent( ea->eaContext, XtIMAll ); }

    switch( apd->apdResponse )
	{
	case AQDrespOK:
	    if  ( apd->apdDestinationChosen == apd->apdFileDestination )
		{
		appDocPrintToFile( printOption, apd->apdTopWidget, ea, ed );
		}
	    else{
		if  ( apd->apdDestinationChosen == apd->apdFaxDestination )
		    {
		    char *	faxNumber;
		    char *	s;

		    s= faxNumber= XmTextGetString( apd->apdFaxNumberText );

		    while( *s == ' ' )
			{ s++;	}

		    if  ( ! *s )
			{ SDEB(faxNumber);	}
		    else{
			if  ( appFaxDocument( ea, ed, s ) )
			    { SDEB(faxNumber);	}
			}

		    XtFree( faxNumber );
		    }
		else{
		    if  ( appPrintDocument( ea, ed,
						apd->apdDestinationChosen ) )
			{ LDEB(apd->apdDestinationChosen); }
		    }
		}

	    XtUnmanageChild( apd->apdDialog );
	    return;

	default:
	    LDEB(apd->apdResponse);
	    /*FALLTHROUGH*/
	case AQDrespCANCEL:
	    XtUnmanageChild( apd->apdDialog );
	    return;
	}

    }
