#   ifndef	APP_DRAW_H
#   define	APP_DRAW_H

#   include	<X11/Intrinsic.h>
#   include	<appGeo.h>
#   include	<docFont.h>
#   include	<psFont.h>

/************************************************************************/
/*									*/
/*  An attempt to consistently use the same formula to convert from	*/
/*  twips to pixels.							*/
/*									*/
/************************************************************************/

#   define	TWIPStoPIXELS(xmag,t) ((xmag)*(t))
#   define	PIXELStoTWIPS(p,xmag) ((p)/(xmag))

/************************************************************************/
/*									*/
/*  For the administration of the relation between PostScript fonts and	*/
/*  X11 fonts.								*/
/*									*/
/************************************************************************/

typedef struct AppPhysicalFont
    {
    TextAttribute	apfAttribute;
    int			apfDocFamilyNumber;

    int			apfPsFamilyNumber;
    int			apfPsFaceNumber;

    XFontStruct *	apfFontStruct;
    XFontSet		apfFontSet;
    unsigned long	apfUnderLinePositionPixels;
    unsigned long	apfUnderlineThicknessPixels;
    int			apfAscentPixels;
    int			apfDescentPixels;
    int			apfFullSizePixels;
    } AppPhysicalFont;

typedef struct AppPhysicalFontList
    {
    const char *	apflAfmDirectory;
    int			apflCount;
    AppPhysicalFont *	apflFonts;
    } AppPhysicalFontList;

typedef struct AppDrawingData
    {
    DocumentRectangle	addBackRect;
    DocumentRectangle	addPaperRect;
    DocumentRectangle	addDocRect;

    int			sgTabInterval;

    double		sgMagnification;
    double		addMagnifiedPixelsPerTwip;

    char *		addAfmDirectory;
    Display *		addDisplay;
    AppPhysicalFontList	addPhysicalFontList;
    } AppDrawingData;

/************************************************************************/
/*									*/
/*  Procedure declarations.						*/
/*									*/
/************************************************************************/

extern void appCollectExposures(	DocumentRectangle *	drClip,
					int			ox,
					int			oy,
					Display *		display,
					Window			win,
					GC			gc,
					XEvent *		event );

extern void appInitDrawingData(		AppDrawingData *	add );
extern void appCleanDrawingData(	AppDrawingData *	add );


extern void appInitFontList(	AppPhysicalFontList *	apfl );
extern void appCleanFontList(	Display *		display,
				AppPhysicalFontList *	apfl );

extern void appEnableFontsTool(	void *	voidafc,
				int	enabled );

extern void appShowFontsTool(		void *	voidefc	);

extern int appFontCatalog(	Display *		display,
				AppFontFamily **	pFamilies,
				int *			pCount		);

extern void appFontFormatCurrent(	char *			target,
					AppFontFamily *		aff,
					AppFontTypeface *	aft,
					int			size	);

extern int appOpenDocumentFont(	AppDrawingData *	add,
				DocumentFontList *	dfl,
				TextAttribute		ta	);

extern int appFontSetCurrentFont(	void *		voidefc,
					int		fontFamilyNumber,
					unsigned int	updMask,
					TextAttribute	taNew );

extern void appFontAttributeString(	char *			target,
					const char *		familyName,
					unsigned int		updMask,
					TextAttribute		taNew );

extern int appGetPsFont(	int *			pFamily,
				int *			pFace,
				AppFontFamily **	pAff,
				AppFontTypeface **	pAft,
				const char *		afmDirectory,
				const DocumentFont *	df,
				TextAttribute		ta );

#   endif							/*  }}  */
