/************************************************************************/
/*  Editor, File actions.						*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<appFrame.h>
#   include	<appUtil.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Respond to selection events.					*/
/*									*/
/************************************************************************/
# define ADEB(d,a) SDEB(((a)==None?"None":XGetAtomName((d),(a))))

static Atom	XA_MULTIPLE= None;
static Atom	XA_TARGETS= None;

static int appDocGetResponseType( AppDocSelectionType **	pAdst,
				AppDocSelectionTargetType **	pAdstt,
				int *				pTtargetFound,
				EditApplication *		ea,
				Atom				selection,
				Atom				target )
    {
    int				i;

    AppDocSelectionType *		adst;
    AppDocSelectionTargetType *		adstt;

    adst= ea->eaDocSelectionTypes;
    for ( i= 0; i < ea->eaDocSelectionTypeCount; adst++, i++ )
	{
	if  ( adst->adstSelectionAtom == selection )
	    { break;	}
	}

    if  ( i >= ea->eaDocSelectionTypeCount )
	{ /*ADEB(ea->eaDisplay,selection);*/ return -1; }

    adstt= adst->adstTargetTypes;
    for ( i= 0; i < adst->adstTargetTypeCount; adstt++, i++ )
	{
	if  ( adstt->adsttTargetAtom == target )
	    { break;	}
	}

    if  ( i >= adst->adstTargetTypeCount )
	{ /*ADEB(ea->eaDisplay,target);*/ return -1; }

    *pAdst= adst; *pTtargetFound= i; *pAdstt= adstt; return 0;
    }

static int appAppGetResponseType( AppAppSelectionType **	pAast,
				AppAppSelectionTargetType **	pAastt,
				int *				pTtargetFound,
				EditApplication *		ea,
				Atom				selection,
				Atom				target )
    {
    int				i;

    AppAppSelectionType *	aast;
    AppAppSelectionTargetType *	aastt;

    aast= ea->eaAppSelectionTypes;
    for ( i= 0; i < ea->eaAppSelectionTypeCount; aast++, i++ )
	{
	if  ( aast->aastSelectionAtom == selection )
	    { break;	}
	}

    if  ( i >= ea->eaAppSelectionTypeCount )
	{ /*ADEB(ea->eaDisplay,selection);*/ return -1; }

    aastt= aast->aastTargetTypes;
    for ( i= 0; i < aast->aastTargetTypeCount; aastt++, i++ )
	{
	if  ( aastt->aasttTargetAtom == target )
	    { break;	}
	}

    if  ( i >= aast->aastTargetTypeCount )
	{ /*ADEB(ea->eaDisplay,target);*/ return -1; }

    *pAast= aast; *pTtargetFound= i; *pAastt= aastt; return 0;
    }

static void appDocSelectionNotify(	Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent )
    {
    EditApplication *		ea= ed->edApplication;

    AppDocSelectionType *	adst;
    AppDocSelectionTargetType *	adstt;
    int				targetFound;

    Display *			display= XtDisplay( w );

    /*
    printf( "PASTE " );
    printf( "selection= %s target= %s, property= %s\n",
			selEvent->selection == None ? "None" :
			    XGetAtomName( display, selEvent->selection ),
			selEvent->target == None ? "None" :
			    XGetAtomName( display, selEvent->target ),
			selEvent->property == None ? "None" :
			    XGetAtomName( display, selEvent->property ) );
    */

    if  ( appDocGetResponseType( &adst, &adstt, &targetFound, ea,
				    selEvent->selection, selEvent->target ) )
	{ LDEB(1); return;	}

    if  ( selEvent->property == None )
	{
	ea->eaGotPaste= -1;

	if  ( targetFound < adst->adstTargetTypeCount- 1 )
	    {
	    Window		win= XtWindow( w );

	    XConvertSelection( display, selEvent->selection,
			    adstt[1].adsttTargetAtom,
			    selEvent->selection, win, selEvent->time );

	    ea->eaGotPaste= 0;
	    }
	}
    else{
	(*adstt->adsttPaste)( w, ed, selEvent );
	ea->eaGotPaste= 1;
	}

    return;
    }

static void appAppSelectionNotify(	Widget			w,
					EditApplication *	ea,
					XSelectionEvent *	selEvent )
    {
    AppAppSelectionType *	aast;
    AppAppSelectionTargetType *	aastt;
    int				targetFound;

    Display *			display= XtDisplay( w );

    /*
    printf( "PASTE " );
    printf( "selection= %s target= %s, property= %s\n",
			selEvent->selection == None ? "None" :
			    XGetAtomName( display, selEvent->selection ),
			selEvent->target == None ? "None" :
			    XGetAtomName( display, selEvent->target ),
			selEvent->property == None ? "None" :
			    XGetAtomName( display, selEvent->property ) );
    */

    if  ( appAppGetResponseType( &aast, &aastt, &targetFound, ea,
				    selEvent->selection, selEvent->target ) )
	{ LDEB(1); return;	}

    if  ( selEvent->property == None )
	{
	ea->eaGotPaste= -1;

	if  ( targetFound < aast->aastTargetTypeCount- 1 )
	    {
	    Window		win= XtWindow( w );

	    XConvertSelection( display, selEvent->selection,
			    aastt[1].aasttTargetAtom,
			    selEvent->selection, win, selEvent->time );

	    ea->eaGotPaste= 0;
	    }
	}
    else{
	(*aastt->aasttPaste)( w, ea, selEvent );
	ea->eaGotPaste= 1;
	}

    return;
    }

static void appSelectionRequest(Widget				w,
				EditDocument *			ed,
				XSelectionRequestEvent *	reqEvent )
    {
    EditApplication *		ea= ed->edApplication;

    AppDocSelectionType *	adst;
    AppDocSelectionTargetType *	adstt;
    int				targetFound;

    Display *			display= XtDisplay( w );

    XSelectionEvent		response;

    /*
    printf( "COPY  " );
    printf( "selection= %s target= %s, property= %s\n",
			    reqEvent->selection == None ? "None" :
				XGetAtomName( display, reqEvent->selection ),
			    reqEvent->target == None ? "None" :
				XGetAtomName( display, reqEvent->target ),
			    reqEvent->property == None ? "None" :
				XGetAtomName( display, reqEvent->property ) );
    */

    response.type= SelectionNotify;
    response.display= reqEvent->display;
    response.requestor= reqEvent->requestor;
    response.selection= reqEvent->selection;
    response.target= reqEvent->target;
    response.property= reqEvent->property;
    response.time= reqEvent->time;

    if  ( response.target == XA_TARGETS )
	{
	static Atom *		atoms;
	Atom *			fresh;
	int			i;

	if  ( ed->edTargetTypeCount < 1 )
	    { LDEB(ed->edTargetTypeCount); goto refuse;	}

	fresh= (Atom *)realloc( atoms, ed->edTargetTypeCount* sizeof(Atom) );
	if  ( ! fresh )
	    { XDEB(fresh); goto refuse;	}
	atoms= fresh;

	for ( i= 0; i < ed->edTargetTypeCount; i++ )
	    { atoms[i]= ed->edTargetTypes[i].adsttTargetAtom; }

	XChangeProperty( display,
			response.requestor, response.property, response.target,
			8* sizeof(Atom), PropModeReplace,
			(unsigned char *)atoms,
			ed->edTargetTypeCount );

	XSendEvent( display, response.requestor, False, 0L,
						    (XEvent *)&response );
	return;
	}

    if  ( response.target == XA_MULTIPLE )
	{
#	define		FST		( 2* 10L )

	Atom *		atomPairs;

	int		ret;
	int		i;

	unsigned long	itemsReturned;
	unsigned long	itemsLeft;
	Atom		typeFound;
	int		formatFound;

	ret= XGetWindowProperty( display, reqEvent->requestor,
		reqEvent->property,
		0L, FST, False, AnyPropertyType,
		&typeFound, &formatFound,
		&itemsReturned, &itemsLeft, (unsigned char **)&atomPairs );

	if  ( ret != Success )
	    { LLDEB(ret,Success); goto refuse;	}

	if  ( itemsLeft > 0 )
	    {
	    XFree( atomPairs );

	    ret= XGetWindowProperty( display, reqEvent->requestor,
		    reqEvent->property,
		    0L, FST+ itemsLeft, False, AnyPropertyType,
		    &typeFound, &formatFound,
		    &itemsReturned, &itemsLeft, (unsigned char **)&atomPairs );
	    }

	if  ( ret != Success )
	    { LLDEB(ret,Success); goto refuse;	}
	if  ( itemsReturned == 0 || itemsReturned % 2 )
	    { LDEB(itemsReturned); goto refuse;	}
	if  ( formatFound != 32 )
	    { LLDEB(typeFound,formatFound); goto refuse;	}

	for ( i= 0; i < (int)itemsReturned; i += 2 )
	    {
	    if  ( appDocGetResponseType( &adst, &adstt, &targetFound, ea,
					reqEvent->selection, atomPairs[i] ) )
		{ LDEB(1); goto refuse;	}

	    if  ( ! adstt->adsttCopy					||
		  (*adstt->adsttCopy)( w, ed, response.requestor,
					atomPairs[i+1], atomPairs[i] )	)
		{ XDEB(adstt->adsttCopy); goto refuse;	}
	    }

	XFree( atomPairs );
	XSendEvent( display, response.requestor, False, 0L,
						    (XEvent *)&response );
	return;
	}

    /*  ICCM L.2.2; ICCM L.2.6.2  */
    if  ( response.property == None )
	{ response.property= response.target;	}

    if  ( appDocGetResponseType( &adst, &adstt, &targetFound, ea,
				reqEvent->selection, reqEvent->target ) )
	{ goto refuse;	}

    if  ( ! adstt->adsttCopy					||
	  (*adstt->adsttCopy)( w, ed, response.requestor,
			    response.property, response.target )	)
	{ XDEB(adstt->adsttCopy); goto refuse;	}

    XSendEvent( display, response.requestor, False, 0L, (XEvent *)&response );
    return;

  refuse:
    /*
    SDEB(XGetAtomName(display,reqEvent->selection));
    SDEB(XGetAtomName(display,reqEvent->target));
    */

    response.property= None;
    XSendEvent( display, reqEvent->requestor,
			False, PropertyChangeMask, (XEvent *)&response );

    return;
    }

static void appSelectionClear(	Widget			w,
				EditDocument *		ed,
				XSelectionClearEvent *	clrEvent )
    {
    EditApplication *		ea= ed->edApplication;

    int				i;
    AppDocSelectionType *		adst;

    adst= ea->eaDocSelectionTypes;
    for ( i= 0; i < ea->eaDocSelectionTypeCount; adst++, i++ )
	{
	if  ( adst->adstSelectionAtom == clrEvent->selection )
	    { break;	}
	}

    if  ( i >= ea->eaDocSelectionTypeCount )
	{ ADEB(ea->eaDisplay,clrEvent->selection); return; }

    if  ( adst->adstLost )
	{ (*adst->adstLost)( w, ed, clrEvent );	}

    return;
    }

void appDocSelectionInput(	Widget		w,
				void *		voided,
				XEvent *	event,
				Boolean *	pRefused	)
    {
    EditDocument *	ed= (EditDocument *)voided;

    if  ( XA_MULTIPLE == None )
	{ XA_MULTIPLE= XInternAtom( XtDisplay( w ), "MULTIPLE", False ); }
    if  ( XA_TARGETS == None )
	{ XA_TARGETS= XInternAtom( XtDisplay( w ), "TARGETS", False ); }

    switch( event->type )
	{
	case SelectionNotify:
	    appDocSelectionNotify( w, ed, (XSelectionEvent *)event );
	    *pRefused= False;
	    break;
	case SelectionRequest:
	    appSelectionRequest( w, ed, (XSelectionRequestEvent *)event );
	    *pRefused= False;
	    break;
	case SelectionClear:
	    appSelectionClear( w, ed, (XSelectionClearEvent *)event );
	    *pRefused= False;
	    break;
	case PropertyNotify:
	    *pRefused= True;
	    break;
	case NoExpose:
	case GraphicsExpose:
	    *pRefused= True;
	    return;
	    break;
	default:
	    printf( "SELECTION \"%s\": %s\n",
			    ed->edTitle, APP_X11EventNames[event->type] );
	    *pRefused= True;
	    break;
	}

    return;
    }

void appAppSelectionInput(	Widget		w,
				void *		voidea,
				XEvent *	event,
				Boolean *	pRefused	)
    {
    EditApplication *	ea= (EditApplication *)voidea;

    if  ( XA_MULTIPLE == None )
	{ XA_MULTIPLE= XInternAtom( XtDisplay( w ), "MULTIPLE", False ); }
    if  ( XA_TARGETS == None )
	{ XA_TARGETS= XInternAtom( XtDisplay( w ), "TARGETS", False ); }

    switch( event->type )
	{
	case SelectionNotify:
	    appAppSelectionNotify( w, ea, (XSelectionEvent *)event );
	    *pRefused= False;
	    break;
	case PropertyNotify:
	    *pRefused= True;
	    break;
	case SelectionClear:
	case NoExpose:
	case GraphicsExpose:
	case SelectionRequest:
	default:
	    printf( "SELECTION \"%s\": %s\n",
		    ea->eaApplicationName, APP_X11EventNames[event->type] );
	    *pRefused= True;
	    break;
	}

    return;
    }

int appDocOwnSelection(		EditDocument *			ed,
				const char *			selection,
				AppDocSelectionTargetType * 	targets,
				int				targetCount,
				Time				eventTime )
    {
    int				i;
    AppDocSelectionType *	adst;

    EditApplication *		ea= ed->edApplication;
    Display *			display= XtDisplay( ed->edDocumentWidget );
    Window			win= XtWindow( ed->edDocumentWidget );

    adst= ea->eaDocSelectionTypes;
    for ( i= 0; i < ea->eaDocSelectionTypeCount; adst++, i++ )
	{
	if  ( ! strcmp( adst->adstSelectionString, selection ) )
	    { break;	}
	}

    if  ( i >= ea->eaDocSelectionTypeCount )
	{ SDEB(selection); return -1; }

    if  ( adst->adstTargetTypeCount == 0 )
	{ SLDEB(selection,adst->adstTargetTypeCount); return -1;	}

    for ( i= 0; i < targetCount; i++ )
	{
	if  ( targets[i].adsttTargetAtom == None )
	    {
	    targets[i].adsttTargetAtom=
				XInternAtom( XtDisplay( ed->edDocumentWidget ),
				targets[i].adsttTargetString, False );

	    if  ( ! targets[i].adsttTargetAtom )
		{
		SDEB(targets[i].adsttTargetString);
		XDEB(targets[i].adsttTargetAtom);
		return -1;
		}
	    }
	}

    ed->edTargetTypes= targets;
    ed->edTargetTypeCount= targetCount;

    XSetSelectionOwner( display, adst->adstSelectionAtom, win, eventTime );

    if  ( XGetSelectionOwner( display, adst->adstSelectionAtom ) != win )
	{ return -1;	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Ask for a paste.							*/
/*									*/
/*  NOTE that the selection and property names are identical.		*/
/*									*/
/*  1)  Some software does not support the normal X11 Copy/Paste	*/
/*	mechanism. (Guess why) This should be handeled by the		*/
/*	application.							*/
/*									*/
/************************************************************************/

static int appAskForPaste(	Widget			w,
				EditApplication *	ea,
				const char *		selection,
				Time			eventTime )
    {
    int				i;
    AppDocSelectionType *	adst;

    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    ea->eaGotPaste= 0;

    adst= ea->eaDocSelectionTypes;
    for ( i= 0; i < ea->eaDocSelectionTypeCount; adst++, i++ )
	{
	if  ( ! strcmp( adst->adstSelectionString, selection ) )
	    { break;	}
	}

    if  ( i >= ea->eaDocSelectionTypeCount )
	{ SDEB(selection); return -1; }

    if  ( adst->adstTargetTypeCount == 0 )
	{ SLDEB(selection,adst->adstTargetTypeCount); return -1;	}

    XConvertSelection( display,
		/*  selection	*/  adst->adstSelectionAtom,
		/*  target	*/  adst->adstTargetTypes[0].adsttTargetAtom,
		/*  property	*/  adst->adstSelectionAtom,
				    win, eventTime );

    while( ! ea->eaGotPaste )
	{
	XEvent		event;

	XtAppNextEvent( ea->eaContext, &event );
	XtDispatchEvent( &event );
	}

    /*  1  */
    if  ( ea->eaGotPaste < 0 )
	{ return -1;	}

    return 0;
    }
				
int appDocAskForPaste(		EditDocument *		ed,
				const char *		selection,
				Time			eventTime )
    {
    return appAskForPaste( ed->edDocumentWidget,
				    ed->edApplication, selection, eventTime );
    }
				
int appAppAskForPaste(		EditApplication *	ea,
				const char *		selection,
				Time			eventTime )
    {
    return appAskForPaste( ea->eaTopWidget, ea, selection, eventTime );
    }
