/************************************************************************/
/*									*/
/*  Convert a windows metafile to a Pixmap.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	"tedApp.h"
#   include	<appImage.h>
#   include	<sioMemory.h>
#   include	<sioEndian.h>
#   include	<sioStdio.h>
#   include	<sioHex.h>

#   include	<debugon.h>

#   include	<appWinMeta.h>

int tedDrawObject(		const BufferItem *	bi,
				TextParticule *		tp,
				int			y,
				const DrawingContext *	dc )
    {
    InsertedObject *	io= bi->biParaObjects+ tp->tpObjectNumber;
    Display *		display= dc->dcDrawingData->addDisplay;

    if  ( tp->tpPhysicalFont < 0 )
	{ LDEB(tp->tpPhysicalFont); return -1;	}

    if  ( ( io->ioKind == DOCokPICTWMETAFILE	||
	    io->ioKind == DOCokPICTPNGBLIP	||
	    io->ioKind == DOCokPICTJPEGBLIP	)	&&
	  io->ioPixmap					)
	{
	XCopyArea( display, io->ioPixmap, dc->dcWindow, dc->dcGc,
	    0, 0, /* src: x,y */
	    io->ioPixelsWide, io->ioPixelsHigh, /* wide, high */
	    tp->tpX0- dc->dcOx, y- io->ioPixelsHigh- dc->dcOy ); /* dest: x,y */
		    
	return 0;
	}

    if  ( io->ioKind == DOCokOLEOBJECT			&&
	  io->ioResultKind == DOCokPICTWMETAFILE	&&
	  io->ioPixmap					)
	{
	XCopyArea( display, io->ioPixmap, dc->dcWindow, dc->dcGc,
	    0, 0, /* src: x,y */
	    io->ioPixelsWide, io->ioPixelsHigh, /* wide, high */
	    tp->tpX0- dc->dcOx, y- io->ioPixelsHigh- dc->dcOy ); /* dest: x,y */
		    
	return 0;
	}

    /*
    LLDEB(io->ioKind,io->ioResultKind);
    XDEB(io->ioPrivate);
    */

    XDrawRectangle( display, dc->dcWindow, dc->dcGc,
		tp->tpX0- dc->dcOx, y- io->ioPixelsHigh- dc->dcOy,
		io->ioPixelsWide, io->ioPixelsHigh );
    return 0;
    }

static int tedOpenMetafileObject(	InsertedObject *	io,
					AppColors *		ac,
					DocumentFontList *	dfl,
					AppDrawingData *	add,
					const ObjectData *	od,
					Window			win )
    {
    Display *		display= add->addDisplay;
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );

    int			xExt= io->ioXExtent;
    int			yExt= io->ioYExtent;

    SimpleInputStream *	sisMem;
    SimpleInputStream *	sisMeta;

    MemoryBuffer	mb;

    mb.mbCapacity= od->odSize;
    mb.mbBytes= od->odBytes;

    sisMem= sioInMemoryOpen( &mb );
    if  ( ! sisMem )
	{ XDEB(sisMem); return -1;	}

    sisMeta= sioInHexOpen( sisMem );
    if  ( ! sisMeta )
	{ XDEB(sisMem); return -1;	}

    io->ioPixmap= XCreatePixmap( display, win,
				io->ioPixelsWide, io->ioPixelsHigh, depth );
    if  ( ! io->ioPixmap )
	{ XDEB(io->ioPixmap); return -1;	}

    if  ( appMetaPlayFileX11( sisMeta, &io->ioPrivate, ac, dfl, add,
		    io->ioPixmap, xExt, yExt,
		    io->ioPixelsWide, io->ioPixelsHigh,
		    io->ioTwipsWide, io->ioTwipsHigh,
		    win ) )
	{ LDEB(1);	}

    sioInClose( sisMeta );
    sioInClose( sisMem );

    return 0;
    }

typedef int (*TedReadBitmap)(	BitmapDescription *	pBd,
				unsigned char **	pBuffer,
				SimpleInputStream *	sis );

static int tedOpenBitmapObject(	TedReadBitmap		readBitmap,
				InsertedObject *	io,
				double			pixelsPerTwip,
				AppColors *		ac,
				ObjectData *		od,
				Display *		display,
				Window			win,
				GC			gc )
    {
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );

    AppBitmapImage *	abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );

    XImage *		xim= (XImage *)0;

    SimpleInputStream *	sisMem;
    SimpleInputStream *	sisPng;

    MemoryBuffer	mb;

    mb.mbCapacity= od->odSize;
    mb.mbBytes= od->odBytes;

    if  ( ! abi )
	{ XDEB(abi); return -1;	}
    appInitBitmapImage( abi );

    io->ioPixmap= XCreatePixmap( display, win,
				io->ioPixelsWide, io->ioPixelsHigh, depth );
    if  ( ! io->ioPixmap )
	{ XDEB(io->ioPixmap); return -1;	}

    sisMem= sioInMemoryOpen( &mb );
    if  ( ! sisMem )
	{ XDEB(sisMem); return -1;	}

    sisPng= sioInHexOpen( sisMem );
    if  ( ! sisPng )
	{ XDEB(sisMem); return -1;	}

    if  ( (*readBitmap)( &abi->abiBitmap, &abi->abiBuffer, sisPng ) )
	{ LDEB(1); return -1;	}

    sioInClose( sisPng );
    sioInClose( sisMem );

    if  ( appImgMakeImage( display, screen,
			&xim, io->ioPixelsWide, io->ioPixelsHigh, ac, abi ) )
	{
	LDEB(1);

	appCleanBitmapImage( abi ); free( abi );

	return -1;
	}

    XPutImage( display, io->ioPixmap, gc, xim, 0, 0, 0, 0,
					io->ioPixelsWide, io->ioPixelsHigh );
    XDestroyImage( xim );

    io->ioPrivate= (void *)abi;

    return 0;
    }

static int tedOpenObject(	InsertedObject *	io,
				AppColors *		ac,
				DocumentFontList *	dfl,
				AppDrawingData *	add,
				Window			win,
				GC			gc )
    {
    if  ( io->ioTwipsWide < 10 || io->ioTwipsHigh < 10 )
	{ LLDEB(io->ioTwipsWide,io->ioTwipsHigh); return -1; }

    switch( io->ioKind )
	{
	case DOCokPICTWMETAFILE:
	    if  ( ! io->ioPrivate					&&
		  tedOpenMetafileObject( io, ac, dfl, add,
					&io->ioObjectData, win )	)
		{ LDEB(1); return 0;	}
	    break;

	case DOCokPICTPNGBLIP:
	    if  ( ! io->ioPrivate					&&
		  tedOpenBitmapObject( bmPngReadPng, io,
			add->addMagnifiedPixelsPerTwip, ac,
			&io->ioObjectData, add->addDisplay, win, gc )	)
		{ LDEB(1); return 0;	}
	    break;

	case DOCokPICTJPEGBLIP:
	    if  ( ! io->ioPrivate					&&
		  tedOpenBitmapObject( bmJpegReadJfif, io,
			add->addMagnifiedPixelsPerTwip, ac,
			&io->ioObjectData, add->addDisplay, win, gc )	)
		{ LDEB(1); return 0;	}
	    break;

	case DOCokOLEOBJECT:
	    if  ( io->ioResultKind == DOCokPICTWMETAFILE )
		{
		if  ( ! io->ioPrivate				&&
		      tedOpenMetafileObject( io, ac, dfl, add,
					&io->ioResultData, win )	)
		    { LDEB(1); return 0;	}

		return 0;
		}
	    return 0;
	default:
	    LDEB(io->ioKind); return 0;
	}

    return 0;
    }

static int tedOpenParaObjects(	BufferItem *		bi,
				AppColors *		ac,
				DocumentFontList *	dfl,
				AppDrawingData *	add,
				Window			win,
				GC			gc )
    {
    int			part;
    TextParticule *	tp;

    tp= bi->biParaParticules;
    for ( part= 0; part < bi->biParaParticuleCount; tp++, part++ )
	{
	InsertedObject *	io;

	if  ( tp->tpKind != DOCkindOBJECT )
	    { continue;	}

	if  ( tp->tpPhysicalFont < 0 )
	    { LLDEB(part,tp->tpPhysicalFont); continue;	}

	io= bi->biParaObjects+ tp->tpObjectNumber;

	if  ( ! io->ioPrivate						&&
	      tedOpenObject( io, ac, dfl, add, win, gc )	)
	    { LDEB(part); continue;	}
	}

    return 0;
    }

int tedOpenItemObjects(	BufferItem *		bi,
			AppColors *		ac,
			DocumentFontList *	dfl,
			AppDrawingData *	add,
			Window			win,
			GC			gc )
    {
    int		i;

    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevSECT:
	case DOClevROW:
	case DOClevCELL:
	    for ( i= 0; i < bi->biGroupChildCount; i++ )
		{
		if  ( tedOpenItemObjects( bi->biGroupChildren[i],
						    ac, dfl, add, win, gc ) )
		    { LDEB(i); return -1;	}
		}
	    break;
	case DOClevPARA:
	    if  ( tedOpenParaObjects( bi, ac, dfl, add, win, gc ) )
		{ LDEB(0); return -1;	}

	    break;
	default:
	    LDEB(bi->biLevel); return -1;
	}


    return 0;
    }

void tedCloseObject(		BufferDocument *	bd,
				BufferItem *		bi,
				TextParticule *		tp,
				void *			voiddisplay )
    {
    Display *		display= (Display *)voiddisplay;
    InsertedObject *	io;

    if  ( tp->tpKind != DOCkindOBJECT	||
	  tp->tpPhysicalFont < 0		)
	{ return;	}

    io= bi->biParaObjects+ tp->tpObjectNumber;

    switch( io->ioKind )
	{
	case DOCokPICTWMETAFILE:
	case DOCokPICTPNGBLIP:
	case DOCokPICTJPEGBLIP:
	case DOCokOLEOBJECT:
	    if  ( io->ioPrivate )
		{
		AppBitmapImage *	abi= (AppBitmapImage *)io->ioPrivate;

		if  ( io->ioPixmap )
		    {
		    XFreePixmap( display, io->ioPixmap );
		    io->ioPixmap= (Pixmap)0;
		    }

		appCleanBitmapImage( abi ); free( abi );

		io->ioPrivate= (void *)0;
		}
	    break;
	default:
	    LDEB(io->ioKind); break;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Called to resize an inserted object.				*/
/*									*/
/************************************************************************/
int tedReopenObject(	BufferDocument *	bd,
			BufferItem *		bi,
			TextParticule *		tp,
			AppColors *		ac,
			DocumentFontList *	dfl,
			AppDrawingData *	add,
			Window			win,
			GC			gc )
    {
    InsertedObject *		io= bi->biParaObjects+ tp->tpObjectNumber;

    tedCloseObject( bd, bi, tp, (void *)add->addDisplay );

    if  ( tedOpenObject( io, ac, dfl, add, win, gc ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

static void tedScaleObjectToParagraph(	EditDocument *		ed,
					InsertedObject *	io )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferItem *		bi= td->tdSelection.bsBegin.bpBi;
    BufferDocument *		bd= td->tdDocument;
    const DocumentGeometry *	dg= &(bd->bdGeometry);
    FormattingFrame		ff;
    int				pageHigh;
    double			scaleX;
    double			scaleY;

    docParagraphFrame( &ff, dg, -1, bi );
    scaleX= (double)( ff.ffX1TextLines- ff.ffX0TextLines )/
						    (double)io->ioTwipsWide;

    pageHigh= dg->dgPaperHighTwips-
			    dg->dgTopMarginTwips- dg->dgBottomMarginTwips;
    scaleY= (double)pageHigh/ (double)io->ioTwipsHigh;

    if  ( scaleY > scaleX )
	{ scaleY=  scaleX;	}

    if  ( scaleY < 0.99 )
	{
	io->ioScaleX= (int)( 99* scaleY );
	io->ioScaleY= (int)( 99* scaleY );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Save the picture of an object for Copy/Paste.			*/
/*									*/
/************************************************************************/
int tedSaveObjectPicture(	AppBitmapImage *	abiTo,
				InsertedObject *	io )
    {
    AppBitmapImage *	abiFrom= (AppBitmapImage *)0;
    unsigned char *	buffer;

    if  ( ( io->ioKind == DOCokPICTWMETAFILE	||
	    io->ioKind == DOCokPICTPNGBLIP	||
	    io->ioKind == DOCokPICTJPEGBLIP	)	&&
	  io->ioPrivate					)
	{ abiFrom= (AppBitmapImage *)io->ioPrivate; }

    if  ( io->ioKind == DOCokOLEOBJECT			&&
	  io->ioResultKind == DOCokPICTWMETAFILE	&&
	  io->ioPrivate					)
	{ abiFrom= (AppBitmapImage *)io->ioPrivate; }

    if  ( ! abiFrom )
	{ LDEB(io->ioKind); return -1;	}

    buffer= (unsigned char *)malloc( abiFrom->abiBitmap.bdBufferLength );
    if  ( ! buffer )
	{ LXDEB(abiFrom->abiBitmap.bdBufferLength,buffer); return -1; }

    if  ( bmCopyDescription( &(abiTo->abiBitmap), &(abiFrom->abiBitmap) ) )
	{ LDEB(1); free( buffer ); return -1;	}

    memcpy( buffer, abiFrom->abiBuffer, abiFrom->abiBitmap.bdBufferLength );
    abiTo->abiBuffer= buffer;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Callback of the 'Insert Picture' menu option.			*/
/*									*/
/*  9)  Not needed as the document is marked as changed anyway.		*/
/*									*/
/************************************************************************/
int tedObjectInsertBitmap(	EditDocument *		ed,
				AppBitmapImage *	abi )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    EditApplication *		ea= ed->edApplication;

    InsertedObject *		io;

    Display *			display= ea->eaDisplay;
    Widget			w= ed->edDocumentWidget;
    Window			win= XtWindow( w );
    GC				gc= ed->edGc;

    MemoryBuffer		mb;
    SimpleOutputStream *	sosMem;
    SimpleOutputStream *	sosHex;

    int				objectNumber;

    double			xfac= ea->eaMagnifiedPixelsPerTwip;

    io= docClaimObject( &objectNumber, td->tdSelection.bsBegin.bpBi );
    if  ( ! io )
	{ XDEB(io); return -1;	}

    sioMemoryInit( &mb );

    sosMem= sioOutMemoryOpen( &mb );
    if  ( ! sosMem )
	{ XDEB(sosMem); return -1;	}

    sosHex= sioOutHexOpen( sosMem );
    if  ( ! sosHex )
	{ XDEB(sosHex); return -1;	}

    if  ( abi->abiFormat >= 0						&&
	  ! strcmp( bmFileFormats[abi->abiFormat].bffFileType->bftTypeId,
								"pngFile" ) )
	{
	if  ( bmPngWritePng( &abi->abiBitmap, abi->abiBuffer, sosHex ) )
	    { LDEB(1); return -1;	}

	io->ioKind= DOCokPICTPNGBLIP;
	}
    else{
	if  ( appMetaSaveBitmapMetafile( &abi->abiBitmap, abi->abiBuffer,
								    sosHex ) )
	    { LDEB(1); return -1;	}

	io->ioKind= DOCokPICTWMETAFILE;
	}

    sioOutClose( sosHex );
    sioOutClose( sosMem );

    io->ioObjectData.odBytes= mb.mbBytes;
    io->ioObjectData.odSize= mb.mbCapacity;

    switch( abi->abiBitmap.bdUnit )
	{
	case BMunCM:
	    io->ioTwipsWide= (int)( ( POINTS_PER_CM* 20* abi->abiBitmap.bdPixelsWide )/
					    abi->abiBitmap.bdXResolution );
	    io->ioTwipsHigh= (int)( ( POINTS_PER_CM* 20* abi->abiBitmap.bdPixelsHigh )/
					    abi->abiBitmap.bdYResolution );
	    break;
	case BMunINCH:
	    io->ioTwipsWide= (int)( ( 72* 20* abi->abiBitmap.bdPixelsWide )/
					    abi->abiBitmap.bdXResolution );
	    io->ioTwipsHigh= (int)( ( 72* 20* abi->abiBitmap.bdPixelsHigh )/
					    abi->abiBitmap.bdYResolution );
	    break;
	case BMunPOINT:
	    io->ioTwipsWide= (int)( ( 20* abi->abiBitmap.bdPixelsWide )/
					    abi->abiBitmap.bdXResolution );
	    io->ioTwipsHigh= (int)( ( 20* abi->abiBitmap.bdPixelsHigh )/
					    abi->abiBitmap.bdYResolution );
	    break;
	default:
	    LDEB(abi->abiBitmap.bdUnit);
	    io->ioTwipsWide= 20* abi->abiBitmap.bdPixelsWide;
	    io->ioTwipsHigh= 20* abi->abiBitmap.bdPixelsHigh;
	    break;
	}

    tedScaleObjectToParagraph( ed, io );

    io->ioPixelsWide= TWIPStoPIXELS( xfac,
				( io->ioScaleX* io->ioTwipsWide )/ 100 );
    io->ioPixelsHigh= TWIPStoPIXELS( xfac,
				( io->ioScaleY* io->ioTwipsHigh )/ 100 );
    io->ioPrivate= abi;

    io->ioXExtent= (int) ( ( 1000.0* io->ioTwipsWide )/ ( 20* POINTS_PER_CM ) );
    io->ioYExtent= (int) ( ( 1000.0* io->ioTwipsHigh )/ ( 20* POINTS_PER_CM ) );

    if  ( appImgMakePixmap( display, ea->eaScreen, win, gc, &io->ioPixmap,
				    io->ioPixelsWide, io->ioPixelsHigh,
				    &ed->edColors, abi ) )
	{ LDEB(1); return -1; }

    tedAppReplaceSelection( ed, (unsigned char *)"", 0 );

    if  ( tedInsertNewObject( ed->edDocumentWidget, io, ed ) )
	{ LDEB(1); return -1;	}

    /*  9
    io->ioBliptag= appGetTimestamp();
    */

    appDocumentChanged( ed->edApplication, ed, 1 );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Callback of the 'Insert Picture' menu option.			*/
/*									*/
/************************************************************************/

static int tedObjectInsertMetafile(	EditDocument *		ed,
					const char *		filename )
    {
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    Widget			w= ed->edDocumentWidget;
    Window			win= XtWindow( w );
    GC				gc= ed->edGc;

    InsertedObject *		io;

    MemoryBuffer		mb;
    SimpleInputStream *		sisIn;
    SimpleOutputStream *	sosMem;
    SimpleOutputStream *	sosMeta;

    int				objectNumber;

    double			xfac= ea->eaMagnifiedPixelsPerTwip;

    sisIn= sioInStdioOpen( filename );
    if  ( ! sisIn )
	{ SXDEB(filename,sisIn); return -1;	}

    io= docClaimObject( &objectNumber, td->tdSelection.bsBegin.bpBi );
    if  ( ! io )
	{ XDEB(io); return -1;	}

    sioMemoryInit( &mb );

    sosMem= sioOutMemoryOpen( &mb );
    if  ( ! sosMem )
	{ XDEB(sosMem); return -1;	}

    sosMeta= sioOutHexOpen( sosMem );
    if  ( ! sosMeta )
	{ XDEB(sosMeta); return -1;	}

    {
    unsigned long		key;
    unsigned int		handle;
    int				left;
    int				top;
    int				right;
    int				bottom;
    unsigned int		inch;

    unsigned long		reserved;
    unsigned int		checksum;

    key= sioEndianGetLeUint32( sisIn );

    if  ( key != 0x9ac6cdd7 )
	{ XDEB(key); return -1;	}

    handle= sioEndianGetLeUint16( sisIn );
    left= sioEndianGetLeInt16( sisIn );
    top= sioEndianGetLeInt16( sisIn );
    right= sioEndianGetLeInt16( sisIn );
    bottom= sioEndianGetLeInt16( sisIn );
    inch= sioEndianGetLeUint16( sisIn );

    reserved= sioEndianGetLeUint32( sisIn );
    checksum= sioEndianGetLeUint16( sisIn );

    if  ( right > left )
	{ io->ioTwipsWide= ( 20* 72* ( right- left ) )/ inch;	}
    else{ io->ioTwipsWide= ( 20* 72* ( left- right ) )/ inch;	}

    if  ( bottom > top )
	{ io->ioTwipsHigh= ( 20* 72* ( bottom- top ) )/ inch;	}
    else{ io->ioTwipsHigh= ( 20* 72* ( top- bottom ) )/ inch;	}

    io->ioXExtent= right- left;
    io->ioYExtent= top- bottom;
    }

    for (;;)
	{
	unsigned char		buf[512];
	int			done;

	done= sioInReadBytes( sisIn, buf, 512 );
	if  ( done < 1 )
	    { break;	}

	if  ( sioOutWriteBytes( sosMeta, buf, done ) != done )
	    { LDEB(done); return -1;	}
	}

    sioOutClose( sosMeta );
    sioOutClose( sosMem );
    sioInClose( sisIn );

    io->ioObjectData.odBytes= mb.mbBytes;
    io->ioObjectData.odSize= mb.mbCapacity;
    io->ioKind= DOCokPICTWMETAFILE;

    tedScaleObjectToParagraph( ed, io );

    io->ioPixelsWide= TWIPStoPIXELS( xfac,
				( io->ioScaleX* io->ioTwipsWide )/ 100 );
    io->ioPixelsHigh= TWIPStoPIXELS( xfac,
				( io->ioScaleY* io->ioTwipsHigh )/ 100 );

    io->ioXExtent= (int) ( ( 1000.0* io->ioTwipsWide )/ ( 20* POINTS_PER_CM ) );
    io->ioYExtent= (int) ( ( 1000.0* io->ioTwipsHigh )/ ( 20* POINTS_PER_CM ) );

    tedAppReplaceSelection( ed, (unsigned char *)"", 0 );

    if  ( tedInsertNewObject( ed->edDocumentWidget, io, ed ) )
	{ LDEB(1); return -1;	}

    /*  9
    io->ioBliptag= appGetTimestamp();
    */

    appDocumentChanged( ed->edApplication, ed, 1 );

    if  ( tedOpenObject( io, &ed->edColors, &(bd->bdFontList),
					    &(ed->edDrawingData), win, gc ) )
	{ LDEB(1);	}

    return 0;
    }

static int tedObjectOpenPicture(	void *		voided,
					Widget		relative,
					Widget		option,
					const char *	filename )
    {
    EditDocument *		ed= (EditDocument *)voided;
    const char *		slash= strrchr( filename, '/' );
    const char *		dot;

    if  ( slash )
	{ dot= strrchr( slash+ 1, '.' );	}
    else{ dot= strrchr( filename, '.' );	}

    if  ( ! dot || strcmp( dot, ".wmf" ) )
	{
	double			factor;
	AppBitmapImage *	abi;

	abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
	if  ( ! abi )
	    { XDEB(abi); return -1;	}
	appInitBitmapImage( abi );

	if  ( bmRead( filename, &abi->abiBuffer, &abi->abiBitmap,
						&abi->abiFormat, &factor ) )
	    { SDEB(filename); return -1;	}

	if  ( tedObjectInsertBitmap( ed, abi ) )
	    { SDEB(filename); return -1; }

	return 0;
	}
    else{
	if  ( tedObjectInsertMetafile( ed, filename ) )
	    { SDEB(filename); return -1; }

	return 0;
	}
    }

void tedDocInsertPicture(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    static AppFileExtension *	openExtensions;
    static int			openExtensionCount;

    static Widget		openPictureChooser;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( openExtensionCount == 0 )
	{
	AppFileExtension *	afe;

	if  ( appImgMakeFileExtensions( &openExtensions,
					&openExtensionCount ) )
	    { LDEB(1); return;	}

	afe= (AppFileExtension *) realloc( openExtensions,
			(openExtensionCount+ 1)* sizeof(AppFileExtension) );
	if  ( ! afe )
	    { LXDEB(openExtensionCount,afe); return; }
	openExtensions= afe;

	afe += openExtensionCount;

	afe->afeId= "wmfFile";
	afe->afeFilter= "*.wmf";
	afe->afeDescription= "Windows Metafile ( *.wmf )";
	afe->afeExtension= "wmf";
	afe->afeUseFlags= APPFILE_CAN_OPEN;

	openExtensionCount++;
	}

    appRunOpenChooser( &openPictureChooser, option, ed->edTopWidget,
			openExtensionCount, openExtensions, (char *)0,
			voided, tedObjectOpenPicture, ea );

    return;
    }
