/************************************************************************/
/*									*/
/*  Format tool:							*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Resources shared by the different pages of a Format Tool.		*/
/*									*/
/************************************************************************/

typedef struct FormatPageResources
    {
    char *		fprSubjectName;
    char *		fprApplyToSubject;
    char *		fprRevert;

    char *		fprNextButtonText;
    char *		fprPrevButtonText;

    char *		fprSelectButtonText;
    char *		fprDeleteButtonText;

    char *		fprInsertButtonText;
    char *		fprAppendButtonText;
    } FormatPageResources;

/************************************************************************/
/*									*/
/*  Resources for the 'Row' page.					*/
/*									*/
/************************************************************************/

typedef struct RowPageResources
    {
    char *		rprHeightFree;
    char *		rprHeightAtLeast;
    char *		rprHeightExactly;

    char *		rprTopBorder;
    char *		rprBottomBorder;

    char *		rprCellMargin;
    char *		rprLeftIndent;
    } RowPageResources;

/************************************************************************/
/*									*/
/*  Resources for the 'Column' page.					*/
/*									*/
/************************************************************************/

typedef struct ColumnPageResources
    {
    char *		cprWidth;
    char *		cprLeftBorder;
    char *		cprRightBorder;
    } ColumnPageResources;

/************************************************************************/
/*									*/
/*  Resources for the 'Table' page.					*/
/*									*/
/************************************************************************/

typedef struct TablePageResources
    {
    char *		tprCellMargin;
    char *		tprLeftIndent;
    } TablePageResources;

/************************************************************************/
/*									*/
/*  Resources for the 'Paragraph; page.					*/
/*									*/
/************************************************************************/

typedef struct ParagraphPageResources
    {
    char *		pprParaFirstIndent;
    char *		pprParaLeftIndent;
    char *		pprParaRightIndent;

    char *		pprParaSpaceAbove;
    char *		pprParaSpaceBelow;

    char *		pprOnNewPage;
    char *		pprOnOnePage;

    char *		pprParaLineDistFree;
    char *		pprParaLineDistAtLeast;
    char *		pprParaLineDistExactly;

    char *		pprTopBorder;
    char *		pprBottomBorder;

    char *		pprParaAlignment;
    char *		pprParaAlignLeft;
    char *		pprParaAlignRight;
    char *		pprParaAlignCentered;
    char *		pprParaAlignJustified;
    } ParagraphPageResources;

/************************************************************************/
/*									*/
/*  Common structures for the array of subject pages on the format tool	*/
/*									*/
/************************************************************************/

typedef struct ToolSubject
    {
    Widget	tsItem;
    Widget	tsPage;

    Widget	tsPrevButton;
    Widget	tsNextButton;

    Widget	tsSelectButton;
    Widget	tsDeleteButton;

    Widget	tsInsertButton;
    Widget	tsAppendButton;

    Widget	tsRevertButton;
    Widget	tsApplyButton;
    } ToolSubject;

/************************************************************************/
/*									*/
/*  A compination of a pulldown menu and a text widget to manage a	*/
/*  height property.							*/
/*									*/
/************************************************************************/

typedef struct HeightChooser
    {
    Widget	hcMenu;
    Widget	hcPulldown;
    Widget	hcText;

    Widget	hcFreeItem;
    Widget	hcExactlyItem;
    Widget	hcAtLeastItem;
    } HeightChooser;

/************************************************************************/
/*									*/
/*  A paragraph tool, i.e. the 'Paragraph' page of the format tool.	*/
/*									*/
/************************************************************************/

typedef struct ParagraphTool
    {
    EditApplication *		ptApplication;

    ParagraphProperties		ptPropertiesSet;
    ParagraphProperties		ptPropertiesChosen;

    Widget			ptFirstIndentText;
    Widget			ptRightIndentText;
    Widget			ptLeftIndentText;

    Widget			ptOnNewPageToggle;
    Widget			ptOnOnePageToggle;

    Widget			ptSpaceAboveToggle;
    Widget			ptSpaceAboveText;

    Widget			ptSpaceBelowToggle;
    Widget			ptSpaceBelowText;

    Widget			ptTopBorderToggle;
    Widget			ptBottomBorderToggle;

    HeightChooser		ptLineDistChooser;

    Widget			ptAlignMenu;
    Widget			ptAlignPulldown;
    Widget			ptAlignLeftItem;
    Widget			ptAlignRightItem;
    Widget			ptAlignCenteredItem;
    Widget			ptAlignJustifiedItem;
    } ParagraphTool;

/************************************************************************/
/*									*/
/*  A row tool, i.e. the 'Row' page of the format tool.			*/
/*									*/
/************************************************************************/

typedef struct RowTool
    {
    EditApplication *		rtApplication;

    RowProperties		rtPropertiesSet;
    RowProperties		rtPropertiesChosen;

    int				rtCol0;
    int				rtCol1;
    int				rtRow00;
    int				rtRow0;
    int				rtRow1;
    int				rtRow11;

    int				rtPageRight;
    int				rtPageLeftMargin;

    Widget			rtNumberText;
    HeightChooser		rtHeightChooser;
    Widget			rtCellMarginText;
    Widget			rtLeftIndentText;

    Widget			rtHeightFreeItem;
    Widget			rtHeightAtLeastItem;
    Widget			rtHeightExactlyItem;

    Widget			rtTopBorderToggle;
    Widget			rtBottomBorderToggle;
    } RowTool;

/************************************************************************/
/*									*/
/*  A column tool, i.e. the 'Column' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct ColumnTool
    {
    EditApplication *		ctApplication;

    int				ctCol0;
    int				ctCol1;
    int				ctRow00;
    int				ctRow0;
    int				ctRow1;
    int				ctRow11;

    int				ctPageRight;
    int				ctPageLeftMargin;

    RowProperties		ctPropertiesSet;
    RowProperties		ctPropertiesChosen;

    Widget			ctNumberText;
    Widget			ctWidthText;

    Widget			ctLeftBorderToggle;
    Widget			ctRightBorderToggle;
    } ColumnTool;

/************************************************************************/
/*									*/
/*  A table tool, i.e. the 'Table' page of the format tool.		*/
/*									*/
/************************************************************************/

typedef struct TableTool
    {
    EditApplication *		ttApplication;

    RowProperties		ttPropertiesSet;
    RowProperties		ttPropertiesChosen;

    int				ttCol0;
    int				ttCol1;
    int				ttRow00;
    int				ttRow0;
    int				ttRow1;
    int				ttRow11;

    int				ttPageRight;
    int				ttPageLeftMargin;

    Widget			ttCellMarginText;
    Widget			ttLeftIndentText;
    } TableTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void tedFormatRefreshHeightChooser(	HeightChooser *	hc,
						int		height );

extern void tedFormatHeightChosen(	Widget			w,
					HeightChooser *		hc,
					int			defaultValue );

extern Widget tedFormatMakePage(	ToolSubject *		ts,
					Widget			pageParent );

extern void tedFormatMakeHeightRow(	Widget *		pRow,
					void *			through,
					Widget			parent,
					HeightChooser *		hc,
					XtCallbackProc		callback );

extern void tedFormatMakeButtonRow(	Widget *		pRow,
					Widget			parent,
					Widget *		pLeftButton,
					Widget *		pRightButton,
					char *			leftLabel,
					char *			rightLabel,
					XtCallbackProc		leftCallback,
					XtCallbackProc		rightCallback,
					void *			through );

extern void tedFormatMakeParagraphPage(	ParagraphTool *			pt,
					Widget				parent,
					const ParagraphPageResources * ppr,
					ToolSubject *			ts,
					const FormatPageResources *	fpr );

extern void tedFormatFinishParagraphPage( ParagraphTool *		pt,
					const ParagraphPageResources *	ppr );

extern void tedFormatFinishRowPage( 	RowTool *			rt,
					const RowPageResources *	rpr );

extern void tedFormatFillParagraphChoosers( ParagraphTool *		pt,
					const ParagraphPageResources *	ppr );

extern void tedFormatFillHeightChooser(	HeightChooser *		hc,
					XtCallbackProc		callback,
					void *			voidtft,
					const char *		freeText,
					const char *		atLeastText,
					const char *		exactlyText );

extern int tedFormatToolGetHeight(	int *		pHeight,
					HeightChooser *	hc );

extern void tedFormatReflectBorder(	Widget				toggle,
					const BorderProperties *	bp );

extern void tedFormatMakeRowPage(	RowTool *			rt,
					Widget				parent,
					const RowPageResources *	rpr,
					ToolSubject *			ts,
					const FormatPageResources *	fpr );

extern void tedFormatFillRowChoosers(	RowTool *			rt,
					const RowPageResources *	rpr );

extern void tedFormatToolRefreshParagraphPage(	ParagraphTool *	pt );

extern void tedFormatMakeTablePage(	TableTool *		tt,
					Widget			pageParent,
					TablePageResources *	tpr,
					ToolSubject *		ts,
					FormatPageResources *	fpr );

extern int tedFormatToolGetRowLeftIndent( const RowProperties *	rp,
					const int		pageLeftMargin,
					int *			pValue,
					Widget			w );

extern int tedFormatToolGetGapWidth(	const RowProperties *	rp,
					int *			pValue,
					Widget			w );

extern void tedFormatMakeColumnPage(	ColumnTool *		ct,
					Widget			pageParent,
					ColumnPageResources *	cpr,
					ToolSubject *		ts,
					FormatPageResources *	fpr );

extern void tedFormatToolRefreshTablePage(	TableTool *	tt );
extern void tedFormatToolRefreshColumnPage(	ColumnTool *	ct );
extern void tedFormatToolRefreshRowPage(	RowTool *	rt );

extern void tedFormatToggleBorder(	BorderProperties *	bp,
					int			set );

extern void tedFormatMakeToggleRow(	Widget *		pRow,
					Widget			parent,
					Widget *		pLeftToggle,
					Widget *		pRightToggle,
					char *			leftText,
					char *			rightText,
					XtCallbackProc		leftCallback,
					XtCallbackProc		rightCallback,
					void *			through );
