#   include	<appFrame.h>
#   include	<appImage.h>
#   include	<X11/Intrinsic.h>

#   include	<appGeo.h>
#   include	<appDraw.h>
#   include	"docBuf.h"
#   include	<sioMemory.h>

/************************************************************************/
/*									*/
/*  Private data for a document.					*/
/*									*/
/************************************************************************/
typedef struct TedDocument
    {
    BufferDocument *	tdDocument;
    TextAttribute	tdCurrentTextAttribute;
    int			tdCurrentPhysicalFont;

    BufferSelection	tdSelection;
    DocumentRectangle	tdSelectedRectangle;

    Widget		tdCopyWidget;
    Widget		tdCutWidget;
    Widget		tdPasteWidget;

    Widget		tdInsertMenu;
    Widget		tdInsertMenuButton;
    Widget		tdInsPictOption;
    Widget		tdInsFileOption;
    Widget		tdInsSymbolWidget;
    Widget		tdInsHyperlinkWidget;
    Widget		tdInsBookmarkWidget;
    Widget		tdInsInsertTableWidget;

    Widget		tdTableMenu;
    Widget		tdTableMenuButton;
    Widget		tdTabInsertTableOption;
    Widget		tdTabAddRowOption;
    Widget		tdTabAddColumnOption;

    Widget		tdFormatMenu;
    Widget		tdFormatMenuButton;
    Widget		tdFormatOneParaOption;

    Widget		tdSelectTableWidget;
    Widget		tdSelectRowWidget;
    Widget		tdSelectColumnWidget;
    Widget		tdDrawTableGridWidgetWidget;

    Widget		tdFontMenu;
    Widget		tdFontMenuButton;
    Widget		tdFontBoldOption;
    Widget		tdFontItalicOption;
    Widget		tdFontUnderlinedOption;
    Widget		tdFontSuperscriptOption;
    Widget		tdFontSubscriptOption;

    Widget		tdToolsMenu;
    Widget		tdToolsMenuButton;

    XColor		tdSelColor;
    XColor		tdXSelColor;
    XColor		tdFieldColor;
    XColor		tdTableColor;

    int			tdVisibleSelectionCopied;
    int			tdCanReplaceSelection;
    int			tdCopiedSelectionClosed;
    MemoryBuffer	tdCopiedSelection;
    MemoryBuffer	tdCopiedFont;
    MemoryBuffer	tdCopiedRuler;
    AppBitmapImage	tdCopiedImage;

    XtIntervalId	tdHideIBarId;
    XtIntervalId	tdShowIBarId;

    Window		tdObjectWindow;
    Window		tdObjectBottomWindow;
    Window		tdObjectRightWindow;
    Window		tdObjectCornerWindow;
    int			tdObjectSelected;

    int			tdDrawTableGrid;
    } TedDocument;

/************************************************************************/
/*									*/
/*  The different resources needed for drawing.				*/
/*  (Just to reduce the number of parameters to the drawing routines)	*/
/*									*/
/************************************************************************/

typedef struct DrawingState
    {
    int		dsLinkPixelSet;
    int		dsPhysicalFont;
    } DrawingState;


typedef struct DrawingContext
    {
    Window		dcWindow;
    GC			dcGc;

    Pixel		dcForePixel;
    Pixel		dcLinkPixel;
    Pixel		dcBackPixel;
    Pixel		dcTablePixel;

    int			dcOx;
    int			dcOy;
    AppDrawingData *	dcDrawingData;

    int			dcDrawTableGrid;

    int			(*dcDrawTextLine)(
				const BufferItem *		bi,
				int				line,
				TextLine *			tl,
				const BufferSelection *		bs,
				const DocumentRectangle *	drClip,
				const FormattingFrame *		ff,
				DrawingState *			ds,
				const struct DrawingContext *	dc );

    int			dcDrawTableBorders;
    } DrawingContext;

#   define	LINEDISTFAC	7

/************************************************************************/
/*									*/
/*  Shared resources.							*/
/*									*/
/************************************************************************/
extern void *		TED_FormatTool;
extern EditDocument *	TED_ManualDocument;

extern const int TedPrimaryTextTargetCount;
extern AppDocSelectionTargetType TedPrimaryTextTargets[];

extern const int TedPrimaryPictureTargetCount;
extern AppDocSelectionTargetType TedPrimaryPictureTargets[];

extern const int TedRulerTargetCount;
extern AppDocSelectionTargetType TedRulerTargets[];

/************************************************************************/
/*									*/
/*  Drawing functionality.						*/
/*									*/
/************************************************************************/

extern int tedDrawIBar(		const BufferPosition *	bp,
				int			ox,
				int			oy,
				Display *		display,
				Window			win,
				GC			gc		);

extern int tedExposeIBar(	const EditDocument *	ed,
				const BufferPosition *	bp );

/************************************************************************/
/*									*/
/*  Geometry calculations.						*/
/*									*/
/************************************************************************/

extern int tedLayoutItem(	BufferItem *		bi,
				BufferDocument *	bd,
				AppDrawingData *	add,
				int			y,
				int *			pY,
				int *			pLastY );

extern int tedLayoutHeaderItem(	BufferItem *		bi,
				BufferDocument *	bd,
				AppDrawingData *	add,
				int			y,
				int *			pY,
				int *			pLastY );

extern int tedFindPosition(	BufferDocument *	bd,
				const AppDrawingData *	add,
				int			x,
				int			y,
				TextParticule **	pTp,
				TextLine **		pTl,
				BufferPosition *	bp	);

extern int tedRecalculateParaLayout(	BufferItem *		bi,
					BufferDocument *	bd,
					AppDrawingData *	add,
					int			line,
					int			yShift,
					int			stroffShift,
					int			upto,
					int			refY1,
					DocumentRectangle *	drChanged );

extern int tedCalculateX(	const BufferItem *	bi,
				const TextParticule *	tp,
				const AppDrawingData *	add,
				int			stroff	);

extern void tedDrawingInput(		Widget		w,
					XtPointer	voided,
					XtPointer	voidcbs	);

extern int tedFindParticule(	TextLine *	tl,
				TextParticule *	tp,
				int		x,
				int		y	);

extern int tedFindStringOffset(	const TextParticule *	tp,
				const unsigned char *	paraString,
				const AppDrawingData *	add,
				int *			pBarX,
				int			x,
				int			y	);

extern int tedHasSelection(	const TedDocument *   td );
extern int tedHasIBarSelection(	const TedDocument *   td );

extern void tedSelectionInput(	Widget		w,
				void *		voided,
				XEvent *	event,
				Boolean *	pRefused	);

extern void tedReplaceSelection(	EditDocument *		ed,
					const unsigned char *	addedText,
					int			addedLength );

extern int tedFirstPosition(	const AppDrawingData *	add,
				BufferDocument *	bd,
				BufferPosition *	bp	);

extern int tedLastPosition(	const AppDrawingData *	add,
				BufferDocument *	bd,
				BufferPosition *	bp	);

extern int tedPrevPosition(	const AppDrawingData *	add,
				BufferPosition *	bp,
				int			lastOne );
extern int tedNextPosition(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedBeginOfLine(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedEndOfLine(	const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedNextLine(		const AppDrawingData *	add,
				BufferPosition *	bp	);
extern int tedPrevLine(		const AppDrawingData *	add,
				BufferPosition *	bp	);

extern int tedPageUp(	BufferPosition *	bp,
			BufferDocument *	bd,
			const AppDrawingData *	add,
			int			pageHeight );

extern int tedPageDown(	BufferPosition *	bp,
			BufferDocument *	bd,
			const AppDrawingData *	add,
			int			docHeight,
			int			pageHeight );

extern void tedObserveFocus(	Widget		w,
				void *		voided,
				XEvent *	event,
				Boolean *	pRefused	);

extern void tedSplitParagraph(		EditDocument *		ed,
					int			onNewPage );

extern void tedSetTab(			Widget			w,
					EditDocument *		ed );

extern int tedChangeSelectionProperties(
				EditDocument *			ed,
				unsigned int			textUpdMask,
				TextAttribute			taNew,
				unsigned int			paraUpdMask,
				const ParagraphProperties *	ppNew );

extern void tedRedrawRectangle(	Widget			w,
				TedDocument *		td,
				DocumentRectangle *	drClip,
				AppDrawingData *	add,
				AppColors *		ac,
				int			ox,
				int			oy,
				Pixel			selPixel,
				Pixel			linkFore,
				Pixel			tableFrame,
				Window			win,
				GC			gc );

extern void tedCalculateSelectedLines(	TedDocument *	td	);

extern void tedAppShowPageTool(		Widget		pageOption,
					XtPointer	voidea,
					XtPointer	voidcbs	 );

extern void tedDocToolFind(		Widget		findOption,
					void *		voided,
					XtPointer	voidcbs );

extern void tedDocToolSpell(		Widget		spellOption,
					XtPointer	voided,
					XtPointer	voidcbs );

extern int tedIncludePlainDocument(	Widget			w,
					EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedIncludeRtfDocument(	Widget			w,
					EditDocument *		ed,
					BufferDocument *	bdFrom );

extern int tedGetDocumentAttributeString(	char *		scratch,
						TedDocument *	td );

extern int tedGetDocumentAttributes(	TedDocument *	td,
					char **		pFamilyName,
					int *		pPsFamilyNumber,
					unsigned int *	pUpdMask,
					TextAttribute *	pTaNew );

extern void tedGetSelectionAttributes(	TedDocument *	td,
					char **		pFamilyName,
					int *		pPsFamilyNumber,
					unsigned int *	pUpdMask,
					TextAttribute *	pTaNew );

extern void tedGetPositionAttributes(	TedDocument *		td,
					const BufferPosition *	bp,
					char **			pFamilyName,
					int *			pPsFamilyNumber,
					unsigned int *		pUpdMask,
					TextAttribute *		pTaNew );

extern void tedDocCopy(		EditDocument *	ed,
				XEvent *	event	);
extern void tedDocCut(		EditDocument *	ed,
				XEvent *	event	);

extern void tedDocSelAll(	EditDocument *	ed,
				XEvent *	event	);

extern void tedSetSelection(	EditDocument *		ed,
				TedDocument *		td,
				BufferSelection *	bs );

extern void tedAppReplaceSelection(	EditDocument *		ed,
					const unsigned char *	word,
					int			len	);

extern void tedExposeHandler(	Widget			w,
				void *			voided,
				XEvent *		event,
				Boolean *		pRefused );

extern void tedSetSelectedPosition(	EditDocument *		ed,
					TedDocument *		td,
					BufferPosition *	bp,
					int *			pScrolledX,
					int *			pScrolledY );

extern int tedBeginSelection(	EditDocument *		ed,
				TedDocument *		td,
				BufferPosition *	newBegin,
				int			x,
				int			y );

extern void tedShowFontsTool(		Widget			fontsOption,
					EditApplication *	ea,
					XtPointer		voidcbs	 );

extern void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
						EditDocument *		ed );

extern void tedAdaptFontsToolToDocument(	EditApplication *	ea,
						EditDocument *		ed );

extern void tedAdaptToolsToSelection(	EditDocument *		ed );

extern int tedExtendSelectionToXY(	EditDocument *		ed,
					const BufferPosition *	bpAnchor,
					int			mouseX,
					int			mouseY );

extern int tedExtendSelectionToPosition(EditDocument *		ed,
					const BufferPosition *	bpAnchor,
					const BufferPosition *	bpFound );

extern void tedScrollToPosition(	EditDocument *		ed,
					const BufferPosition *	bp,
					int *			pScrolledX,
					int *			pScrolledY );

extern void tedScrollToSelection(	EditDocument *		ed,
					const BufferSelection *	bs,
					int *			pScrolledX,
					int *			pScrolledY );

extern void tedDocFontBold(		Widget		boldOption,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern void tedDocFontItalic(	Widget		italicOption,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern void tedDocFontUnderlined(	Widget		underlineOption,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern void tedDocFontSupersub(		Widget		option,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern int tedLayoutDocument(	EditDocument *		ed,
				BufferDocument *	bd );

extern void tedSetRectangles(	EditDocument *		ed,
				DocumentGeometry *	dg,
				double			xfac,
				double			yfac );

extern void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed );

extern void tedAppReplace(	void *			voidea,
				const unsigned char *	word	);

extern void tedGetNamedPictures(	EditApplication *	ea );

extern int tedAppChangeSelectionAttributeString( EditDocument *	ed,
					char *			attributeString );

extern void tedAdaptFontIndicatorsToValues( EditDocument *	ed,
					char *			familyName,
					int			psFamilyNumber,
					unsigned int		updMask,
					TextAttribute		taNew );

extern void tedDocSetTopRuler(	EditDocument *	ed,
				int		documentWidth,
				int		topRulerHeight,
				double		horPixPerMM,
				int		unitInt,
				Display *	display,
				int		screen );

extern void tedDocAdaptHorizontalRuler(	EditDocument *		ed,
					BufferItem *		bi,
					int			andExpose );

extern void tedAdaptToolsToPosition(	EditDocument *		ed,
					int			exposeRuler );

extern void tedEditApplyItemFormat(	EditDocument *	ed,
					BufferItem *	bi );

extern void tedApplyItemFormat(	BufferItem *			bi,
				BufferDocument *		bd,
				AppDrawingData *		add,
				DocumentRectangle *		drChanged );

extern void tedRedrawIBar(	TedDocument *	td,
				int		ox,
				int		oy,
				Display *	display,
				Window		win,
				GC		gc );

extern void tedUndrawIBar(	const EditDocument *	ed );

extern void tedStartCursorBlink(	XtAppContext	context,
					EditDocument *	ed );

extern void tedStopCursorBlink(		XtAppContext	context,
					EditDocument *	ed );

extern int tedOpenItemObjects(	BufferItem *		bi,
				AppColors *		ac,
				DocumentFontList *	dfl,
				AppDrawingData *	add,
				Window			win,
				GC			gc );

extern int tedDrawObject(	const BufferItem *	bi,
				TextParticule *		tp,
				int			y,
				const DrawingContext *	dc );

extern void tedCloseObject(		BufferDocument *	bd,
					BufferItem *		bi,
					TextParticule *		tp,
					void *			voiddisplay );

extern void tedDocInsertPicture(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcs	 );

extern void tedDocInsertFile(		Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcs	 );

extern void tedDocInsertLink(	Widget		option,
				XtPointer	voided,
				XtPointer	voidpbcs	 );

extern void tedDocInsertBookmark(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcs	 );

extern void tedDocFormatOnePara(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcs );

extern int tedInsertNewObject(		Widget			w,
					InsertedObject *	io,
					EditDocument *		ed );

extern void tedPastePrimaryRtf(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern void tedPastePrimaryString(	Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern void tedPasteRulerTed(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern void tedPasteFontTed(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern int tedCopyPrimaryRtf(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyPrimaryString(Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyPrimaryPng(Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyPrimaryPixmap(Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyFontTed(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyRulerTed(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target );

extern int tedCopyAsLink(	EditDocument *		ed,
				const BufferItem *	bi,
				const BufferSelection *	bs,
				const char *		file,
				const char *		markName,
				int			markSize,
				XEvent *		event );

extern void tedPrimaryLost(	Widget				w,
				EditDocument *			ed,
				XSelectionClearEvent *		clrEvent );

extern int tedObjectInsertBitmap(	EditDocument *		ed,
					AppBitmapImage *	abi );

extern void tedPastePrimaryPixmap(	Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern void tedPastePrimaryPng(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent );

extern int tedGetObjectSelection(	TedDocument *   	td,
					BufferItem **		pBi,
					TextLine **		pTl,
					TextParticule **	pTp,
					InsertedObject **	pIo	);

extern void tedSetObjectWindows(	TedDocument *		td,
					BufferItem *		bi,
					TextLine *		tl,
					TextParticule *		tp,
					int			ox,
					int			oy,
					Display *		display,
					Window			win );

extern void tedMoveObjectWindows(	Widget			w,
					EditDocument *		ed );

extern int tedResizeObject(		EditDocument *		ed,
					BufferItem *		bi,
					int			line,
					TextParticule *		tp,
					InsertedObject *	io,
					int			newWidth,
					int			newHeight,
					int			ox,
					int			oy );

extern int tedReopenObject(	BufferDocument *	bd,
				BufferItem *		bi,
				TextParticule *		tp,
				AppColors *		ac,
				DocumentFontList *	dfl,
				AppDrawingData *	add,
				Window			win,
				GC			gc );

extern int tedSaveObjectPicture(	AppBitmapImage *	abiTo,
					InsertedObject *	io );

extern void tedExposeSelection(	const EditDocument *	ed,
				const BufferSelection *	bs,
				int			scrolledX,
				int			scrolledY );

extern void tedPositionCoordinates(	BufferPosition *	bp,
					const AppDrawingData *	add );

extern void tedSelectionCoordinates(	BufferSelection *	bs,
					const AppDrawingData *	add );

extern void tedSelectionRectangle(	DocumentRectangle *	drClip,
					const AppDrawingData *	add,
					const BufferSelection *	bs );

extern void tedDrawingExpose(	Widget		w,
				XtPointer	voided,
				XtPointer	voidcbs	);

extern void tedDrawRectangle(	Widget			w,
				EditDocument *		ed,
				DocumentRectangle *	drClip,
				int			ox,
				int			oy,
				Window			win,
				GC			gc );

extern void tedDocHorizontalScrollbarCallback(	Widget		w,
						XtPointer	voided,
						XtPointer	voidscbs );

extern void tedDocVerticalScrollbarCallback(	Widget		w,
						XtPointer	voided,
						XtPointer	voidscbs );

extern int tedFinishDocumentSetup(	EditApplication *	ea,
					EditDocument *		ed );

extern void tedDocShowPageTool(		Widget		pageOption,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern void tedDocFormatCopyRul(	Widget		fontsOption,
					XtPointer	voided,
					XtPointer	voidpbcbs	 );

extern void tedDocFormatPasteRul(	Widget		fontsOption,
					XtPointer	voided,
					XtPointer	voidpbcbs	 );

extern int tedSetupDocument(	EditApplication *	ea,
				EditDocument *		ed	);

extern int tedMakeDocumentWidget(	EditApplication *	ea,
					EditDocument *		ed,
					Widget			scrollw );

extern int tedChangeParticuleAttribute( AppDrawingData *	add,
					TextParticule *		tp,
					DocumentFontList *	dfl,
					unsigned int		updMask,
					TextAttribute		taNew );

extern int tedInsertTable(	Widget			w,
				EditDocument *		ed,
				int			rows,
				int			columns );

extern void tedParaScreenGeometry(	BufferItem *		bi,
					const FormattingFrame *	ff,
					double			xfac );

extern int tedInsertRowsInTable(	BufferItem *		sectBi,
					const RowProperties *	rp,
					EditDocument *		ed,
					int			row,
					int			rows );

extern void tedParagraphFrame(		FormattingFrame *	ff,
					const AppDrawingData *	add,
					int			bottom,
					const BufferItem *	bi );

extern int tedInsertColumnInTable(	Widget			w,
					EditDocument *		ed );
extern int tedAppendColumnToTable(	Widget			w,
					EditDocument *		ed );
extern int tedInsertRowInTable(		Widget			w,
					EditDocument *		ed );
extern int tedAppendRowToTable(		Widget			w,
					EditDocument *		ed );

extern void tedDocTableSelectTable(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcbs );

extern void tedDocTableSelectRow(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcbs );

extern void tedDocTableSelectColumn(	Widget		option,
					XtPointer	voided,
					XtPointer	voidpbcbs );

extern void tedDocToolInsertSymbol(	Widget		symbolOption,
					XtPointer	voided,
					XtPointer	voidcbs );

extern int tedSplitParaContents(	BufferItem **		pNewBi,
					DocumentRectangle *	drChanged,
					EditDocument *		ed,
					int			splitLevel,
					int			onNewPage );

extern int tedEditSetIBarSelection(	EditDocument *	ed,
					BufferItem *	bi,
					int *		pScrolledX,
					int *		pScrolledY,
					int		stroff );

extern void tedSetTableProperties(	EditApplication *	ea,
					int			col0Set,
					int			col1Set,
					int			row0Set,
					int			row1Set,
					const RowProperties *	rp );

extern int tedGetTableRectangle(	const BufferSelection *	bs,
					BufferItem **		pSectBi,
					int *			pCol0,
					int *			pCol1,
					int *			pCol11,
					int *			pRow00,
					int *			pRow0,
					int *			pRow1,
					int *			pRow11 );

extern void tedAdaptFormatToolToDocument(	void *		voidtft,
						EditDocument *	ed );

extern void tedAppSetTableSelection(	EditDocument *		ed,
					int			col0Set,
					int			col1Set,
					int			row0Set,
					int			row1Set );

extern void tedDocTableSelectTableRectangle(	EditDocument *	ed,
						TedDocument *	td,
						BufferItem *	sectBi,
						int		col0,
						int		col1,
						int		row0,
						int		row1 );

extern void tedChangeTableLayout(	EditDocument *		ed,
					BufferItem *		bi,
					BufferItem *		sectBi,
					const RowProperties *	rp,
					int			rowHeightAlso,
					int			row0,
					int			row1 );

extern void tedDocTableDrawGrid(	Widget		option,
					XtPointer	voided,
					XtPointer	voidcbs	 );

extern void tedMergeParagraphsInSelection(	EditDocument *	ed );

extern int tedDeleteRowsFromTable(	EditDocument *		ed,
					int			delRow0,
					int			delRow1 );

extern int tedDeleteColumnsFromRows(	EditDocument *	ed,
					int		delRow0,
					int		delRow1,
					int		delCol0,
					int		delCol1 );

extern void tedExposeRectangle(	const EditDocument *		ed,
				const DocumentRectangle *	drChanged,
				int				scrolledX,
				int				scrolledY );

extern int tedRunPropertyDialog(	EditApplication *	ea,
					EditDocument *		ed,
					Widget			option,
					const char *		pixmapName );

extern int tedBorderThick(		int *				pWide,
					const BorderProperties *	bp,
					const AppDrawingData *		add );

extern int tedSetHyperlink(	EditDocument *		ed,
				const char *		file,
				const char *		mark );

extern int tedSetBookmark(	EditDocument *		ed,
				const char *		mark );

extern int tedRemoveHyperlink(	EditDocument *		ed );

extern int tedRemoveBookmark(	EditDocument *		ed );

extern int tedCopyBookmarkAsLink(	EditDocument *	ed,
					const char *	link,
					XEvent *	event );

extern void tedRunLinkDialog(	EditApplication *	ea,
				EditDocument *		ed,
				Widget			option,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern void tedRunBookmarkDialog(	EditApplication *	ea,
					EditDocument *		ed,
					Widget			option,
					int			nameProposed,
					const char *		markName,
					int			markSize );

extern int tedGoToBookmark(	EditDocument *		ed,
				const char *		markName,
				int			markSize );

extern int tedSaveDocument(	const EditApplication *		ea,
				const EditDocument *		ed,
				int				format,
				const char *			filename );

extern int tedSetPrivateData(	EditApplication *	ea,
				EditDocument *		ed );

extern void tedMakeDocumentReadonly(	EditDocument *	ed );

extern int tedFollowLink(	Widget			relative,
				Widget			option,
				EditDocument *		edFrom,
				const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize );

extern int tedSelectWholeParagraph(	EditApplication *	ea,
					int			direction );

extern int tedDeleteCurrentParagraph(	EditApplication *	ea );

extern int tedInsertParagraph(	EditApplication *	ea,
				int			after );

extern int tedGetParaLineHeight(	int *			pLineHeight,
					EditDocument *		ed );


extern void tedShowFormatTool(	Widget			toolOption,
				EditApplication *	ea,
				const char *		widgetName,
				const char *		pixmapName );

extern void tedFormatToolAdaptToSelection( void *		voidtft,
				const BufferSelection *		bs,
				int				fileReadonly,
				const DocumentGeometry *	dg );

extern void tedEnableFormatTool(	void *	voidtft,
					int	enabled );

extern int tedNewDocument(	EditApplication *	ea,
				EditDocument *		ed,
				const char *		filename );

extern int tedUpdateParaProperties( unsigned int *	pChangedMask,
				    const AppDrawingData *	add,
				    BufferItem *		bi,
				    unsigned int		updMask,
				    const ParagraphProperties *	newPP );
