/************************************************************************/
/*									*/
/*  Spell checking utility routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<debugon.h>

#   include	"docBuf.h"
#   include	"docSpell.h"

#   include	<ind.h>
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Find the first misspelling from a certain position in a document.	*/
/*									*/
/************************************************************************/

static int docSpellParaFind(	BufferItem *		bi,
				int			stroff,
				int			part,
				int *			pStart,
				int *			pLength,
				SpellCheckContext *	scc	)
    {
    PossibleWord *	possibilities= (PossibleWord *)0;
    TextParticule *	tp= bi->biParaParticules+ part;

    /*  3  */
    while( part < bi->biParaParticuleCount )
	{
	int			count;
	const unsigned char *	str= bi->biParaString+ stroff;

	while( stroff < tp->tpStroff+ tp->tpStrlen )
	    {
	    int		isWord= 0;

	    while( stroff < tp->tpStroff+ tp->tpStrlen			&&
		   ! ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( possibilities, *str );
		stroff++; str++;
		}

	    if  ( stroff < tp->tpStroff+ tp->tpStrlen		&&
		  ( scc->sccCharKinds[*str] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( possibilities, *str );

		possibilities= indNewPossibility( stroff, possibilities, *str );
		if  ( ! possibilities )
		    { XDEB(possibilities); return -1;	}
		isWord= 1;
		}
	    else{ isWord= 0;	}

	    stroff++; str++;
	    while( stroff < tp->tpStroff+ tp->tpStrlen		&&
		   ( scc->sccCharKinds[*str] & CHARisALNUM )	)
		{
		indAddCharacterToPossibilities( possibilities, *str );
		stroff++; str++;
		}

	    if  ( isWord )
		{
		count= indCountPossibilities( possibilities, stroff,
								scc, *str );

		if  ( count == 0 )
		    {
		    PossibleWord *	maxpw;

		    maxpw= indMaximalPossibility( possibilities );

		    *pStart= maxpw->pwStartPosition;
		    *pLength= maxpw->pwInsertionPoint;

		    indFreePossibilities( possibilities );

		    return 0;
		    }
		}
	    }

	possibilities= indRejectPossibilities( possibilities );

	part++; tp++;
	if  ( part < bi->biParaParticuleCount )
	    { stroff= tp->tpStroff;	}
	}

    indFreePossibilities( possibilities );
    return 1;
    }

int docSpellFindNext(	BufferPosition *	bpFrom,
			BufferSelection *	bs,
			SpellCheckContext *	scc	)
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;
    int				part= bpFrom->bpParticule;
    TextParticule *		tp= bi->biParaParticules+ part;
    const unsigned char *	str= bi->biParaString+ stroff;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    if  ( stroff > tp->tpStroff )
	{
	while( stroff < tp->tpStroff+ tp->tpStrlen		&&
	       ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
	    { stroff++; str++; }
	}

    if  ( stroff == tp->tpStroff+ tp->tpStrlen )
	{ tp++; part++;	}

    for (;;)
	{
	ret= docSpellParaFind( bi, stroff, part, &start, &length, scc );

	if  ( ret == 0 )
	    {
	    docSetSelection( bs, bi, 1, start, length );

	    return ret;
	    }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= 0; part= 0;
	}
    }
