#####################################################################
##
##   Find out how to link statically
##
##   1:  From utter stupidity, we only know this for gcc.
##
#####################################################################

AC_DEFUN(AC_LD_FLAGS_STATIC,
[
    echo Checking for static link flags...

    LD_FLAGS_STATIC=

    #   1
    if  test x_$GCC = x_yes
    then
	LD_FLAGS_STATIC=-static
    fi


    AC_SUBST(LD_FLAGS_STATIC)dnl
])
#####################################################################
##
##   Look for libxpm
##
#####################################################################

AC_DEFUN(AC_PATH_XPM,
[
    echo Checking for libxpm...

    XPM_CFLAGS=
    XPM_LIBS=

    ac_xpm_includes=NO
    ac_xpm_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/X11R6/include	\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/apps/include	\
	../xpm
    do
    if  test -r "$ac_dir/X11/xpm.h"
	then
	    ac_xpm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/X11R6/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../xpm/lib
    do
    if  test -r "$ac_dir/libXpm.a"
	then
	    ac_xpm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xpm_includes
    #echo Libraries: $ac_xpm_libraries

    if  test $ac_xpm_includes != NO
    then
	XPM_CFLAGS=-I$ac_xpm_includes

	if  test "$XPM_CFLAGS" = "$X_CFLAGS"
	then
	    XPM_CFLAGS=
	fi
    fi

    if  test $ac_xpm_libraries != NO
    then
	XPM_LIBS="-L$ac_xpm_libraries"

	if  test "$XPM_LIBS" = "$X_LIBS"
	then
	    XPM_LIBS=
	fi
    fi

    AC_SUBST(XPM_CFLAGS)dnl
    AC_SUBST(XPM_LIBS)dnl
])
#####################################################################
##
##   Look for Motif
##
#####################################################################

AC_DEFUN(AC_PATH_XM,
[
    echo Checking for Motif...

    XM_CFLAGS=
    XM_LIBS=
    XM_EXTRA_LIBS=

    ac_xm_includes=NO
    ac_xm_libraries=NO

    # Includes
    for ac_dir in			\
	/usr/X11R6/include		\
	/usr/local/include		\
	/usr/dt/include			\
	/opt/SUNWmotif/include		\
	/usr/apps/include		\
	/usr/local/LessTif/include
    do
    if  test -r "$ac_dir/Xm/Xm.h"
	then
	    ac_xm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in			\
	/usr/X11R6/lib			\
	/usr/local/lib			\
	/usr/dt/lib			\
	/opt/SUNWmotif/lib		\
	/usr/apps/lib			\
	/usr/local/LessTif/include
    do
    if  test -r "$ac_dir/libXm.a"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi

    if  test -r "$ac_dir/libXm.so"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xm_includes
    #echo Libraries: $ac_xm_libraries

    if  test $ac_xm_includes != NO
    then
	XM_CFLAGS=-I$ac_xm_includes

	if  test "$XM_CFLAGS" = "$X_CFLAGS"
	then
	    XM_CFLAGS=
	fi
    fi

    if  test $ac_xm_libraries != NO
    then
	XM_LIBS="-L$ac_xm_libraries"

	if  test "$XM_LIBS" = "$X_LIBS"
	then
	    XM_LIBS=
	fi
    fi

    #  Too simple..
    #  AC_CHECK_LIB( Xp, XpStartPage, XM_EXTRA_LIBS="-lXp" )
    if  test -r $ac_xm_libraries/libXp.a
    then
	XM_EXTRA_LIBS="-lXp"
    else
	if  test -r $ac_xm_libraries/libXp.so
	then
	    XM_EXTRA_LIBS="-lXp"
	fi
    fi

    AC_SUBST(XM_CFLAGS)dnl
    AC_SUBST(XM_LIBS)dnl
    AC_SUBST(XM_EXTRA_LIBS)dnl
])
#####################################################################
##
##   Look for libpng
##
#####################################################################

AC_DEFUN(AC_PATH_PNG,
[
    echo Checking for libpng...

    PNG_CFLAGS=
    PNG_LIBS=

    ac_png_includes=NO
    ac_png_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/X11R6/include	\
	/usr/apps/include	\
	../libpng
    do
    if  test -r "$ac_dir/png.h"
	then
	    ac_png_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	/usr/X11R6/lib		\
	../libpng
    do
    if  test -r "$ac_dir/libpng.a"
	then
	    ac_png_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_png_includes
    #echo Libraries: $ac_png_libraries

    if  test $ac_png_includes != NO
    then
	PNG_CFLAGS=-I$ac_png_includes
    fi

    if  test $ac_png_libraries != NO
    then
	PNG_LIBS="-L$ac_png_libraries"
    fi

    AC_SUBST(PNG_CFLAGS)dnl
    AC_SUBST(PNG_LIBS)dnl
])
#####################################################################
##
##   Look for zlib
##
#####################################################################

AC_DEFUN(AC_PATH_ZLIB,
[
    echo Checking for zlib...

    ZLIB_CFLAGS=
    ZLIB_LIBS=

    ac_zlib_includes=NO
    ac_zlib_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/apps/include	\
	../zlib
    do
    if  test -r "$ac_dir/zlib.h"
	then
	    ac_zlib_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../zlib
    do
    if  test -r "$ac_dir/libz.a"
	then
	    ac_zlib_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_zlib_includes
    #echo Libraries: $ac_zlib_libraries

    if  test $ac_zlib_includes != NO
    then
	ZLIB_CFLAGS=-I$ac_zlib_includes
    fi

    if  test $ac_zlib_libraries != NO
    then
	ZLIB_LIBS="-L$ac_zlib_libraries"
    fi

    AC_SUBST(ZLIB_CFLAGS)dnl
    AC_SUBST(ZLIB_LIBS)dnl
])
#####################################################################
##
##   Look for libjpeg
##
#####################################################################

AC_DEFUN(AC_PATH_JPEG,
[
    echo Checking for libjpeg...

    JPEG_CFLAGS=
    JPEG_LIBS=

    ac_jpeg_includes=NO
    ac_jpeg_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/apps/include	\
	../jpeg
    do
    if  test -r "$ac_dir/jpeglib.h"
	then
	    ac_jpeg_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../jpeg
    do
    if  test -r "$ac_dir/libjpeg.a"
	then
	    ac_jpeg_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_jpeg_includes
    #echo Libraries: $ac_jpeg_libraries

    if  test $ac_jpeg_includes != NO
    then
	JPEG_CFLAGS=-I$ac_jpeg_includes
    fi

    if  test $ac_jpeg_libraries != NO
    then
	JPEG_LIBS="-L$ac_jpeg_libraries"
    fi

    AC_SUBST(JPEG_CFLAGS)dnl
    AC_SUBST(JPEG_LIBS)dnl
])
#####################################################################
##
##   Look for giflib
##
#####################################################################

AC_DEFUN(AC_PATH_GIF,
[
    echo Checking for giflib...

    GIF_CFLAGS=
    GIF_LIBS=
    GIFLIB=

    ac_gif_includes=NO
    ac_gif_libraries=NO
    ac_giflib=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/X11R6/lib		\
	/usr/pkg/include/giflib	\
	/usr/apps/include	\
	../giflib/lib
    do
    if  test -r "$ac_dir/gif_lib.h"
	then
	    ac_gif_includes=$ac_dir
	    break
	fi
    done

    # Library (libgif)
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/X11R6/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../giflib/lib
    do
    if  test -r "$ac_dir/libgif.a"
	then
	    ac_gif_libraries=$ac_dir
	    ac_giflib=-lgif
	    break
	fi
    done

    if  test $ac_giflib = NO
    then
	# Library (libgif)
	for ac_dir in		\
	    /usr/lib		\
	    /usr/local/lib	\
	    /usr/X11R6/lib	\
	    /usr/pkg/lib	\
	    /usr/apps/lib	\
	    ../giflib/lib
	do
	if  test -r "$ac_dir/libungif.a"
	    then
		ac_gif_libraries=$ac_dir
		ac_giflib=-lungif
		break
	    fi
	done
    fi

    #echo Includes : $ac_gif_includes
    #echo Library:   $ac_gif_libraries $ac_giflib

    if  test $ac_gif_includes != NO
    then
	GIF_CFLAGS=-I$ac_gif_includes
    fi

    if  test $ac_gif_libraries != NO
    then
	GIF_LIBS="-L$ac_gif_libraries"
    fi

    if  test $ac_giflib != NO
    then
	GIFLIB="$ac_giflib"
    fi

    AC_SUBST(GIF_CFLAGS)dnl
    AC_SUBST(GIF_LIBS)dnl
    AC_SUBST(GIFLIB)dnl
])
#####################################################################
##
##   Look for libtiff
##
#####################################################################

AC_DEFUN(AC_PATH_TIFF,
[
    echo Checking for libtiff...

    TIFF_CFLAGS=
    TIFF_LIBS=

    ac_tiff_includes=NO
    ac_tiff_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/apps/include	\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/tiffio.h"
	then
	    ac_tiff_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/libtiff.a"
	then
	    ac_tiff_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_tiff_includes
    #echo Libraries: $ac_tiff_libraries

    if  test $ac_tiff_includes != NO
    then
	TIFF_CFLAGS=-I$ac_tiff_includes
    fi

    if  test $ac_tiff_libraries != NO
    then
	TIFF_LIBS="-L$ac_tiff_libraries"
    fi

    AC_SUBST(TIFF_CFLAGS)dnl
    AC_SUBST(TIFF_LIBS)dnl
])
