;; Mule default configuration file

;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).

;; Mule is free software distributed in the forms of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; 87.6.9   created by K.handa
;;; 87.6.15  modified by K.Handa
;;; 88.1.15  modified for Nemacs Ver.2.0 by K.Handa
;;; 88.5.26  modified for Nemacs Ver.2.1 by K.handa
;;; 88.3.23  modified for Nemacs Ver.3.0 by K.handa
;;; 89.11.21 modified for Nemacs Ver.3.2 by K.Handa and S.Tomura
;;; 89.12.15 modified for Nemacs Ver.3.2.1 by S.Tomura
;;; 90.2.28  copied from site-init.el for Nemacs Ver.3.3.0 by K.Handa
;;; 91.3.22  modified for Egg Ver.3.0 by S.Tomura
;;; 92.2.14  modified for Nemacs Ver.4.0.0 by K.Handa
;;; 92.3.5   modified for Mule Ver.0.9.0 by K.Handa <handa@etl.go.jp>
;;; 92.3.23  modified for Mule Ver.0.9.1 by T.Enami <enami@sys.ptg.sony.co.jp>
;;;	coding-system for "nntp" is set to *junet*
;;; 92.4.27  modified for Mule Ver.0.9.4
;;;	by K.Nozoe <nozoe@mtc.telcom.oki.co.jp> and A.Furuta <furuta@sra.co.jp>
;;;	Setting coding-system for MH.
;;; 92.5.15  modified for Mule Ver.0.9.4
;;;	by M.Higashida <manabu@sigmath.osaka-u.ac.jp>
;;;	set-keyboard-coding-system is called after (load keyboard).
;;; 92.5.20  modified for Mule Ver.0.9.4
;;;	by A.Tanaka <aries@ecs.isl.melco.co.jp>
;;;	Setting for MH is changed.
;;; 92.5.29  modified for Mule Ver.0.9.3 by T.Ito <toshi@his.cpl.melco.co.jp>
;;;	Setting for MH is changed again.
;;; 92.7.6   modified for Mule Ver.0.9.5
;;;		by M.Kuwada <kuwada@soliton.ee.uec.ac.jp>
;;;	Setting coding-system for VM.
;;; 92.7.9   modified for Mule Ver.0.9.5 by K.Sakaeda <saka@pfu.fujitsu.co.jp>
;;;	Setting for MH is changed again.
;;; 92.8.6   modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
;;;	mule-util should be loaded at first.
;;; 92.10.11 modified for Mule Ver.0.9.6 by K.Handa <handa@etl.go.jp>
;;;	Setting default fonts and private character sets.
;;; 92.11.27 modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
;;;	New comment added.
;;; 92.12.16 modified for Mule Ver.0.9.7 by K.Handa <handa@etl.go.jp>
;;;	term-setup-hook is set in this file.
;;; 93.2.10  modified for Mule Ver.0.9.7.1
;;;				by T.Enami <enami@sys.ptg.sony.co.jp>
;;;	Used purebytes is shown in loadup.el.
;;; 93.4.10  modified for Mule Ver.0.9.7.1 by K.Handa <handa@etl.go.jp>
;;;	Font for new char-set lc-ascr2l is defined.
;;; 93.4.29  modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
;;;	CNS11643 support.
;;; 93.6.17  modified for Mule Ver.0.9.8 by K.Handa <handa@etl.go.jp>
;;;	Don't specify coding-system for shell.
;;; 93.7.23  modified for Mule Ver.0.9.8 by N.Demizu<nori-d@is.aist-nara.ac.jp>
;;;	For "anno" called by mh-e, *junet* is set.

;;; IMPORTANT NOTICE -- DON'T EDIT THIS FILE!!!
;;;  Keep this file unmodified for further patches being applied successfully.
;;;  All language specific basic environments are defined here.
;;;  By default, Japanese is set as the primary environment.
;;;  You can change primary environment in `./lisp/site-init.el by
;;;  `set-primary-environment'.  For instance,
;;;  	(set-primary-environment 'chinese)
;;;  makes Chinese the primary environment.
;;;  If you are still not satisfied with the settings, you can
;;;  override them after the above line.  For instace,
;;;  	(set-default-file-coding-system '*big5*)
;;;  makes *big5* be used for file I/O by default.
;;;  If you are not satisfied with other default settings in this file,
;;;  override any of them also in `./lisp/site-init.el'.  For instance,
;;;	(define-program-coding-system nil ".*mail.*" '*iso-8859-1*)
;;;  makes the coding-system '*iso-8859-1* be used in mail.


;;;; GLOBAL ENVIRONMENT SETUP

;; For RMAIL and NEWS
;; Notice!  In Korea for mail, use *iso-2022-kr* instead of *junet*.
(define-program-coding-system nil ".*mail.*" *junet*)
(define-program-coding-system nil ".*inews.*" *junet*)
;; For GNUS
;; 92.3.23 by T.Enami - set to *junet*
(define-service-coding-system "nntp" nil *junet*unix)
;; For MH
;; 92.4.27 by K.Nozoe
(define-program-coding-system nil ".*scan.*" *junet*)
(define-program-coding-system nil ".*inc.*" *junet*)
(define-program-coding-system nil ".*mhl.*" *junet*)
;; 93.7.23 by N.Demizu -- for MIME
(define-program-coding-system nil ".*anno.*" *junet*)
;; 92.7.9 by K.Sakaeda
(define-program-coding-system nil ".*rcvstore.*" *junet*)
;; 92.4.27 by A.Furuta, 92.5.20 by A.Tanaka, 92.5.28 by T.Ito
(setq mh-before-send-letter-hook
      '(lambda () (set-file-coding-system *junet*)))
;; For VM
;; 92.7.6 by M.Kuwada, 95.6.9 by K.Rikitake
(add-hook 'vm-mode-hooks
	  '(lambda ()
	     (set-file-coding-system *junet*)))
;; For Wnn and cWnn
(define-service-coding-system "wnn" nil *noconv*)

;; For shells -- 93.6.17 by K.Handa -- commented out
;;(define-program-coding-system nil ".*sh.*" '(nil . nil))

;; For gnus user only
;(setq gnus-your-domain "your.domain.address"
;      gnus-your-organization "Your site name"
;      gnus-use-generic-from t)

;; For rnews user only
(setq news-inews-program "/usr/lib/news/inews")

;; For terminal setup
(setq term-setup-hook
      (function (lambda ()
		  (if window-system nil
		    (set-display-coding-system display-coding-system)
		    (set-keyboard-coding-system keyboard-coding-system)))))


;;;; LANGUAGE SPECIFIC ENVIRONMENT SETUP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ARABIC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun set-arabic-environment ()
  (load "arabic")
  )

(put 'arabic 'primary-function 'set-arabic-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; CHINESE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(make-coding-system
 '*euc-china* 2
 ?C "Coding-system of Chinese EUC (Extended Unix Code)."
 t
 (list lc-ascii lc-cn lc-sisheng nil
	 nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(make-coding-system
 '*hz* 0
 ?v "Codins-system of Hz/ZW used for Chinese."
 nil)
(put *hz* 'post-read-conversion 'hz2gb-region)
(put *hz* 'pre-write-conversion 'gb2hz-region)

;; If you prefer QUAIL to EGG, please modify below as you wish.
(if (and (boundp 'EGG) (boundp 'WNN))
    (progn
      (setq wnn-server-type 'cserver)
      (load "its/pinyin")
      (setq its:*standard-modes*
	    (cons (its:get-mode-map "PinYin") its:*standard-modes*))
      ))

;; For QUAIL
;; Please add your own quail package if any.

;; For GB character input
(add-hook 'quail-package-alist '("py" "quail/py"))
(add-hook 'quail-package-alist '("qj" "quail/qj"))
(add-hook 'quail-package-alist '("punct" "quail/punct"))
(add-hook 'quail-package-alist '("sw" "quail/sw"))
(add-hook 'quail-package-alist '("tonepy" "quail/tonepy"))
(add-hook 'quail-package-alist '("ccdospy" "quail/ccdospy"))
(add-hook 'quail-package-alist '("ctlau" "quail/ctlau"))

;; For BIG5 character input
(add-hook 'quail-package-alist '("py-b5" "quail/py-b5"))
(add-hook 'quail-package-alist '("qj-b5" "quail/qj-b5"))
(add-hook 'quail-package-alist '("punct-b5" "quail/punct-b5"))
(add-hook 'quail-package-alist '("ctlaub" "quail/ctlaub"))
(add-hook 'quail-package-alist '("zozy" "quail/zozy"))
(add-hook 'quail-package-alist '("etzy" "quail/etzy"))

;; For Big5 handling

(define-ccl-program ccl-internal-to-big5-1
  '(0
    ((r1 = ((((r0 - ?\xA1) * 94) + r1) - ?\xA1))
     (r0 = ((r1 / 157) + ?\xA1))
     (r1 %= 157)
     (if (r1 < ?\x3F) (r1 += ?\x40) (r1 += ?\x62))))
  "CCL program convert internal Big5 code (level1) to code point of Big5 font.")

(define-ccl-program ccl-internal-to-big5-2
  '(0
    ((r1 = (((((r0 - ?\xA1) * 94) + r1) - ?\xA1) + 6280))
     (r0 = ((r1 / 157) + ?\xA1))
     (r1 %= 157)
     (if (r1 < ?\x3F) (r1 += ?\x40) (r1 += ?\x62))))
  "CCL program to convert internal Big5 code (level2) to code point of Big5 font.")

(if (not (fboundp 'x-synchronize))
    ;; You don't have X window.
    nil
  (x-set-ccl lc-big5-1 ccl-internal-to-big5-1)
  (x-set-ccl lc-big5-2 ccl-internal-to-big5-2))

(define-ccl-program ccl-big5-to-internal
  '(0
    ((if (r0 < ?\xC9)
	 ((r2 = (((r0 - ?\xA1) * 157) + r1))
	  (r0 = 152))
       ((r2 = (((r0 - ?\xC9) * 157) + r1))
	(r0 = 153)))
     (if (r1 < ?\x7F) (r2 -= ?\x40) (r2 -= ?\x62))
     (r1 = ((r2 / 94) + ?\xA1))
     (r2 = ((r2 % 94) + ?\xA1))
     ))
  "CCL program to convert Big5 code to internal code.")

(defun set-chinese-environment ()
  (load "chinese")

  (setq *coding-category-iso-8-2* '*euc-china*)

  (set-coding-priority
   '(*coding-category-iso-8-2*
     *coding-category-big5*
     *coding-category-iso-8-1*))

  (set-default-file-coding-system '*euc-china*) ; GB encoding
  (setq display-coding-system '*euc-china*)
  (setq keyboard-coding-system '*euc-china*)

  (if (boundp 'EGG)
      (setq-default its:*current-map* (its:get-mode-map "PinYin")))

  (setq-default quail-current-package (assoc "py" quail-package-alist))
  )

(put 'chinese 'primary-function 'set-chinese-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; CYRILLIC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(make-coding-system
 '*iso-8859-5* 2 ?5 "MIME ISO-8859-5" nil
 (list lc-ascii lc-crl nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(add-hook 'quail-package-alist '("jcuken" "quail/cyrillic"))
(add-hook 'quail-package-alist '("macedonian" "quail/cyrillic"))
(add-hook 'quail-package-alist '("serbian" "quail/cyrillic"))
(add-hook 'quail-package-alist '("beylorussian" "quail/cyrillic"))
(add-hook 'quail-package-alist '("ukrainian" "quail/cyrillic"))
(add-hook 'quail-package-alist '("yawerty" "quail/cyrillic"))

(defun set-cyrillic-environment ()
  (setq *coding-category-iso-8-1* '*iso-8859-5*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*iso-8859-5*)
  (setq display-coding-system '*iso-8859-5*)
  (setq keyboard-coding-system '*iso-8859-5*)

  (setq-default quail-current-package (assoc "yawerty" quail-package-alist))
  )

(put 'cyrillic 'primary-function 'set-cyrillic-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ETHIOPIC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-category ?E (make-character lc-ethio) "Ethiopic (Ge'ez) character.")

(define-ccl-program ccl-x-ethio
  '(0
    ((r0 -= 161)
     (r1 -= 161)
     (r0 *= 94)
     (r1 += r0)
     (if (r1 < 256) (r0 = 0) ((r1 -= 256) (r0 = 1))))))

(if (fboundp 'x-synchronize)
    (x-set-ccl lc-ethio ccl-x-ethio))

(add-hook 'quail-package-alist '("ethio" "quail/ethio"))

(defun set-ethio-environment ()
  (setq-default quail-current-package (assoc "ethio" quail-package-alist))
  )

(put 'ethio 'primary-function 'set-ethio-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; EUROPEANS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; 93.8.12 by K.Handa
(make-coding-system
 '*iso-8859-2* 2 ?2 "MIME ISO-8859-2" nil
 (list lc-ascii lc-ltn2 nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(make-coding-system
 '*iso-8859-3* 2 ?3 "MIME ISO-8859-3" nil
 (list lc-ascii lc-ltn3 nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(make-coding-system
 '*iso-8859-4* 2 ?4 "MIME ISO-8859-4" nil
 (list lc-ascii lc-ltn4 nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(make-coding-system
 '*iso-8859-9* 2 ?9 "MIME ISO-8859-9" nil
 (list lc-ascii lc-ltn5 nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(add-hook 'quail-package-alist '("latin-1" "quail/latin"))
(add-hook 'quail-package-alist '("latin-2" "quail/latin"))
(add-hook 'quail-package-alist '("latin-3" "quail/latin"))
(add-hook 'quail-package-alist '("latin-4" "quail/latin"))
(add-hook 'quail-package-alist '("latin-5" "quail/latin"))

(defun set-european-environment ()
  (setq *coding-category-iso-8-1* '*iso-8859-1*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*iso-8859-1*)
  (setq display-coding-system '*iso-8859-1*)
  (setq keyboard-coding-system '*iso-8859-1*)

  (setq-default quail-current-package (assoc "latin-1" quail-package-alist))
  )

(put 'european 'primary-function 'set-european-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; GREEK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(make-coding-system
 '*iso-8859-7* 2 ?7 "MIME ISO-8859-7" nil
 (list lc-ascii lc-grk nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(add-hook 'quail-package-alist '("greek" "quail/greek"))

(defun set-greek-environment ()
  (setq *coding-category-iso-8-1* '*iso-8859-7*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*iso-8859-7*)
  (setq display-coding-system '*iso-8859-7*)
  (setq keyboard-coding-system '*iso-8859-7*)

  (setq-default quail-current-package (assoc "greek" quail-package-alist))
  )

(put 'greek 'primary-function 'set-greek-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; HEBREW
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(make-coding-system
 '*iso-8859-8* 2 ?8 "MIME ISO-8859-8" nil
 (list lc-ascii lc-hbw nil nil nil 'ascii-eol 'ascii-cntl nil nil nil nil t))

(make-coding-system
 '*ctext-hebrew* 2
 ?H "Coding-system of Hebrew."
 nil
 (list lc-ascii lc-hbw nil nil
	 nil 'ascii-eol 'ascii-cntl nil nil nil nil))

(add-hook 'quail-package-alist '("hebrew" "quail/hebrew"))

(defun set-hebrew-environment ()
  (setq *coding-category-iso-8-1* '*iso-8859-8*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*iso-8859-8*)
  (setq display-coding-system '*iso-8859-8*)
  (setq keyboard-coding-system '*iso-8859-8*)

  (setq-default quail-current-package (assoc "hebrew" quail-package-alist))
  )

(put 'hebrew 'primary-function 'set-hebrew-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; JAPANESE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Character category S, A, H, K, G, Y, and C
(define-category ?S (make-character lc-jp 161)
  "Japanese 2-byte symbol character.")
(modify-category-entry (make-character lc-jp 162) ?S)
(modify-category-entry (make-character lc-jp 168) ?S)
(define-category ?A  (make-character lc-jp 163)
  "Japanese 2-byte Alpha numeric character.")
(define-category ?H (make-character lc-jp 164)
  "Japanese 2-byte Hiragana character.")
(define-category ?K (make-character lc-jp 165)
  "Japanese 2-byte Katakana character.")
(define-category ?G (make-character lc-jp 166)
  "Japanese 2-byte Greek character.")
(define-category ?Y (make-character lc-jp 167)
  "Japanese 2-byte Cyrillic character.")
(define-category ?C (make-character lc-jp 176)
  "Japanese 2-byte Kanji characters.")
(let ((c 177))
  (while (< c 256)
    (modify-category-entry (make-character lc-jp c) ?C)
    (setq c (1+ c))))
(let ((chars '(?$B!<(B ?$B!+(B ?$B!,(B)))
  (while chars
    (modify-category-entry (car chars) ?K)
    (modify-category-entry (car chars) ?H)
    (setq chars (cdr chars))))
(let ((chars '(?$B!3(B ?$B!4(B ?$B!5(B ?$B!6(B ?$B!7(B ?$B!8(B ?$B!9(B ?$B!:(B ?$B!;(B)))
  (while chars
    (modify-category-entry (car chars) ?C)
    (setq chars (cdr chars))))
(modify-category-entry (make-character lc-jp2) ?C) ; 93.8.3 by K.Handa

;; 93.7.14 by K.Handa
(define-word-regexp japanese-word-regexp
  "\\cA+\\cH*\\|\\cK+\\cH*\\|\\cC+\\cH*\\|\\cH+\\|\\ck+\\|\\sw+")

(set-word-regexp japanese-word-regexp)
(setq forward-word-regexp "\\w\\>")
(setq backward-word-regexp "\\<\\w")

;; Paragraph setting
;; 93.6.27 by N.Kamei
(setq sentence-end
      (concat 
       "\\("
       "\\("
       "[.?!][]\"')}]*"
       "\\|"
       "[$B!%!)!*(B][$B!O!I!G!K!Q!M!S!U!W!Y(B]*"
       "\\)"
       "\\($\\|\t\\|  \\)"
       "\\|"
       "$B!#(B"
       "\\)"
       "[ \t\n]*"))
(setq paragraph-start "^[ $B!!(B\t\n\f]")
(setq paragraph-separate "^[ $B!!(B\t\f]*$")

;; EGG specific setup
(if (boundp 'EGG)
    (progn
      (setq wnn-server-type 'jserver)
      (load "its/hira")
      (load "its/kata")
      (load "its/hankaku")
      (load "its/zenkaku")
      (setq its:*standard-modes*
	    (append
	     (list (its:get-mode-map "roma-kana")
		   (its:get-mode-map "roma-kata")
		   (its:get-mode-map "downcase")
		   (its:get-mode-map "upcase")
		   (its:get-mode-map "zenkaku-downcase")
		   (its:get-mode-map "zenkaku-upcase"))
	     its:*standard-modes*))))

(defun set-japanese-environment ()
  (setq *coding-category-iso-8-2* '*euc-japan*)

  (set-coding-priority
   '(*coding-category-iso-8-2*
     *coding-category-sjis*
     *coding-category-iso-8-1*
     *coding-category-big5*))

  (setq keyboard-coding-system '*junet*)
  (setq display-coding-system '*junet*)

  (set-default-file-coding-system '*junet*)

  (if (boundp 'EGG)
      (setq-default its:*current-map* (its:get-mode-map "roma-kana")))

  ;; <MULE-COMMENT>
  ;; Shift-JIS code is the standard coding system under Japanese
  ;; MS-DOS.
  ;; (by Mineharu Takahara mtakahar@jp.oracle.com)
  ;; </MULE-COMMENT>
  (if (eq system-type 'ms-dos)
      (progn
	(set-keyboard-coding-system *sjis*dos)
	(set-display-coding-system *sjis*dos)
	(set-default-file-coding-system *sjis*dos)
	(set-default-process-coding-system *sjis*dos *sjis*dos)))
  )

(put 'japanese 'primary-function 'set-japanese-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; KOREAN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; EGG specific setup
;(if (boundp 'EGG)
;    (progn
;      (load "its-hangul")
;      (setq its:*standard-modes*
;	    (cons (its:get-mode-map "hangul") its:*standard-modes*))
;      (setq-default its:*current-map* (its:get-mode-map "hangul"))))

(add-hook 'quail-package-alist '("hangul" "quail/hangul"))
(add-hook 'quail-package-alist '("hangul3" "quail/hangul3"))
(add-hook 'quail-package-alist '("hanja-jis" "quail/hanja-jis"))
(add-hook 'quail-package-alist '("hanja-ksc" "quail/hanja-ksc"))

(defun set-korean-environment ()
  (setq *coding-category-iso-8-2* '*euc-korea*)

  (set-coding-priority
   '(*coding-category-iso-8-2*
     *coding-category-iso-8-1*))

  (set-default-file-coding-system '*iso-2022-kr*)

  (setq-default quail-current-package (assoc "hangul" quail-package-alist))
  )

(put 'korean 'primary-function 'set-korean-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; THAI
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(make-coding-system
 '*tis620* 2
 ?T "Coding-system used for ASCII(MSB=0) & TIS620(MSB=1)."
 t
 (list lc-ascii lc-thai lc-invalid lc-invalid
       nil 'ascii-eol))
(put '*tis620* 'post-read-conversion 'thai-compose-region)
(put '*tis620* 'pre-write-conversion 'decompose-region)

(add-hook 'quail-package-alist '("thai" "quail/thai"))

(defun set-thai-environment ()
  (setq *coding-category-iso-8-1* '*tis620*)

  (set-coding-priority
   '(*coding-category-iso-8-1*
     *coding-category-iso-8-2*))

  (set-default-file-coding-system '*tis620*)

  (setq-default quail-current-package (assoc "thai" quail-package-alist))
  )

(put 'thai 'primary-function 'set-thai-environment)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; VIETNAMESE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-category-mnemonic ?v "Vietnamese character.")
(modify-category-entry (make-character lc-vn-1) ?v)
(modify-category-entry (make-character lc-vn-2) ?v)

(define-ccl-program ccl-read-viscii
  '(3
    ((read r0)
      (loop
	  (write-read-repeat
	   r0
	   [ 0 1 ?,2F(B 3 4 ?,2G(B ?,2g(B 7 8 9 10 11 12 13 14 15
	     16 17 18 19 ?,2V(B 21 22 23 24 ?,2[(B 26 27 28 29 ?,2\(B 31
	     32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47
	     48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63
	     64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79
	     80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95
	     96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111
	     112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 
	     ?,2U(B ?,2!(B ?,2"(B ?,2#(B ?,2$(B ?,2%(B ?,2&(B ?,2'(B ?,2((B ?,2)(B ?,2*(B ?,2+(B ?,2,(B ?,2-(B ?,2.(B ?,2/(B
	     ?,20(B ?,21(B ?,22(B ?,25(B ?,2~(B ?,2>(B ?,26(B ?,27(B ?,28(B ?,2v(B ?,2w(B ?,2o(B ?,2|(B ?,2{(B ?,2x(B ?,2O(B
	     ?,2u(B ?,1!(B ?,1"(B ?,1#(B ?,1$(B ?,1%(B ?,1&(B ?,1'(B ?,1((B ?,1)(B ?,1*(B ?,1+(B ?,1,(B ?,1-(B ?,1.(B ?,1/(B
	     ?,10(B ?,11(B ?,12(B ?,2^(B ?,2=(B ?,15(B ?,16(B ?,17(B ?,18(B ?,2q(B ?,2Q(B ?,2W(B ?,2X(B ?,1=(B ?,1>(B ?,2_(B
	     ?,2`(B ?,2a(B ?,2b(B ?,2c(B ?,2d(B ?,2e(B ?,1F(B ?,1G(B ?,2h(B ?,2i(B ?,2j(B ?,2k(B ?,2l(B ?,2m(B ?,2n(B ?,1O(B
	     ?,2p(B ?,1Q(B ?,2r(B ?,2s(B ?,2t(B ?,1U(B ?,1V(B ?,1W(B ?,1X(B ?,2y(B ?,2z(B ?,1[(B ?,1\(B ?,2}(B ?,1^(B ?,1_(B
	     ?,1`(B ?,1a(B ?,1b(B ?,1c(B ?,1d(B ?,1e(B ?,1f(B ?,1g(B ?,1h(B ?,1i(B ?,1j(B ?,1k(B ?,1l(B ?,1m(B ?,1n(B ?,1o(B
	     ?,1p(B ?,1q(B ?,1r(B ?,1s(B ?,1t(B ?,1u(B ?,1v(B ?,1w(B ?,1x(B ?,1y(B ?,1z(B ?,1{(B ?,1|(B ?,1}(B ?,1~(B ?,2f(B ]))))
  "CCL program to read VISCII 1.1")

(define-ccl-program ccl-write-viscii
  (` (1
     ((read r0)
      (loop
       (if (r0 < 128)
	   (write-read-repeat r0)
	 (if (r0 != (, lc-prv11))
	     (write-read-repeat r0)
	   ((read-if (r0 == (, lc-vn-1))
	     ((read r0)
	      (r0 -= 160)
	      (write-read-repeat
	       r0
	     [  0 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175
	      176 177 178   0   0 181 182 183 184   0   0   0   0 189 190   0
	        0   0   0   0   0   0 198 199   0   0   0   0   0   0   0 207
		0 209   0   0   0 213 214 215 216   0   0 219 220   0 222 223
	      224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239
	      240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 0
	      ]))
	     (if (r0 == (, lc-vn-2))
		 ((read r0)
		  (r0 -= 160)
		  (write-read-repeat
		   r0
	       [  0 129 130 131 132 165 134 135 136 137 138 139 140 141 142 143
	        144 145 146   0   0 147 150 151 152   0   0   0   0 180 149   0
		  0   0   0   0   0   0   2   5   0   0   0   0   0   0   0 159
		  0 186   0   0   0 128  20 187 188   0   0  25  30   0 179 191
	        192 193 194 195 196 197 255   6 200 201 202 203 204 205 206 155
	        208 185 210 211 212 160 153 154 158 217 218 157 156 221 148   0
		]))
	       (write-read-repeat r0))))))))))
  "CCL program to write VISCII 1.1")

(make-coding-system
 '*viscii* 4
 ?V "Coding-system used for VISCII 1.1."
 t
 (cons ccl-read-viscii ccl-write-viscii))

(make-coding-system
 '*viqr* 0
 ?v "Codins-system used for VIQR."
 nil)
(put '*viqr* 'post-read-conversion 'vn-compose-viqr)
(put '*viqr* 'pre-write-conversion 'vn-decompose-viqr)

(define-ccl-program ccl-read-vscii
  '(3
     ((read r0)
      (loop
	  (write-read-repeat r0
       [0 ?,2z(B ?,2x(B 3 ?,2W(B ?,2X(B ?,2f(B 7 8 9 10 11 12 13 14 15
	16 ?,2Q(B ?,2_(B ?,2O(B ?,2V(B ?,2[(B ?,2}(B ?,2\(B 24 25 26 27 28 29 30 31
	32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47
	48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63
	64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79
	80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95
	96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111
	112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 
	?,2`(B ?,2d(B ?,2c(B ?,2a(B ?,2U(B ?,2#(B ?,2'(B ?,2h(B ?,2k(B ?,2((B ?,2i(B ?,2)(B ?,2.(B ?,2l(B ?,2o(B ?,2n(B
	?,2m(B ?,28(B ?,2r(B ?,2v(B ?,2u(B ?,2s(B ?,2w(B ?,25(B ?,26(B ?,27(B ?,2^(B ?,2>(B ?,2~(B ?,2y(B ?,2|(B ?,2{(B
	160 ?,2e(B ?,2b(B ?,2j(B ?,2t(B ?,2=(B ?,2_(B ?,2p(B ?,1e(B ?,1b(B ?,1j(B ?,1t(B ?,1>(B ?,1y(B ?,1p(B ?,2"(B
	192 193 194 195 196 ?,1`(B ?,1d(B ?,1c(B ?,1a(B ?,1U(B ?,2F(B ?,1"(B ?,1F(B ?,1G(B ?,1!(B ?,2G(B
	?,2!(B ?,2%(B ?,2&(B ?,2g(B ?,2%(B ?,2+(B ?,1#(B ?,1%(B ?,1&(B ?,1g(B ?,1$(B ?,1'(B ?,1h(B ?,2,(B ?,1k(B ?,1((B
	?,1i(B ?,1)(B ?,1+(B ?,1,(B ?,1-(B ?,1*(B ?,1.(B ?,1l(B ?,1o(B ?,2-(B ?,2*(B ?,20(B ?,1n(B ?,1m(B ?,18(B ?,1r(B
	?,21(B ?,1v(B ?,1u(B ?,1s(B ?,1w(B ?,10(B ?,11(B ?,12(B ?,1/(B ?,15(B ?,16(B ?,17(B ?,1^(B ?,1>(B ?,1~(B ?,1y(B
	?,22(B ?,1|(B ?,1{(B ?,1z(B ?,1x(B ?,1W(B ?,1X(B ?,1f(B ?,1Q(B ?,1q(B ?,1O(B ?,1V(B ?,1[(B ?,1}(B ?,1\(B ?,2/(B]))))
  "CCL program to read VSCII-1.")

(define-ccl-program ccl-write-vscii
  (` (1
     ((read r0)
      (loop
	  (if (r0 < 128)
	      (write-read-repeat r0)
	    (if (r0 != (, lc-prv11))
		(write-read-repeat r0)
	      (read-if (r0 == (, lc-vn-1))
	       ((read r0)
		(r0 -= 160)
		(write-read-repeat
		 r0
	     [  0 190 187 198 202 199 200 203 207 209 213 210 211 212 214 232
	      229 230 231   0   0 233 234 235 222   0   0   0   0   0 237   0
	        0   0   0   0   0   0 188 189   0   0   0   0   0   0   0 250
	        0 248   0   0   0 185 251 245 246   0   0 252 254   0 236   0
	      181 184 169 183 182 168 247 201 204 208 170 206 215 221 220 216
	      174 249 223 227 171 226 225 228 244 239 243 242 241 253 238   0
	      ]))
	       (if (r0 == (, lc-vn-2))
		((read r0)
		 (r0 -= 160)
		 (write-read-repeat
		  r0
	       [  0 192 175 133   0 196 194 134 137 139 218 197 205 217 140 255
	        219 224 240   0   0 151 152 153 145   0   0   0   0 165 155   0
		  0   0   0   0   0   0 186 191   0   0   0   0   0   0   0  19
		  0  17   0   0   0 132  20   4   5   0   0  21  23   0 154 166
	        128 131 162 130 129 161   6 195 135 138 163 136 141 144 143 142
	        167   0 146 149 164 148 147 150   2 157   1 159 158  22 156   0
		]))
		(write-read-repeat r0)))))))))
  "CCL program to write VSCII-1.")

(make-coding-system
 '*vscii* 4
 ?V "Coding-system used for VSCII-1."
 t
 (cons ccl-read-vscii ccl-write-vscii))

(define-ccl-program ccl-x-vn-1-viscii
  '(0
     ((r1 = r1
       [  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
          0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175
	176 177 178   0   0 181 182 183 184   0   0   0   0 189 190   0
	  0   0   0   0   0   0 198 199   0   0   0   0   0   0   0 207
	  0 209   0   0   0 213 214 215 216   0   0 219 220   0 222 223
	224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239
	240 241 242 243 244 245 246 247 248 249 250 251 252 253 254   0
	])))
  "CCL program to convert chars of lc-vn-1 to VISCII 1.1 font")

(define-ccl-program ccl-x-vn-2-viscii
  '(0
     ((r1 = r1
       [  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
          0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143
	144 145 146   0   0 147 150 151 152   0   0   0   0 180 149   0
	  0   0   0   0   0   0   2   5   0   0   0   0   0   0   0 159
	  0 186   0   0   0 128  20 187 188   0   0  25  30   0 179 191
	192 193 194 195 196 197 255   6 200 201 202 203 204 205 206 155
	208 185 210 211 212 160 153 154 158 217 218 157 156 221 148   0
	])))
  "CCL program to convert chars of lc-vn-2 to VISCII 1.1 font")

(define-ccl-program ccl-x-vn-1-vscii
  '(0
     ((r1 = r1
       [  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0 190 187 198 202 199 200 203 207 209 213 210 211 212 214 232
	229 230 231   0   0 233 234 235 222   0   0   0   0   0 237   0
	  0   0   0   0   0   0 188 189   0   0   0   0   0   0   0 250
	  0 248   0   0   0 185 251 245 246   0   0 252 254   0 236   0
	181 184 169 183 182 168 247 201 204 208 170 206 215 221 220 216
	174 249 223 227 171 226 225 228 244 239 243 242 241 253 238   0
	])))
  "CCL program to convert chars of lc-vn-1 to VSCII-1 font.")

(define-ccl-program ccl-x-vn-2-vscii
  '(0
     ((r1 = r1
       [  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0
	  0 192 175 133   0 196 194 134 137 139 218 197 205 217 140 255
	219 224 240   0   0 151 152 153 145   0   0   0   0 165 155   0
	  0   0   0   0   0   0 186 191   0   0   0   0   0   0   0  19
	  0  17   0   0   0 132  20   4   5   0   0  21  23   0 154 166
	128 131 162 130 129 161   6 195 135 138 163 136 141 144 143 142
	167   0 146 149 164 148 147 150   2 157   1 159 158  22 156   0
	])))
  "CCL program to convert chars of lc-vn-2 to VSCII-1 font.")

(if (not (fboundp 'x-synchronize))
    ;; You don't have X window.
    nil
  ;; For VISCII users
  (x-set-ccl lc-vn-1 ccl-x-vn-1-viscii)
  (x-set-ccl lc-vn-2 ccl-x-vn-2-viscii)
  ;; For VSCII users
  ;; (x-set-ccl lc-vn-1 ccl-x-vn-1-vscii)
  ;; (x-set-ccl lc-vn-2 ccl-x-vn-2-vscii)
  )

(add-hook 'quail-package-alist '("viqr" "quail/viet"))

(defun set-viet-environment ()
  ;; For VISCII users
  (setq *coding-category-bin* '*viscii*)
  ;; For VSCII users
  ;; (setq *coding-category-bin* '*vscii*)

  (set-coding-priority
   '(*coding-category-bin*))

  (set-default-file-coding-system '*viscii*)

  (setq-default quail-current-package (assoc "viqr" quail-package-alist))
  )

(put 'viet 'primary-function 'set-viet-environment)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; OTHERS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(add-hook 'quail-package-alist '("ipa" "quail/ipa"))

;;; Set Japanese as primary environment by default.
(set-primary-environment 'japanese)

;;; mule-init.el ends here
