/*
 * LEVEE, or Captain Video;  A vi clone
 *
 * Copyright (c) 1982-1997 David L Parsons
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by David L Parsons (orc@pell.chi.il.us).  My name may not be used
 * to endorse or promote products derived from this software without
 * specific prior written permission.  THIS SOFTWARE IS PROVIDED
 * AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.
 */
#include <unistd.h>

#include "levee.h"
#include "extern.h"

boolean getline(char *str)
{
    int len;
    char flag;
    
    flag = line(str, 0, COLS-curpos.x, &len);
    str[len] = 0;
    strput(CE);
    return (flag == EOL);
} /* getline */


char readchar()
{
    ch = peekc();		/* get the peeked character */
    needchar = TRUE;		/* force a read on next readchar/peekc */
    if (xerox) {		/* save this character for redo */
	if (rcp >= &rcb[256-1])	/* oops, buffer overflow */
	    error();
	else			/* concat it at the end of rcb^ */
	    *rcp++ = ch;
    }
    return ch;
} /* readchar */


/* look at next input character without actually using it */
char peekc()
{
    if (needchar) {				/* if buffer is empty, */
	if (macro >= 0) {			/* if a macro */
	    lastchar = *mcr[macro].ip;
	    mcr[macro].ip++;
	    if (*mcr[macro].ip == 0) {
		if (--mcr[macro].m_iter > 0) {
		    mcr[macro].ip = mcr[macro].mtext;
		} else {
		    --macro;
		}
	    }
	} else {			/* else get one from the keyboard */
	    lastchar = getKey();
	}
        needchar = FALSE;
    }
    return lastchar;
} /* peekc */


/* find the amount of leading whitespace between start && limit.
   endd is the last bit of whitespace found.
*/
int findDLE(int start, int *endd, int limit, int dle)
{
    while ((core[start] == '\t' || core[start] == ' ') && start < limit) {
	if (core[start] == '\t')
	    dle = tabsize * (1+(dle/tabsize));
	else
	    dle++;
	start++;
    }
    *endd = start;
    return dle;
} /* findDLE */


int skipws(int loc)
{
    while ((core[loc] == '\t' || core[loc] == ' ') && loc <= bufmax)
	loc++;
    return(loc);
} /* skipws */


int setX(int cp)
{
    int top, xp;
    
    top = bseekeol(cp);
    xp = 0;
    while (top < cp) {
	switch (cclass(core[top])) {
	    case 0 : xp++; break;
	    case 1 : xp += 2; break;
	    case 2 : xp = tabsize*(1+(xp/tabsize)); break;
	    case 3 : xp += 3; break;
	}
	top++;
    }
    return(xp);
} /* setX */

/* I renumbered this to look more pretty */
int setY(int cp)
{
    int yp = 0;
    int ix = ptop;

    cp = min(cp, bufmax - 1);

    while ((ix = fseekeol(ix) + 1) <= cp) 
	yp++;

    return(yp);
} /* setY */


int to_line(int cp)
{
    int tdx = 0;
    int line = 0;

    while (tdx <= cp) {
	tdx = 1 + fseekeol(tdx);
	line++;
    }
    return(line);
} /* to_line */


int to_index(int line)
{
    int cp = 0;
    while (cp < bufmax && line > 1) {
	cp = 1+fseekeol(cp);
	line--;
    }
    return(cp);
} /* to_index */
    
void swap(int *a, int *b)
{
    int c;
    
    c = *a;
    *a = *b;
    *b = c;
} /* swap */


int cclass(unsigned char c)
{
    if (c == '\t' && !list)
	return 2;
    if (c == '' || c < ' ')
	return 1;
    if (c & 0x80)
	return 3;

    return 0;
} /* cclass */

void error()
{
    indirect = FALSE;
    macro = -1;

    if (xerox)
	rcb[0] = 0;
    xerox = FALSE;

    if (tbeep)
	strput(BELL);
} /* error */


/* the dirty work to start up a macro */
void insertmacro(char *cmdstr, int count)
{
    if (macro >= NMACROS)
	error();
    else if (*cmdstr != 0) {
	macro++;
	mcr[macro].mtext = cmdstr;	/* point at the text */
	mcr[macro].ip = cmdstr;		/* starting index */
	mcr[macro].m_iter = count;	/* # times to do the macro */
    }
} /* insertmacro */


int lookup(char c)
{
    int ix = MAXMACROS;
    
    while (--ix >= 0 && mbuffer[ix].token != c)
	;
    return ix;
} /* lookup */


void fixmarkers(int base, int offset)
{
    char c;
    
    for (c = 0; c < 'z' - '`'; c++)
	if (contexts[(int)c] > base) {
	    if (contexts[(int)c] + offset <  base ||
	        contexts[(int)c] + offset >= bufmax) {

		contexts[(int)c] = -1;
	    } else {
		contexts[(int)c] += offset;
	    }
	}
} /* fixmarkers */


void wr_stat()
{
    clrprompt();
    if (filenm[0] != 0) {
	printch('"');
	prints(filenm);
	prints("\" ");
	if (newfile)
	    prints("<New file> ");
    }
    else
	prints("No file");
    printch(' ');
    if (readonly)
	prints("<readonly> ");
    else if (modified)
	prints("<Modified> ");
    if (bufmax > 0) {
	prints(" line ");
	printi(to_line(curr));
	prints(" -");
	printi((int)((long)(curr*100L)/(long)bufmax));
	prints("%-");
    }
    else
	prints("-empty-");
} /* wr_stat */


static int  tabptr,
	    tabstack[20],
	    ixp;
	
void back_up(char c)
{
    switch (cclass(c)) {
	case 0: ixp--; break;
	case 1: ixp -= 2; break;
	case 2: ixp = tabstack[--tabptr]; break;
	case 3: ixp -= 3; break;
    }
    levee_mvcur(-1,ixp);
} /* back_up */


/*
 *  put input into buf[] || instring[].
 *  return states are:
 *	0 : backed over beginning
 *    ESC : ended with an ESC
 *    EOL : ended with an '\r'
 */
char line(char *s, int start, int endd, int *size)
{
    int col0,
	ip;
    char c;
    
    col0 = ixp = curpos.x;
    ip = start;
    tabptr = 0;
    for (;;) {
	c = readchar();
	if (movemap[(int)c] == INSMACRO)	/* map!ped macro */
	    insertmacro(mbuffer[lookup(c)].m_text, 1);
	else if (c == DW) {
	    while (!wc(s[ip-1]) && ip > start)
		back_up(s[--ip]);
	    while (wc(s[ip-1]) && ip > start)
		back_up(s[--ip]);
	}
	else if (c == eraseline) {
	    ip = start;
	    tabptr = 0;
	    levee_mvcur(-1,ixp=col0);
	}
	else if (c==Erasechar) {
	    if (ip>start)
		back_up(s[--ip]);
	    else {
		*size = 0;
		return(0);
	    }
	}
	else if (c=='\r' || c==ESC) {
	    *size = (ip-start);
            return (c==ESC) ? ESC : EOL;
	}
	else if ((!beautify) || c == TAB || c == ''
			     || (c >= ' ' && c <= '~')) {
	    if (ip < endd) {
		if (c == '')
		    c = readchar();
		switch (cclass(c)) {
		    case 0 : ixp++; break;
		    case 1 : ixp += 2; break;
		    case 2 :
			tabstack[tabptr++] = ixp;
			ixp = tabsize*(1+(ixp/tabsize));
			break;
		    case 3 : ixp += 3; break;
		}
		s[ip++] = c;
		printch(c);
	    }
	    else
		error();
	}
        else
	    error();
    }
} /* line */

/* move to core[loc] */
void setpos(int loc)
{
    lstart = bseekeol(loc);
    lend = fseekeol(loc);
    xp = setX(loc);
    curr = loc;
} /* setpos */


void resetX()
{
    if (deranged) {
	xp = setX(curr);
	levee_mvcur(-1, xp);
	deranged = FALSE;
    }
} /* resetX */


/* set end of window */
void setend()
{
    int bottom, count;
    
    bottom = ptop;
    count = LINES-1;
    while (bottom < bufmax && count > 0) {
	bottom = 1+fseekeol(bottom);
	count--;
    }
    pend = bottom-1;		/* last char before eol || eof */
} /* setend */


/*  set top of window
 *  return the number of lines actually between curr && ptop.
 */
int settop(int line)
{
    int top, yp;
    
    top = curr;
    yp = -1;
    do {
	yp++;
	top = bseekeol(top) - 1;
	line--;
    } while (top >= 0 && line > 0);
    ptop = top+1;			/* tah-dah */
    setend();
    return(yp);
} /* settop */
