%  -*- mode: SLang; mode: fold -*-
% Japanese KANJI code library


define	TRUE()	{return -1;}
define	FALSE()	{return 0;}

% If your slang-j's version in jed-j is after 0.3.2,
% you can use KANJI function name.
% but, that file's KANJI code must be the same SLang buffer KANJI code.
%define ̊֐()
%{
%   message("SLang-j 0.3.2 ȍ~ł͊֐Ɋg܂");
%}

define set_jedcode(code)
{
   if ((code != ASCII) and (code != EUC))
     SLang_code = SJIS;
   else 
     SLang_code = code;
}

define	set_default_kanji_fileio_code(code)
{
	if ((ASCII <= code) and (code <= SJIS))
		kfile_code = code;
}

define	get_default_kanji_fileio_code()
{
	return kfile_code;
}

define	rot_default_kanji_fileio_code()
{
	kfile_code++;
	if ((kfile_code < ASCII) or (SJIS < kfile_code))
		kfile_code = ASCII;
}

define	set_kanji_input_code(code)
{
	if ((ASCII <= code) and (code <= SJIS))
		kinput_code = code;
}

define	get_kanji_input_code()
{
	return kinput_code;
}

define	rot_kanji_input_code()
{
	kinput_code++;
	if ((kinput_code < ASCII) or (SJIS < kinput_code))
		kinput_code = ASCII;
}


define	set_kanji_display_code(code)
{
	if ((ASCII <= code) and (code <= SJIS))
		kdisplay_code = code;
}

define	get_kanji_display_code()
{
	return kdisplay_code;
}

define	rot_kanji_display_code()
{
	kdisplay_code++;
	if ((kdisplay_code < ASCII) or (SJIS < kdisplay_code))
		kdisplay_code = ASCII;
}



% returns
%	0x000: mark, space, kanji mark, kanji space.
%	0x001: number
%	0x002: alphabette
%	0x004: hankaku kana
%	0x010: 2byte number
%	0x020: 2byte alphabette
%	0x040: 2byte hiragana
%	0x080: 2byte katakana
%	0x100: 2byte kanji
define char_type(ch)
{
   variable mode = 0;

   if(('0' <= ch) and (ch <= '9'))
     mode = 1;
   else if((('a' <= ch) and (ch <= 'z')) or (('A' <= ch) and (ch <= 'Z')))
     mode = 2;
   else if((0xa1 <= ch) and (ch <= 0xe0))
     mode = 4;
   else if(ch & 0xff00)		% KANJI
     {
	if (SLang_code == SJIS)
	  {
	     if(ch == 0x815b)		% hiragana | katakana
	       mode = 0xc0;
	     else if((0x824f <= ch) and (ch <= 0x8258))	% 2byte '0' - '9'
	       mode = 0x10;
	     else if(((0x8260 <= ch) and (ch <= 0x8279)))	% 2byte alphabette
	       mode = 0x20;
	     else if(((0x8281 <= ch) and (ch <= 0x829a)))	% 2byte alphabette
	       mode = 0x20;
	     else if((0x82a0 <= ch) and (ch <= 0x82f1))		% hiragana
	       mode = 0x40;
	     else if((0x8340 <= ch) and (ch <= 0x8396))		% katakana
	       mode = 0x80;
	     else if(0x889f <= ch)		% kanji
	       mode = 0x100;
	  }
	else if (SLang_code == EUC)
	  {
	     if(ch == 0xa1bc)		% hiragana | katakana
	       mode = 0xc0;
	     else if((0xa3b0 <= ch) and (ch <= 0xa3b9))	% 2byte '0' - '9'
	       mode = 0x10;
	     else if(((0xa3c1 <= ch) and (ch <= 0xa3da)))	% 2byte alphabette
	       mode = 0x20;
	     else if(((0xa3e1 <= ch) and (ch <= 0xa3fa)))	% 2byte alphabette
	       mode = 0x20;
	     else if((0xa4a2 <= ch) and (ch <= 0xa4f3))		% hiragana
	       mode = 0x40;
	     else if((0xa5a1 <= ch) and (ch <= 0xa5f6))		% katakana
	       mode = 0x80;
	     else if(0xb0a1 <= ch)		% kanji
	       mode = 0x100;
	  }
     }
   
   return mode;
}


define jskip_non_word_chars(mode)	% forward: mode != 0	backward: mode == 0
{
   variable n = 0;
%   while(skip_non_word_chars(), jwhat_char() == 0x8140 )  % 0x8140 is 2byte KANJI white space.
   while(char_type(jwhat_char()) == 0)
	{
	   if(mode) {
		 !if(right(1)) break;
	   }
	   else {
		  !if (left(1)) break;
	   }
	   n++;
	}
   return n;
}
 
define jskip_word ()
{
   variable ch, mode;
%   while (jskip_non_word_chars(), eolp())
%     {
%		if (1 != right(1)) break;
%     }

   jskip_non_word_chars(1);
   
%   ch = jwhat_char();
   mode = char_type(jwhat_char());
   while(right(1))
	 {
		variable t;
		
		t = char_type(jwhat_char());
		!if(t & mode) return;
		if(t < mode) mode = t;
	 }
}

define jbskip_word ()
{
   variable ch, mode;

   !if(left(1)) return;
   jskip_non_word_chars(0);

   mode = char_type(jwhat_char());
   while(left(1))
	 {
		variable t;
		
		t = char_type(jwhat_char());
		!if(t & mode) {
		   right(1);
		   return;
		}
		if(t < mode) mode = t;
	 }
}

% flg is TRUE/FALSE
define	auto_file_code (flg)
{
	KfioAuto = flg;
	file_kanjicode_detect = flg;
}

define print_jversion()
{
   variable kanji_major_version, kanji_minor_version, kanji_fix_version;
   variable slkanji_major_version, slkanji_minor_version, slkanji_fix_version;
   
   kanji_major_version = _jed_jversion / 10000;
   kanji_minor_version = (_jed_jversion / 100) - (kanji_major_version * 100);
   kanji_fix_version = _jed_jversion - (kanji_minor_version * 100);
   slkanji_major_version = _slang_jversion / 10000;
   slkanji_minor_version = (_slang_jversion / 100) - (slkanji_major_version * 100);
   slkanji_fix_version = _slang_jversion - (slkanji_minor_version * 100);
   message(Sprintf("Jed-j Version is %d.%d.%d\tSLang-j Version is %d.%d.%d",
		   kanji_major_version, kanji_minor_version, kanji_fix_version,
		   slkanji_major_version, slkanji_minor_version, slkanji_fix_version, 6));
}

