%   Borland-like IDE Mode for JED	-*- SLang -*-
%
%   Put the line: () = evalfile ("ide.sl");
%   in your jed.rc startup file.
%
%   Written by Guido Gonzato <guido@ibogfs.cineca.it>
%   based on John E. Davis' original wordstar.sl and Stuart Herbert's
%   old Borland routines.
%
%   This file makes jed a jolly good 99% compatible with the true-blue 
%   WordStar, jstar, and - what counts more! - the Borland IDE, while 
%   maintaining some Emacs compatibility (blocks are handled in a fashion
%   similar to Emacs').
%
%   Please send me requests and bug reports, should you find any.
%
%   Last modified: December 22, 1997

Help_File = "ide.hlp";

%
%  Key definitions for Linux and DOS.
%

#ifdef MSDOS

variable Key_F1         = "^@;";
variable Key_F2         = "^@<";
variable Key_F3         = "^@=";
variable Key_F4         = "^@>";
variable Key_F5         = "^@?";
variable Key_F6         = "^@@";
variable Key_F7         = "^@A";
variable Key_F8         = "^@B";
variable Key_F9         = "^@C";
variable Key_F10        = "^@D";
variable Key_Ins        = "\xE0R";
variable Key_Del        = "\xE0S";
variable Key_Home       = "\xE0G";
variable Key_End        = "\xE0O";
variable Key_PgUp       = "\xE0I";
variable Key_PgDown     = "\xE0Q";
variable Key_ArUp       = "\xE0H";
variable Key_ArDown     = "\xE0P";
variable Key_ArRight    = "\xE0M";
variable Key_ArLeft     = "\xE0K";
variable Key_Alt_F	= "\eF";
variable Key_Alt_E	= "\eE";
variable Key_Alt_M	= "\eM";
variable Key_Alt_S	= "\eS";
variable Key_Alt_C	= "\eC";
variable Key_Alt_B	= "\eB";
variable Key_Alt_W	= "\eW";
variable Key_Alt_H	= "\eH";
variable Key_Alt_Y	= "\eY";
variable Key_Alt_F3	= "\ej";
variable Key_Alt_BS	= "\e^O";

#else

% Linux assumed - key bindings kind of work under other Unices and VMS

#ifdef XWINDOWS
variable Key_F1 	= "^[[11~";
variable Key_F2		= "^[[12~";
variable Key_F3		= "^[[13~";
variable Key_F4		= "^[[14~";
variable Key_F5		= "^[[15~";
#else
variable Key_F1 	= "^[[[A";
variable Key_F2		= "^[[[B";
variable Key_F3		= "^[[[C";
variable Key_F4		= "^[[[D";
variable Key_F5		= "^[[[E";
#endif

variable Key_F6		= "^[[17~";
variable Key_F7		= "^[[18~";
variable Key_F8		= "^[[19~";
variable Key_F9		= "^[[20~";
variable Key_F10	= "^[[21~";
variable Key_Ins	= "^[[2~";
variable Key_Del	= "^[[3~";
variable Key_Home	= "^[[1~";
variable Key_End	= "^[[4~";
variable Key_PgUp	= "^[[5~";
variable Key_PgDown	= "^[[6~";
variable Key_ArUp	= "^[[A";
variable Key_ArDown	= "^[[B";
variable Key_ArRight	= "^[[C";
variable Key_ArLeft	= "^[[D";
variable Key_Alt_F	= "\ef";
variable Key_Alt_E	= "\ee";
variable Key_Alt_M	= "\em";
variable Key_Alt_S	= "\es";
variable Key_Alt_C	= "\ec";
variable Key_Alt_B	= "\eb";
variable Key_Alt_W	= "\ew";
variable Key_Alt_H	= "\eh";
variable Key_Alt_Y	= "\ey";
variable Key_Alt_F3	= strcat("\e", Key_F3);
variable Key_Alt_BS	= "\e^?";

#endif

CASE_SEARCH = 1;			% I prefer this way
variable Ide_Bookmark_Exist = 1;	% internal use

set_status_line (" Jed %v : %b   (%m%n)   (%p %c)   %t", 1);

set_abort_char (30);    % ^^ (Control 6 on most keyboards)
% Note, the above command BREAKS ^G emacs abort.

unsetkey("^B");
unsetkey("^F");
unsetkey("^K");
unsetkey("^U");
unsetkey("^V");
unsetkey("^W");
unsetkey("^X");
unsetkey(Key_F1);
unsetkey(Key_ArUp);	% arrows keys are redefined to add the
unsetkey(Key_ArDown);	% "goto previous position" feature
unsetkey(Key_ArLeft);
unsetkey(Key_ArRight);
unsetkey(Key_PgUp);
unsetkey(Key_PgDown);
%
% Basic commands: cursor movement, delete, search & replace, etc.
%
setkey ("begin_macro", "\e(");
setkey ("compile", Key_F9);
setkey ("delete_char_cmd", "^G");
setkey ("delete_line","^Y");
setkey ("end_macro", "\e)");
setkey ("execute_macro", "\em");
setkey ("format_paragraph", "^B");
setkey ("toggle_overwrite", "^V");
setkey ("undo", "^U");
setkey ("ide_bdelete_word", Key_Alt_BS);
setkey ("ide_bdelete_word", "\eo");
setkey ("ide_bskip_word", "^A");
setkey ("ide_delete_word", "^T");
setkey ("ide_insert_last_block", "^P");
setkey ("ide_next_char_cmd", "^D");
setkey ("ide_next_char_cmd", Key_ArRight);
setkey ("ide_next_line_cmd", "^X");
setkey ("ide_next_line_cmd", Key_ArDown);
setkey ("ide_page_down", "^C");
setkey ("ide_page_down", Key_PgDown);
setkey ("ide_page_up", "^R");
setkey ("ide_page_up", Key_PgUp);
setkey ("ide_previous_char_cmd", "^S");
setkey ("ide_previous_char_cmd", Key_ArLeft);
setkey ("ide_previous_line_cmd", "^E");
setkey ("ide_previous_line_cmd", Key_ArUp);
setkey ("ide_repeat_search", "^L");
setkey ("ide_skip_word", "^F");
setkey ("ide_window_down", "^Z");
setkey ("ide_window_up", "^W");
%
% Borland-style commands
%
setkey ("compile", Key_Alt_C);		% ALT-C
setkey ("IDE_buffer_menu", Key_Alt_B);	% ALT-B
setkey ("IDE_edit_menu", Key_Alt_E);	% ALT-E
setkey ("IDE_file_menu", Key_Alt_F);	% ALT-F
setkey ("IDE_menu", Key_F10);		% F10
% setkey ("IDE_mode_menu", Key_Alt_M);	% ALT-M
setkey ("IDE_search_menu", Key_Alt_S);	% ALT-S
setkey ("IDE_system_menu", Key_Alt_Y);	% ALT-Y
setkey ("IDE_window_menu", Key_Alt_W);	% ALT-W
setkey ("ide_help", Key_F1);
setkey ("ide_help", Key_Alt_H);		% ALT-H
%
% Control-Q keys  --- hope you figure out how to pass ^Q/^S through system
% In case you *cannot* figure out how, you can use ESC+^key instead of ^Q; 
% for instance, ESC-^Y acts as ^Q-Y.
% This makes ide.sl usable on non-Linux or non-DOS terminals - namely,
% vt100 and compatibles.
%
setkey (".0 ide_goto_mark_n", "^Q0");
setkey (".1 ide_goto_mark_n", "^Q1");
setkey (".2 ide_goto_mark_n", "^Q2");
setkey (".3 ide_goto_mark_n", "^Q3");
setkey (".4 ide_goto_mark_n", "^Q4");
setkey (".5 ide_goto_mark_n", "^Q5");
setkey (".6 ide_goto_mark_n", "^Q6");
setkey (".7 ide_goto_mark_n", "^Q7");
setkey (".8 ide_goto_mark_n", "^Q8");
setkey (".9 ide_goto_mark_n", "^Q9");
#ifndef MSDOS
setkey (".0 ide_goto_mark_n", "\e0");
setkey (".1 ide_goto_mark_n", "\e1");
setkey (".2 ide_goto_mark_n", "\e2");
setkey (".3 ide_goto_mark_n", "\e3");
setkey (".4 ide_goto_mark_n", "\e4");
setkey (".5 ide_goto_mark_n", "\e5");
setkey (".6 ide_goto_mark_n", "\e6");
setkey (".7 ide_goto_mark_n", "\e7");
setkey (".8 ide_goto_mark_n", "\e8");
setkey (".9 ide_goto_mark_n", "\e9");
#endif
setkey ("kill_line", "^QY");
setkey ("kill_line", "^Q^Y");
setkey ("ide_bob", "^QR");
setkey ("ide_bob", "^Q^R");
setkey ("ide_bol", "^QS");
setkey ("ide_bol", "^Q^S");
setkey ("ide_bol", Key_Home);
setkey ("ide_eob", "^QC");
setkey ("ide_eob", "^Q^C");
setkey ("ide_eol", "^QD");
setkey ("ide_eol", "^Q^D");
setkey ("ide_eol", Key_End);
setkey ("ide_goto_begin_block", "^QB");
setkey ("ide_goto_begin_block", "^Q^B");
setkey ("ide_goto_bottom_of_window", "^QX");
setkey ("ide_goto_bottom_of_window", "^Q^X");
setkey ("ide_goto_end_block", "^QK");
setkey ("ide_goto_end_block", "^Q^K");
setkey ("ide_goto_line_cmd", "^QI");
setkey ("ide_goto_line_cmd", "^Q^I");
setkey ("ide_goto_prev", "^QP");
setkey ("ide_goto_top_of_window", "^QE");
setkey ("ide_goto_top_of_window", "^Q^E");
setkey ("ide_replace_cmd", "^QA");
setkey ("ide_replace_cmd", "^Q^A");
setkey ("ide_search_forward", "^QF");
setkey ("ide_search_forward", "^Q^F");
setkey ("ide_toggle_case", "^QT");
setkey ("ide_toggle_case", "^Q^T");
#ifndef MSDOS
setkey ("kill_line", "\e^Y");
setkey ("ide_bob", "\e^R");
setkey ("ide_bol", "\e^S");
setkey ("ide_eob", "\e^C");
setkey ("ide_eol", "\e^D");
setkey ("ide_goto_begin_block", "\e^B");
setkey ("ide_goto_bottom_of_window", "\e^X");
setkey ("ide_goto_end_block", "\e^K");
setkey ("ide_goto_line_cmd", "\e^I");
setkey ("ide_goto_prev", "\e^P");
setkey ("ide_goto_top_of_window", "\e^E");
setkey ("ide_replace_cmd", "\e^A");
setkey ("ide_search_forward", "\e^F");
setkey ("ide_toggle_case", "\e^T");
#endif
%
% Control-K map
%
setkey (".0 ide_set_mark_n", "^K0");
setkey (".1 ide_set_mark_n", "^K1");
setkey (".2 ide_set_mark_n", "^K2");
setkey (".3 ide_set_mark_n", "^K3");
setkey (".4 ide_set_mark_n", "^K4");
setkey (".5 ide_set_mark_n", "^K5");
setkey (".6 ide_set_mark_n", "^K6");
setkey (".7 ide_set_mark_n", "^K7");
setkey (".8 ide_set_mark_n", "^K8");
setkey (".9 ide_set_mark_n", "^K9");
setkey ("exit_jed", "^KX");
setkey ("exit_jed", "^K^X");
setkey ("open_file", "^KE");
setkey ("open_file", "^K^E");
setkey ("open_file", Key_F3);
setkey ("kill_buffer", "^KQ");
setkey ("kill_buffer", "^K^Q");
setkey ("kill_buffer", Key_Alt_F3);
setkey ("one_window", "^KI");
setkey ("one_window", "^K^I");
setkey ("one_window", Key_F5);
setkey ("save_buffer", "^KD");
setkey ("save_buffer", "^K^D");
setkey ("save_buffer", Key_F2);
setkey ("suspend", "^KZ");
setkey ("suspend", "^K^Z");
setkey ("switch_to_buffer", "^KP");
setkey ("switch_to_buffer", "^K^P");
setkey ("switch_to_buffer", Key_F6);
setkey ("ide_begin_block", "^KB");	% set mark
setkey ("ide_begin_block", "^K^B");
setkey ("ide_comment_block", "^K;");
setkey ("ide_copy_block", "^KC");	% yank
setkey ("ide_copy_block", "^K^C");
setkey ("ide_delete_block", "^KY");	% kill region
setkey ("ide_delete_block", "^K^Y");
setkey ("ide_end_block", "^KK");	% exchange point and mark
setkey ("ide_end_block", "^K^K");
setkey ("ide_filter_region", "^K/");
setkey ("ide_insert_file", "^KR");
setkey ("ide_insert_file", "^K^R");
setkey ("ide_lowercase_region", "^KL");
setkey ("ide_lowercase_region", "^K^L");
% setkey ("ide_move_block", "^KV");	% no longer implemented
% setkey ("ide_move_block", "^K^V");
setkey ("ide_save_buffer", "^KS");
setkey ("ide_save_buffer", "^K^S");
setkey ("ide_select_word", "^KT");
setkey ("ide_select_word", "^K^T");
setkey ("ide_clear_block", "^KH");	% clear but copy to clipboard
setkey ("ide_clear_block", "^K^H");
setkey ("ide_uncomment_block", "^K:");
setkey ("ide_uppercase_region", "^KU");
setkey ("ide_uppercase_region", "^K^U");
setkey ("ide_write_region", "^KW");
setkey ("ide_write_region", "^K^W");

%
% Now let's implement the damn thing
%

!if (is_defined("_Ide_Bookmarks"))
{
  % user marks are of type 128
   $1 = 13;

  % bookmarks 0..9 are for the user; bookmark 10 is used by some of the
  % following functions; bookmark 11 and 12 mark the beginning and end of
  % the block (used by ^QB and ^QK)

  variable _Ide_Bookmarks = create_array (128, $1, 1);
  variable _Ide_Bookmarks_Exist = create_array ('i', $1, 1);
  variable i;
  for (i = 0; i < $1; i++)
    _Ide_Bookmarks_Exist [i] = -1; % not initialized
}

%  ide_set_bookmark () and ide_goto_bookmark () are implemented to provide
%  a more Borland-ish way of copying and moving blocks, and of moving 
%  around generally.

define ide_set_bookmark ()
{
  _Ide_Bookmarks[10] = create_user_mark ();
  Ide_Bookmark_Exist = 1;
}
   
define ide_goto_bookmark ()
{
  variable mrk = _Ide_Bookmarks[10];
  ide_set_bookmark ();
  sw2buf (user_mark_buffer (mrk));
  goto_user_mark (mrk);
}

%
% Basic commands: cursor movement, delete, s&r, etc.
%

define ide_execute_macro ()		% ESC-M
{
  ide_set_bookmark ();
  call ("execute_macro");
}

define ide_previous_char_cmd ()		% Key_ArLeft
{
  ide_set_bookmark ();
  call ("previous_char_cmd");
}

define ide_next_char_cmd ()		% Key_ArRight
{
  ide_set_bookmark ();
  call ("next_char_cmd");
}

define ide_next_line_cmd ()		% Key_ArDown
{
  ide_set_bookmark ();
  call ("next_line_cmd");
}

define ide_previous_line_cmd ()		% Key_ArUp
{
  ide_set_bookmark ();
  call ("previous_line_cmd");
}

define ide_page_down ()			% Key_PgDown
{
  ide_set_bookmark ();
  call ("page_down");
}

define ide_page_up ()			% Key_PgUp
{
  ide_set_bookmark ();
  call ("page_up");
}

define ide_bob ()			% ^QR
{
  ide_set_bookmark ();
  bob ();
}

define ide_eob ()			% ^QC
{
  ide_set_bookmark ();
  eob ();
}

define ide_bol ()			% Key_Home
{
  ide_set_bookmark ();
  bol ();
}

define ide_eol ()			% Key_End
{
  ide_set_bookmark ();
  eol ();
}

define ide_goto_bottom_of_window ()	% ^QX
{
  ide_set_bookmark ();
  goto_bottom_of_window ();
}

define ide_goto_top_of_window ()	% ^QE
{
  ide_set_bookmark ();
  goto_top_of_window ();
}

define ide_window_up ()			% ^W
{
  ide_set_bookmark ();
  recenter (window_line() + 1);
}

define ide_window_down ()		% ^Z
{
  ide_set_bookmark ();
  recenter (window_line() + 1);
}

define ide_goto_line_cmd ()		% ^QI
{
  ide_set_bookmark ();
  goto_line_cmd ();
}

define ide_replace_cmd ()		% ^QA
{
  ide_set_bookmark ();
  replace_cmd ();
}

define ide_search_forward ()		% ^QF
{
  ide_set_bookmark ();
  search_forward ();
}

define ide_toggle_case ()		% ^QT
{
  variable on_off;
  CASE_SEARCH = not(CASE_SEARCH);
  if (CASE_SEARCH == 1)
    on_off = "On";
  else
    on_off = "Off";
  vmessage ("Case search is %s ", on_off, 1);
}

define ide_repeat_search ()		% ^L
{
  ide_set_bookmark ();
  go_right_1 ();
   !if (fsearch(LAST_SEARCH)) error ("Not found.");
}

define ide_bdelete_word ()		% M-O
{
  variable p = POINT;
  
  ide_set_bookmark ();
  push_mark ();
  bskip_chars ("a-zA-Z0-9");
  if (POINT == p) bskip_chars (" \n\t"); 
  if (POINT == p) left (1);
  del_region ();
}

define ide_bskip_word ()		% ^A
{
  variable p = POINT;
  
  ide_set_bookmark ();
  push_mark ();
  bskip_chars ("\n\t !\"#$%&'()*+,-./:;<=>?@[\]^`{|}~");
  bskip_chars ("^\n\t !\"#$%&'()*+,-./:;<=>?@[\]^`{|}~");
  pop_mark_0 ();
}

define ide_delete_word ()		% ^T
{
  variable p = POINT;
        
  push_mark ();
  skip_chars ("a-zA-Z0-9");
  if (POINT == p) skip_chars (" \n\t"); 
  if (POINT == p) right (1);
  del_region ();
}

define ide_skip_word ()			% ^F
{
  variable p = POINT;

  ide_set_bookmark ();
  push_mark ();
  skip_chars ("^\n\t !\"#$%&'()*+,-./:;<=>?@[\]^`{|}~"); 
  if (POINT == p) {
    skip_chars ("\n\t !\"#$%&'()*+,-./:;<=>?@[\]^`{|}~");
    skip_chars ("^\n\t !\"#$%&'()*+,-./:;<=>?@[\]^`{|}~"); 
  }
  pop_mark_0 ();
}

define open_file ()			% Key_F3
{
  variable file = read_file_from_mini ("Open file:");
  () = find_file (file);
}

% Blocks: ^K-something
%
% the blocks are no longer as in wordstar.sl. We don't cheat anymore. Rather,
% blocks are implemented a la Emacs to maintain compatibility with most .sl
% files (e.g., latex.sl, cmode.sl, etc)

% copies block to internal buffer-- preserves block

variable IDE_Block_Buffer = "*ide-clipboard*";
variable IDE_Block_Buffer_Empty = 1;

define ide_copy_block_to_buffer ()
{
  if (1 == IDE_Block_Buffer_Empty) {
    setbuf(IDE_Block_Buffer);
    call ("yank");
  }
}

define ide_begin_block ()		% ^KB
{
  _Ide_Bookmarks[11] = create_user_mark ();
  call ("set_mark_cmd");
  message ("Begin block.");
}

define ide_end_block ()			% ^KK
{
  _Ide_Bookmarks[12] = create_user_mark ();
  exchange_point_and_mark ();
  message ("Block defined.");
}

define ide_copy_block ()		% ^KC
{
  ide_set_bookmark ();
  call ("yank");
  ide_goto_bookmark ();
  message ("Block copied.");
  ide_copy_block_to_buffer ();
  IDE_Block_Buffer_Empty = 0;
}

define ide_goto_begin_block ()		% ^QB
{
  variable mrk = _Ide_Bookmarks[11];
  ide_set_bookmark ();
  sw2buf (user_mark_buffer (mrk));
  ide_set_bookmark ();
  goto_user_mark (mrk);
}

define ide_goto_end_block ()		% ^QK
{
  variable mrk = _Ide_Bookmarks[12];
  ide_set_bookmark ();
  sw2buf (user_mark_buffer (mrk));
  ide_set_bookmark ();
  goto_user_mark (mrk);
}

define ide_delete_block ()		% ^KY
{
  call ("kill_region");
}

define ide_clear_block ()		% ^KH
{
  %  let's make this work like a cut followed by a paste
  ide_delete_block ();
  call ("yank");
  _Ide_Bookmarks[12] = create_user_mark ();
  ide_copy_block_to_buffer ();
  IDE_Block_Buffer_Empty = 0;
}

define ide_show_clipboard ()		% Key_Alt_E S
{
  setbuf(IDE_Block_Buffer);
  pop2buf(whatbuf());
}

define ide_goto_prev ()			% ^QP
{
  if (Ide_Bookmark_Exist != 1) 
    error ("No previous location!");
  ide_goto_bookmark ();
}

define ide_write_region ()		% ^KW
{
  write_region ();
}

%  Variables for (un)commenting regions

variable cbeg = Null_String, cmid = Null_String, cend = Null_String;
variable smode, mode;

define ide_set_comment ()
{
  (smode, mode) = what_mode ();

  if (string_match(smode, "TeX", 1)) {	% TeX/LaTeX mode
    cbeg = "% ";
    cmid = "% ";
    cend = Null_String;
  }

  !if (strcmp(smode,"html")) {		% html mode
    cbeg = "<!--";
    cmid = " -*-"; % Null_String;
    cend = " -->";
  }
  
  !if (strcmp(smode,"C")) {		% C mode
    cbeg = "/* ";
    cmid = " * ";
    cend = " */";
  }
  
  if (string_match(smode, "SL", 1)) {	% Slang mode
    cbeg = "% ";
    cmid = "% ";
    cend = Null_String;
  }

  !if (strcmp(smode,"SH")) {		% Shell mode
    cbeg = "# ";
    cmid = "# ";
    cend = Null_String;
  }

  !if (strcmp(smode,"Fortran")) {	% Fortran mode
    cbeg = "C ";
    cmid = "C ";
    cend = Null_String;
  }
}

define ide_comment_region ()
{
  ide_set_comment ();
  push_spot ();
  narrow ();
  bob ();
  insert (cbeg);
  while (2 == down(2)) {
    go_up_1 ();
    bol ();
    insert (cmid);
  } 
  insert (cend);
  widen ();
  pop_spot ();
}

define ide_uncomment_region ()
{
  variable len_cbeg, len_cmid, len_cend;
  
  ide_set_comment ();
  len_cbeg = strlen (cbeg);
  len_cmid = strlen (cmid);
  len_cend = strlen (cend);
  push_spot ();
  narrow ();
  bob ();
  if (looking_at(cbeg)) deln(len_cbeg);
  while (1 == down(1)) {
    bol ();
    if (looking_at(cmid)) deln(len_cmid);
  }
  if (looking_at(cend)) deln(len_cend);
  widen ();
  pop_spot ();
}

define ide_comment_block ()		% ^K;
{
   ide_set_bookmark ();
   ide_comment_region ();
   ide_goto_bookmark ();
   message ("Block commented.");
}

define ide_uncomment_block ()		% ^K:
{
   ide_set_bookmark ();
   ide_uncomment_region ();
   ide_goto_bookmark ();
   message ("Block uncommented.");
}

define ide_insert_file ()		% ^KR
{
  variable file = 
    read_with_completion ("File:", Null_String, Null_String, 'f');
  ide_set_bookmark ();
  insert_file (file);
  ide_goto_bookmark ();
  message ("File inserted.");
}

define ide_select_word ()		% ^KT, Borland IDE facility
{
  ide_set_bookmark ();
  ide_skip_word ();
  ide_bskip_word ();
  ide_begin_block ();
  ide_skip_word ();
  ide_end_block ();
  ide_goto_bookmark ();
  message ("Word selected.");
}

define ide_insert_last_block ()
{
   if (bufferp(IDE_Block_Buffer)) insbuf (IDE_Block_Buffer);
}

#ifndef MSDOS

variable Last_Process_Command = Null_String;

define ide_filter_region ()		% ^K/, Joe extension
{
  variable cmd, tmp_file;
  cmd = read_mini ("Pipe to command:", Last_Process_Command, Null_String);
  !if (strlen (cmd)) return;
   
  Last_Process_Command = cmd;
  ide_set_bookmark ();
  tmp_file = make_tmp_file ("/tmp/jedpipe");
  cmd = strncat (cmd, " > ", tmp_file, " 2>&1", 4);

  if (pipe_region (cmd)) {
    error ("Process returned a non-zero exit status.");
  }
 
  () = insert_file (tmp_file);
  ide_begin_block ();
  ide_goto_end_block ();
  ide_end_block ();
  ide_delete_block ();
  () = delete_file (tmp_file);
}

#endif

define ide_uppercase_region()		% ^KU
{
  xform_region('u');
  ide_goto_end_block ();
}
   
define ide_lowercase_region()		% ^KL
{
  xform_region('d');
  ide_goto_end_block ();
}
%
% These are predefined bookmarks 0..9, a la Wordstar.
%
define ide_goto_mark_n (n)
{
   variable mrk;

   if (_Ide_Bookmarks_Exist[n] != 1)
     error ("Bookmark not set!");

   ide_set_bookmark ();
   mrk = _Ide_Bookmarks[n];
   sw2buf (user_mark_buffer (mrk));
   goto_user_mark (mrk);
   message ("done.");
}

define ide_set_mark_n (n)		% ^K0..9
{
  _Ide_Bookmarks[n] = create_user_mark ();
  _Ide_Bookmarks_Exist[n] = 1;
  vmessage ("Bookmark %d set.", n, 1);
}
   
define ide_save_buffer ()		% ^KW
{
   variable file, dir, flags;
   (file, dir, , flags) = getbuf_info ();
   file = read_file_from_mini ("Save to file:");
   write_buffer (file);
}

% These are Stuart Herbert's routines, slightly modified

define clear_menu ()
{
  flush ("  ");
}

define new_file ()			% Key_Alt_F N
{
  variable bufname = "*noname*";
%   bufname = strcat (bufname,"new_buffer");
%   bufname = strcat (bufname,"*");
  setbuf(bufname);
  erase_buffer();
  set_buffer_modified_flag(0);
  pop2buf(whatbuf());
}

define better_help ()
{
  help ();
  sw2buf ("*help*");
  call ("one_window");
}

define ide_help ()			% ALT-H, Key_F1: Help menu
{
  variable ch;
  
#ifdef UNIX
  flush ("Help: (I)nfo, (M)an, (K)ey, (F)unctions, I(D)E mode");
#else
  flush ("Help: (I)nfo, (K)ey, (F)unctions, I(D)E mode");
#endif
  ch = int(strup(char(getkey)));
  switch (ch)
    { case 'I': info_mode ();		}
#ifdef UNIX
    { case 'M': unix_man ();		}
#endif
    { case 'K': describe_bindings ();	}
    { case 'F': describe_function ();	}
    { case 'D': better_help ();		}
    { clear_menu ();		}
}

define IDE_buffer_menu ()		% ALT-B: Buffer menu
{
  variable c;

  flush ("Buffer: (I)nsert, (L)ist, (S)witch to, (C)lose");
  c = int (strup(char(getkey())));
  switch(c)
    { case 'I' : insert_buffer();		}
    { case 'L' : list_buffers();		}
    { case 'S' : call("switch_to_buffer"); }
    { case 'C' : call("kill_buffer");	}
    { clear_menu();		}
}

define IDE_edit_menu ()			% ALT-E: Edit menu
{
  variable c;

  flush ("Edit: (U)ndo, cu(T), (P)aste, c(L)ear, (S)how clipboard, c(E)ntre");
  c = int (strup(char(getkey())));
  switch (c)
    { case 'U' : call ("undo");		}
%    { case 'R' : not_implemented   }	% redo
    { case 'T' : ide_delete_block();	}
%    { case 'C' : ide_copy_block     } % it's different!
    { case 'P' : ide_copy_block	();	}
    { case 'L' : ide_clear_block();	}
    { case 'S' : ide_show_clipboard	();}
    { case 'E' : call("center_line");	}
    { clear_menu();		}
}

define IDE_file_menu ()			% ALT-F, Key_F3: File menu
{
  variable c;

  flush ("File: (N)ew, (O)pen, (S)ave, s(A)ve as, save a(L)l, (I)nsert, s(H)ell, (Q)uit");
  c = int (strup(char(getkey())));
  switch (c)
    { case 'N' : new_file();		}
    { case 'O' : open_file();		}
    { case 'S' : save_buffer();		}
    { case 'A' : ide_save_buffer();	}
    { case 'L' : save_buffers	();	}
    { case 'I' : ide_insert_file();	}
    { case 'H' : shell		();	}
    { case 'Q' : exit_jed();		}
    { clear_menu(); 		}
}

% no, I don't like this - I'll comment it out.

% define IDE_mode_menu ()		% ALT-M: Mode menu
% {
%   variable c;
%   
%   flush ("Mode: (0)None, (1)Text, (2)C, (3)Fortran, (4)SLang, (5)TeX");
%   c = int (strup(char(getkey())));
%   switch (c)
%     { case '0' : no_mode    }
%     { case '1' : text_mode  }
%     { case '2' : c_mode     }
%     { case '3' : fortran_mode    }
%     { case '4' : slang_mode }
%     { case '5' : tex_mode   }
%   clear_menu();
% }

define IDE_search_menu ()		% ALT-S: Search menu
{
  variable c;

  flush ("Search: (F)ind, (R)eplace, (S)earch again, (G)oto line");
  c = int (strup(char(getkey())));
  switch (c)
    { case 'F' : search_forward();		}
    { case 'R' : replace_cmd	();	}
    { case 'S' : ide_repeat_search();	}
    { case 'G' : goto_line_cmd	();	}
    { clear_menu();		}
}

define IDE_system_menu ()		% ALT-Y: System menu
{
  variable c;

#ifdef UNIX
  flush ("System: (R)epaint, (I)spell, (M)ail, (C)alendar, (F)unction");
#else
  flush ("System: (R)epaint, (C)alendar, (F)unction");
#endif
  c = int (strup(char(getkey())));
  switch (c)
    { case 'R' : call ("redraw");	}
#ifdef UNIX
    { case 'I' : ispell		();	}
    { case 'M' : mail		();	}
#endif
    { case 'C' : calendar	();	}
    { case 'F' : emacs_escape_x	();	}
    { flush("  ");		}
}

define IDE_window_menu ()
{
  variable c;

  flush ("Window: (N)ew, ne(X)t, (C)lose this, c(L)ose others");
  c = int (strup(char(getkey())));
  switch (c)
    { case 'N' : call ("split_window");	}
    { case 'X' : call ("other_window");	}
    { case 'C' : call ("delete_window");	}
    { case 'L' : call ("one_window");	}
  clear_menu();
}

define IDE_menu ()			% Key_F10
{
  variable c;

  flush ("IDE: (F)ile (E)dit (S)earch (C)ompile (B)uffer (W)indow (H)elp S(y)stem");
  c = int (strup(char(getkey())));
  switch (c)
    { case 'F' : IDE_file_menu	();	}
    { case 'E' : IDE_edit_menu	();	}
%    { case 'M' : IDE_mode_menu   (); }
    { case 'S' : IDE_search_menu ();	}
    { case 'C' : compile	();	}
    { case 'B' : IDE_buffer_menu();	}
    { case 'W' : IDE_window_menu();	}
    { case 'H' : ide_help	();	}
    { case 'Y' : IDE_system_menu();	}
    {clear_menu();		}
}

% --- End of file ide.sl ---
